// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_Edge_HeaderFile
#define _ShapeFix_Edge_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeFix_Edge_HeaderFile
#include <Handle_ShapeFix_Edge.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_ShapeConstruct_ProjectCurveOnSurface_HeaderFile
#include <Handle_ShapeConstruct_ProjectCurveOnSurface.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_ShapeAnalysis_Surface_HeaderFile
#include <Handle_ShapeAnalysis_Surface.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
class ShapeConstruct_ProjectCurveOnSurface;
class TopoDS_Edge;
class TopoDS_Face;
class Geom_Surface;
class TopLoc_Location;
class ShapeAnalysis_Surface;


//! Fixing invalid edge. <br>
//!          Geometrical and/or topological inconsistency: <br>
//!          - no 3d curve or pcurve, <br>
//!          - mismatching orientation of 3d curve and pcurve, <br>
//!          - incorrect SameParameter flag (curve deviation is greater than <br>
//!            edge tolerance), <br>
//!          - not adjacent curves (3d or pcurve) to the vertices. <br>
class ShapeFix_Edge : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Empty constructor <br>
Standard_EXPORT ShapeFix_Edge();

//! Returns the projector used for recomputing missing pcurves <br>
//!          Can be used for adjusting parameters of projector <br>
Standard_EXPORT   Handle_ShapeConstruct_ProjectCurveOnSurface Projector() ;


Standard_EXPORT   Standard_Boolean FixRemovePCurve(const TopoDS_Edge& edge,const TopoDS_Face& face) ;

//! Removes the pcurve(s) of the edge if it does not match the <br>
//!          vertices <br>
//!          Check is done <br>
//!  Use    : It is to be called when pcurve of an edge can be wrong <br>
//!          (e.g., after import from IGES) <br>
//!  Returns: True, if does not match, removed (status DONE) <br>
//!          False, (status OK) if matches or (status FAIL) if no pcurve, <br>
//!          nothing done <br>
Standard_EXPORT   Standard_Boolean FixRemovePCurve(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surface,const TopLoc_Location& location) ;

//! Removes 3d curve of the edge if it does not match the vertices <br>
//!  Returns: True,  if does not match, removed (status DONE) <br>
//!          False, (status OK) if matches or (status FAIL) if no 3d curve, <br>
//!          nothing done <br>
Standard_EXPORT   Standard_Boolean FixRemoveCurve3d(const TopoDS_Edge& edge) ;

//! See method below for information <br>
Standard_EXPORT   Standard_Boolean FixAddPCurve(const TopoDS_Edge& edge,const TopoDS_Face& face,const Standard_Boolean isSeam,const Standard_Real prec = 0.0) ;

//! See method below for information <br>
Standard_EXPORT   Standard_Boolean FixAddPCurve(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surface,const TopLoc_Location& location,const Standard_Boolean isSeam,const Standard_Real prec = 0.0) ;

//! See method below for information <br>
Standard_EXPORT   Standard_Boolean FixAddPCurve(const TopoDS_Edge& edge,const TopoDS_Face& face,const Standard_Boolean isSeam,const Handle(ShapeAnalysis_Surface)& surfana,const Standard_Real prec = 0.0) ;

//! Adds pcurve(s) of the edge if missing (by projecting 3d curve) <br>
//!          Parameter isSeam indicates if the edge is a seam. <br>
//!          The parameter <prec> defines the precision for calculations. <br>
//!          If it is 0 (default), the tolerance of the edge is taken. <br>
//!  Remark : This method is rather for internal use since it accepts parameter <br>
//!          <surfana> for optimization of computations <br>
//!  Use    : It is to be called after FixRemovePCurve (if removed) or in any <br>
//!          case when edge can have no pcurve <br>
//!  Returns: True if pcurve was added, else False <br>
//!  Status : <br>
//!          OK   : Pcurve exists <br>
//!          FAIL1: No 3d curve <br>
//!          FAIL2: fail during projecting <br>
//!          DONE1: Pcurve was added <br>
//!          DONE2: specific case of pcurve going through degenerated point on <br>
//!                 sphere encountered during projection (see class <br>
//!                 ShapeConstruct_ProjectCurveOnSurface for more info) <br>
Standard_EXPORT   Standard_Boolean FixAddPCurve(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surface,const TopLoc_Location& location,const Standard_Boolean isSeam,const Handle(ShapeAnalysis_Surface)& surfana,const Standard_Real prec = 0.0) ;

//! Tries to build 3d curve of the edge if missing <br>
//!  Use    : It is to be called after FixRemoveCurve3d (if removed) or in any <br>
//!          case when edge can have no 3d curve <br>
//!  Returns: True if 3d curve was added, else False <br>
//!  Status : <br>
//!          OK   : 3d curve exists <br>
//!          FAIL1: BRepLib::BuildCurve3d() has failed <br>
//!          DONE1: 3d curve was added <br>
Standard_EXPORT   Standard_Boolean FixAddCurve3d(const TopoDS_Edge& edge) ;


Standard_EXPORT   Standard_Boolean FixVertexTolerance(const TopoDS_Edge& edge,const TopoDS_Face& face) ;

//! Increases the tolerances of the edge vertices to comprise <br>
//!          the ends of 3d curve and pcurve on the given face <br>
//!          (first method) or all pcurves stored in an edge (second one) <br>
//!  Returns: True, if tolerances have been increased, otherwise False <br>
//!  Status: <br>
//!          OK   : the original tolerances have not been changed <br>
//!          DONE1: the tolerance of first vertex has been increased <br>
//!          DONE2: the tolerance of last  vertex has been increased <br>
Standard_EXPORT   Standard_Boolean FixVertexTolerance(const TopoDS_Edge& edge) ;


Standard_EXPORT   Standard_Boolean FixReversed2d(const TopoDS_Edge& edge,const TopoDS_Face& face) ;

//! Fixes edge if pcurve is directed opposite to 3d curve <br>
//!          Check is done by call to the function <br>
//!          ShapeAnalysis_Edge::CheckCurve3dWithPCurve() <br>
//!  Warning: For seam edge this method will check and fix the pcurve in only <br>
//!          one direction. Hence, it should be called twice for seam edge: <br>
//!          once with edge orientation FORWARD and once with REVERSED. <br>
//!  Returns: False if nothing done, True if reversed (status DONE) <br>
//!  Status:  OK    - pcurve OK, nothing done <br>
//!          FAIL1 - no pcurve <br>
//!          FAIL2 - no 3d curve <br>
//!          DONE1 - pcurve was reversed <br>
Standard_EXPORT   Standard_Boolean FixReversed2d(const TopoDS_Edge& edge,const Handle(Geom_Surface)& surface,const TopLoc_Location& location) ;

//! Tries to make edge SameParameter and sets corresponding <br>
//!          tolerance and SameParameter flag. <br>
//!          First, it makes edge same range if SameRange flag is not set. <br>
Standard_EXPORT   Standard_Boolean FixSameParameter(const TopoDS_Edge& edge,const Standard_Real tolerance = 0.0) ;

//! Returns the status (in the form of True/False) of last Fix <br>
Standard_EXPORT   Standard_Boolean Status(const ShapeExtend_Status status) const;
//Standard_EXPORT ~ShapeFix_Edge();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Integer myStatus;
Handle_ShapeConstruct_ProjectCurveOnSurface myProjector;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
