// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic2d_VectorialMarker_HeaderFile
#define _Graphic2d_VectorialMarker_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic2d_VectorialMarker_HeaderFile
#include <Handle_Graphic2d_VectorialMarker.hxx>
#endif

#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Graphic2d_Line_HeaderFile
#include <Graphic2d_Line.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Graphic2d_GraphicObject;


//! Groups all the primitives which behaves like <br>
//!	    geometrical marker. <br>
//!	    for example : EllipsMarker, CircleMarker ... <br>
//!	    A marker is a primitive which retains its original <br>
//!	    on-screen size no matter how the view is zoomed. <br>
//!	    For example, markers are used as symbols of dimension. <br>
//!	    Every marker takes a reference point as an argument in <br>
//!	    its constructor. CircleMarker and EllipsMarker take <br>
//!	    another point as the center and PolylineMarker takes the <br>
//!	    first point of its list as its origin. <br>
//!	    The coordinates of the centre or origin point are offsets <br>
//!	    with respect to the reference point. <br>
class Graphic2d_VectorialMarker : public Graphic2d_Line {

public:
 // Methods PUBLIC
 // 

//! Modifies the marker position. <br>
//!  Warning: If the associated GraphicObject is transformed <br>
//!	    the position will be transformed. <br>
Standard_EXPORT   void SetPosition(const Quantity_Length aXPosition,const Quantity_Length aYPosition) ;

//! Returns the x position of the marker <br>
//!  Warning: If the associated GraphicObject is transformed <br>
//!	    the returned position is the transformed position. <br>
Standard_EXPORT   Quantity_Length XPosition() const;

//! Returns the y position of the marker <br>
//!  Warning: If the associated GraphicObject is transformed <br>
//!	    the returned position is the transformed position. <br>
Standard_EXPORT   Quantity_Length YPosition() const;
//Standard_EXPORT ~Graphic2d_VectorialMarker();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Creates a marker at <aXPosition>, <aYPosition> <br>
Standard_EXPORT Graphic2d_VectorialMarker(const Handle(Graphic2d_GraphicObject)& aGraphicObject,const Quantity_Length aXPosition,const Quantity_Length aYPosition);


 // Fields PROTECTED
 //
Standard_ShortReal myXPosition;
Standard_ShortReal myYPosition;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
