// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic2d_SetOfMarkers_HeaderFile
#define _Graphic2d_SetOfMarkers_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic2d_SetOfMarkers_HeaderFile
#include <Handle_Graphic2d_SetOfMarkers.hxx>
#endif

#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _TShort_SequenceOfShortReal_HeaderFile
#include <TShort_SequenceOfShortReal.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfInteger_HeaderFile
#include <Handle_TColStd_HSequenceOfInteger.hxx>
#endif
#ifndef _TColStd_MapOfInteger_HeaderFile
#include <TColStd_MapOfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Graphic2d_Line_HeaderFile
#include <Graphic2d_Line.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Quantity_PlaneAngle_HeaderFile
#include <Quantity_PlaneAngle.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Handle_TShort_HArray1OfShortReal_HeaderFile
#include <Handle_TShort_HArray1OfShortReal.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
#ifndef _Graphic2d_PickMode_HeaderFile
#include <Graphic2d_PickMode.hxx>
#endif
class TColStd_HSequenceOfInteger;
class Graphic2d_MarkerDefinitionError;
class Standard_OutOfRange;
class Graphic2d_GraphicObject;
class Graphic2d_Drawer;
class TShort_HArray1OfShortReal;
class TColStd_MapOfInteger;


//! The primitive SetOfMarkers <br>
//!  Warning: This primitive must be use as possible for performance <br>
//!	   improvment but is drawn with a global marker attributes <br>
//!	   for all the set. <br>
//!	   NOTE: than the method PickedIndex() permits to known <br>
//!	        the last picked marker in the set. <br>
//!      SAV : 14/11/01 : Added a set of methods (marked SAV before declaration) <br>
//!                       to provide highlighting/selection <br>
//!                       of SetOfMarkers elements. These methods should be redefined <br>
//!                       for other SetOf<>. <br>
//! <br>
//!      SAV : 23/05/02 : WARNING!!! method PickByCircle performs only detection <br>
//!      function. It doesn't cause any visual highlighting. <br>
class Graphic2d_SetOfMarkers : public Graphic2d_Line {

public:
 // Methods PUBLIC
 // 

//! Creates an empty set of markers in the graphic <br>
//!         object <aGraphicObject>. <br>
Standard_EXPORT Graphic2d_SetOfMarkers(const Handle(Graphic2d_GraphicObject)& aGraphicObject);

//! Add a pixel point marker in the set <br>
Standard_EXPORT   void Add(const Quantity_Length X,const Quantity_Length Y) ;

//! Add a marker of predefined index <anIndex> in the set <br>
//!          at position <X>,<Y> and size <aWidth>,<aHeight>. <br>
//!          Angle is measured counterclockwise with 0 radian <br>
//!          at 3 o'clock. <br>
//!  Trigger: Raises MarkerDefinitionError if the <br>
//!          marker index is <= 0 or undefined in the MarkMap, <br>
//!          or the marker size <aWidth,anHeight> is <= 0. <br>
Standard_EXPORT   void Add(const Standard_Integer anIndex,const Quantity_Length X,const Quantity_Length Y,const Quantity_Length aWidth,const Quantity_Length anHeight,const Quantity_PlaneAngle anAngle = 0.0) ;

//! Returns the number of markers in the set. <br>
Standard_EXPORT   Standard_Integer Length() const;

//! Returns the marker type, position, sizes and angle <br>
//!          and type from the set at rank <aRank>. <br>
//!  Warning: For the pixel point marker the returned <anIndex> is NULL <br>
//!  Trigger: Raises OutOfRange if <aRank> is <1 or >Length() <br>
Standard_EXPORT   void Values(const Standard_Integer aRank,Standard_Integer& anIndex,Quantity_Length& X,Quantity_Length& Y,Quantity_Length& aW,Quantity_Length& aH,Quantity_PlaneAngle& anAngle) const;

//! Declares that previously highlighted elements will be selected ones. <br>
Standard_EXPORT virtual  Standard_Boolean SetElementsSelected() ;


Standard_EXPORT virtual  Standard_Boolean HasSelectedElements() ;


Standard_EXPORT virtual  void ClearSelectedElements() ;


Standard_EXPORT  const TColStd_MapOfInteger& GetSelectedElements() const;

//! adds/removes marker to/from selection map. <br>
Standard_EXPORT   void AddOrRemoveSelected(const Standard_Integer index) ;


Standard_EXPORT virtual  void Save(Aspect_FStream& aFStream) const;

//! sets limit of number elements to be highlighted. <br>
Standard_EXPORT   void SetHighlightedLimit(const Standard_Integer number) ;

//! Changes myScaledWidth field. As this value used in detection <br>
//!          mechanism it should be reset after view transformation. <br>
Standard_EXPORT   void SetScaledWidth(const Standard_ShortReal width) ;
//Standard_EXPORT ~Graphic2d_SetOfMarkers();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Draws the set of markers <me>. <br>
Standard_EXPORT   void Draw(const Handle(Graphic2d_Drawer)& aDrawer) ;

//! Draws element <anIndex> of the set <me>. <br>
Standard_EXPORT virtual  void DrawElement(const Handle(Graphic2d_Drawer)& aDrawer,const Standard_Integer anIndex) ;

//! Draws the all picked elements of the primitive <me>. <br>
Standard_EXPORT virtual  void DrawPickedElements(const Handle(Graphic2d_Drawer)& aDrawer) ;

//! Draws the all selected elements of the primitive <me>. <br>
Standard_EXPORT virtual  void DrawSelectedElements(const Handle(Graphic2d_Drawer)& aDrawer) ;

//! Draws vertex <anIndex> of the set <me>. <br>
Standard_EXPORT virtual  void DrawVertex(const Handle(Graphic2d_Drawer)& aDrawer,const Standard_Integer anIndex) ;

//! Returns Standard_True if one marker of the set <me> <br>
//!	    is picked, Standard_False if not. <br>
//!  Warning: The PickIndex() method returns the rank of the picked <br>
//!	    marker if any. <br>
Standard_EXPORT   Standard_Boolean Pick(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal aPrecision,const Handle(Graphic2d_Drawer)& aDrawer) ;


Standard_EXPORT virtual  Standard_Boolean Pick(const Standard_ShortReal X1,const Standard_ShortReal Y1,const Standard_ShortReal X2,const Standard_ShortReal Y2,const Handle(Graphic2d_Drawer)& aDrawer,const Graphic2d_PickMode aPickMode) ;


Standard_EXPORT virtual  Standard_Boolean PickByCircle(const Standard_ShortReal x,const Standard_ShortReal y,const Standard_ShortReal radius,const Handle(Graphic2d_Drawer)& aDrawer,const Graphic2d_PickMode aPickMode) ;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void DrawElements(const Handle(Graphic2d_Drawer)& aDrawer,const Handle(TShort_HArray1OfShortReal)& x,const Handle(TShort_HArray1OfShortReal)& y) ;


 // Fields PRIVATE
 //
TColStd_SequenceOfInteger myType;
TShort_SequenceOfShortReal myX;
TShort_SequenceOfShortReal myY;
TShort_SequenceOfShortReal myWidth;
TShort_SequenceOfShortReal myHeight;
TShort_SequenceOfShortReal myAngle;
Handle_TColStd_HSequenceOfInteger mySelIndices;
TColStd_MapOfInteger myMapOfSelected;
Standard_Integer myHLimit;
Standard_Boolean mySuppressHigh;
Quantity_Length myScaledWidth;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
