// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2d_VectorWithMagnitude_HeaderFile
#define _Geom2d_VectorWithMagnitude_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom2d_VectorWithMagnitude_HeaderFile
#include <Handle_Geom2d_VectorWithMagnitude.hxx>
#endif

#ifndef _Geom2d_Vector_HeaderFile
#include <Geom2d_Vector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_Vector_HeaderFile
#include <Handle_Geom2d_Vector.hxx>
#endif
#ifndef _Handle_Geom2d_Geometry_HeaderFile
#include <Handle_Geom2d_Geometry.hxx>
#endif
class Standard_ConstructionError;
class gp_Vec2d;
class gp_Pnt2d;
class Geom2d_Vector;
class gp_Trsf2d;
class Geom2d_Geometry;



//!  Defines a vector with magnitude. <br>
//!  A vector with magnitude can have a zero length. <br>
class Geom2d_VectorWithMagnitude : public Geom2d_Vector {

public:
 // Methods PUBLIC
 // 

//! Creates a persistent copy of V. <br>
Standard_EXPORT Geom2d_VectorWithMagnitude(const gp_Vec2d& V);

//! Creates a vector with two cartesian coordinates. <br>
Standard_EXPORT Geom2d_VectorWithMagnitude(const Standard_Real X,const Standard_Real Y);


//!  Creates a vector from the point P1 to the point P2. <br>
//!  The magnitude of the vector is the distance between P1 and P2 <br>
Standard_EXPORT Geom2d_VectorWithMagnitude(const gp_Pnt2d& P1,const gp_Pnt2d& P2);

//!  Set <me> to X, Y coordinates. <br>
Standard_EXPORT   void SetCoord(const Standard_Real X,const Standard_Real Y) ;


Standard_EXPORT   void SetVec2d(const gp_Vec2d& V) ;

//! Changes the X coordinate of <me>. <br>
Standard_EXPORT   void SetX(const Standard_Real X) ;

//!  Changes the Y coordinate of <me> <br>
Standard_EXPORT   void SetY(const Standard_Real Y) ;

//! Returns the magnitude of <me>. <br>
Standard_EXPORT   Standard_Real Magnitude() const;

//! Returns the square magnitude of <me>. <br>
Standard_EXPORT   Standard_Real SquareMagnitude() const;


//!  Adds the Vector Other to <me>. <br>
Standard_EXPORT   void Add(const Handle(Geom2d_Vector)& Other) ;
  void operator +=(const Handle(Geom2d_Vector)& Other) 
{
  Add(Other);
}



//!  Adds the vector Other to <me>. <br>
Standard_EXPORT   Handle_Geom2d_VectorWithMagnitude Added(const Handle(Geom2d_Vector)& Other) const;
  Handle_Geom2d_VectorWithMagnitude operator +(const Handle(Geom2d_Vector)& Other) const
{
  return Added(Other);
}



//!  Computes the cross product  between <me> and Other <br>
//!  <me> ^ Other. A new vector is returned. <br>
Standard_EXPORT   Standard_Real Crossed(const Handle(Geom2d_Vector)& Other) const;
  Standard_Real operator ^(const Handle(Geom2d_Vector)& Other) const
{
  return Crossed(Other);
}


//! Divides <me> by a scalar. <br>
Standard_EXPORT   void Divide(const Standard_Real Scalar) ;
  void operator /=(const Standard_Real Scalar) 
{
  Divide(Scalar);
}



//!  Divides <me> by a scalar. A new vector is returned. <br>
Standard_EXPORT   Handle_Geom2d_VectorWithMagnitude Divided(const Standard_Real Scalar) const;
  Handle_Geom2d_VectorWithMagnitude operator /(const Standard_Real Scalar) const
{
  return Divided(Scalar);
}



//!  Computes the product of the vector <me> by a scalar. <br>
//!  A new vector is returned. <br>
//! <br>
//!  -C++: alias operator * <br>
//!  Collision with same operator defined for the class Vector! <br>
Standard_EXPORT   Handle_Geom2d_VectorWithMagnitude Multiplied(const Standard_Real Scalar) const;


//!  Computes the product of the vector <me> by a scalar. <br>
Standard_EXPORT   void Multiply(const Standard_Real Scalar) ;
  void operator *=(const Standard_Real Scalar) 
{
  Multiply(Scalar);
}


//! Normalizes <me>. <br>
//!  Raised if the magnitude of the vector is lower or equal to <br>
//!  Resolution from package gp. <br>
Standard_EXPORT   void Normalize() ;

//! Returns a copy of <me> Normalized. <br>
//!  Raised if the magnitude of the vector is lower or equal to <br>
//!  Resolution from package gp. <br>
Standard_EXPORT   Handle_Geom2d_VectorWithMagnitude Normalized() const;

//! Subtracts the Vector Other to <me>. <br>
Standard_EXPORT   void Subtract(const Handle(Geom2d_Vector)& Other) ;
  void operator -=(const Handle(Geom2d_Vector)& Other) 
{
  Subtract(Other);
}



//!  Subtracts the vector Other to <me>. A new vector is returned. <br>
Standard_EXPORT   Handle_Geom2d_VectorWithMagnitude Subtracted(const Handle(Geom2d_Vector)& Other) const;
  Handle_Geom2d_VectorWithMagnitude operator -(const Handle(Geom2d_Vector)& Other) const
{
  return Subtracted(Other);
}


//! Applies the transformation T to this vector. <br>
Standard_EXPORT   void Transform(const gp_Trsf2d& T) ;

//! Creates a new object which is a copy of this vector. <br>
Standard_EXPORT   Handle_Geom2d_Geometry Copy() const;
//Standard_EXPORT ~Geom2d_VectorWithMagnitude();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
