// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GC_MakeCircle_HeaderFile
#define _GC_MakeCircle_HeaderFile

#ifndef _Handle_Geom_Circle_HeaderFile
#include <Handle_Geom_Circle.hxx>
#endif
#ifndef _GC_Root_HeaderFile
#include <GC_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Geom_Circle;
class StdFail_NotDone;
class gp_Circ;
class gp_Ax2;
class gp_Pnt;
class gp_Dir;
class gp_Ax1;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class implements the following algorithms used <br>
//!           to create Cirlec from Geom. <br>
//! <br>
//!           * Create a Circle parallel to another and passing <br>
//!             though a point. <br>
//!           * Create a Circle parallel to another at the distance <br>
//!             Dist. <br>
//!           * Create a Circle passing through 3 points. <br>
//!           * Create a Circle with its center and the normal of its <br>
//!             plane and its radius. <br>
//!           * Create a Circle with its axis and radius. <br>
//!  The circle's parameter is the angle (Radian). <br>
//!  The parametrization range is [0,2*PI]. <br>
//!  The circle is a closed and periodic curve. <br>
//!  The center of the circle is the Location point of its axis <br>
//!  placement. The XDirection of the axis placement defines the <br>
//!  origin of the parametrization. <br>
class GC_MakeCircle  : public GC_Root {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//!  creates a circle from a non persistent circle C by its conversion. <br>
Standard_EXPORT GC_MakeCircle(const gp_Circ& C);


//!  A2 is the local coordinates system of the circle. <br>
//!  It is not forbidden to create a circle with Radius = 0.0 <br>
//!  Status is "NegativeRadius" if Radius < 0. <br>
Standard_EXPORT GC_MakeCircle(const gp_Ax2& A2,const Standard_Real Radius);

//! Make a Circle from Geom <TheCirc> parallel to another <br>
//!           Circ <Circ> with a distance <Dist>. <br>
//!           If Dist is greater than zero the result is enclosing <br>
//!           the circle <Circ>, else the result is enclosed by the <br>
//!           circle <Circ>. <br>
Standard_EXPORT GC_MakeCircle(const gp_Circ& Circ,const Standard_Real Dist);

//! Make a Circle from Geom <TheCirc> parallel to another <br>
//!           Circ <Circ> and passing through a Pnt <Point>. <br>
Standard_EXPORT GC_MakeCircle(const gp_Circ& Circ,const gp_Pnt& Point);

//! Make a Circ from gp <TheCirc> passing through 3 <br>
//!           Pnt2d <P1>,<P2>,<P3>. <br>
Standard_EXPORT GC_MakeCircle(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3);

//! Make a Circle from Geom <TheCirc> with its center <br>
//!           <Center> and the normal of its plane <Norm> and <br>
//!           its radius <Radius>. <br>
Standard_EXPORT GC_MakeCircle(const gp_Pnt& Center,const gp_Dir& Norm,const Standard_Real Radius);

//! Make a Circle from Geom <TheCirc> with its center <br>
//!           <Center> and the normal of its plane defined by the <br>
//!           two points <Center> and <PtAxis> and its radius <Radius>. <br>
Standard_EXPORT GC_MakeCircle(const gp_Pnt& Center,const gp_Pnt& PtAxis,const Standard_Real Radius);

//! Make a Circle from Geom <TheCirc> with its center <br>
//!           <Center> and its radius <Radius>. <br>
Standard_EXPORT GC_MakeCircle(const gp_Ax1& Axis,const Standard_Real Radius);


//! Returns the constructed circle. <br>
//! Exceptions <br>
//! StdFail_NotDone if no circle is constructed. <br>
Standard_EXPORT  const Handle_Geom_Circle& Value() const;


Standard_EXPORT  const Handle_Geom_Circle& Operator() const;
Standard_EXPORT operator Handle_Geom_Circle() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Geom_Circle TheCircle;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
