// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GCPnts_TangentialDeflection_HeaderFile
#define _GCPnts_TangentialDeflection_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColgp_SequenceOfPnt_HeaderFile
#include <TColgp_SequenceOfPnt.hxx>
#endif
#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class Standard_OutOfRange;
class Adaptor3d_Curve;
class Adaptor2d_Curve2d;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!  Computes a set of  points on a curve from package <br>
//!          Adaptor3d  such  as between  two successive   points <br>
//!          P1(u1)and P2(u2) : <br>
//! <br>
//!         . ||P1P3^P3P2||/||P1P3||*||P3P2||<AngularDeflection <br>
//!         . ||P1P2^P1P3||/||P1P2||*||P1P3||<CurvatureDeflection <br>
class GCPnts_TangentialDeflection  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT GCPnts_TangentialDeflection();


Standard_EXPORT GCPnts_TangentialDeflection(const Adaptor3d_Curve& C,const Standard_Real AngularDeflection,const Standard_Real CurvatureDeflection,const Standard_Integer MinimumOfPoints = 2,const Standard_Real UTol = 1.0e-9);


Standard_EXPORT GCPnts_TangentialDeflection(const Adaptor3d_Curve& C,const Standard_Real FirstParameter,const Standard_Real LastParameter,const Standard_Real AngularDeflection,const Standard_Real CurvatureDeflection,const Standard_Integer MinimumOfPoints = 2,const Standard_Real UTol = 1.0e-9);


Standard_EXPORT GCPnts_TangentialDeflection(const Adaptor2d_Curve2d& C,const Standard_Real AngularDeflection,const Standard_Real CurvatureDeflection,const Standard_Integer MinimumOfPoints = 2,const Standard_Real UTol = 1.0e-9);


Standard_EXPORT GCPnts_TangentialDeflection(const Adaptor2d_Curve2d& C,const Standard_Real FirstParameter,const Standard_Real LastParameter,const Standard_Real AngularDeflection,const Standard_Real CurvatureDeflection,const Standard_Integer MinimumOfPoints = 2,const Standard_Real UTol = 1.0e-9);


Standard_EXPORT   void Initialize(const Adaptor3d_Curve& C,const Standard_Real AngularDeflection,const Standard_Real CurvatureDeflection,const Standard_Integer MinimumOfPoints = 2,const Standard_Real UTol = 1.0e-9) ;


Standard_EXPORT   void Initialize(const Adaptor3d_Curve& C,const Standard_Real FirstParameter,const Standard_Real LastParameter,const Standard_Real AngularDeflection,const Standard_Real CurvatureDeflection,const Standard_Integer MinimumOfPoints = 2,const Standard_Real UTol = 1.0e-9) ;


Standard_EXPORT   void Initialize(const Adaptor2d_Curve2d& C,const Standard_Real AngularDeflection,const Standard_Real CurvatureDeflection,const Standard_Integer MinimumOfPoints = 2,const Standard_Real UTol = 1.0e-9) ;


Standard_EXPORT   void Initialize(const Adaptor2d_Curve2d& C,const Standard_Real FirstParameter,const Standard_Real LastParameter,const Standard_Real AngularDeflection,const Standard_Real CurvatureDeflection,const Standard_Integer MinimumOfPoints = 2,const Standard_Real UTol = 1.0e-9) ;

  Standard_Integer NbPoints() const;

  Standard_Real Parameter(const Standard_Integer I) const;

  gp_Pnt Value(const Standard_Integer I) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void PerformLinear(const Adaptor3d_Curve& C) ;


Standard_EXPORT   void PerformLinear(const Adaptor2d_Curve2d& C) ;


Standard_EXPORT   void PerformCircular(const Adaptor3d_Curve& C) ;


Standard_EXPORT   void PerformCircular(const Adaptor2d_Curve2d& C) ;


Standard_EXPORT   void PerformCurve(const Adaptor3d_Curve& C) ;


Standard_EXPORT   void PerformCurve(const Adaptor2d_Curve2d& C) ;


Standard_EXPORT   void EvaluateDu(const Adaptor3d_Curve& C,const Standard_Real U,gp_Pnt& P,Standard_Real& Du,Standard_Boolean& NotDone) const;


Standard_EXPORT   void EvaluateDu(const Adaptor2d_Curve2d& C,const Standard_Real U,gp_Pnt& P,Standard_Real& Du,Standard_Boolean& NotDone) const;


 // Fields PRIVATE
 //
Standard_Real angularDeflection;
Standard_Real curvatureDeflection;
Standard_Real uTol;
Standard_Integer minNbPnts;
Standard_Real lastu;
Standard_Real firstu;
TColgp_SequenceOfPnt points;
TColStd_SequenceOfReal parameters;


};


#include <GCPnts_TangentialDeflection.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
