// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Bnd_BoundSortBox2d_HeaderFile
#define _Bnd_BoundSortBox2d_HeaderFile

#ifndef _Bnd_Box2d_HeaderFile
#include <Bnd_Box2d.hxx>
#endif
#ifndef _Handle_Bnd_HArray1OfBox2d_HeaderFile
#include <Handle_Bnd_HArray1OfBox2d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfListOfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfListOfInteger.hxx>
#endif
#ifndef _TColStd_DataMapOfIntegerInteger_HeaderFile
#include <TColStd_DataMapOfIntegerInteger.hxx>
#endif
#ifndef _TColStd_ListOfInteger_HeaderFile
#include <TColStd_ListOfInteger.hxx>
#endif
class Bnd_HArray1OfBox2d;
class TColStd_HArray1OfListOfInteger;
class Standard_NullValue;
class Standard_MultiplyDefined;
class Bnd_Box2d;
class TColStd_ListOfInteger;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A tool to compare a 2D bounding box with a set of 2D <br>
//! bounding boxes. It sorts the set of bounding boxes to give <br>
//! the list of boxes which intersect the element being compared. <br>
//! The boxes being sorted generally bound a set of shapes, <br>
//! while the box being compared bounds a shape to be <br>
//! compared. The resulting list of intersecting boxes therefore <br>
//! gives the list of items which potentially intersect the shape to be compared. <br>
class Bnd_BoundSortBox2d  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs an empty comparison algorithm for 2D bounding boxes. <br>
//! The bounding boxes are then defined using the Initialize function. <br>
Standard_EXPORT Bnd_BoundSortBox2d();

//! Initializes this comparison algorithm with <br>
//! -   the set of 2D bounding boxes SetOfBox <br>
Standard_EXPORT   void Initialize(const Bnd_Box2d& CompleteBox,const Handle(Bnd_HArray1OfBox2d)& SetOfBox) ;

//! Initializes this comparison algorithm with <br>
//! -   the set of 2D bounding boxes SetOfBox, where <br>
//!  CompleteBox is given as the global bounding box of   SetOfBox. <br>
Standard_EXPORT   void Initialize(const Handle(Bnd_HArray1OfBox2d)& SetOfBox) ;

//! Initializes this comparison algorithm, giving it only <br>
//! -   the maximum number nbComponents, and <br>
//! -   the global bounding box CompleteBox, <br>
//! of the 2D bounding boxes to be managed. Use the Add <br>
//! function to define the array of bounding boxes to be sorted by this algorithm. <br>
Standard_EXPORT   void Initialize(const Bnd_Box2d& CompleteBox,const Standard_Integer nbComponents) ;

//! Adds the 2D bounding box theBox at position boxIndex in <br>
//! the array of boxes to be sorted by this comparison algorithm. <br>
//! This function is used only in conjunction with the third <br>
//! syntax described in the synopsis of Initialize. <br>
//! Exceptions <br>
//! -   Standard_OutOfRange if boxIndex is not in the <br>
//!   range [ 1,nbComponents ] where <br>
//!   nbComponents is the maximum number of bounding <br>
//!   boxes declared for this comparison algorithm at <br>
//!   initialization. <br>
//! -   Standard_MultiplyDefined if a box still exists at <br>
//!   position boxIndex in the array of boxes to be sorted by <br>
//!   this comparison algorithm. <br>
Standard_EXPORT   void Add(const Bnd_Box2d& theBox,const Standard_Integer boxIndex) ;


//! Compares the 2D bounding box theBox with the set of <br>
//! bounding boxes to be sorted by this comparison algorithm, <br>
//! and returns the list of intersecting bounding boxes as a list <br>
//! of indexes on the array of bounding boxes used by this algorithm. <br>
Standard_EXPORT  const TColStd_ListOfInteger& Compare(const Bnd_Box2d& theBox) ;


Standard_EXPORT   void Dump() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Prepares BoundSortBox2d and sorts the rectangles of <br>
//!          <SetOfBox> . <br>
Standard_EXPORT   void SortBoxes() ;


 // Fields PRIVATE
 //
Bnd_Box2d myBox;
Handle_Bnd_HArray1OfBox2d myBndComponents;
Standard_Real Xmin;
Standard_Real Ymin;
Standard_Real deltaX;
Standard_Real deltaY;
Standard_Integer discrX;
Standard_Integer discrY;
Handle_TColStd_HArray1OfListOfInteger axisX;
Handle_TColStd_HArray1OfListOfInteger axisY;
Standard_Integer theFound;
TColStd_DataMapOfIntegerInteger Crible;
TColStd_ListOfInteger lastResult;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
