// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepMAT2d_LinkTopoBilo_HeaderFile
#define _BRepMAT2d_LinkTopoBilo_HeaderFile

#ifndef _BRepMAT2d_DataMapOfShapeSequenceOfBasicElt_HeaderFile
#include <BRepMAT2d_DataMapOfShapeSequenceOfBasicElt.hxx>
#endif
#ifndef _BRepMAT2d_DataMapOfBasicEltShape_HeaderFile
#include <BRepMAT2d_DataMapOfBasicEltShape.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_MAT_BasicElt_HeaderFile
#include <Handle_MAT_BasicElt.hxx>
#endif
class Standard_ConstructionError;
class BRepMAT2d_Explorer;
class BRepMAT2d_BisectingLocus;
class TopoDS_Shape;
class MAT_BasicElt;
class TopoDS_Wire;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!Constucts links between the Face of the explorer and <br>
//!         the BasicElts contained in the bisecting locus. <br>
class BRepMAT2d_LinkTopoBilo  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepMAT2d_LinkTopoBilo();

//! Constructs the links Between S and BiLo. <br>
//! <br>//! raises if <S> is not a face. <br>
Standard_EXPORT BRepMAT2d_LinkTopoBilo(const BRepMAT2d_Explorer& Explo,const BRepMAT2d_BisectingLocus& BiLo);

//! Constructs the links Between S and BiLo. <br>
//! <br>//! raises if <S> is not a face or a wire. <br>
Standard_EXPORT   void Perform(const BRepMAT2d_Explorer& Explo,const BRepMAT2d_BisectingLocus& BiLo) ;

//! Initialise the Iterator on <S> <br>
//!          <S> is an edge or a vertex of the initial <br>
//!          wire or face. <br>//! raises if <S> is not an edge or a vertex. <br>
Standard_EXPORT   void Init(const TopoDS_Shape& S) ;

//! Returns True if there  is a current  BasicElt. <br>
Standard_EXPORT   Standard_Boolean More() ;

//! Proceed to the next BasicElt. <br>
Standard_EXPORT   void Next() ;

//! Returns the current BasicElt. <br>
Standard_EXPORT   Handle_MAT_BasicElt Value() const;

//! Returns the Shape linked to <aBE>. <br>
Standard_EXPORT   TopoDS_Shape GeneratingShape(const Handle(MAT_BasicElt)& aBE) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void LinkToWire(const TopoDS_Wire& W,const BRepMAT2d_Explorer& Explo,const Standard_Integer IndexContour,const BRepMAT2d_BisectingLocus& BiLo) ;


 // Fields PRIVATE
 //
BRepMAT2d_DataMapOfShapeSequenceOfBasicElt myMap;
BRepMAT2d_DataMapOfBasicEltShape myBEShape;
TopoDS_Shape myKey;
Standard_Integer current;
Standard_Boolean isEmpty;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
