// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_FaceAreaBuilder_HeaderFile
#define _BOP_FaceAreaBuilder_HeaderFile

#ifndef _BOP_Area2dBuilder_HeaderFile
#include <BOP_Area2dBuilder.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BOP_LoopSet;
class BOP_LoopClassifier;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! The FaceAreaBuilder algorithm is used to construct Faces from a LoopSet, <br>
//! where the Loop is the composite topological object of the boundary, <br>
//! here wire or block of edges. <br>
//! The LoopSet gives an iteration on Loops. <br>
//! For each Loop  it indicates if it is on the boundary (wire) or if it <br>
//! results from  an interference (block of edges). <br>
//! The result of the FaceAreaBuilder is an iteration on areas. <br>
//! An area is described by a set of Loops. <br>
class BOP_FaceAreaBuilder  : public BOP_Area2dBuilder {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_FaceAreaBuilder();


//! Creates the object to build faces on the (wires,blocks of edge) <br>
//! of <LS>, using the classifier <LC>. <br>
Standard_EXPORT BOP_FaceAreaBuilder(BOP_LoopSet& LS,BOP_LoopClassifier& LC,const Standard_Boolean ForceClass = Standard_False);


//! Initializes the object to build faces on the (wires,blocks of edge) <br>
//! of <LS>, using the classifier <LC>. <br>
Standard_EXPORT   void InitFaceAreaBuilder(BOP_LoopSet& LS,BOP_LoopClassifier& LC,const Standard_Boolean ForceClass = Standard_False) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
