// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AppParCurves_ConstraintCouple_HeaderFile
#define _AppParCurves_ConstraintCouple_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _AppParCurves_Constraint_HeaderFile
#include <AppParCurves_Constraint.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! associates an index and a constraint for an object. <br>
//! This couple is used by AppDef_TheVariational when performing approximations. <br>
class AppParCurves_ConstraintCouple  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! returns an indefinite ConstraintCouple. <br>
Standard_EXPORT AppParCurves_ConstraintCouple();

//! Create a couple the object <Index> will have the <br>
//!          constraint <Cons>. <br>
Standard_EXPORT AppParCurves_ConstraintCouple(const Standard_Integer TheIndex,const AppParCurves_Constraint Cons);

//! returns the index of the constraint object. <br>
Standard_EXPORT   Standard_Integer Index() const;

//! returns the constraint of the object. <br>
Standard_EXPORT   AppParCurves_Constraint Constraint() const;

//! Changes the index of the constraint object. <br>
Standard_EXPORT   void SetIndex(const Standard_Integer TheIndex) ;

//! Changes the constraint of the object. <br>
Standard_EXPORT   void SetConstraint(const AppParCurves_Constraint Cons) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myIndex;
AppParCurves_Constraint myConstraint;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
