// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AIS_AttributeFilter_HeaderFile
#define _AIS_AttributeFilter_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_AIS_AttributeFilter_HeaderFile
#include <Handle_AIS_AttributeFilter.hxx>
#endif

#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _SelectMgr_Filter_HeaderFile
#include <SelectMgr_Filter.hxx>
#endif
#ifndef _Handle_SelectMgr_EntityOwner_HeaderFile
#include <Handle_SelectMgr_EntityOwner.hxx>
#endif
class SelectMgr_EntityOwner;


//! Selects Interactive Objects, which have the desired width or color. <br>
//! The filter questions each Interactive Object in local <br>
//! context to determine whether it has an non-null <br>
//! owner, and if so, whether it has the required color <br>
//! and width attributes. If the object returns true in each <br>
//! case, it is kept. If not, it is rejected. <br>
//! This filter is used only in an open local context. <br>
//! In the Collector viewer, you can only locate <br>
//! Interactive Objects, which answer positively to the <br>
//! filters, which are in position when a local context is open. <br>
class AIS_AttributeFilter : public SelectMgr_Filter {

public:
 // Methods PUBLIC
 // 


//! Constructs an empty attribute filter object. <br>
//! This filter object determines whether selectable <br>
//! interactive objects have a non-null owner. <br>
Standard_EXPORT AIS_AttributeFilter();


//! Constructs an attribute filter object defined by the <br>
//! color attribute aCol. <br>
Standard_EXPORT AIS_AttributeFilter(const Quantity_NameOfColor aCol);


//! Constructs an attribute filter object defined by the line <br>
//! width attribute aWidth. <br>
Standard_EXPORT AIS_AttributeFilter(const Standard_Real aWidth);

//! Indicates that the Interactive Object has the color <br>
//! setting specified by the argument aCol at construction time. <br>
  Standard_Boolean HasColor() const;

//! Indicates that the Interactive Object has the width <br>
//! setting specified by the argument aWidth at <br>
//! construction time. <br>
  Standard_Boolean HasWidth() const;
//! Sets the color aCol. <br>
//! This must be chosen from the list of colors in Quantity_NameOfColor. <br>
  void SetColor(const Quantity_NameOfColor aCol) ;
//!  Sets the line width aWidth. <br>
  void SetWidth(const Standard_Real aWidth) ;

//! Removes the setting for color from the filter. <br>
  void UnsetColor() ;

//! Removes the setting for width from the filter. <br>
  void UnsetWidth() ;

//! Indicates that the selected Interactive Object passes <br>
//! the filter. The owner, anObj, can be either direct or <br>
//! user. A direct owner is the corresponding <br>
//! construction element, whereas a user is the <br>
//! compound shape of which the entity forms a part. <br>
//! If the Interactive Object returns Standard_True <br>
//! when detected by the Local Context selector through <br>
//! the mouse, the object is kept; if not, it is rejected. <br>
Standard_EXPORT virtual  Standard_Boolean IsOk(const Handle(SelectMgr_EntityOwner)& anObj) const;
//Standard_EXPORT ~AIS_AttributeFilter();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Quantity_NameOfColor myCol;
Standard_Real myWid;
Standard_Boolean hasC;
Standard_Boolean hasW;


};


#include <AIS_AttributeFilter.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
