# ------------------------------------------------------------------------
# Copyright (C) 2001 Other Contributors.
#
# Permission to use, copy, distribute and modify this software and its
# documentation for any purpose is hereby granted without fee, provided that
# the above copyright notice appear in all copies and that both that copyright
# notice and this permission notice appear in supporting documentation.
#
# Other Contributors make no representations about the suitability of this
# software for any purpose. It is provided "as is" without express or implied
# warranty.
#
# Other Contributors are: Grzegorz Jakacki.
# ------------------------------------------------------------------------
#

dnl AM_PATH_GC()
dnl Test for Boehm's Garbage Collector
dnl
AC_DEFUN(AM_PATH_GC,
[dnl
dnl Get the Bohem's gc configuration
dnl
AC_ARG_WITH(gc-prefix,
    [  --with-gc-prefix=PFX         dir where Bohem's GC is installed],
    [ gc_includedir="$withval";  gc_libdir="$withval"; 
      gc_external=true; ],
    [ gc_includedir='$(top_srcdir)/gc/include'; gc_libdir='$(top_builddir)/gc'; 
      gc_external=false; ])
AC_SUBST(gc_includedir)
AC_SUBST(gc_libdir)
AC_SUBST(gc_external)
])

dnl GC_CHECK_LIB
dnl Test for Boehm's GC
dnl
AC_DEFUN(GC_CHECK_LIB,
[
if test "$gc_external" = "true"; then
    OLD_CPPFLAGS=$CPPFLAGS
    OLD_LIBS=$LIBS
    CPPFLAGS="$CPPFLAGS -I$gc_includedir"
    LIBS="$LIBS -L$gc_libdir"
    AC_CHECK_LIB(gc, GC_abort, occ_have_gc=true)
    CPPFLAGS=$OLD_CPPFLAGS
    LIBS=$OLD_LIBS
fi
])

dnl OCC_PROG_BASH
dnl Test for Bourne Again Shell (BASH)
dnl
AC_DEFUN(OCC_PROG_BASH,
[
AC_MSG_CHECKING([for bash])
if bash --version >/dev/null 2>/dev/null; then
    BASH_SH=`bash -ec 'echo $BASH'`
    AC_MSG_RESULT($BASH_SH)
else
    AC_MSG_RESULT("not found")
    BASH_SH=""
fi
])
