#!/bin/sh

set -e

cd debian/tmp/usr/lib/openarena

arch="$1"

case "$arch" in
    (x86)
        compat=i386
        ;;
    (i386)
        compat=x86
        ;;
    (alpha)
        compat=axp
        ;;
    (axp)
        compat=alpha
        ;;
esac

if test -n "$compat"; then
    for module in baseoa/*${arch}.so baseoa/pak*/*${arch}.so missionpack/*${arch}.so; do
        ln -s ${module##*/} ${module%${arch}.so}${compat}.so
    done
fi
