/*
  Copyright (C) 1991-2002, The Numerical ALgorithms Group Ltd.
  All rights reserved.
  Copyright (C) 2007-2008, Gabriel Dos Reis.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

      - Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

      - Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in
        the documentation and/or other materials provided with the
        distribution.

      - Neither the name of The Numerical ALgorithms Group Ltd. nor the
        names of its contributors may be used to endorse or promote products
        derived from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/* main procedure to test out Gdraw functions in this directory */
#include <stdio.h>
#include "Gdraws0.h"
#include "../view3D/header.h"

GC              gc, gc1;
Display         *dsply;
int             scrn;
viewPoints      *viewport;

int             psInit=no;
GCptr           GChead=NULL;
char            *PSfilename="OUTPUT.ps";
char            *envAXIOM;

int
main(int argc, char **argv)
{

   XGCValues    values;

   XEvent       report;
   int          x0=0, y0=0, width=300, height=200, border=3;

   char         *fontname = "6x13";
   XFontStruct  *dsp_font;

   Window       menu;
   char         *str1 = "     Print out the PostScript file?    ",
                *str0 = "Generate a PostScript file (OUTPUT.ps)?";
   int          m_width, m_height, flag=yes;

   /* open display */
   if ((dsply = XOpenDisplay(NULL)) == NULL) {
     printf("Can't open display NULL\n");
     exit(-1);
   }

   scrn = DefaultScreen(dsply);

   /* access font */
   Gdraws_load_font(&dsp_font, fontname);

   values.background = WhitePixel(dsply, scrn);
   values.foreground = BlackPixel(dsply, scrn);

   gc = XCreateGC(dsply, RootWindow(dsply, scrn),
                  (GCForeground | GCBackground), &values);
   PSGlobalInit();      /* must initiate before using G/PS functions */
   PSCreateContext(gc, "gc", psNormalWidth, psButtCap,
                   psMiterJoin, psWhite, psBlack);
   XSetFont(dsply, gc, dsp_font->fid);
   gc1 = XCreateGC(dsply, RootWindow(dsply, scrn),
                   (GCForeground | GCBackground), &values);
   PSCreateContext(gc1, "gc1", psNormalWidth, psButtCap, psMiterJoin,
                   psWhite, psBlack);
   XSetFont(dsply, gc1, dsp_font->fid);

   if (!(viewport = (viewPoints *)malloc(sizeof(viewPoints)))) {
     fprintf(stderr,"Ran out of memory (malloc) trying to create a viewport.\n");
     exit(-1);
   }

   viewport->titleWindow = XCreateSimpleWindow(dsply, RootWindow(dsply,scrn),
                                               x0, y0, width+6,
                                               height+32+height/4, border,
                                               BlackPixel(dsply, scrn),
                                               WhitePixel(dsply, scrn));

   viewport->viewWindow = XCreateSimpleWindow(dsply, viewport->titleWindow,
                                              x0, y0+20, width, height, border,
                                              BlackPixel(dsply, scrn),
                                              WhitePixel(dsply, scrn));

   strcpy(viewport->title, "what is a test title?");

   m_width = width; m_height = height/4;
   menu = XCreateSimpleWindow(dsply, viewport->titleWindow, x0, y0+20+height+6,
                              m_width, m_height, border,
                              BlackPixel(dsply,scrn), WhitePixel(dsply,scrn));

   XSelectInput(dsply, viewport->viewWindow,
                KeyPressMask|ButtonPressMask|ExposureMask);
   XSelectInput(dsply, viewport->titleWindow, KeyPressMask|ExposureMask);
   XSelectInput(dsply, menu, KeyPressMask|ButtonPressMask|ExposureMask);

   XMapWindow(dsply, viewport->viewWindow);
   XMapWindow(dsply, viewport->titleWindow);
   XFlush(dsply);

   while (yes) {
      XNextEvent(dsply, &report);
      switch (report.type) {

         case Expose:
                if (report.xexpose.window==viewport->titleWindow) {
                  if (GDrawImageString(gc, viewport->titleWindow,
                                       20, 15, viewport->title,
                                       strlen(viewport->title),X) == psError)
                    printf("screen draw image string failed.\n");
                  if (Gdraws_data(X) == psError)
                    printf("screen Gdraws_data failed.\n");
                }
                if (report.xexpose.window==viewport->viewWindow) {
                  if (Gdraws_data(X) == psError)
                    printf("screen Gdraws_data failed.\n");
                }
                else if (report.xexpose.window==menu) {
                  if (flag)
                    Gdraws_draw_menu(menu, str0, m_width, m_height);
                  else
                    Gdraws_draw_menu(menu, str1, m_width, m_height);
                }
                break;

         case ButtonPress:
                if (report.xbutton.window==viewport->viewWindow) {
                  XMapWindow(dsply, menu);
                  XFlush(dsply);
                }
                else if (report.xbutton.window==menu && flag) {
                       XUnmapWindow(dsply, menu);
                       if (Gdraws_pressed_yes(m_width, m_height, report.xbutton.x,
                           report.xbutton.y)) {
                         flag=no;
                         XMapWindow(dsply, menu);
                         PSInit(viewport->viewWindow, viewport->titleWindow);
                         if (Gdraws_data(PS) != psError)
                           PSCreateFile(3,viewport->viewWindow,
                                        viewport->titleWindow,viewport->title);
                         else printf("PS Gdraws_data failed.\n");
                       }
                     }
                else if (report.xbutton.window==menu && !flag) {
                       XUnmapWindow(dsply, menu);
                       if (Gdraws_pressed_yes(m_width, m_height, report.xbutton.x,
                           report.xbutton.y))
                         system("print OUTPUT.ps");
                       flag = yes;
                     }
                break;

         case KeyPress:
                if (report.xkey.window==viewport->viewWindow ||
                    report.xkey.window==viewport->titleWindow) {
                  XFreeGC(dsply, gc);
                  XFreeGC(dsply, gc1);
                  XCloseDisplay(dsply);
                  PSClose();
                  exit(1);
                }
                else if (report.xkey.window==menu) XUnmapWindow(dsply, menu);

         default:
                break;
      }
   }
   return 0;
}
