/***************************************************************************
 *   Copyright (C) 2006 by Christian Nitschkowski   *
 *   christian.nitschkowski@kdemail.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef OOOQS2CONFIGDIALOG_H
#define OOOQS2CONFIGDIALOG_H

#include "wgtadvanced.h"
#include "wgtgeneral.h"

#include <qcheckbox.h>

#include <kcombobox.h>
#include <kdialogbase.h>
#include <kurlrequester.h>

/**
	@author Christian Nitschkowski <christian.nitschkowski@kdemail.net>
*/
class OOoQs2ConfigDialog : public KDialogBase
{
   Q_OBJECT
   public:
      OOoQs2ConfigDialog( const bool onError, QWidget* parent );

      ~OOoQs2ConfigDialog();

      inline int quickAccess() const
      {
         return p_wgtGeneral->comboAccess->currentItem();
      }

      QString binary() const
      {
         return p_wgtAdvanced->urlBinary->url();
      }

      inline bool autostart() const
      {
         return p_wgtGeneral->checkAutostart->isChecked();
      }

      inline bool preload() const
      {
         return p_wgtAdvanced->checkPreload->isChecked();
      }

      inline bool overrideAutodetection() const
      {
         return p_wgtAdvanced->checkOverride->isChecked();
      }

   private:
      WgtAdvanced* p_wgtAdvanced;
      WgtGeneral* p_wgtGeneral;

   private slots:
      void preloadingToggled( bool );
};

#endif
