/*
* Copyright (C) 2003 Christian Nitschkowski <segfault_ii@web.de>
*/

#include <stdlib.h>

#include <qdir.h>

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdesktopfile.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kuniqueapplication.h>

#include "oooqs.h"

static const char description[] =
    I18N_NOOP( "The OpenOffice.org Quickstarter for KDE" );

static const char version[] = "2.0.2";

static KCmdLineOptions options[] =
    {
        KCmdLineLastOption
    };

int main( int argc, char **argv ) {
	OOoQs *mainWin = 0;
	int returnValue;

	KAboutData about( "oooqs",
	                  I18N_NOOP( "OpenOffice.org Quickstarter" ),
	                  version, description, KAboutData::License_GPL,
	                  "(C) 2003 Christian Nitschkowski",
	                  0, 0, "segfault_ii@web.de" );
	about.addAuthor( "Christian Nitschkowski",
	                 0, "segfault_ii@web.de" );

	KCmdLineArgs::init( argc, argv, &about );
	KCmdLineArgs::addCmdLineOptions( options );

	KUniqueApplication app;

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	/**
	Disable the regular session management.
	OOoQs takes care for itself if it should be restarted
	on login.
	*/
	app.disableSessionManagement();

	mainWin = new OOoQs();
	if ( !mainWin->okToRun() ) {
		delete mainWin;
		/**
		Return with an errorcode as defined in stdlib.h
		*/
		return EXIT_FAILURE;
		}

	app.setMainWidget( mainWin );
	mainWin->show();

	args->clear();

	returnValue = app.exec();
	/**
	Delete the mainwindow manually to make sure the destructor is
	called and the user asked for remaining soffice-instances.
	*/
	delete mainWin;

	return returnValue;
	}
