/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "RequestPortValueEvent.h"
#include <string>
#include "Om.h"
#include "OSCSender.h"
#include "Port.h"
#include "ObjectStore.h"

using std::string;

namespace Om {


RequestPortValueEvent::RequestPortValueEvent(Request* request, const string& url, const string& port_path)
: SlowEvent(request),
  m_url(url),
  m_addr(lo_address_new_from_url(url.c_str())),
  m_port_path(port_path),
  m_port(NULL),
  m_value(0.0)
{
}


RequestPortValueEvent::~RequestPortValueEvent()
{
	lo_address_free(m_addr);
}


void
RequestPortValueEvent::prepare()
{
	m_port = om->object_store()->find_port(m_port_path);

	SlowEvent::prepare();
}


void
RequestPortValueEvent::execute(uint sample_offset)
{
	if (m_port != NULL)
		m_value = m_port->get_value(0, sample_offset);
	
	SlowEvent::execute(sample_offset);
}


void
RequestPortValueEvent::post_process()
{
	string msg;
	if (m_port == NULL) {
		m_request->respond_error("Unable to find port for get_value request.");
	} else if (m_addr != NULL) {
		m_request->respond_ok();
		om->osc_sender()->send_control_change_to(m_addr, m_port_path, m_value);
	} else {
		m_request->respond_error("Invalid URL");
	}
}


} // namespace Om

