/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <iostream>
#include <unistd.h>
#include <libgnomecanvasmm.h>
#include <string>
#include "config.h"
#include "OmGtk.h"
#include "StateManager.h"
#include "Controller.h"
#include "OmGtkApp.h"
#include "GladeFactory.h"
#include "cmdline.h"
#ifdef HAVE_LASH
#include "LashController.h"
#endif
using std::string; using std::cout; using std::cerr; using std::endl;
using namespace OmGtk;

bool cleanup();

int
main(int argc, char *argv[])
{
	OmGtk::glade_factory = new GladeFactory();
	OmGtk::controller = new Controller();
	OmGtk::state_manager = new StateManager();
	OmGtk::state_manager->load_settings();

	Gnome::Canvas::init();
	Gtk::Main gtk_main(argc, argv);
	
	const char* engine_url  = NULL;
	int         client_port = 0;

	app = new OmGtkApp();
	
	#ifdef HAVE_LASH
	lash_args_t* lash_args = lash_extract_args(&argc, &argv);
	#endif // HAVE_LASH

	
	/* Parse command line options */
	gengetopt_args_info args_info;
	if (cmdline_parser (argc, argv, &args_info) != 0)
		return 1;

	if (args_info.engine_url_given) {
		engine_url = args_info.engine_url_arg;
	} else {
		cout << "[Main] No engine URL specified.  Attempting to use osc.udp://localhost:16180" << endl;
		engine_url = "osc.udp://localhost:16180";
	}	

	if (args_info.client_port_given)
		client_port = args_info.client_port_arg;
	else
		client_port = 0; // will choose a free port automatically
	
	/* Connect to engine */
	controller->attach(engine_url, client_port);
	controller->register_client();

	controller->request_plugins();
	controller->request_all_objects();
	
	gtk_main.signal_quit().connect(sigc::ptr_fun(cleanup));		
	
	string msg = "Connected to engine at ";
	msg.append(controller->engine_url());
	app->set_status_bar_text(msg);
	
	#ifdef HAVE_LASH
		lash_controller = new LashController(app, lash_args);
	#endif // HAVE_LASH
	
	gtk_main.run(*app->window());

	return 0;
}


bool
cleanup()
{
	delete app;
	delete controller;
	delete state_manager;
	delete glade_factory;

	return false;
}
