#ifndef OKLE_WIN_H
#define OKLE_WIN_H

#include <kmainwindow.h>

#include "okleiface.h"

extern "C" {
#include <ogle/dvd.h>
#include <ogle/dvdcontrol.h>
#include <ogle/dvdbookmarks.h>
}

class QPushButton;
class QPopupMenu;
class KToggleAction;
class KActionMenu;
class KSelectAction;
class KListAction;
class KStatusBar;
class QLabel;
class QSlider;
class Prefs;
class Sniffer;
class DCOPClient;

class OkleWin : public KMainWindow , virtual public OkleIface
{
 Q_OBJECT
public:
 OkleWin(int /*msgqid*/);
 virtual ~OkleWin();

 void setFullScreen(bool /*fullscreen*/);
 bool isFullScreen()const;
 void toggleFullScreen();

 // these two needed from sniffer.cpp...
 void setToTop(bool /*totop*/);
 bool isSetToTop()const;

 bool isPaused()const;
 bool isPlaying()const;

 int currentTitle()const;
 int currentChapter()const;
public slots:
 void openDisc();
 void openFile(const QString& path = "");
 void closeDisc();
 void quit();
 
 void takeScreenshot(const QString& /*filename*/,bool /*withsubtitle*/);
 
 void play();
 void reverse();
 void pause();
 void unpause();
 void stop();
 void rewind();
 void fastForward();
 void nextChapter();
 void previousChapter();
 void stepReverse();
 void stepForward();
 void fast();
 void slow();
 void gotoTitleHighlighted(int /*title*/);
 void gotoChapter(int /*chapter*/);
 void gotoTime();
 
 void up();
 void down();
 void left();
 void right();
 void enter();
 void goUp();
 void resume();
 
 void titleMenu();
 void rootMenu();
 void audioMenu();
 void angleMenu();
 void chapterMenu();
 void subtitleMenu();

 void addBookmark(const QString& /*usercomment*/);
 void removeAllBookmarks();
 void removeBookmark(int /*bookmarknr*/);

 void setVolume(int /*volume*/);
 int volume();

 void mute();
 void unmute();
 void toggleMute();
 bool isMuted()const;
 
 // needed from sniffer.cpp...
 void keyPressed(int /*x11keysym*/);
protected:
 void keyPressEvent(QKeyEvent* /*keyevent*/);
 void closeEvent(QCloseEvent* /*closeevent*/);
private slots:
 void DVDInfo();
 void preferences();

 void viewFullscreenActivated();
 void viewScreenshotActivated();
 
 void selectMenu(int /*menu*/);
 void subTitleSelect(int /*subtitle*/);
 void audioSelect(int /*audio*/);
 void angleSelect(int /*angle*/);
 
 void bookmarkAddBookmark();
 void bookmarkRemoveActivated(int /*bookmarknr*/);
 void bookmarkActivated(int /*bookmarknr*/);
 void editBookmarks();

 void sliderPressed();
 void sliderReleased();
 
 void volumeChanged(int /*volume*/);
 
 void toggleMuteButton(bool /*muted*/);

 void updatePosition();
private:
 void initNav();
 void initSniffer();
 void initDCOP();
 void initMenuBar();
 void initUI();
 void initStatusBar();
 void initOpen();

 void setJustStartedState();
 void setStoppedState();
 void setPlayingState();

 void updateAudioChannels();
 void updateSubtitles();
 void updateAngles();

 void readConfig(KConfig*);
 void saveConfig(KConfig*);

 void disableDPMS();
 void restoreDPMS();

 void disableScreensaver();
 void restoreScreensaver();

 void loadBookmarks();

 QString twonum(const QString&);
 bool timecode_eq(DVDTimecode_t,DVDTimecode_t);

 void _notimpl(); // messagebox "Feature not implemented."
 
 
 QPushButton *rewindB,*reverseB,*stopB,*playB,*fastforwardB,
             *skipbackwardB,*stepreverseB,*pauseB,*stepforwardB,*skipforwardB;
 QPushButton *selectmenu,*audioselect,*subtitleselect,*angleselect;
 QSlider *volumeslider;
 QPushButton *mutebutton;
 QPopupMenu *audioChannels,*subtitleChannels,*angles,*menus;
 KAction *fileOpenDisc,*fileOpenFile,*fileCloseDisc,*fileDVDInfo;
 KAction *goPlay,*goPause,*goStop,*goPrevChapter,*goNextChapter,*goFast,*goSlow,*goGotoTime;
 KAction *menuUp,*menuDown,*menuLeft,*menuRight,*menuEnter,*menuGoUp,*menuResume,
         *menuTitleMenu,*menuRootMenu,*menuAudioMenu,*menuAngleMenu,*menuChapterMenu,*menuSubtitleMenu;
 KAction *bookmarkAdd,*bookmarkRemoveAll,*bookmarkEdit;
 KToggleAction* viewFullscreen;
 KAction* viewScreenshot;
 KActionMenu *goGoto,*selChapter,*bookmarksMenu,*bookmarkRemove;
 QLabel *infoctime,*infottime,*infotitle,*infochapter,*infoaudio,*infosubtitle;
 QSlider* slider;
 int oldsliderval;
 int stoptitle,stopchapter;
 KConfig* conf;
 DVDNav_t* nav;
 DVDBookmark_t* bookmarks;
 Sniffer* sniffer;
 int currtitle;
 int oldtitle,oldchapter;
 DVDTimecode_t oldctime,oldttime;
 double speed;
 bool ispaused;
 bool isinited;
 bool isstopped;
 bool sliderMoving;
 bool hasDPMS;
 unsigned short dpms_standby,dpms_suspend,dpms_off;
 bool hasScreensaver;
 DCOPClient* dcopclient;
 int msgqid;
};

#endif // OKLE_WIN_H
