#include "gototime_win.h"

#include <klocale.h>
#include <klineedit.h>
#include <qvalidator.h>
#include <qlayout.h>
#include <qlabel.h>

GotoTimeWin::GotoTimeWin(QWidget* parent) : KDialogBase(parent,"",true,i18n("Go to time"),Ok|Cancel,Ok)
{
 QFrame* page = makeMainWidget();

 QVBoxLayout* layout = new QVBoxLayout(page,0,marginHint());

 QHBoxLayout* hbox = new QHBoxLayout(layout);

 QLabel* time = new QLabel(i18n("Time:")+" ",page);
 hbox->addWidget(time);

 h = new KLineEdit("00",page);
 h->setFocus();
 h->setFixedWidth(h->fontMetrics().maxWidth()*2);
 h->setValidator(new QIntValidator(0,99,h));
 h->setMaxLength(2);
 hbox->addWidget(h);
 
 QLabel* c1 = new QLabel(" :",page);
 hbox->addWidget(c1);

 m = new KLineEdit("00",page);
 m->setFixedWidth(m->fontMetrics().maxWidth()*2);
 m->setValidator(new QIntValidator(0,60,m));
 m->setMaxLength(2);
 hbox->addWidget(m);

 QLabel* c2 = new QLabel(" :",page);
 hbox->addWidget(c2);

 s = new KLineEdit("00",page);
 s->setFixedWidth(s->fontMetrics().maxWidth()*2);
 s->setValidator(new QIntValidator(0,60,s));
 s->setMaxLength(2);
 hbox->addWidget(s);
 
 layout->activate();
}

GotoTimeWin::~GotoTimeWin()
{}

void GotoTimeWin::setHour(int i)
{
 QString tmp = QString::number(i);
 if(i<10)
  tmp.prepend('0');
 h->setText(tmp);
}

int GotoTimeWin::hour()const
{
 return h->text().toInt();
}

void GotoTimeWin::setMinute(int i)
{
 QString tmp = QString::number(i);
 if(i<10)
  tmp.prepend('0');
 m->setText(tmp);
}

int GotoTimeWin::minute()const
{
 return m->text().toInt();
}

void GotoTimeWin::setSecond(int i)
{ 
 QString tmp = QString::number(i);
 if(i<10)
  tmp.prepend('0');
 s->setText(tmp);
}

int GotoTimeWin::second()const
{
 return s->text().toInt();
}

#include "gototime_win.moc"
