#include <klocale.h>

#include "country.h"

CountryCode::CountryCode(const QString& n,const QString& c)
{
 name = n;
 code = c;
}

// country codes
void Country::init()
{
 countries.append(new CountryCode(I18N_NOOP("Afghanistan"),"af"));
 countries.append(new CountryCode(I18N_NOOP("Albania"),"al"));
 countries.append(new CountryCode(I18N_NOOP("Algeria"),"dz"));
 countries.append(new CountryCode(I18N_NOOP("American Samoa"),"as"));
 countries.append(new CountryCode(I18N_NOOP("Andorra"),"ad"));
 countries.append(new CountryCode(I18N_NOOP("Angola"),"ao"));
 countries.append(new CountryCode(I18N_NOOP("Anguilla"),"ai"));
 countries.append(new CountryCode(I18N_NOOP("Antarctica"),"aq"));
 countries.append(new CountryCode(I18N_NOOP("Antigua and Barbuda"),"ag"));
 countries.append(new CountryCode(I18N_NOOP("Argentina"),"ar"));
 countries.append(new CountryCode(I18N_NOOP("Armenia"),"am"));
 countries.append(new CountryCode(I18N_NOOP("Aruba"),"aw"));
 countries.append(new CountryCode(I18N_NOOP("Australia"),"au"));
 countries.append(new CountryCode(I18N_NOOP("Austria"),"at"));
 countries.append(new CountryCode(I18N_NOOP("Azerbaijan"),"az"));
 countries.append(new CountryCode(I18N_NOOP("Bahamas"),"bs"));
 countries.append(new CountryCode(I18N_NOOP("Bahrain"),"bh"));
 countries.append(new CountryCode(I18N_NOOP("Bangladesh"),"bd"));
 countries.append(new CountryCode(I18N_NOOP("Barbados"),"bb"));
 countries.append(new CountryCode(I18N_NOOP("Belarus"),"by"));
 countries.append(new CountryCode(I18N_NOOP("Belgium"),"be"));
 countries.append(new CountryCode(I18N_NOOP("Belize"),"bz"));
 countries.append(new CountryCode(I18N_NOOP("Benin"),"bj"));
 countries.append(new CountryCode(I18N_NOOP("Bermuda"),"bm"));
 countries.append(new CountryCode(I18N_NOOP("Bhutan"),"bt"));
 countries.append(new CountryCode(I18N_NOOP("Bolivia"),"bo"));
 countries.append(new CountryCode(I18N_NOOP("Bosina and Herzegovina"),"ba"));
 countries.append(new CountryCode(I18N_NOOP("Botswana"),"bw"));
 countries.append(new CountryCode(I18N_NOOP("Bouvet Island"),"bv"));
 countries.append(new CountryCode(I18N_NOOP("Brazil"),"br"));
 countries.append(new CountryCode(I18N_NOOP("British Indian Ocean Territory"),"io"));
 countries.append(new CountryCode(I18N_NOOP("Brunei Darussalam"),"bn"));
 countries.append(new CountryCode(I18N_NOOP("Bulgaria"),"bg"));
 countries.append(new CountryCode(I18N_NOOP("Burkina Faso"),"bf"));
 countries.append(new CountryCode(I18N_NOOP("Burundi"),"bi"));
 countries.append(new CountryCode(I18N_NOOP("Cambodia"),"kh"));
 countries.append(new CountryCode(I18N_NOOP("Cameroon"),"cm"));
 countries.append(new CountryCode(I18N_NOOP("Canada"),"ca"));
 countries.append(new CountryCode(I18N_NOOP("Cape Verde"),"cv"));
 countries.append(new CountryCode(I18N_NOOP("Cayman Islands"),"ky"));
 countries.append(new CountryCode(I18N_NOOP("Central African Republic"),"cf"));
 countries.append(new CountryCode(I18N_NOOP("Chad"),"td"));
 countries.append(new CountryCode(I18N_NOOP("Chile"),"cl"));
 countries.append(new CountryCode(I18N_NOOP("China"),"cn"));
 countries.append(new CountryCode(I18N_NOOP("Christmas Island"),"cx"));
 countries.append(new CountryCode(I18N_NOOP("Cocos (Keeling) Islands"),"cc"));
 countries.append(new CountryCode(I18N_NOOP("Colombia"),"co"));
 countries.append(new CountryCode(I18N_NOOP("Comoros"),"km"));
 countries.append(new CountryCode(I18N_NOOP("Congo"),"cg"));
 countries.append(new CountryCode(I18N_NOOP("Congo, The Democratic Republic of The"),"cd"));
 countries.append(new CountryCode(I18N_NOOP("Cook Islands"),"ck"));
 countries.append(new CountryCode(I18N_NOOP("Costa Rica"),"cr"));
 // TRANSLATORS: this is really C&#244;te D'Ivoire
 countries.append(new CountryCode(I18N_NOOP("Cote d'Ivoire"),"ci"));
 countries.append(new CountryCode(I18N_NOOP("Croatia"),"hr"));
 countries.append(new CountryCode(I18N_NOOP("Cuba"),"cu"));
 countries.append(new CountryCode(I18N_NOOP("Cyprus"),"cy"));
 countries.append(new CountryCode(I18N_NOOP("Czech Republic"),"cz"));
 countries.append(new CountryCode(I18N_NOOP("Denmark"),"dk"));
 countries.append(new CountryCode(I18N_NOOP("Djibouti"),"dj"));
 countries.append(new CountryCode(I18N_NOOP("Dominica"),"dm"));
 countries.append(new CountryCode(I18N_NOOP("Dominican Republic"),"do"));
 countries.append(new CountryCode(I18N_NOOP("East Timor"),"tl"));
 countries.append(new CountryCode(I18N_NOOP("Ecuador"),"ec"));
 countries.append(new CountryCode(I18N_NOOP("Egypt"),"eg"));
 countries.append(new CountryCode(I18N_NOOP("El Salvador"),"sv"));
 countries.append(new CountryCode(I18N_NOOP("Equatorial Guinea"),"gq"));
 countries.append(new CountryCode(I18N_NOOP("Eritrea"),"er"));
 countries.append(new CountryCode(I18N_NOOP("Estonia"),"ee"));
 countries.append(new CountryCode(I18N_NOOP("Ethiopia"),"et"));
 countries.append(new CountryCode(I18N_NOOP("Falkland Islands (Malvinas)"),"fk"));
 countries.append(new CountryCode(I18N_NOOP("Faroe Islands"),"fo"));
 countries.append(new CountryCode(I18N_NOOP("Fiji"),"fj"));
 countries.append(new CountryCode(I18N_NOOP("Finland"),"fi"));
 countries.append(new CountryCode(I18N_NOOP("France"),"fr"));
 countries.append(new CountryCode(I18N_NOOP("French Guiana"),"gf"));
 countries.append(new CountryCode(I18N_NOOP("French Polynesia"),"pf"));
 countries.append(new CountryCode(I18N_NOOP("French Southern Territories"),"tf"));
 countries.append(new CountryCode(I18N_NOOP("Gabon"),"ga"));
 countries.append(new CountryCode(I18N_NOOP("Gambia"),"gm"));
 countries.append(new CountryCode(I18N_NOOP("Georgia"),"ge"));
 countries.append(new CountryCode(I18N_NOOP("Germany"),"de"));
 countries.append(new CountryCode(I18N_NOOP("Ghana"),"gh"));
 countries.append(new CountryCode(I18N_NOOP("Gibraltar"),"gi"));
 countries.append(new CountryCode(I18N_NOOP("Greece"),"gr"));
 countries.append(new CountryCode(I18N_NOOP("Greenland"),"gl"));
 countries.append(new CountryCode(I18N_NOOP("Grenada"),"gd"));
 countries.append(new CountryCode(I18N_NOOP("Guadeloupe"),"gp"));
 countries.append(new CountryCode(I18N_NOOP("Guam"),"gu"));
 countries.append(new CountryCode(I18N_NOOP("Guatemala"),"gt"));
 countries.append(new CountryCode(I18N_NOOP("Guinea"),"gn"));
 countries.append(new CountryCode(I18N_NOOP("Guinea-Bissau"),"gw"));
 countries.append(new CountryCode(I18N_NOOP("Guyana"),"gy"));
 countries.append(new CountryCode(I18N_NOOP("Haiti"),"hi"));
 countries.append(new CountryCode(I18N_NOOP("Heard Island and McDonald Islands"),"hm"));
 countries.append(new CountryCode(I18N_NOOP("Vatican City State"),"va"));
 countries.append(new CountryCode(I18N_NOOP("Honduras"),"hn"));
 countries.append(new CountryCode(I18N_NOOP("Hong Kong"),"hk"));
 countries.append(new CountryCode(I18N_NOOP("Hungary"),"hu"));
 countries.append(new CountryCode(I18N_NOOP("Iceland"),"is"));
 countries.append(new CountryCode(I18N_NOOP("India"),"in"));
 countries.append(new CountryCode(I18N_NOOP("Indonesia"),"id"));
 countries.append(new CountryCode(I18N_NOOP("Iran, Islamic Republic of"),"ir"));
 countries.append(new CountryCode(I18N_NOOP("Iraq"),"iq"));
 countries.append(new CountryCode(I18N_NOOP("Ireland"),"ie"));
 countries.append(new CountryCode(I18N_NOOP("Israel"),"il"));
 countries.append(new CountryCode(I18N_NOOP("Italy"),"it"));
 countries.append(new CountryCode(I18N_NOOP("Jamaica"),"jm"));
 countries.append(new CountryCode(I18N_NOOP("Japan"),"jp"));
 countries.append(new CountryCode(I18N_NOOP("Jordan"),"jo"));
 countries.append(new CountryCode(I18N_NOOP("Kazakhstan"),"kz"));
 countries.append(new CountryCode(I18N_NOOP("Kenya"),"ke"));
 countries.append(new CountryCode(I18N_NOOP("Kiribati"),"ki"));
 countries.append(new CountryCode(I18N_NOOP("Korea, Democratic People's Republic of"),"kp"));
 countries.append(new CountryCode(I18N_NOOP("Korea, Republic of"),"kr"));
 countries.append(new CountryCode(I18N_NOOP("Kuwait"),"kw"));
 countries.append(new CountryCode(I18N_NOOP("Kyrgyzstan"),"kg"));
 countries.append(new CountryCode(I18N_NOOP("Lao People's Democratic Republic"),"la"));
 countries.append(new CountryCode(I18N_NOOP("Latvia"),"lv"));
 countries.append(new CountryCode(I18N_NOOP("Lebanon"),"lb"));
 countries.append(new CountryCode(I18N_NOOP("Lesotho"),"ls"));
 countries.append(new CountryCode(I18N_NOOP("Liberia"),"lr"));
 countries.append(new CountryCode(I18N_NOOP("Libyan Arab Jamahiriya"),"ly"));
 countries.append(new CountryCode(I18N_NOOP("Liechtenstein"),"li"));
 countries.append(new CountryCode(I18N_NOOP("Lithuania"),"lt"));
 countries.append(new CountryCode(I18N_NOOP("Luxembourg"),"lu"));
 countries.append(new CountryCode(I18N_NOOP("Macao"),"mo"));
 countries.append(new CountryCode(I18N_NOOP("Macedonia, The Former Yugoslav Republic of"),"mk"));
 countries.append(new CountryCode(I18N_NOOP("Madagascar"),"mg"));
 countries.append(new CountryCode(I18N_NOOP("Malawi"),"mw"));
 countries.append(new CountryCode(I18N_NOOP("Malaysia"),"my"));
 countries.append(new CountryCode(I18N_NOOP("Maldives"),"mv"));
 countries.append(new CountryCode(I18N_NOOP("Mali"),"ml"));
 countries.append(new CountryCode(I18N_NOOP("Malta"),"mt"));
 countries.append(new CountryCode(I18N_NOOP("Marshall Islands"),"mh"));
 countries.append(new CountryCode(I18N_NOOP("Martinique"),"mq"));
 countries.append(new CountryCode(I18N_NOOP("Mauritania"),"mr"));
 countries.append(new CountryCode(I18N_NOOP("Mauritius"),"mu"));
 countries.append(new CountryCode(I18N_NOOP("Mayotte"),"yt"));
 countries.append(new CountryCode(I18N_NOOP("Mexico"),"mx"));
 countries.append(new CountryCode(I18N_NOOP("Micronesia, Federated States of"),"fm"));
 countries.append(new CountryCode(I18N_NOOP("Moldova, Republic of"),"md"));
 countries.append(new CountryCode(I18N_NOOP("Monaco"),"mc"));
 countries.append(new CountryCode(I18N_NOOP("Mongolia"),"mn"));
 countries.append(new CountryCode(I18N_NOOP("Montserrat"),"ms"));
 countries.append(new CountryCode(I18N_NOOP("Morocco"),"ma"));
 countries.append(new CountryCode(I18N_NOOP("Mozambique"),"mz"));
 countries.append(new CountryCode(I18N_NOOP("Myanmar"),"mm"));
 countries.append(new CountryCode(I18N_NOOP("Namibia"),"na"));
 countries.append(new CountryCode(I18N_NOOP("Nauru"),"nr"));
 countries.append(new CountryCode(I18N_NOOP("Nepal"),"np"));
 countries.append(new CountryCode(I18N_NOOP("Netherlands"),"nl"));
 countries.append(new CountryCode(I18N_NOOP("Netherlands Antilles"),"an"));
 countries.append(new CountryCode(I18N_NOOP("New Caledonia"),"nc"));
 countries.append(new CountryCode(I18N_NOOP("New Zealand"),"nz"));
 countries.append(new CountryCode(I18N_NOOP("Nicaragua"),"ni"));
 countries.append(new CountryCode(I18N_NOOP("Niger"),"ne"));
 countries.append(new CountryCode(I18N_NOOP("Nigeria"),"ng"));
 countries.append(new CountryCode(I18N_NOOP("Niue"),"nu"));
 countries.append(new CountryCode(I18N_NOOP("Norfolk Island"),"nf"));
 countries.append(new CountryCode(I18N_NOOP("Northern Mariana Islands"),"mp"));
 countries.append(new CountryCode(I18N_NOOP("Norway"),"no"));
 countries.append(new CountryCode(I18N_NOOP("Oman"),"om"));
 countries.append(new CountryCode(I18N_NOOP("Pakistan"),"pk"));
 countries.append(new CountryCode(I18N_NOOP("Palau"),"pw"));
 countries.append(new CountryCode(I18N_NOOP("Palestinian Territory, Occupied"),"ps"));
 countries.append(new CountryCode(I18N_NOOP("Panama"),"pa"));
 countries.append(new CountryCode(I18N_NOOP("Papua New Guinea"),"pg"));
 countries.append(new CountryCode(I18N_NOOP("Paraguay"),"py"));
 countries.append(new CountryCode(I18N_NOOP("Peru"),"pe"));
 countries.append(new CountryCode(I18N_NOOP("Philippines"),"ph"));
 countries.append(new CountryCode(I18N_NOOP("Pitcairn"),"pn"));
 countries.append(new CountryCode(I18N_NOOP("Poland"),"pl"));
 countries.append(new CountryCode(I18N_NOOP("Portugal"),"pt"));
 countries.append(new CountryCode(I18N_NOOP("Puerto Rico"),"pr"));
 countries.append(new CountryCode(I18N_NOOP("Qatar"),"qa"));
 // TRANSLATORS: this is really R&#233;union
 countries.append(new CountryCode(I18N_NOOP("Reunion"),"re"));
 countries.append(new CountryCode(I18N_NOOP("Romania"),"ro"));
 countries.append(new CountryCode(I18N_NOOP("Russian Federation"),"ru"));
 countries.append(new CountryCode(I18N_NOOP("Rwanda"),"rw"));
 countries.append(new CountryCode(I18N_NOOP("Saint Helena"),"sh"));
 countries.append(new CountryCode(I18N_NOOP("Saint Kitts and Nevis"),"kn"));
 countries.append(new CountryCode(I18N_NOOP("Saint Lucia"),"lc"));
 countries.append(new CountryCode(I18N_NOOP("Saint Pierre and Miquelon"),"pm"));
 countries.append(new CountryCode(I18N_NOOP("Saint Vincent and the Grenadines"),"vc"));
 countries.append(new CountryCode(I18N_NOOP("Samoa"),"ws"));
 countries.append(new CountryCode(I18N_NOOP("San Marino"),"sm"));
 countries.append(new CountryCode(I18N_NOOP("Sao Tome and Principe"),"st"));
 countries.append(new CountryCode(I18N_NOOP("Saudi Arabia"),"sa"));
 countries.append(new CountryCode(I18N_NOOP("Senegal"),"sn"));
 countries.append(new CountryCode(I18N_NOOP("Seychelles"),"sc"));
 countries.append(new CountryCode(I18N_NOOP("Sierra Leone"),"sl"));
 countries.append(new CountryCode(I18N_NOOP("Singapore"),"sg"));
 countries.append(new CountryCode(I18N_NOOP("Slovakia"),"sk"));
 countries.append(new CountryCode(I18N_NOOP("Slovenia"),"si"));
 countries.append(new CountryCode(I18N_NOOP("Solomon Islands"),"sb"));
 countries.append(new CountryCode(I18N_NOOP("Somalia"),"so"));
 countries.append(new CountryCode(I18N_NOOP("South Africa"),"za"));
 countries.append(new CountryCode(I18N_NOOP("South Georgia and the South Sandwich Islands"),"gs"));
 countries.append(new CountryCode(I18N_NOOP("Spain"),"es"));
 countries.append(new CountryCode(I18N_NOOP("Sri Lanka"),"lk"));
 countries.append(new CountryCode(I18N_NOOP("Sudan"),"sd"));
 countries.append(new CountryCode(I18N_NOOP("Suriname"),"sr"));
 countries.append(new CountryCode(I18N_NOOP("Svalbard and Jan Mayen"),"sj"));
 countries.append(new CountryCode(I18N_NOOP("Swaziland"),"sz"));
 countries.append(new CountryCode(I18N_NOOP("Sweden"),"se"));
 countries.append(new CountryCode(I18N_NOOP("Switzerland"),"ch"));
 countries.append(new CountryCode(I18N_NOOP("Syrian Arab Republic"),"sy"));
 countries.append(new CountryCode(I18N_NOOP("Taiwan, Province of China"),"tw"));
 countries.append(new CountryCode(I18N_NOOP("Tajikistan"),"tj"));
 countries.append(new CountryCode(I18N_NOOP("Tanzania, United Republic of"),"tz"));
 countries.append(new CountryCode(I18N_NOOP("Thailand"),"th"));
 countries.append(new CountryCode(I18N_NOOP("Togo"),"tg"));
 countries.append(new CountryCode(I18N_NOOP("Tokelau"),"tk"));
 countries.append(new CountryCode(I18N_NOOP("Tonga"),"td"));
 countries.append(new CountryCode(I18N_NOOP("Trinidad and Tobago"),"tt"));
 countries.append(new CountryCode(I18N_NOOP("Tunisia"),"tn"));
 countries.append(new CountryCode(I18N_NOOP("Turkey"),"tr"));
 countries.append(new CountryCode(I18N_NOOP("Turkmenistan"),"tm"));
 countries.append(new CountryCode(I18N_NOOP("Turks and Caicos Islands"),"tc"));
 countries.append(new CountryCode(I18N_NOOP("Tuvalu"),"tv"));
 countries.append(new CountryCode(I18N_NOOP("Uganda"),"ug"));
 countries.append(new CountryCode(I18N_NOOP("Ukraine"),"ua"));
 countries.append(new CountryCode(I18N_NOOP("United Arab Emirates"),"ae"));
 countries.append(new CountryCode(I18N_NOOP("United Kingdom"),"gb"));
 countries.append(new CountryCode(I18N_NOOP("United States (USA)"),"us"));
 countries.append(new CountryCode(I18N_NOOP("United States Minore Outlying Islands"),"um"));
 countries.append(new CountryCode(I18N_NOOP("Uruguay"),"uy"));
 countries.append(new CountryCode(I18N_NOOP("Uzbekistan"),"uz"));
 countries.append(new CountryCode(I18N_NOOP("Vanuatu"),"vu"));
 countries.append(new CountryCode(I18N_NOOP("Venezuela"),"ve"));
 countries.append(new CountryCode(I18N_NOOP("Viet Nam"),"vn"));
 countries.append(new CountryCode(I18N_NOOP("Virgin Islands, British"),"vg"));
 countries.append(new CountryCode(I18N_NOOP("Virgin Islands, U.S."),"vi"));
 countries.append(new CountryCode(I18N_NOOP("Wallis and Futuna"),"wf"));
 countries.append(new CountryCode(I18N_NOOP("Western Sahara"),"eh"));
 countries.append(new CountryCode(I18N_NOOP("Yemen"),"ye"));
 countries.append(new CountryCode(I18N_NOOP("Yugoslavia"),"yu"));
 countries.append(new CountryCode(I18N_NOOP("Zambia"),"zm"));
 countries.append(new CountryCode(I18N_NOOP("Zimbabwe"),"zw"));
}

QString Country::name(DVDCountryID_t lang) 
{
 QString lang_code;
 lang_code[0] = lang >> 8;
 lang_code[1] = lang & 0xff;
 for(uint i=0;i<countries.count();i++)
  {
   if(countries.at(i)->code == lang_code)
    return i18n(countries.at(i)->name);
  }
 // Unknown country
 return i18n("Unknown");
}

QString Country::code(DVDCountryID_t lang) 
{
  QString lang_code;

 lang_code[0] = lang >> 8;
 lang_code[1] = lang & 0xff;
 for(uint i=0;i<countries.count();i++)
  {
   if(countries.at(i)->code == lang_code)
    return countries.at(i)->code;
  }
 return "??";
}

QStringList Country::allNames()
{
 QStringList tmplist;
 for(uint i=0;i<countries.count();i++)
  tmplist.append(i18n(countries.at(i)->name));
 tmplist.sort();
 return tmplist;
}

QStringList Country::allCodes()
{
 QStringList tmplist;
 for(uint i=0;i<countries.count();i++)
  tmplist.append(countries.at(i)->code);
 tmplist.sort();
 return tmplist;
}

DVDCountryID_t Country::id(const QString& str)
{
 DVDCountryID_t countryid = 0;
 QString code_639_1;
 for(uint i=0;countries.count();i++)
  {
   if(i18n(countries.at(i)->name) == str)
    {
     countryid = QChar(countries.at(i)->code[0]) << 8;
     countryid += QChar(countries.at(i)->code[1]);
     break;
    }
  }
 return countryid;
}

QPtrList<CountryCode> Country::countries;

