//------------------------------------------------------
//Radial_Blur_FP.cg
//  Implements radial blur to be used with the compositor
//  It's very dependant on screen resolution
//------------------------------------------------------

uniform sampler2D tex: register(s0);

static const float samples[10] =
{
-0.08,
-0.05,
-0.03,
-0.02,
-0.01,
0.01,
0.02,
0.03,
0.05,
0.08
};

float4 main(float4 Pos : SV_POSITION,
            float2 texCoord: TEXCOORD0,
            uniform float sampleDist,
            uniform float sampleStrength
           ) : COLOR
{
   //Vector from pixel to the center of the screen
   float2 dir = 0.5 - texCoord;

   //Distance from pixel to the center (distant pixels have stronger effect)
   //float dist = distance( float2( 0.5, 0.5 ), texCoord );
   float dist = sqrt( dir.x*dir.x + dir.y*dir.y );


   //Now that we have dist, we can normlize vector
   dir = normalize( dir );

   //Save the color to be used later
   float4 color = tex2D( tex, texCoord );
   //Average the pixels going along the vector
   float4 sum = color;
   for (int i = 0; i < 10; i++)
   {
      float4 res=tex2D( tex, texCoord + dir * samples[i] * sampleDist );
      sum += res;
   }
   sum /= 11;

   //Calculate amount of blur based on
   //distance and a strength parameter
   float t = dist * sampleStrength;
   t = saturate( t );//We need 0 <= t <= 1

   //Blend the original color with the averaged pixels
   return lerp( color, sum, t );
}
