/*

Copyright (C) 2008 Michael Goffioul,
              2008,2009 John P. Swensen.

This file is part of GtkHandles.

GtkHandles is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

GtkHandles is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GtkHandles; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>.

*/

#include "gtk-backend.h"
#include "gh-figure.h"

#include <octave/oct.h>

#include<iostream>
using namespace std;

inline GtkmmGLFigure*
ov2GtkmmGLFigure (const octave_value& val)
{
  gpointer data = reinterpret_cast<gpointer>
      (val.int32_scalar_value ().value ());

  if (! error_state)
    return reinterpret_cast<GtkmmGLFigure*> (data);
  else
    return 0;
}

typedef struct __startup_t
{
  GMutex *mutex;
  GCond *cond;
} startup_t;


gpointer
do_run_main (gpointer data)
{
  startup_t *startup = (startup_t *)data;
  const char *_argv[] = { "octave" };
  char **argv = (char**)_argv;
  int argc = 1;

  g_mutex_lock (startup->mutex);

  gdk_threads_init ();
  gdk_threads_enter ();

  gtk_disable_setlocale ();
  gtk_init (&argc, &argv);


  Gtk::Main kit(argc, argv);
  //Gtk::GL::init(argc, argv);

  //
  // Query OpenGL extension version.
  //
  //int major, minor;
  //Gdk::GL::query_version(major, minor);
  //std::cout << "OpenGL extension version - "
  //          << major << "." << minor << std::endl;

  g_cond_signal (startup->cond);
  g_mutex_unlock (startup->mutex);

  Gtk::Main::run();

  return NULL;
}

void
gtk_backend::init (void)
{
  if (gtk_main_level () == 0)
  {
    startup_t startup = { NULL, NULL };

    g_thread_init (NULL);
    startup.mutex = g_mutex_new ();
    startup.cond = g_cond_new ();
    g_mutex_lock (startup.mutex);
    g_thread_create (do_run_main, &startup, FALSE, NULL);
    g_cond_wait (startup.cond, startup.mutex);
    g_mutex_unlock (startup.mutex);
    
    stand_alone = true;
  }
}

void
gtk_backend::redraw_figure (const graphics_object& f) const
{
  graphics_object go = const_cast<graphics_object&>(f);

  if (go.isa ("figure"))
  {
    figure::properties& props = dynamic_cast<figure::properties&> (go.get_properties ());

    if (props.get___plot_stream__ ().is_empty ())
    {
      //      GtkmmGLFigure* window = GtkmmGLFigure::figureNew (h.value ());
      GtkmmGLFigure* window = GtkmmGLFigure::figureNew (go.get_handle().value());

      props.set___plot_stream__ (octave_int32 (int(window)));
    }
    else
    {
      GtkmmGLFigure *window = ov2GtkmmGLFigure (props.get___plot_stream__ ());
      if (window)
	window->figureRedraw();
	
    }
  }
}

void
gtk_backend::close_figure (const octave_value& pstream) const
{
  if (! pstream.is_empty ())
  {
    gpointer data;
      
    data = reinterpret_cast<gpointer>
      (pstream.int32_scalar_value ().value ());

    if (! error_state)
    {
      GtkmmGLFigure::figureClose ((GtkmmGLFigure*)data);
    }
  }
}

static bool gtkhandles_initialized = false;

void ___gtkhandles_init(bool withIDE)
{
  if (! gtkhandles_initialized)
  {
    graphics_object root = gh_manager::get_object (0);
    graphics_backend gtkh (new gtk_backend (withIDE));
    graphics_backend::register_backend (gtkh);

    //gdk_threads_enter();
    GtkStyle *style = gtk_style_new ();
    Matrix col (1, 3, 1.0);

    col(0) = (style->bg[0].red / 65535.0);
    col(1) = (style->bg[0].green / 65535.0);
    col(2) = (style->bg[0].blue / 65535.0);
    root.set ("defaultfigurecolor", octave_value (col));

    g_object_unref (style);
    //gdk_threads_leave();

    gtkhandles_initialized = true;
  }  
}


DEFUN_DLD (__gtkhandles_init, args, , "")
{
  ___gtkhandles_init();
  return octave_value (gtkhandles_initialized);
}


void ___gtkhandles_terminate()
{
  if (gtkhandles_initialized)
  {
    graphics_backend::unregister_backend ("gtkhandles");
    
    gtkhandles_initialized = false;
  }

}


DEFUN_DLD (__gtkhandles_terminate, args, , "")
{
  ___gtkhandles_terminate();
  return octave_value (gtkhandles_initialized);
}

