/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#ifndef __PATHCHOOSER_H__
#define __PATHCHOOSER_H__

#include <gdk/gdk.h>
#include <gtkmm.h>
using namespace Gtk;

/**
 * Class used to put a directory chooser on the toolbar.
 */
class PathChooser : public Gtk::ToolItem
{
  /**
   * Freind decalarations.
   */
  friend class OctaveDEToolbar;
  friend class OctaveUI;

private:
  /**
   * An HBox in which the widgets are placed.
   */
  Gtk::HBox m_hbox;

  /**
   * The 'Working Directory' label
   */
  Gtk::Label m_path_label;

  /**
   * The file chooser dropdown.
   */
  Gtk::FileChooserButton m_dir_button;

  /**
   * A button to move the path up.
   */
  //Gtk::ToolButton m_tool_path_up;

public:
  /**
   * Default constructor.
   */
  PathChooser() 
    : Gtk::ToolItem(), 
    m_path_label("Working directory: ")//,
    //m_tool_path_up(Gtk::Stock::GOTO_TOP)
  {
    // Set up the ToolItem container
    this->set_homogeneous(false);
    this->set_size_request(400,-1);
    this->add(m_hbox);

    // Initialize the filechooser
    m_dir_button.set_action( FILE_CHOOSER_ACTION_SELECT_FOLDER );

    // Add the two widgets to the HBox
    m_hbox.pack_start(m_path_label,Gtk::PACK_SHRINK);
    m_hbox.pack_start(m_dir_button,Gtk::PACK_EXPAND_WIDGET );
    //m_hbox.pack_start(m_tool_path_up, Gtk::PACK_SHRINK);    

    // Register 


  }

  /**
   * Destructor
   */
  ~PathChooser() {};

};

#endif //__PATHCHOOSER_H__
