/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#ifndef __MEDITOR_PANEL_H__
#define __MEDITOR_PANEL_H__


#include <iostream>
using namespace std;

#include <stdio.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcelanguage.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include <gtksourceview/gtksourcestyleschememanager.h>

#include <gtkmm.h>

#include "dock.h"
#include "dock-item.h"

#include "OctaveDEToolbar.h"

#include "mEditor.h"

typedef enum {
  BP_MARKER_TYPE_LOC = 0,
  BP_MARKER_TYPE_HIT = 1,
} bp_marker_type_t;

#define MARK_TYPE_1      "one"
#define MARK_TYPE_2      "two"

////////////////////////////////////////////////////////////////////////
class MEditorPanel : public DockItem
{
public:
  MEditorPanel(Dock& dock, string filename);
  ~MEditorPanel() {};

  Gtk::TextView* getView(void) {return view;}

  void onModifiedChanged(void);
  bool onMouseClicked(GdkEventButton* ev);

  void add_breakpoint_marker (int line, bp_marker_type_t type = BP_MARKER_TYPE_LOC);
  void remove_breakpoint_marker (bp_info_t bp, bp_marker_type_t type = BP_MARKER_TYPE_LOC)
  {
    const gchar *mark_type;
    if (type == BP_MARKER_TYPE_LOC)
      mark_type = MARK_TYPE_1;
    else
      mark_type = MARK_TYPE_2;

    GtkTextIter s, e;
    gtk_text_buffer_get_bounds (GTK_TEXT_BUFFER (buffer), &s, &e);
    gtk_text_iter_set_line (&s, bp.line_number-1);
    
    gtk_source_buffer_remove_source_marks (buffer, &s, &s, mark_type);
  }

  void remove_all_markers (bp_marker_type_t type = BP_MARKER_TYPE_LOC);

  bool has_breakpoint_marker (bp_info_t bp);
  std::vector<bp_info_t> get_breakpoint_markers ();

  string getShortName() { return shortName; }
  void setShortName(string name) { shortName = name; }
  string getFuncName()
  {
    std::string funcName;
    int dot = shortName.find_first_of(".");
    if (dot!=string::npos)
    {
      funcName = shortName.substr (0,dot);
    }
    return funcName;
  }

  string getFilename();
  void setFilename(void);

  sigc::slot<void> signal_on_new;
  sigc::slot<void> signal_on_open;

  void onNew (void);
  void onOpen (void);
  void onSave (void);
  void onSaveAs(void);

  void onUndo (void);
  void onRedo (void);

  void onCut (void);
  void onCopy (void);
  void onPaste (void);

  void onStepOver(void);

  
private:
  
  string shortName;

  // Toolbar widgets
  OctaveDEEditorToolbar m_toolbar;

  // ScrollPane in which the editor is placed
  Gtk::ScrolledWindow scrollView;

  /**
   * A GTK+ pointer to the GtkSourceBuffer object.
   */
  GtkSourceBuffer* buffer;

  /**
   * A GTKMM representation of the GtkSourceView widget 
   * as a Gtk::TextBuffer.
   */
  //Gtk::TextBuffer* mmBuffer;
  Glib::RefPtr<Gtk::TextBuffer> mmBuffer;

  /**
   * The Gtk::TextView in which we place the GtkSourceView widget.
   */
  Gtk::TextView* view;

  GtkSourceLanguageManager *lm;

  

};

#endif //__MEDITOR_PANEL_H__
