/*
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */

#ifndef __HELP_WINDOW_H__
#define __HELP_WINDOW_H__

#include <xapian.h>

#include <webkit/webkit.h>
#include <gtkmm.h>

#include <iostream>
#include <string>
#include <vector>
using namespace std;

class HelpWindow : public Gtk::Window
{
 public:
  static HelpWindow* GetInstance(bool show_it = true);
  
 private:

  Gtk::VBox vbox;
  Gtk::HPaned m_pane;

  Gtk::Toolbar m_toolbar;  
  Gtk::ToolButton m_backButton;
  Gtk::ToolButton m_fwdButton;
  Gtk::ToolItem m_uriToolItem;
  Gtk::Entry m_uriEntry;
  Gtk::ToolButton m_goButton;

  Gtk::Statusbar m_statusBar;

  
  Gtk::VBox m_searchVBox;
  Gtk::Entry m_searchEntry;
  Gtk::ListViewText m_searchItems;
  

  Gtk::ScrolledWindow m_scrolled;
  WebKitWebView* m_webView;
  Gtk::Widget* m_webViewObj;


  Xapian::Database db;

  static HelpWindow* __instance;

  HelpWindow(string database="./DATABASE");

  ~HelpWindow();

  GtkWidget* create_browser ();

  Xapian::MSet xapianSearch(std::string searchString);

  void onBackClicked ();
  void onForwardClicked ();
  void onGoClicked(void);
  void onSearchChanged(void);
  void onSearchItemActivated(const Gtk::TreeModel::Path& path,Gtk::TreeViewColumn* /*column*/);

};


int create_help_window ();

#endif // __HELP_WINDOW_H__
