/* -*- Mode: C; tab-width: 2; indent-tabs-mode: t; c-basic-offset: 2; coding: utf-8 -*- 
 *
 * Copyright (C) 2007, 2008, 2009 John P. Swensen
 *
 * This file is as a part of OctaveDE.
 *
 * Octave is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * Octave is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Octave; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * */
/*
 * Copyright (C) 2006, 2007 Apple Inc.
 * Copyright (C) 2007 Alp Toker <alp@atoker.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include <gtk/gtk.h>


#include "HelpWindow.h"

#if defined(__APPLE__)
#include <sys/param.h>
#include <mach-o/dyld.h>
#endif

#include <sys/stat.h>

/*static*/ GtkWidget* create_browser ();

////////////////////////////////////////////////////////////////////////////////////
bool doesFileExist2 (string filename)
{
	struct stat statVar;
	int rv = stat(filename.c_str(), &statVar);
	if (rv<0)
		return false;
	else
		return true;
}

/*static*/ HelpWindow* HelpWindow::__instance = NULL;
/*static*/ HelpWindow* HelpWindow::GetInstance(bool show_it)
{
  if (__instance == NULL)
  {
    gchar * databasePath = NULL;

    gchar *path = g_build_filename(DATA_DIRECTORY,"octavede","DATABASE",NULL);
    if (doesFileExist2(path))
    {
      databasePath = path;
    }
    else
    {
      const gchar * const*sys_data_dir = g_get_system_data_dirs();
      int i = 0;
      while (sys_data_dir[i]!=NULL)
      {
	gchar* path = g_build_filename(sys_data_dir[i],"octavede","DATABASE",NULL);
	if (doesFileExist2(path))
	{
	  databasePath = path;
	  break;
	}
	i++;
      }

      if (databasePath == NULL)
      {
	std::cout << "Error finding the HTML search database" << std::endl;
	return NULL;
      }
    }
    
    __instance = new HelpWindow(databasePath);
  }

  if (show_it)
    __instance->show_all();

  return __instance;
}

HelpWindow::HelpWindow(string database) 
  : Gtk::Window(), 
    m_backButton(Gtk::Stock::GO_BACK), 
    m_fwdButton(Gtk::Stock::GO_FORWARD),
    m_goButton(Gtk::Stock::OK),
    m_searchItems(2),
    db(database)
{
  set_title ("OctaveDE Help Browser");
  m_toolbar.set_orientation (Gtk::ORIENTATION_HORIZONTAL);
  //  m_toolbar.set_style (Gtk::TOOLBAR_BOTH_HORIZ);

  m_uriToolItem.set_expand(true);
  m_uriToolItem.add (m_uriEntry);

  m_toolbar.insert (m_backButton,-1);
  m_toolbar.insert (m_fwdButton,-1);
  //m_toolbar.insert (m_uriToolItem,-1);
  //m_toolbar.insert (m_goButton,-1);

  // Add listeners
  //m_goButton.signal_clicked().connect( sigc::mem_fun(*this, &HelpWindow::onGoClicked));
  m_searchEntry.signal_changed().connect( sigc::mem_fun(*this, &HelpWindow::onSearchChanged));
  m_searchItems.signal_row_activated().connect(sigc::mem_fun(*this,&HelpWindow::onSearchItemActivated));

  m_backButton.signal_clicked().connect( sigc::mem_fun(*this, &HelpWindow::onBackClicked ));
  m_fwdButton.signal_clicked().connect( sigc::mem_fun(*this, &HelpWindow::onForwardClicked ));


  vbox.pack_start (m_toolbar, false, false, 0);
  vbox.pack_start (m_pane, true, true, 0);
  //vbox.pack_start (m_statusBar, false, false, 0);

  m_searchItems.set_column_title(0,"Search Results");
  m_searchItems.set_column_title(1,"URL");
  m_searchItems.get_column(1)->set_visible(false);
  m_searchVBox.pack_start (m_searchEntry, false, false, 0);
  m_searchVBox.pack_start (m_searchItems, true, true, 0);

  create_browser();

  m_pane.pack1(m_searchVBox);
  m_pane.pack2(m_scrolled);

  //gchar* uri = (gchar*) "http://octave.sourceforge.net/doc/index.html";
  gchar* uri = g_build_filename(DATA_DIRECTORY,"octavede","DOC","overview","Getting_Started.html",NULL);
  webkit_web_view_open (m_webView, uri);
  
  m_webViewObj->grab_focus();

  add (vbox);
}

HelpWindow::~HelpWindow()
{

}

static GtkWidget* main_window;
static GtkWidget* uri_entry;
static GtkStatusbar* main_statusbar;
static WebKitWebView* web_view;
static gchar* main_title;
static gint load_progress;
static guint status_context_id;

static void
activate_uri_entry_cb (GtkWidget* entry, gpointer data)
{
    const gchar* uri = gtk_entry_get_text (GTK_ENTRY (entry));
    g_assert (uri);
    webkit_web_view_open (web_view, uri);
}

static void
update_title (GtkWindow* window)
{
    GString* string = g_string_new (main_title);
    g_string_append (string, " - WebKit Launcher");
    if (load_progress < 100)
        g_string_append_printf (string, " (%d%%)", load_progress);
    gchar* title = g_string_free (string, FALSE);
    gtk_window_set_title (window, title);
    g_free (title);
}

static void
link_hover_cb (WebKitWebView* page, const gchar* title, const gchar* link, gpointer data)
{
    /* underflow is allowed */
    gtk_statusbar_pop (main_statusbar, status_context_id);
    if (link)
        gtk_statusbar_push (main_statusbar, status_context_id, link);
}

static void
title_change_cb (WebKitWebView* web_view, WebKitWebFrame* web_frame, const gchar* title, gpointer data)
{
    if (main_title)
        g_free (main_title);
    main_title = g_strdup (title);
    update_title (GTK_WINDOW (main_window));
}

static void
progress_change_cb (WebKitWebView* page, gint progress, gpointer data)
{
    load_progress = progress;
    update_title (GTK_WINDOW (main_window));
}

static void
load_commit_cb (WebKitWebView* page, WebKitWebFrame* frame, gpointer data)
{
    const gchar* uri = webkit_web_frame_get_uri(frame);
    if (uri)
        gtk_entry_set_text (GTK_ENTRY (uri_entry), uri);
}

static void
destroy_cb (GtkWidget* widget, gpointer data)
{
  //gtk_main_quit ();
}

void HelpWindow::onBackClicked ()
{
  webkit_web_view_go_back (m_webView);

}

void HelpWindow::onForwardClicked ()
{
  webkit_web_view_go_forward (m_webView);

}


static void
go_back_cb (GtkWidget* widget, gpointer data)
{
    webkit_web_view_go_back (web_view);
}

static void
go_forward_cb (GtkWidget* widget, gpointer data)
{
    webkit_web_view_go_forward (web_view);
}

GtkWidget* HelpWindow::create_browser ()
{
  //GtkWidget* scrolled_window = gtk_scrolled_window_new (NULL, NULL);
  //gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  m_webView = WEBKIT_WEB_VIEW (webkit_web_view_new ());
  m_webViewObj = Glib::wrap(GTK_WIDGET (m_webView));
  m_scrolled.add (*m_webViewObj);
  //  gtk_container_add (GTK_CONTAINER (scrolled_window), GTK_WIDGET (web_view));

  //  g_signal_connect (G_OBJECT (m_webView), "title-changed", G_CALLBACK (title_change_cb), m_webView);
  //  g_signal_connect (G_OBJECT (m_webView), "load-progress-changed", G_CALLBACK (progress_change_cb), m_webView);
  //  g_signal_connect (G_OBJECT (m_webView), "load-committed", G_CALLBACK (load_commit_cb), m_webView);
  //  g_signal_connect (G_OBJECT (m_webView), "hovering-over-link", G_CALLBACK (link_hover_cb), m_webView);

    return NULL; //scrolled_window;
}

static GtkWidget*
create_statusbar ()
{
    main_statusbar = GTK_STATUSBAR (gtk_statusbar_new ());
    status_context_id = gtk_statusbar_get_context_id (main_statusbar, "Link Hover");

    return (GtkWidget*)main_statusbar;
}

static GtkWidget*
create_toolbar ()
{
    GtkWidget* toolbar = gtk_toolbar_new ();

    gtk_toolbar_set_orientation (GTK_TOOLBAR (toolbar), GTK_ORIENTATION_HORIZONTAL);
    gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_BOTH_HORIZ);

    GtkToolItem* item;

    /* the back button */
    item = gtk_tool_button_new_from_stock (GTK_STOCK_GO_BACK);
    g_signal_connect (G_OBJECT (item), "clicked", G_CALLBACK (go_back_cb), NULL);
    gtk_toolbar_insert (GTK_TOOLBAR (toolbar), item, -1);

    /* The forward button */
    item = gtk_tool_button_new_from_stock (GTK_STOCK_GO_FORWARD);
    g_signal_connect (G_OBJECT (item), "clicked", G_CALLBACK (go_forward_cb), NULL);
    gtk_toolbar_insert (GTK_TOOLBAR (toolbar), item, -1);

    /*
    // The URL entry
    item = gtk_tool_item_new ();
    gtk_tool_item_set_expand (item, TRUE);
    uri_entry = gtk_entry_new ();
    gtk_container_add (GTK_CONTAINER (item), uri_entry);
    g_signal_connect (G_OBJECT (uri_entry), "activate", G_CALLBACK (activate_uri_entry_cb), NULL);
    gtk_toolbar_insert (GTK_TOOLBAR (toolbar), item, -1);

    // The go button 
    item = gtk_tool_button_new_from_stock (GTK_STOCK_OK);
    g_signal_connect_swapped (G_OBJECT (item), "clicked", G_CALLBACK (activate_uri_entry_cb), (gpointer)uri_entry);
    gtk_toolbar_insert (GTK_TOOLBAR (toolbar), item, -1);
*/

    return toolbar;
}

static GtkWidget*
create_window ()
{
    GtkWidget* window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_default_size (GTK_WINDOW (window), 800, 600);
    gtk_widget_set_name (window, "GtkLauncher");
    g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (destroy_cb), NULL);

    return window;
}

Xapian::MSet HelpWindow::xapianSearch(std::string searchString)
{
  Xapian::MSet retval;
  try {
    Xapian::Enquire enquire(db);

    Xapian::QueryParser qp;
    Xapian::Stem stemmer("english");
    qp.set_stemmer(stemmer);
    qp.set_database(db);
    qp.set_stemming_strategy(Xapian::QueryParser::STEM_SOME);
    Xapian::Query query = qp.parse_query(searchString);
    //    std::cout << "Parsed query is: " << query.get_description() << std::endl;
  
    // Find the top 10 results for the query.
    enquire.set_query(query);
    retval = enquire.get_mset(0, 10);
  }
  catch (const Xapian::Error &e) 
  {
    std::cout << e.get_description() << std::endl;
  }

  return retval;
}

void HelpWindow::onGoClicked(void)
{
  
}

void HelpWindow::onSearchChanged(void)
{
  std::vector<std::string> strVec;
  try {
    std::string searchString = m_searchEntry.get_text();
    Xapian::MSet results = xapianSearch (searchString);

    m_searchItems.clear_items();
    for (Xapian::MSetIterator i = results.begin(); i != results.end(); ++i) 
    {
       string tmp = i.get_document().get_data();
       string::size_type loc = tmp.find( "caption", 0 );
       if( loc != string::npos ) 
       {
	 string::size_type loc2 = tmp.find( "\n", loc );
	 string tmp2 = tmp.substr(loc+8, loc2-loc-8);
	 m_searchItems.append_text(tmp2);
       }
       
       int row = m_searchItems.size()-1;
       string::size_type loc3 = tmp.find( "\n", 0 );
       string tmp3 = tmp.substr(4, loc3-4);
       //m_searchItems.append_text(tmp3);
       m_searchItems.set_text(row,1,tmp3);

    }
  }
  catch (const Xapian::Error &e) 
  {
    std::cout << e.get_description() << std::endl;
  }
}

void HelpWindow::onSearchItemActivated(const Gtk::TreeModel::Path& path,Gtk::TreeViewColumn* /*column*/)
{
  /*Gtk::TreeModel::iterator iter=m_refTreeModel->get_iter(path);
  if(iter)
  {
    Gtk::TreeModel::Rowrow=*iter;
    std::cout <<"Rowactivated:ID="
	      <<row[m_Columns.m_col_id]
	      <<",Name="<<row[m_Columns.m_col_name]
	      <<std::endl;
	      }*/
  Gtk::ListViewText::SelectionList sl = m_searchItems.get_selected();
  Glib::ustring selected = m_searchItems.get_text( sl[0], 1 );

  gchar* docpath = g_build_filename(DATA_DIRECTORY,"octavede",selected.c_str(),NULL);
  //cout << "Selected: " << docpath << endl;
  webkit_web_view_open (m_webView, docpath);

}
