% evec2a85(vector)
% converts binary vector to ASCII85 vector 
% written by stefan.mueller@fgan.de (C) 2005
function a85code=evec2a85(bincode)
  if (nargin~=1)
    eusage('a85Vector=evec2a85(binVector)');
  end
  n=size(bincode,1);
  nTuples=ceil(n/4);
  nTail=nTuples*4-n;
  if nTail>0
    bincode=[bincode;zeros(nTail,1)];
  end
  a85code=[reshape(bincode,4,nTuples);zeros(1,nTuples)];
  tupSum=a85code(4,:)+a85code(3,:)*256+a85code(2,:)*65536+a85code(1,:)*16777216;
  a85code(5,:)=rem(tupSum,85);
  tupSum=fix(tupSum/85);
  a85code(4,:)=rem(tupSum,85);
  tupSum=fix(tupSum/85);
  a85code(3,:)=rem(tupSum,85);
  tupSum=fix(tupSum/85);
  a85code(2,:)=rem(tupSum,85);
  a85code(1,:)=fix(tupSum/85);
  a85code=a85code+33;
  a85code=reshape(a85code,5*nTuples,1);
