#!/usr/bin/perl

eval 'exec /usr/bin/perl  -S $0 ${1+"$@"}'
    if 0; # not running under some shell

###############################################################################
##OCSInventory Version NG RC3
##Copyleft Pascal DANEK 2005
##Web : http://ocsinventory.sourceforge.net
##
##This code is open source and may be copied and modified as long as the source
##code is always made freely available.
##Please refer to the General Public Licence http://www.gnu.org/ or Licence.txt
################################################################################

use strict;

use XML::Simple;
use LWP::UserAgent;
use Compress::Zlib;
use Net::IP qw(:PROC);
use Digest::MD5 qw(md5_base64);
use Ocsinventory::Agent::Common qw/:all/;
use Fcntl qw/:flock/;
# Options
# Net scan
use Ocsinventory::Agent::Option::Ipdiscover;
# Update feature: feature is now stopped. All updates will go through software deployment
# use Ocsinventory::Agent::Option::Update;
# Software deployment
use Ocsinventory::Agent::Option::Download;

$ENV{PATH} = '/bin:/usr/bin';

#Data in MB
use constant UNITE => 1024;

#
use constant VERSION =>15;
#
my $log_path		= "/var/log/ocsinventory-client/ocsinv.log";
my $default_server	= "ocsinventory-ng";
my $install_path	= "/etc/ocsinventory-client";
my $exe_path		= "/usr/sbin";
our $debug;

my $checksum = 0;

#To apply to $checksum with an OR
my %mask = (
	'hardware' 	=> 1,
	'bios'		=> 2,
	'memories'	=> 4,
	'slots'		=> 8,
	'registry'	=> 16,
	'controllers'	=> 32,
	'monitors'	=> 64,
	'ports'		=> 128,
	'storages'	=> 256,
	'drives'	=> 512,
	'inputs'	=> 1024,
	'modems'	=> 2048,
	'networks'	=> 4096,
	'printers'	=> 8192,
	'sounds'	=> 16384,
	'videos'	=> 32768,
	'softwares'	=> 65536
);

######
#MAIN#
############################################################
my(	
	$ServerName,
	$req, $res, $ua,
	$inventory, %request,
	@lspci,
	%account, @config,
	$DeviceID, $old_deviceid,
	$YEAR, $MONTH, $DAY, $HOUR, $MIN, $SEC,
	$xfree, @xconfig,
	$compress, $xml,
	$start, $end,
	%xmladm, $URI, %options,
	$distro, $nosoft, $force, $tag,
	$auth_user, $auth_pwd, $auth_realm,
	@unknown_opt	
);


#timestamp at the beginning (to estimate the etime)
$start = time();

# Is there a user to watch to logs ? If not, we put it into the logs file
unless(defined($ENV{USER})){
  open STDOUT, ">>".$log_path;
}else{
  #We notify that an inventory had been manually generated
  open FILE, ">>".$log_path;
  print FILE localtime()." => Generated manually\n";
  close FILE;
}

# Error logs to STDOUT
open STDERR, ">>&STDOUT";

# Checking Permissions
unless(-r "/dev/mem"){
	die localtime()." => You don't have enough rights to run this program\n";
}

#Get last inventory state
my $last_state = XML::Simple::XMLin($install_path."/last_state", SuppressEmpty => undef, ForceArray => ['hardware', 'inputs', 'controllers', 'memories', 'monitors', 'ports', 'softwares', 'storages', 'drives', 'inputs', 'modems', 'networks', 'printers', 'slots', 'sounds', 'videos', 'bios' ] ) if -r "$install_path/last_state";
#If data are not available
my %last_state;

# Configuration reading
my $xmlconf = XML::Simple::XMLin($install_path."/ocsinv.conf", SuppressEmpty => undef);
#
$ServerName = $xmlconf->{OCSFSERVER};
$DeviceID   = $xmlconf->{DEVICEID};

# Reading Account infos 
my $xmladm = XML::Simple::XMLin( $install_path."/ocsinv.adm", ForceArray => [ 'ACCOUNTINFO' ] );
for(@{$xmladm->{ACCOUNTINFO}}){
	$account{ $_->{KEYNAME} } = $_->{KEYVALUE};
}

# Reading parameters
for(@ARGV){
	if(/-local/) {
		$ServerName = '__local__'
	}elsif(/-server=(\S+)/){
		$ServerName = $1
	}elsif(/-xml/){
		$xml=1
	}elsif(/-tag=(\S+)/){
		$tag = $1;
	}elsif(/-debug/){
		$debug = 2;
	}elsif(/-info/){
		$debug = 1;
	}elsif(/-nosoft/){
		$nosoft = 1;
	}elsif(/-force/){
		$force = 1;
	}elsif(/-auth_realm=(\S+)/){
		$auth_realm = $1;
	}elsif(/-auth_user=(\S+)/){
		$auth_user = $1;
	}elsif(/-auth_pwd=(\S+)/){
		$auth_pwd = $1;
	}elsif(/^(-h|--help)$/){
		print <<EOF;
Usage:
\t-local           do not send data to server
\t-server=SERVER   use the specific server SERVER
\t-xml             write output in a xml file
\t-tag=TAG         use TAG as tag
\t-debug           debug mode
\t-info            verbose mode
\t-nosoft          do not return installed software list
\t-force           always send data to server (Don't ask before)
\t-auth_realm      HTTP Realm to authenticate
\t-auth_user       HTTP user to use for authentication
\t-auth_pwd        HTTP password to use for authentication
\t-auth_pwd        HTTP password to use for authentication
\t-ipdisc_lat      specify the time between two ipdiscover requests
EOF
	exit;
	}else{
		push @unknown_opt, $_;
	}
}

# To prevent typo
if( $debug ){
	print "$_ => Unknown argument = Maybe used by a module ?\n" for @unknown_opt;
}

# -tag parameter
if($tag){
	$account{TAG} = $tag;
}

print <<EOF if $debug;

####################
#OCSINVENTORY NG
#Linux agent report
####################


EOF


#Setting binaries locations
my $dmidecode_path 	= &_get_path('dmidecode');
my $ifconfig_path 	= &_get_path('ifconfig');
my $route_path		= &_get_path('route');
my $df_path		= &_get_path('df');
my $lspci_path		= &_get_path('lspci');
my $who_path		= &_get_path('who');
my $uname_path		= &_get_path('uname');
my $fdisk_path		= &_get_path('fdisk');

#Get the binaries output
#ifconfig
my @ifconfig = `env LANGUAGE=us $ifconfig_path`;
#dmidecode
my @dmidecode = `env LANGUAGE=us $dmidecode_path`;
# Remove spaces at the beginning of lines
s/^\s+// for (@dmidecode);

# Checking DeviceID
chomp(my $Device = `$uname_path -n| cut -d . -f 1`);
unless($DeviceID=~/$Device-(?:\d{4})(?:-\d{2}){5}/){
	# We save the old deviceid in order to tell to the server that we changed
	$old_deviceid = $DeviceID;

	# Building DeviceID
	($YEAR, $MONTH , $DAY, $HOUR, $MIN, $SEC) = (localtime (time))[5,4,3,2,1,0];
	$DeviceID=sprintf "%s-%02d-%02d-%02d-%02d-%02d-%02d",  $Device, ($YEAR+1900), ($MONTH+1), $DAY, $HOUR, $MIN, $SEC;

	# writing ocsinv.conf
	$xmlconf->{DEVICEID}		= [ $DeviceID ];
	
	my $xml = XML::Simple::XMLout( $xmlconf, RootName => 'CONF', NoAttr => 1 );
	
	open CONF, ">".$install_path."/ocsinv.conf";
	print CONF $xml;
	close CONF;
}

# Server default name
$ServerName = $default_server unless($ServerName);
# For authentication purposes
if( $ServerName!~/:\d+$/ and $ServerName ne '__local__'){
	$ServerName .= ':80';
}
# URI
$URI = "http://".$ServerName."/ocsinventory";

# Setting current context for modules
my %CURRENT_CONTEXT;

$CURRENT_CONTEXT{'OCS_AGENT_LOG_PATH'} 			= $log_path;
$CURRENT_CONTEXT{'OCS_AGENT_SERVER_URI'} 		= $URI;
$CURRENT_CONTEXT{'OCS_AGENT_INSTALL_PATH'}	= $install_path;
$CURRENT_CONTEXT{'OCS_AGENT_DEBUG_LEVEL'} 	= $debug;
$CURRENT_CONTEXT{'OCS_AGENT_EXE_PATH'} 			= $exe_path;
$CURRENT_CONTEXT{'OCS_AGENT_SERVER_NAME'} 	= $ServerName;
$CURRENT_CONTEXT{'OCS_AGENT_AUTH_USER'} 		= $auth_user;
$CURRENT_CONTEXT{'OCS_AGENT_AUTH_PWD'} 			= $auth_pwd;
$CURRENT_CONTEXT{'OCS_AGENT_AUTH_REALM'} 		= $auth_realm;
$CURRENT_CONTEXT{'OCS_AGENT_DEVICEID'} 			= $DeviceID;
$CURRENT_CONTEXT{'OCS_AGENT_VERSION'} 			= VERSION;
$CURRENT_CONTEXT{'OCS_AGENT_CMDL'}					= \@ARGV;
$CURRENT_CONTEXT{'OCS_AGENT_CONFIG'}				= $xmlconf;

# Proceed...
if(($ServerName=~/^__local__$/i) or $xml){
	&_inventory();
}else{
	# Connect to server
	$ua = LWP::UserAgent->new(keep_alive => 1);
	$ua->agent('OCS-NG_linux_client_v'.VERSION);
	$ua->credentials( $ServerName, $auth_realm, $auth_user => $auth_pwd );

	# Call modules start sub
	&_call_start_handlers();
	
	# Prolog phase
	if(&_prolog()){
		# Send inventory if needed
		&_inventory();
	}
	
	# Call modules end sub
	&_call_end_handlers;
}

# That's all
print localtime()." => Terminated... :-)\n";
print localtime()." => Execution time : ".(($end?$end:time()) - $start)." secs\n";

############
#SUBROUTINES
############
#
sub _hardware{
	my (	$OSVersion, $OSName, $OSComment, $DeviceType, $PhysicalMemory,
		$SwapFileSize, $ip, @ip, $UsersLoggedOn, @users, $domain, $uptime,
		$UYEAR, $UMONTH , $UDAY, $UHOUR, $UMIN, $USEC, %processors, $distro_file );

	# Operating system informations
	chomp($OSName =`$uname_path -s`);
	chomp($OSVersion =`$uname_path -r`);
	chomp($OSComment =`$uname_path -v`);
	chomp($DeviceType =`$uname_path -m`);

	# Wich distro ?
	if(-e "/etc/debian_version"){
		$distro = 'Debian';
		$distro_file = "/etc/debian_version";
	}elsif(-e "/etc/mandrake-release"){
		$distro = 'Mandrake';
		$distro_file = "/etc/mandrake-release";
	}elsif(-e "/etc/redhat-release"){
		$distro = 'Redhat';
		$distro_file = "/etc/redhat-release";
	}elsif(-e "/etc/SuSE-release"){
		$distro = 'SuSe';
		$distro_file = "/etc/SuSE-release";
	}elsif(-e "/etc/slackware-version"){
		$distro = 'Slackware';
		$distro_file = "/etc/slackware-version";
	}elsif(-e "/etc/knoppix_version"){
		$distro = 'Knoppix'; 
		$distro_file = "/etc/knoppix_version";
	}elsif(-e "/etc/fedora-release"){
	   	$distro = 'Fedora Core';
		$distro_file = "/etc/fedora-release";
	}elsif(-e "/etc/trustix-release"){
	   	$distro = 'Trustix';
		$distro_file = "/etc/trustix-release";
	}elsif(-e "/etc/gentoo-release"){
	    # D LIROULET 2006/08/31 Gentoo Support
		$distro = 'Gentoo';
		$distro_file = "/etc/gentoo-release";
	}
	
	open DISTRO, $distro_file;
	chomp($distro.=" / ".$_) while(<DISTRO>);
	   
	# Memory informations
	open MEMINFO, "/proc/meminfo";
	while(<MEMINFO>){
		$PhysicalMemory=$1 if /^memtotal\s*:\s*(\S+)/i;
		$SwapFileSize=$1 if /^swaptotal\s*:\s*(\S+)/i;
	}

	# Looking for ip addresses with ifconfig, except loopback
	for(@ifconfig){
		if(/^\s*inet add?r\s*:\s*(\S+)/){
			($1=~/127.+/)?next:push @ip, $1
		};
	}
	$ip=join "/", @ip;

	# Logged on users
	for(`$who_path`){
		/^(\S+)./;
		push @users, $1 if(! &_already_in_array($1, @users));
	}
	
	$UsersLoggedOn = join "/", @users;

	# Domain
	open RESOLV, "/etc/resolv.conf";
	while(<RESOLV>){
		$domain=$2 if (/^(domain|search)\s+(.+)/);
	}

#    # D LIROULET 2006/08/31 Try to get domain from samba if not defined
	unless( $domain ){
		if( open SAMBA, "/etc/samba/smb.conf" ){
			while(<SAMBA>){
				if(/^\s*(workgroup\s*=\s*)\s+(.+)/){
					$domain=$2 ;
					last;
				}
			}
		close(SAMBA);
		}

	}

	# If no domain name, we send "WORKGROUP"
	$domain = 'WORKGROUP' unless $domain;

	# Uptime
	open UPTIME, "/proc/uptime";
	$uptime = <UPTIME>;
	$uptime =~ s/^(.+)\s+.+/$1/;
	close UPTIME;

	# Uptime conversion
	($UYEAR, $UMONTH , $UDAY, $UHOUR, $UMIN, $USEC) = (gmtime ($uptime))[5,4,3,2,1,0];

	# Write in ISO format
	$uptime=sprintf "%02d-%02d-%02d %02d:%02d:%02d", ($UYEAR-70), $UMONTH, ($UDAY-1), $UHOUR, $UMIN, $USEC;

	# Hostname
	chomp(my $DeviceName=`$uname_path -n| cut -d . -f 1`);

	# CPU
	open CPUINFO, "/proc/cpuinfo";
	my($nbproc, @processors);
	while(<CPUINFO>){
		if (/^processor\s*:/){(defined($nbproc))?($nbproc++):($nbproc=0);}
		if (/^model name\s*:\s*(.+)/i){$processors{Type}=$1;}
		if (/^cpu mhz\s*:\s*(\S+)\n/i){$processors{Speed}=$1;}
	}
	
	# Writing data
	$request{'CONTENT'}{'HARDWARE'} = {
		'NAME'			=> [ $DeviceName ],
		'WORKGROUP'		=> [ $domain ],
		'OSNAME'		=> [ $OSName ],
		'OSVERSION'		=> [ $OSVersion ],
		'OSCOMMENTS'		=> [ "$distro / $OSComment" ],
		'PROCESSORT'		=> [ $processors{Type} ],
		'PROCESSORS'		=> [ $processors{Speed} ],
		'PROCESSORN'		=> [ $nbproc+1 ],
		'MEMORY'		=> [ sprintf("%i",$PhysicalMemory/UNITE) ],
		'SWAP'			=> [ sprintf("%i", $SwapFileSize/UNITE) ],
		'IPADDR'		=> [ $ip ],
		'USERID'		=> [ $UsersLoggedOn ],
		'TYPE'			=> [ '8' ],
		'DESCRIPTION'		=> [ "$DeviceType/$uptime" ],
  		#"WINCOMPANY"; Arf...
		#"WINOWNER"; Arf...
		#"WINPRODID"; Arf.
	};
	
	#Computing hardware checksum and put the whole changes flag in CHECKSUM
	&_has_changed("hardware",md5_base64($domain, $OSName, $distro, $OSVersion, $OSComment, $processors{Type}, $processors{Speed}, $nbproc,  $PhysicalMemory, $SwapFileSize)	);

}

# Account Infos
sub _accountinfo{
	for(keys(%account)){
		push @{$request{'CONTENT'}{'ACCOUNTINFO'}}, {'KEYNAME' =>  [ $_ ], 'KEYVALUE' => [ $account{$_} ] };
	}
}

# Bios infos
sub _bios{
	# Parsing dmidecode output
	# Using "type 0" section
	my(	$SystemSerial , $SystemModel, $SystemManufacturer, $BiosManufacturer,
		$BiosVersion, $BiosDate, $YEAR, $MONTH, $DAY, $HOUR, $MIN, $SEC);

	my $flag=0;
	for(@dmidecode){
		$flag=1 if /dmi type 0,/i;
		if((/dmi type (\d+),/i) && ($flag)){($1!='0')?last:1;}
		if((/^vendor\s*:\s*(.+)/i) && ($flag)) { $BiosManufacturer = $1 }
		if((/^release date\s*:\s*(.+)/i) && ($flag)) { $BiosDate = $1 }
		if((/^version\s*:\s*(.+)/i) && ($flag)) { $BiosVersion = $1 }
	}

	$flag=0;
	for(@dmidecode){
		if(/dmi type 1,/i){$flag=1;}
		if((/dmi type (\d+),/i) && ($flag)){($1!='1')?last:1;}
		if((/^serial number\s*:\s*(.+?)\s*$/i) && ($flag)) { $SystemSerial = $1 }
		if((/^product name\s*:\s*(.+?)\s*$/i) && ($flag)) { $SystemModel = $1 }
		if((/^manufacturer\s*:\s*(.+?)\s*$/i) && ($flag)) { $SystemManufacturer = $1 }
	}

	# Writing data
	$request{'CONTENT'}{'BIOS'} = {
		'SMANUFACTURER' 	=> [ $SystemManufacturer ],
		'SMODEL'		=> [ $SystemModel ],
		'SSN'			=> [ $SystemSerial ],
		'BMANUFACTURER'		=> [ $BiosManufacturer ],
		'BVERSION'		=> [ $BiosVersion ],
		'BDATE'			=> [ $BiosDate ],
	};
	
	#Checksum
	&_has_changed('bios', md5_base64($SystemManufacturer,$SystemModel,$SystemSerial,$BiosManufacturer,$BiosVersion,$BiosDate));
}


sub _accesslog{
	my ($YEAR, $MONTH , $DAY, $HOUR, $MIN, $SEC) = (localtime (time))[5,4,3,2,1,0];
	my $Date=sprintf "%02d-%02d-%02d %02d:%02d:%02d", ($YEAR+1900), ($MONTH+1), $DAY, $HOUR, $MIN, $SEC;

	$request{'CONTENT'}{'ACCESSLOG'} = {
		'USERID'		=> [ 'N/A' ],
		'LOGDATE' 		=> [ $Date ],
	};
}

sub _memories{
	# TODO: Use type 6 too
	# Using "type 17" section
	my ($n, $flag, @values);
	for(@dmidecode){
		if(/dmi type 17,/i){$flag=1; (defined($n))?($n++):($n=0);}

		if((/dmi type (\d+),/i) && ($flag)) {$flag=($1!='17'?0:1);}
		if((/^size\s*:\s*(\S+)/i) && ($flag)) {	$request{'CONTENT'}{'MEMORIES'}[$n]{'CAPACITY'}= [ $1 ]; push @values, $1}
		if((/^speed\s*:\s*(.+)/i) && ($flag)) {$request{'CONTENT'}{'MEMORIES'}[$n]{'SPEED'}	= [ $1 ]; push @values, $1}
		if((/^type\s*:\s*(.+)/i) && ($flag)) {$request{'CONTENT'}{'MEMORIES'}[$n]{'TYPE'}= [ $1 ]; push @values, $1}
		if((/^Form Factor\s*:\s*(.+)/i) && ($flag)) {$request{'CONTENT'}{'MEMORIES'}[$n]{'DESCRIPTION'}= [ $1 ]; push @values, $1}
		if((/^Locator\s*:\s*(.+)/i) && ($flag)) {$request{'CONTENT'}{'MEMORIES'}[$n]{'NUMSLOTS'} = [ $1 ]; push @values, $1}
	}
	#Checksum
	&_has_changed('memories', md5_base64(@values));
}

sub _ipdhcp{
	my $if = shift;

	my $path;
	my $dhcp;
	my $ipdhcp;
	my $leasepath;

	foreach ( 
		"/var/lib/dhcp3/dhclient.%s.leases",
		"/var/lib/dhcp3/dhclient.%s.leases",
		"/var/lib/dhcp/dhclient.leases", ) {

		$leasepath = sprintf($_,$if);
		last if (-e $leasepath);
	}
	return unless $leasepath;

	if (open DHCP, $leasepath) {
	my $lease;
	while(<DHCP>){
		$lease = 1 if(/lease\s*{/i);
		$lease = 0 if(/^\s*}\s*$/);
		#Interface name
		if ($lease) { #inside a lease section
			if(/interface\s+"(.+?)"\s*/){
				$dhcp = ($1 =~ /^$if$/);
			}
			#Server IP
			if(/option\s+dhcp-server-identifier\s+(\d{1,3}(?:\.\d{1,3}){3})\s*;/ and $dhcp){
				$ipdhcp = $1;
			}
		}
	}
	close DHCP or warn;
	} else {
		warn "Can't open $leasepath\n"; 
	}
	return $ipdhcp;
}


sub _networks{
	#Same way that dmidecode but with ifconfig
	my ($line, @network, $dhcp, $gateway, $n, $flag, $lease, @values);

	# Looking for the default gateway
	for(`$route_path`){
		$gateway=$1 if /^defau\S*\s+(\S+)/i;
	}

	# Retrieving network settings
	for $line (@ifconfig){
	
		if($line =~ /^lo/ or $line =~ /^$/){$flag = 0; next;}
		
		if($line =~ /^(\S+)\s+/i){
			my $if = $1;
			defined($n)?($n++):($n = 0);
			$request{'CONTENT'}{'NETWORKS'}[$n]{'DESCRIPTION'} = [ $if ];
			push @values, $if;
			$flag = 1;
			# Looking for dhcp server IP in a lease declaration (using /var/lib/dhcp/dhclient.leases)
			if(my $ipdhcp = _ipdhcp($if)){
				#Server IP
				$request{'CONTENT'}{'NETWORKS'}[$n]{'IPDHCP'} = [ $ipdhcp ];
				push @values, $ipdhcp;
			}
		}
		if (!$request{'CONTENT'}{'NETWORKS'}[$n]{IPGATEWAY} and $flag){ 
			$request{'CONTENT'}{'NETWORKS'}[$n]{IPGATEWAY} = [ $gateway ]; 
			push @values, $gateway;
		};
		if($line =~ /(link|lien) encap:(\S+)/i && $flag){ 
			$request{'CONTENT'}{'NETWORKS'}[$n]{'TYPE'}= [ $2 ];
			push @values, $2;
		};
  		if($line =~ /hwadd?r\s+(\S+)/i	&& $flag){ 
			$request{'CONTENT'}{'NETWORKS'}[$n]{'MACADDR'}= [ $1 ];
			push @values, $1;			
		};
		if($line =~ /inet add?r:(\S+)/i && $flag){ 
			$request{'CONTENT'}{'NETWORKS'}[$n]{'IPADDRESS'}= [ $1 ];
			push @values, $1;
		};
		if($line =~ /\S*mas(?:k|que):(\S+)/i && $flag){ 
			$request{'CONTENT'}{'NETWORKS'}[$n]{'IPMASK'}= [ $1 ];
			push @values, $1;
		};
		if($line =~ /^\s*UP/i && $flag){ 
			$request{'CONTENT'}{'NETWORKS'}[$n]{'STATUS'}= [ 'Up' ];
		}

		# Retrieving ip of the subnet for each interface
		if($request{'CONTENT'}{'NETWORKS'}[$n]{'IPMASK'}[0]
		   and $request{'CONTENT'}{'NETWORKS'}[$n]{'IPADDRESS'}[0]
		   and !$request{'CONTENT'}{'NETWORKS'}[$n]{'IPSUBNET'}[0]){
		  	# To retrieve the subnet for this iface
			my $binip = &ip_iptobin ($request{'CONTENT'}{'NETWORKS'}[$n]{'IPADDRESS'}[0] ,4);
		  	my $binmask = &ip_iptobin ($request{'CONTENT'}{'NETWORKS'}[$n]{'IPMASK'}[0] ,4);
		  	my $subnet = $binip & $binmask;
		  	$request{'CONTENT'}{'NETWORKS'}[$n]{'IPSUBNET'} = [ ip_bintoip($subnet,4) ] or warn(Error());
			push @values, $request{'CONTENT'}{'NETWORKS'}[$n]{'IPSUBNET'}[0];
		}
	}
	#Checksum
	&_has_changed('networks', md5_base64(@values));
}


sub _drives{
	my @values;
	# Looking for mount points and disk space
	for(`$df_path -TP`){
		if(/^(\S+)\s+(\S+)\s+(\S+)\s+(?:\S+)\s+(\S+)\s+(?:\S+)\s+(\S+)\n/){
			next if ($1 =~ /^(tmpfs|usbfs|proc|devpts)$/);
			push @values, ($1,$2,$5);
			push @{$request{'CONTENT'}{'DRIVES'}}, {
				'TYPE'		=> [ $1 ],
				'FILESYSTEM'	=> [ $2 ],
				'TOTAL'		=> [ sprintf("%i",($3/UNITE)) ],
				'FREE'		=> [ sprintf("%i",($4/UNITE)) ],
				'VOLUMN'	=> [ $5 ],
			};
		}
	}
	#Checksum
	&_has_changed('drives', md5_base64(@values));
}


sub _storages{
my $partitions;
my @values;


foreach (glob ("/sys/block/*")) {# /sys fs style
        $partitions->{$1} = undef
                if (/^\/sys\/block\/([sh]d[a-z])$/)
}
foreach (`$fdisk_path -l`) {# call fdisk to list partitions
        chomp;
        next unless (/^\//);
        $partitions->{$1} = undef
                if (/^\/dev\/([sh]d[a-z])/);
}

foreach my $device (keys %$partitions) {
	my $manufacturer;
	my $model;
	my $description;
	my $media;
	my $type;
	my $capacity;

# Parse info from /sys
	if (open VENDOR, "/sys/block/$device/device/vendor") {
		chomp($manufacturer = <VENDOR>);
		$manufacturer =~ s/^(\w+)\W*/$1/;# remove spaces
			close VENDOR;
	}
	if (open MODEL, "/sys/block/$device/device/model") {
		chomp($model = <MODEL>);
		$model =~ s/^(\w+)\W*/$1/;
		close MODEL;
	}
	if (open REMOVABLE, "/sys/block/$device/removable") {
		chomp(my $removable = <REMOVABLE>);
# i guess it's an hard drive if the media is not removable
		$media = $removable?"removable":"disk";
			close REMOVABLE;
	}


# Old style, fetch data from /proc
	if(!$model) {
		if (open MODEL, "/proc/ide/$device/model") {
			chomp($model = <MODEL>);
			close MODEL;
		}
	}
	if (!$media) {
		if (open MEDIA, "/proc/ide/$device/media") {
			chomp($media = <MEDIA>);
			close MEDIA;
		}
	}
	if (!$manufacturer) {
		if($model =~ /(maxtor|western|sony|compaq|hewlett packard|ibm|seagate|toshiba|fujitsu|lg|samsung)/i){
			$manufacturer=$1;
		}
	}

	if ($device =~ /^s/) { # /dev/sd* are SCSI _OR_ SATA
		if ($manufacturer =~ /ATA/) {
			$description = "SATA";
		} else {
			$description = "SCSI";
		}
	} else {
		$description = "IDE";
	}
	chomp ($capacity = `/sbin/fdisk -s /dev/$device`);
	$capacity = int ($capacity/1000) if $capacity;

	push @{$request{'CONTENT'}{'STORAGES'}}, {
		     MANUFACTURER => [$manufacturer?$manufacturer:"??"],
		     MODEL => [$model?$model:"??"],
		     DESCRIPTION => [$description?$description:"??"],
		     TYPE => [$media?$media:"??"],
		     DISKSIZE => [$capacity?$capacity:"??"]
	     };

	push @values, (
			$manufacturer?$manufacturer:"??",
			$model?$model:"??",
			$media?$media:"??",
			$capacity?$capacity:"??"
		      );
}

#Checksum
&_has_changed('storages', md5_base64(@values));
}


sub _ports{
	# Using "type 8" section
	my ($n, $flag, @values);
	for(@dmidecode){
		if(/dmi type 8,/i){$flag=1; (defined($n))?($n++):($n=0);}
		if((/dmi type (\d+),/i) && ($flag)){($1!='8')?$flag=0:1;}
		if((/^internal reference designator\s*:\s*(.+)/i) && ($flag)) { 
			$request{'CONTENT'}{'PORTS'}[$n]{'NAME'} = [ $1 ];
			push @values, ($1);
		};
		if((/^external connector type\s*:\s*(.+)/i) && ($flag)) { 
			$request{'CONTENT'}{'PORTS'}[$n]{'CAPTION'} = [ $1 ]; 
			push @values, ($1);
		};
		if((/^internal connector type\s*:\s*(.+)/i) && ($flag)) { 
			$request{'CONTENT'}{'PORTS'}[$n]{'DESCRIPTION'} = [ $1 ]; 
			push @values, ($1);
		};
		if((/^port type\s*:\s*(.+)/i) && ($flag)) { 
			$request{'CONTENT'}{'PORTS'}[$n]{'TYPE'} = [ $1 ];
			push @values, ($1);
		};
	}
	#Checksum
	&_has_changed('ports', md5_base64(@values));
}


sub _controllers{
	my @values;
	
	for(`$lspci_path`){push @lspci, $_;}
	for(@lspci){
		/^\S+\s([^:]+):\s*(.+?)(?:\(([^()]+)\))?$/i;
		push @values, ($1,$2,$3);
		push @{$request{'CONTENT'}{'CONTROLLERS'}}, {
			'NAME'		=> [ $1 ],
			'MANUFACTURER'	=> [ $2 ],
			'TYPE'		=> [ $3 ],
		};
	}
	#Checksum
	&_has_changed('controllers', md5_base64(@values));
}


sub _slots{
	# Using "type 9" section
	my ($n, $flag, @values);
	for(@dmidecode){
		if(/dmi type 9,/i){$flag=1; (defined($n))?($n++):($n=0);}
		if((/dmi type (\d+),/i) && ($flag)){($1!='9')?$flag=0:1;}
		if((/^id\s*:\s*(.+)/i) && ($flag)){
			$request{'CONTENT'}{'SLOTS'}[$n]{'DESIGNATION'} = [ $1 ]; 
			push @values, ($1);
		};
		if((/^type\s*:\s*(.+)/i) && ($flag)){
			$request{'CONTENT'}{'SLOTS'}[$n]{'DESCRIPTION'} = [ $1 ]; 
			push @values, ($1);
		};
		if((/^designation\s*:\s*(.+)/i) && ($flag)){
			$request{'CONTENT'}{'SLOTS'}[$n]{'NAME'}= [ $1 ]; 
			push @values, ($1);
		};
		if((/^current usage\s*:\s*(.+)/i) && ($flag)){
			$request{'CONTENT'}{'SLOTS'}[$n]{'STATUS'} = [ $1 ]; 
			push @values, ($1);
		};
	}
	#Checksum
	&_has_changed('slots', md5_base64(@values));
}


sub _monitors{
	# Looking for XFConfig
	-e "/etc/X11/XF86Config" and $xfree = "/etc/X11/XF86Config";
	-e "/etc/X11/XF86Config-4" and $xfree = "/etc/X11/XF86Config-4";
	-e "/etc/XF86Config" and $xfree = "/etc/XF86Config";
	-e "/etc/Xconfig" and $xfree = "/etc/Xconfig";
	-e "/usr/X11/lib/X11/XF86Config" and $xfree = "/usr/X11/lib/X11/XF86Config";
	-e "/etc/X11/xorg.conf" and $xfree = "/etc/X11/xorg.conf";

	my ($n, $flag, @values);

	open XCONFIG, $xfree;
	@xconfig = <XCONFIG>;

	#If xfree config file found
	if($xfree){
		for(@xconfig){
			if(/section\s+("monitor")/i){
				$flag=1;(defined($n))?($n++):($n=0);
			}
			if((/endsection/i) && $flag){$flag=0;}
			if((/identifier\s+"(.+)"/i) && ($flag)) { 
				$request{'CONTENT'}{'MONITORS'}[$n]{'CAPTION'} = [ $1 ]; 
				push @values, ($1);
			};
			if((/vendorname\s+"(.+)"/i) && ($flag)) { 
				$request{'CONTENT'}{'MONITORS'}[$n]{'MANUFACTURER'}= [ $1 ]; 
				push @values, ($1);
			};
			if((/modelname\s+"(.+)"/i) && ($flag)) { 
				$request{'CONTENT'}{'MONITORS'}[$n]{'DESCRIPTION'}= [ $1 ]; 
				push @values, ($1);
			};

		}
	}
	#Checksum
	&_has_changed('monitors', md5_base64(@values));
}


sub _videos{
	my( $vendor, $name, $n, @values );
	for(@lspci){
		if(/graphics|vga|video/i){
			if(/^\S+\s([^:]+):\s*(.+?)(?:\(([^()]+)\))?$/i){
				push @values, ($1,$2);
				push @{$request{'CONTENT'}{'VIDEOS'}}, {
					'CHIPSET'	=> [ $1 ],
					'NAME'	 	=> [ $2 ]
				}
			}
		}
	}
	#Checksum
	&_has_changed('videos', md5_base64(@values));
}

sub _sounds{
	my( $vendor, $name, @values );
	for(@lspci){
		if(/audio/i){
			if(/^\S+\s([^:]+):\s*(.+?)(?:\(([^()]+)\))?$/i){
				push @values, ($1,$2,$3);
				push @{$request{'CONTENT'}{'SOUNDS'}}, {
					'MANUFACTURER'	=> [ $2 ],
					'NAME'		=> [ $1 ],
					'DESCRIPTION' 	=> [ $3 ]
				};
			}
		}
	}
	#Checksum
	&_has_changed('sounds', md5_base64(@values));
}


sub _inputs{
	my($flag, $n, @values);
	if($xfree){
		for(@xconfig){
			if(/section\s+("inputdevice")|
			section\s+("keyboard")|
			section\s+("pointer")/i){
				$flag=1;(defined($n))?($n++):($n=0);
			}
			if((/endsection/i) && $flag){$flag=0;}

			if((/identifier\s+"(.+)"/i) && ($flag)) {
				$request{'CONTENT'}{'INPUTS'}[$n]{'CAPTION'}= [ $1 ]; 
				push @values, ($1);
			};
			if((/driver\s+"(.+)"/i) && ($flag)) {
				$request{'CONTENT'}{'INPUTS'}[$n]{'TYPE'}= [ $1 ]; 
				push @values, ($1);
			};
			if((/option\s+"protocol"\s*"(.+)"/i) && ($flag)) { 
				$request{'CONTENT'}{'INPUTS'}[$n]{'INTERFACE'} = [ $1 ]; 
				push @values, ($1);
			};
		}
	}
	#Checksum
	&_has_changed('inputs', md5_base64(@values));
}


sub _modems{
	my @values;
	for(@lspci){
		if(/modem/i){
			if(/\d+\s(.+):(.+)$/){
				push @values, ($1,$2);
				push @{$request{'CONTENT'}{'MODEMS'}}, {
					'NAME'		=> [ $1 ],
					'DESCRIPTION'	=> [ $2 ],
				};
			}
		}
	}
	#Checksum
	&_has_changed('modems', md5_base64(@values));
}


sub _softwares{
	my (@liste, $dpkg, @values);
	
	#If no software inventory is needed
	return(0) if $nosoft;
	
	#Working with dpkg and rpm packets management
	# D LIROULET 2006/08/31 added software support for knoppix
	if($distro =~/debian|knoppix/i){
		my $dpkg_path = &_get_path('dpkg');
		@liste = `COLUMNS=200 $dpkg_path -l`;
		for(@liste){
			if (/^[uirph]/){
				/^(\w+)\s+(\S+)\s+(\S+)\s+(.*)/;
				push @values, ($1,$2,$3,$4);
				push @{$request{'CONTENT'}{'SOFTWARES'}}, {
					'NAME'		=> [ $2 ],
					'VERSION'	=> [ $3 ],
					'COMMENTS'	=> [ "$4($1)" ],
				};
			}else{
				next;
			}
		}
		
	}
	# D LIROULET 2006/08/31 added software support for fedora and trustix
    elsif($distro=~/mandrake|redhat|suse|fedora|trustix/i){
		my $rpm_path = &_get_path('rpm');
		my $buff;
		foreach(`env LANGUAGE=us $rpm_path -qa --queryformat "%{NAME} %{VERSION}-%{RELEASE} %{SUMMARY}\n--\n"`) {
			if (/^--/) {
				push @liste, $buff;
				$buff = undef;
			} else {
				chomp;
				$buff .= $_;
			}
		}
		for(@liste){
			/^(\S+)\s+(\S+)\s+(.*)/;
			push @values, ($1,$2,$3);
			push @{$request{'CONTENT'}{'SOFTWARES'}}, {
				'NAME'		=> [ $1 ],
				'VERSION'	=> [ $2 ],
				'COMMENTS'	=> [ $3 ],
			};
		}
    }elsif($distro=~/gentoo/i){
        # D LIROULET 2006/08/31 Gentoo support with "equery"
		my $equery_path = &_get_path('equery');
		@liste = `$equery_path list -i`;
        for(@liste){
		if (/^[a-z]/){
			/^(\w+-\w+\/\w+)-([0-9]+.*)/;
			push @values, ($1,$2);
			push @{$request{'CONTENT'}{'SOFTWARES'}}, {
				'NAME'		=> [ $1 ],
				'VERSION'	=> [ $2 ],
				'COMMENTS'	=> [ "" ],
			};
		}else{
			next;
		}
	}	
    }
    
	#Checksum
	&_has_changed('softwares', md5_base64(@values));
}

sub _generate{
	my (@account, $err, $ptmontage, $values, $i, $content);

	# If $ServerName is local, we know that the inventory is generated on the local machine
	if(($ServerName eq '__local__') or $xml){
		$err=1;

		while($err){
			print "\n\n\tChoose your target directory ? :  ";

			chomp($ptmontage=<STDIN>);

			# Checking existence and permissions of the destination directory
			if(!(-e $ptmontage)){
				print "The directory do not exist .\n";
				$err++;
			}elsif(!(-w $ptmontage)){
				print "The mount point is not writeable.\n";
				$err++;
			# Generate...
			}else{
				$err = 0;
				open XML, ">$ptmontage/$DeviceID.ocs" or die localtime()." => Cannot create file : $!\n";

				if($xml){
					print XML $inventory;
				}else{
				 	&_debug($inventory, 'SENDING') if $debug and $debug>1;
					$inventory = Compress::Zlib::compress( $inventory ) or die localtime()." => Compression error\n";
					binmode XML;
					print XML $inventory
				}
				close XML;
			}

			die("Abort.\n") if $err>3;
		}
		print localtime()." => Inventory generated...\n";
	}else{
		# Sending inventory to web server

		# Request construction
		$req = HTTP::Request->new(POST => $URI);

		$req->header('Pragma' => 'no-cache', 'content-type' => 'application/x-compress', 'Connection' => 'keep-alive');

		&_debug($inventory, 'SENDING') if $debug and $debug>1;

		$inventory=Compress::Zlib::compress( $inventory ) or die localtime()." => Compression error\n";

		$req->content($inventory);

		# Sending
		my $res = $ua->request($req);

		# Checking response
		if($res->is_success){
			print localtime()." => Transmission...done.\n";
			&_save_checksums;
		}else{
			print localtime()." => Cannot transmit inventory ->".$res->status_line, "\n";
			exit(1);
		}

		# If we receive account informations, we write it to the admin file
		$content = _uncompress($res->content)  or die localtime()." => Cannot read the server message (code $content)\n";

		&_debug($content, 'RECEIVING') if $debug and $debug>1;

		$xml=XML::Simple::XMLin( $content, ForceArray => ['ACCOUNTINFO', 'KEYNAME', 'KEYVALUE'], SuppressEmpty => undef);

		if($xml->{RESPONSE}=~/^no_account_update/i){
			print localtime()." => Account infos up to date\n";
		}elsif($xml->{RESPONSE}=~/^account_update/i){
			delete $xml->{RESPONSE};

			$xml=XML::Simple::XMLout( $xml, RootName => 'ADM', NoSort => 1 );

			print localtime()." => Updating Account infos\n";

			open ADM, ">".$install_path."/ocsinv.adm";
			print ADM $xml;
			close ADM;
		}else{
			print localtime()." => Problem with account infos : $content\n";
		}
	}
}

sub _inventory{
	# Query type is INVENTORY
	$request{'QUERY'} = ['INVENTORY'];

	# Writing DeviceID
	$request{'DEVICEID'} = [ $DeviceID ];

	# Writing old deviceid if needed
	$request{'CONTENT'}{'OLD_DEVICEID'} = [ $old_deviceid ] if $old_deviceid;

	# Launching subroutines
	&_hardware;
	&_accountinfo;
	&_bios;
	&_accesslog;
	&_memories;
	&_networks;
	&_drives;
	&_storages;
	&_ports;
	&_controllers;
	&_slots;
	&_monitors;
	&_videos;
	&_sounds;
	&_inputs;
	&_modems;
	&_softwares;
	&_call_inventory_handlers(\%request);
	#
	$end = time();

	$request{'CONTENT'}{'HARDWARE'}{'ETIME'} = [ $end - $start ];
	# Convert perl data structure into xml string
	$inventory = XMLout( \%request, RootName => 'REQUEST', XMLDecl => '<?xml version="1.0" encoding="ISO-8859-1"?>', NoSort => 1, SuppressEmpty => undef );

	# Create/send inventory
	&_generate;
}

# We ask to server if we have to send an inventory
sub _prolog{
	my ($message, $xml, $resp, $content);

	%request = ();

	# Generation of xml message
	$request{'QUERY'} = ['PROLOG'];
	$request{'DEVICEID'} = [$DeviceID];
		
	# Call modules prolog writers sub
	_call_prolog_writers(\%request);

	$message=XMLout( \%request, RootName => 'REQUEST', XMLDecl => '<?xml version="1.0" encoding="ISO-8859-1"?>',
	                 NoSort => 1, SuppressEmpty => undef );

	#####
	#HTTP
	#####
	$req = HTTP::Request->new(POST => $URI);

	$req->header('Pragma' => 'no-cache', 'Content-type', 'application/x-compress');

	&_debug($message, 'SENDING') if $debug and $debug>1;

	$message = Compress::Zlib::compress( $message )  or die localtime()." => Probleme de compression(prolog)\n";

	$req->content($message);

	$res = $ua->request($req);

	# Checking if connected
	unless($res->is_success) {
		die localtime()." => Cannot establish communication : ".$res->status_line, "\n";
	}

	# stop or send in the http's body
	$content = _uncompress($res->content)  or die localtime()." => Deflating problem (prolog, code= $content )\n";

	&_debug($content, 'RECEIVING') if $debug and $debug>1;

	# Call modules prolog readers sub
	_call_prolog_readers($content);
	
	$xml = XML::Simple::XMLin( $content, ForceArray => ['OPTION'] );
		
	# If -force tag
	return(1) if $force;
	
	if($xml->{RESPONSE} eq 'STOP'){
		print localtime()." => Inventory not generated, command by server...\n";
		return(0);
	}elsif($xml->{RESPONSE} eq 'SEND'){
		return(1);
# 	}elsif($xml->{RESPONSE} eq 'OTHER'){
# 		print localtime()." => Inventory not generated, command by server...\n";
# 		return(0);
	}else{
		die("Server response unreadeable. Abort...\n");
	}
}

sub _has_changed{
	my $section 	= shift;
	my $hash	= shift;
	if($last_state){
		#If the checksum has changed...
		if($last_state->{$section}[0] ne $hash){
			print "Section $section has changed since last inventory( ".$last_state->{$section}[0]." --> ".$hash.")\n" if $debug;
			#We made OR on $checksum with the mask of the current section
			$checksum |= $mask{$section};
			#And we replace the hash with the new value
			$last_state->{$section} = [ $hash ];
		}
	}else{
		$checksum |= $mask{$section};
		$last_state{$section} = [ $hash ];
	}
}

sub _save_checksums{
	$last_state = \%last_state unless $last_state;
	my $string = XML::Simple::XMLout( $last_state, RootName => 'LAST_STATE' );
	open LAST_STATE, ">$install_path/last_state" or warn "Cannot save the checksum values (will be synchronized by GLPI!!): $!\n";
	print LAST_STATE $string;
	close LAST_STATE;
	my $base = $request{'CONTENT'}{'HARDWARE'};
	$base->{'CHECKSUM'} = [ $checksum ];
}

sub _call_start_handlers{
	my @f =  _get_symbols('_start_handler');
	for(@f){
		&$_(\%CURRENT_CONTEXT);
	}
}

sub _call_end_handlers{
	my @f =  &_get_symbols('_end_handler');
	for(@f){
		&$_(\%CURRENT_CONTEXT);
	}
}

# sub that will talk through prolog
sub _call_prolog_writers{
	my $prolog = shift;
	my @f = &_get_symbols('_prolog_writer');
	for(@f){
		&$_(\%CURRENT_CONTEXT, $prolog);
	}
}

# sub that will read something in prolog
sub _call_prolog_readers{
	my $resp = shift;
	my @f = &_get_symbols('_prolog_reader');
	for(@f){
		&$_(\%CURRENT_CONTEXT, $resp);
	}
}

# sub that will talk through inventory
sub _call_inventory_handlers{
	my $inventory = shift;
	my @f = &_get_symbols('_inventory_handler');
	for(@f){
		&$_(\%CURRENT_CONTEXT, $inventory);
	}
}

# sub that will retrieve the functions
sub _get_symbols{
	my $suffix = shift;
	my @ret;
	for(sort keys(%main::)){
		push @ret, \&$_ if $_=~/$suffix$/;
	}
	return @ret;
}













