/* OpenCP Module Player
 * copyright (c) '94-'98 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * DOS4GFIX initialisation handlers
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -kb98????   Tammo Hinrichs <opencp@gmx.net>                 (?)
 *    -some bugfix(?)
 *  -fd981205   Felix Domke <tmbinc@gmx.net>
 *    -KB's "bugfix" doesn't work with Watcom106
 *  -ss040613   Stian Skjelstad <stian@nixia.no>
 *    -Redone to use gcc assembler inline and posix libc
 *  -ss040908   Stian Skjelstad <stian@nixia.no>
 *    -Made the assembler inlines optimize-safe
 */

#ifndef IMSRTNS__H
#define IMSRTNS__H

/* Assembler optimization per cpu we can wait with.... */

#define memsetb(dst, what, len) memset(dst, what, len*1) /* let the compiler handle this */
#define memcpyb(dst, src, len) memcpy(dst, src, len) /* let the compiler handle this */
#define memcpyf(dst, src, len) memcpy(dst, src, len*sizeof(float)) /* let the compiler handle this.. even this one... not even used yet */
#define memmovel(dst, src, n) memmove(dst, src, (n)*4)

#ifdef I386_ASM

static inline signed long imuldiv(signed long a,signed long b,signed long c)
{
#ifdef __PIC__
	int d0, d1;
	signed long register retval;
	__asm__ __volatile__(
		"pushl %%ebx\n"
		"movl %%ecx, %%ebx\n"
		"imul %%edx\n"
		"idiv %%ebx\n"
		"popl %%ebx\n"
		:"=a"(retval), "=&d"(d0), "=&c"(d1)
		:"0"(a), "1"(b), "2"(c)
	);
	return retval;
#else
	int d0, d1;
	signed long register retval;
	__asm__ __volatile__(
		"imul %%edx\n"
		"idiv %%ebx\n"
		:"=a"(retval), "=&d"(d0), "=&b"(d1)
		:"0"(a), "1"(b), "2"(c)
	);
	return retval;
#endif
}

static inline unsigned long umuldiv(unsigned long a,unsigned long b,unsigned long c)
{
#ifdef __PIC__
	int d0, d1;
	unsigned long register retval;
	__asm__ __volatile__
	(
	 	"pushl %%ebx\n"
		"movl %%ecx, %%ebx\n"
		"mul %%edx\n"
		"div %%ebx\n"
		"popl %%ebx\n"
		:"=a"(retval), "=&d"(d0), "=&c"(d1)
		:"0"(a), "1"(b), "2"(c)
	);
	return retval;
#else
	int d0, d1;
	unsigned long register retval;
	__asm__ __volatile__
	(
		"mul %%edx\n"
		"div %%ebx\n"
		:"=a"(retval), "=&d"(d0), "=&b"(d1)
		:"0"(a), "1"(b), "2"(c)
	);
	return retval;
#endif
}

static inline signed long imulshr16(signed long a,signed long b)
{
	int d0;
	signed long register retval;
	__asm__ __volatile__
	(
		"imul %%edx\n"
		"shrd $16,%%edx,%%eax\n"
		:"=a"(retval), "=&d"(d0)
		:"0"(a), "1"(b)
	);
	return retval;
}

static inline unsigned long umulshr16(unsigned long a,unsigned long b)
{
	int d0;
	unsigned long register retval;
	__asm__ __volatile__
	(
		"mul %%edx\n"
		"shrd $16,%%edx,%%eax\n"
		:"=a"(retval), "=&d"(d0)
		:"0"(a), "1"(b)
	);
	return retval;
}

static inline unsigned long umldivrnd(unsigned long a,unsigned long b,unsigned long c)
{
	int d0, d1;
	unsigned long register retval;
	__asm__ __volatile__
	(
		"mul %%edx\n"
		"movl %%ecx,%%ebx\n"
		"shrl $1,%%ebx\n"
		"addl %%ebx,%%eax\n"
		"adc $0,%%edx\n"
		"div %%ecx\n"
		:"=a"(retval), "=&d"(d0), "=&c"(d1)
		:"0"(a), "1"(b), "2"(c)
		:"ebx"
	);
	return retval;
}

static inline void memsetd(void *dst, long what, long len)
{
	int d0, d1, d2;
	__asm__ __volatile__
	(
		"rep stosl\n"
		: "=&D"(d0), "=&a"(d1), "=&c"(d2)
		: "0" (dst), "1" (what), "2" (len)
		: "memory"
	);
}

static inline void memsetw(void *dst, short what, long len)
{
	short d1;
	int d0, d2;
	__asm__ __volatile__
	(
		"rep stosw\n"
		: "=&D"(d0), "=&a"(d1), "=&c"(d2)
		: "0" (dst), "1" (what), "2" (len)
		: "memory"
	);
}

#else

#define imuldiv(mul1, mul2, divby) ((signed long)((((signed long long)mul1)*mul2)/(signed long)divby))
#define umuldiv(mul1, mul2, divby) ((unsigned long)((((unsigned long long)mul1)*mul2)/(unsigned long)divby))
#define imulshr16(m1, m2) ((signed long)((((signed long long)m1)*m2)>>16))
#define umulshr16(m1, m2) ((unsigned long)((((unsigned long long)m1)*m2)>>16))
#define umldivrnd(mul1, mul2, divby) umuldiv(mul1, mul2, divby) /* dirty */

#define memsetd(dst, what, len) {int i;long *tmp_dst=dst;for(i=len;i;i--)*tmp_dst++=(long)what;} while(0)
#define memsetw(dst, what, len) {int i;short *tmp_dst=dst;for(i=len;i;i--)*dst_dst++=(short)what;} while(0)

#endif


#endif
