/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * GMDPlay file type detection routines for the fileselector
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 */

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include "types.h"
#include "filesel/mdb.h"

/*

#define _MAX_EXT 5
static void getext(char *ext, const char *name)
{
	int i;
	name+=8;
	for (i=0; i<(_MAX_EXT-1); i++)
		if (*name==' ')
			break;
		else
			*ext++=*name++;
	*ext=0;
}*/

static unsigned char gmdGetModuleType(const char *buf/*, const char *ext*/)
{
	if (*(unsigned long*)(buf+44)==0x4D524353)
		return mtS3M;

	if (*(unsigned long*)(buf+44)==0x464D5450)
		return mtPTM;

	if (!memcmp(buf, "AMShdr\x1A", 7))
		return mtAMS;

	if (!memcmp(buf, "MAS_UTrack_V00", 14))
		return mtULT;

	if (!memcmp(buf, "OKTASONG", 8))
		return mtOKT;

	if (*(unsigned long*)buf==0x4C444D44)
		return mtMDL;

	if (*(unsigned long*)buf==0x104D544D)
		return mtMTM;

	if (*(unsigned long*)buf==0x464D4444)
		return mtDMF;

	if ((*(unsigned short*)buf==0x6669)||(*(unsigned short*)buf==0x4E4A))
		return mt669;

	return mtUnRead;
}


static int gmdReadMemInfo(struct moduleinfostruct *m, const char *buf, size_t len)
{
/*	char ext[_MAX_EXT];*/
	int type;
	int i;

	if (!memcmp(buf, "ziRCONia", 8))
	{
		strcpy(m->modname, "MMCMPed module");
	    	return 0;
	}

/*	getext(ext, m.name);*/

	if ((type=gmdGetModuleType(buf))!=mtUnRead)
		m->modtype=type;
	
	switch (type)
	{
		case mtS3M:
			memcpy(m->modname, buf, 28);
			m->modname[28]=0;
			m->channels=0;
			for (i=0; i<32; i++)
				if (buf[64+i]!=(char)0xFF)
					m->channels++;
			memset(&m->composer, 0, sizeof(m->composer));
			return 1;

		case mtMDL:
			if (buf[4]<0x10)
			{
				m->modtype=0xFF;
				strcpy(m->modname,"too old version");
				return 0;
			}
			memcpy(m->modname, buf+11, 32);
			for (i=32; i>0; i--)
				if (m->modname[i-1]!=' ')
					break;
			if (i!=32)
				m->modname[i]=0;
			memcpy(m->composer, buf+43, 20);
			for (i=20; i>0; i--)
				if (m->composer[i-1]!=' ')
					break;
			if (i!=20)
				m->composer[i]=0;
			m->channels=0;
			for (i=0; i<32; i++)
				if (!(buf[i+70]&0x80))
					m->channels++;
			return 1;

		case mtPTM:
			memcpy(m->modname, buf, 28);
			m->modname[28]=0;
			m->channels=buf[38];
			memset(&m->composer, 0, sizeof(m->composer));
			return 1;
			
		case mtAMS:
			memcpy(m->modname, buf+8, buf[7]);
			m->modname[(unsigned char)buf[7]]=0;
			memset(&m->composer, 0, sizeof(m->composer));
			return 1;

		case mtMTM:
			memcpy(m->modname, buf+4, 20);
			m->modname[20]=0;
			m->channels=buf[33];
			memset(&m->composer, 0, sizeof(m->composer));
			return 1;

		case mt669:
			memcpy(m->modname, buf+2, 32);
			m->channels=8;
			memset(&m->composer, 0, sizeof(m->composer));
			return 1;

		case mtOKT:
			m->channels=4+(buf[17]&1)+(buf[19]&1)+(buf[21]&1)+(buf[23]&1);
			memset(&m->modname, 0, sizeof(m->modname));
			memset(&m->composer, 0, sizeof(m->composer));
			return 1;

		case mtULT:
			m->modtype=0xFF;
			memcpy(m->modname, buf+15, 32);
			memset(&m->composer, 0, sizeof(m->composer));
			return 0;

		case mtDMF:
			m->modtype=0xFF;
			memcpy(m->modname, buf+13, 30);
			m->modname[30]=0;
			memcpy(m->composer, buf+43, 20);
			m->composer[20]=0;
			m->date=(*(unsigned long*)(buf+63))&0xFFFFFF;
			return 0;
	}
	return 0;
}

static int gmdReadInfo(struct moduleinfostruct *m, FILE *fp, const char *buf, size_t len)
{
/*	char ext[_MAX_EXT];*/
	int type;
/*	getext(ext, m->gen.name);*/

	if ((type=gmdGetModuleType(buf))!=mtUnRead)
		m->modtype=type;
	switch (type)
	{
		case mtULT:
			fseek(fp, 48+buf[47]*32, SEEK_SET);
			fseek(fp, 256+fgetc(fp)*((buf[14]>='4')?66:64), SEEK_CUR);
			m->channels=fgetc(fp)+1;
			return 1;

		case mtDMF:
			fseek(fp, 66, SEEK_SET);
			m->channels=32;
			while (1)
			{
				unsigned long sig=0;
				unsigned long len=0;
				if (!fread(&sig, 4, 1, fp))
					break;
				if (!fread(&len, 4, 1, fp))
					break;
				if (sig==0x54544150)
				{
					char buffer[1024];
					fgets(buffer, 1024, fp);
					m->channels=fgetc(fp);
					break;
				}
				fseek(fp, len, SEEK_CUR);
			}
			return 1;
	}
	return 0;
}

struct mdbreadnforegstruct gmdReadInfoReg = {gmdReadMemInfo, gmdReadInfo};
