#ifndef __PLAYER_H
#define __PLAYER_H

#ifdef WIN32
#include "w32idata.h"
#endif

#define PLR_STEREO 1
#define PLR_16BIT 2
#define PLR_SIGNEDOUT 4
#define PLR_REVERSESTEREO 8
#define PLR_RESTRICTED 16

enum
{
	plrGetSampleStereo=1
};

/*
#if defined(DOS32) || (defined(WIN32)&&defined(NO_PLRBASE_IMPORT))
*/
extern int plrRate;
extern int plrOpt;
extern int (*plrPlay)(void **buf, int *len);
extern void (*plrStop)(void);
extern void (*plrSetOptions)(int rate, int opt);
extern int (*plrGetBufPos)(void);
extern int (*plrGetPlayPos)(void);
extern void (*plrAdvanceTo)(int pos);
extern long (*plrGetTimer)(void);
extern void (*plrIdle)(void);
#ifdef PLR_DEBUG
extern char *(*plrDebug)(void);
#endif

/*
#else
extern_data int plrRate;
extern_data int plrOpt;
extern_data int (*plrPlay)(void *&buf, int &len);
extern_data void (*plrStop)();
extern_data void (*plrSetOptions)(int rate, int opt);
extern_data int (*plrGetBufPos)();
extern_data int (*plrGetPlayPos)();
extern_data void (*plrAdvanceTo)(int pos);
extern_data long (*plrGetTimer)();
extern_data void (*plrIdle)();
#endif
*/
extern int plrOpenPlayer(void **buf, uint32_t *len, uint32_t blen);
extern void plrClosePlayer(void);
extern void plrGetRealMasterVolume(int *l, int *r);
extern void plrGetMasterSample(short *s, int len, int rate, int opt);

#if 0
extern void (*plrIdle)();
int pollInit(void (*)());
void pollClose();
extern int pollInterval;
#endif

#endif
