/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * MEDIALIBRARY filebrowser
 *
 * revision history: (please note changes here)
 *  -ss050430   Stian Skjelstad <stian@nixia.no>
 *    -first release
 */

#include "config.h"
#include <ctype.h>
#include <curses.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "types.h"
#include "boot/plinkman.h"
#include "boot/pmain.h"
#include "filesel/dirdb.h"
#include "filesel/modlist.h"
#include "filesel/mdb.h"
#include "filesel/adb.h"
#include "filesel/pfilesel.h"
#include "boot/psetting.h"
#include "stuff/err.h"
#include "stuff/poutput.h"
#include "stuff/framelock.h"

struct sources_t;
struct sources_t
{
	struct sources_t *next, *prev;
	int i;
	char name[PATH_MAX+1];
};
static int sourcecount=0;

static struct sources_t *sources=NULL;

struct file_t
{
	char name[PATH_MAX+1];
	int fileref, adb_ref;
	int flag; /* flags are ONLY used be mlRescan for now */
};
static struct file_t *files;
static uint32_t files_n, files_m;

static struct dmDrive *dmMEDIALIB;

static int mlDrawBox(void)
{
	int mlTop=plScrHeight/2-2;
	int i;

	displayvoid(mlTop+1, 5, plScrWidth-10);
	displayvoid(mlTop+2, 5, plScrWidth-10);
	displayvoid(mlTop+3, 5, plScrWidth-10);
	displaystr(mlTop, 4, 0x04, "\xda", 1);
	for (i=5;i<(plScrWidth-5);i++)
		displaystr(mlTop, i, 0x04, "\xc4", 1);
	displaystr(mlTop, plScrWidth-5, 0x04, "\xbf", 1);
	displaystr(mlTop+1, 4, 0x04, "\xb3", 1);
	displaystr(mlTop+2, 4, 0x04, "\xb3", 1);
	displaystr(mlTop+3, 4, 0x04, "\xb3", 1);
	displaystr(mlTop+1, plScrWidth-5, 0x04, "\xb3", 1);
	displaystr(mlTop+2, plScrWidth-5, 0x04, "\xb3", 1);
	displaystr(mlTop+3, plScrWidth-5, 0x04, "\xb3", 1);
	displaystr(mlTop+4, 4, 0x04, "\xc0", 1);
	for (i=5;i<(plScrWidth-5);i++)
		displaystr(mlTop+4, i, 0x04, "\xc4", 1);
	displaystr(mlTop+4, plScrWidth-5, 0x04, "\xd9", 1);

	return mlTop;
}

static void mlSaveSources(void)
{
	char path[PATH_MAX+1];
	int f;
	uint32_t sources_n=0;
	struct sources_t *source=sources;


	mdbUpdate();
	adbUpdate();
	
	if ((strlen(cfConfigDir)+12)>PATH_MAX)
		fprintf(stderr, "[medialib]: CPMODML.DAT path is too long\n");

	strcpy(path, cfConfigDir);
	strcat(path, "CPMODML.DAT");

	if ((f=open(path, O_WRONLY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE))<0)
	{
		perror("open(CPMODML.DAT)");
		return;
	}

	while (source)
	{
		sources_n++;
		source=source->next;
	}

	write(f, "Cubic Player MediaLib Information Data Base\x1B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 56);
	write(f, &sources_n, sizeof(uint32_t));
	write(f, &files_n, sizeof(uint32_t));

	source=sources;
	while (source)
	{
		write(f, sources->name, sizeof(sources->name));
		source=source->next;
	}


	write(f, files, sizeof(struct file_t)*files_n);
	close(f);
}

static int mlScan(const char *source, int mlTop)
{
	struct modlist *ml = create_modlist();
	struct modlistentry *mle;
	int i;
	uint32_t dirdbnode;

	displaystr(mlTop+2, 5, 0x0f, source, plScrWidth-10);
	dirdbnode=dirdbResolvePathWithBaseAndRef(dmFILE->basepath, (char *)source);
	fsReadDir(ml, dmFILE, dirdbnode, "*", RD_PUTRSUBS/*|RD_PUTSUBS*/|(fsScanArcs?RD_ARCSCAN:0));
	dirdbUnref(dirdbnode);

	if (ekbhit())
	{
		uint16_t key=egetch();
		if (key==27)
			return -1;
	}

	for (i=0;i<ml->num;i++)
	{
		mle=ml->get(ml, i);
		if (mle->flags&MODLIST_FLAG_DIR)
		{
			char npath[PATH_MAX+1];
			if (strcmp(mle->name, ".."))
			if (strcmp(mle->name, "."))
			if (strcmp(mle->name, "/"))
			{
				dirdbGetFullName(mle->dirdbfullpath, npath, DIRDB_FULLNAME_NOBASE|DIRDB_FULLNAME_ENDSLASH);
				if (mlScan(npath, mlTop))
					return -1;
			}
		} else if (mle->flags&MODLIST_FLAG_FILE)
		{
			int i;
			char npath[PATH_MAX+1];
			if (!mdbInfoRead(mle->fileref))
				mdbScan(mle);
			for (i=0;i<files_n;i++)
			{
				dirdbGetFullName(mle->dirdbfullpath, npath, DIRDB_FULLNAME_NOBASE);
				if (!strcmp(files[i].name, npath))
				{
					files[i].flag=0;
					goto skip;
				}
			}
			if (files_n==files_m)
			{
				files_m+=50;
				files=realloc(files, sizeof(struct file_t)*files_m);
			}
			dirdbGetFullName(mle->dirdbfullpath, npath, 0);
			strncpy(files[files_n].name, npath, sizeof(files[files_n].name));
			files[files_n].name[sizeof(files[files_n].name)-1]=0;
			files[files_n].adb_ref=mle->adb_ref;
			files[files_n].fileref=mle->fileref;
			files_n++;
skip:{}
		}
	}
	ml->_free(ml);
	return 0;
}

static int mlRescan(const char *source)
{
	int i;
	int old_files_n=files_n;
	int cachelen=strlen(source);

	int mlTop=mlDrawBox();

	for (i=0;i<files_n;i++)
		files[i].flag=!strncmp(files[i].name, source, cachelen);
	
	displaystr(mlTop+1, 5, 0x0b, "Scanning filesystem, current directory:", 39);
	displaystr(mlTop+3, 5, 0x0b, "-- Abort with escape --", 23);

	if (mlScan(source, mlTop))
	{
		/* user aborted */
	 	files_n=old_files_n;
		return -1;
	}

	/* remove files that have gone into the night */
	for (i=0;i<files_n;i++)
		if (files[i].flag)
		{
			memcpy(&files[i], &files[files_n-1], sizeof(struct file_t));
			files_n--;
			i--;
		}
	return 0;
}

static void mlAddSource(const char *path)
{
	struct sources_t *source=sources;
	while (source)
	{
		if (!strcmp(source->name, path))
		{
			/* perfect match? */
			if (!(mlRescan(source->name)))
				mlSaveSources();
			return;
		} else if (!strncmp(source->name, path, strlen(source->name)))
		{
			/* sub of older match ? */
			if (!mlRescan(path))
				mlSaveSources();
			return;
		} else if ((!strncmp(source->name, path, strlen(path))))
		{
			/* supersets older match */
			if (!mlRescan(path))
			{
				strcpy(source->name, path);
				mlSaveSources();
			}
			return;
		}
		source=source->next;
	}
	/* not an existing path */
	if (!mlRescan(path))
	{
		source=malloc(sizeof(struct sources_t));
		strcpy(source->name, path);
		source->next=sources;
		source->i=++sourcecount;
		source->prev=NULL;
		sources=source;
		mlSaveSources();
	}
}

static FILE *mlSourcesAdd(struct modlistentry *entry)
{
	int mlTop=mlDrawBox();
	int editpath=0;

	/* these are for editing the path */
	char str[PATH_MAX+6];
	int curpos;
	int cmdlen;
      	int insmode=1;
	int scrolled=0;

	strcpy(str, "file:/");
	curpos=strlen(str);
	cmdlen=strlen(str);

	displaystr(mlTop+3, 5, 0x0b, "Abort with escape, or finish selection by pressing enter", 56);

	while (1)
	{
		uint16_t key;
		displaystr(mlTop+1, 5, (editpath?0x8f:0x0f), str+scrolled, plScrWidth-10);
		if (editpath)
			setcur(mlTop+1, 5+curpos-scrolled);

		displaystr(mlTop+2, 5, (editpath?0x0f:0x8f), "current file: directory", plScrWidth-10);

		while (!ekbhit())
			framelock();
		key=egetch();

		if ((key>=0x20)&&(key<=0xFF))
		{
			if (editpath)
			{
				if (insmode)
				{
					if (cmdlen<(PATH_MAX+5))
					{
						memmove(str+curpos+1, str+curpos, cmdlen-curpos+1);
						str[curpos]=key;
						curpos++;
						cmdlen++;
					}
				} else if (curpos==cmdlen)
				{
					if (cmdlen<(PATH_MAX+5))
					{
						str[curpos++]=key;
						str[curpos]=0;
						cmdlen++;
					}
				} else
				str[curpos++]=key;
			}
		} else switch (key)
		{
			case 27:
				setcurshape(0);
				return NULL;
			case KEY_LEFT:
				if (editpath)
					if (curpos)
						curpos--;
				break;
			case KEY_RIGHT:
				if (editpath)
					if (curpos<cmdlen)
						curpos++;
				break;
			case KEY_HOME:
				if (editpath)
					curpos=0;
				break;
			case KEY_END:
				if (editpath)
					curpos=cmdlen;
				break;
			case KEY_INSERT:
				if (editpath)
				{
					insmode=!insmode;
					setcurshape(insmode?1:2);
				}
				break;
			case KEY_DELETE:
				if (editpath)
					if (curpos!=cmdlen)
					{
						memmove(str+curpos, str+curpos+1, cmdlen-curpos);
						cmdlen--;
					}
				break;
			case KEY_BACKSPACE:
				if (editpath)
					if (curpos)
					{
						memmove(str+curpos-1, str+curpos, cmdlen-curpos+1);
						curpos--;
						cmdlen--;
					}
				break;
			case _KEY_ENTER:
				if (!editpath)
				{
					struct dmDrive *_dmDrives=dmDrives;
					while (_dmDrives)
					{
						if (!strcmp(_dmDrives->drivename, "file:"))
						{
							char currentpath[PATH_MAX+1];
							dirdbGetFullName(_dmDrives->currentpath, currentpath, DIRDB_FULLNAME_NOBASE|DIRDB_FULLNAME_ENDSLASH);
							mlAddSource(currentpath);
							break;
						}
						_dmDrives=_dmDrives->next;
					}
				} else {
					if (!strncmp(str, "file:/", 6))
					{
						char *last=rindex(str, '/');
						if (last[1])
						{
							if (strlen(str)<(PATH_MAX+4))
							{
								strcat(str, "/");
								mlAddSource(str+5);
							}
						} else
							mlAddSource(str+5);
					}
				}
				setcurshape(0);
				fsRescanDir();
				return NULL;
			case KEY_UP:
			case KEY_DOWN:
				if ((editpath^=1))
					setcurshape((insmode?1:2));
				else 
					setcurshape(0);
				break;
		}
		while ((curpos-scrolled)>=(plScrWidth-10))
			scrolled+=8;
		while ((curpos-scrolled)<0)
			scrolled-=8;
	}
}

static FILE *mlSourcesRemove(struct modlistentry *entry)
{
	int id=atoi(entry->name);
	struct sources_t *source=sources;
	while (source)
	{
		if (id==(int)source)
		{
			int cachelen=strlen(source->name);
			int i;	
			for (i=0;i<files_n;i++)
			{
				if (!strncmp(files[i].name, source->name, cachelen))
				{
					memcpy(&files[i], &files[files_n-1], sizeof(struct file_t));
					files_n--;
					i--;
				}
			}
			if (source->next)
				source->next->prev=source->prev;
			if (source->prev)
				source->prev->next=source->next;
			else
				sources=source->next;
			free(source);
			mlSaveSources();
			fsRescanDir();
			break;
		}
		source=source->next;
	}
	return NULL;
}

static int mlReadDir(struct modlist *ml, const struct dmDrive *drive, const uint32_t path, const char *mask, unsigned long opt)
{
	struct modlistentry entry;
	uint32_t dmsources, dmall, dmsearch, dmparent;

	if (drive!=dmMEDIALIB)
		return 1;

	dmsources=dirdbFindAndRef(drive->basepath, "sources");
	dmall=dirdbFindAndRef(drive->basepath, "all");
	dmsearch=dirdbFindAndRef(drive->basepath, "search");
	dmparent=dirdbGetParentAndRef(path);

	if (path==drive->basepath)
	{
		if (!(opt&RD_PUTSUBS))
			return 1;

		strcpy(entry.shortname, "sources");
		strcpy(entry.name, "sources");
		entry.drive=drive;
		entry.dirdbfullpath=dmsources;
		entry.flags=MODLIST_FLAG_DIR;
		entry.fileref=0xffffffff;
		entry.adb_ref=0xffffffff;
		entry.Read=0; entry.ReadHeader=0; entry.ReadHandle=0;
		ml->append(ml, &entry);
	
		strcpy(entry.shortname, "all");
		strcpy(entry.name, "all");
		entry.drive=drive;
		entry.dirdbfullpath=dmall;
		ml->append(ml, &entry);
	
		strcpy(entry.shortname, "search");
		strcpy(entry.name, "search");
		entry.drive=drive;
		entry.dirdbfullpath=dmsearch;
		ml->append(ml, &entry);
		goto out;
	}
	if (path==dmsources)
	{
		struct sources_t *source=sources;

		if (!(opt&RD_PUTSUBS))
			return 1;

		strcpy(entry.shortname, "add");
		strcpy(entry.name, "add");
		entry.drive=drive;
		entry.dirdbfullpath=dirdbFindAndRef(dmsources, "add");
		entry.flags=MODLIST_FLAG_FILE|MODLIST_FLAG_VIRTUAL;
		entry.fileref=0xffffffff;
		entry.adb_ref=0xffffffff;
		entry.Read=0; entry.ReadHeader=0; entry.ReadHandle=mlSourcesAdd;
		ml->append(ml, &entry);
		dirdbUnref(entry.dirdbfullpath);

		entry.ReadHandle=0;
		entry.flags=MODLIST_FLAG_DIR;
		while (source)
		{
			char *last=rindex(source->name, '/');
			char *prelast;
			char npath[64];

			if (last!=source->name)
			{
				int len;
				prelast=last-1;
				while (*prelast!='/')
					prelast--;
				prelast++;
				if ((last-prelast)>12)
					len=12;
				else
					len=last-prelast;
				strncpy(entry.shortname, prelast, len);
				if (len<12)
					entry.shortname[len]=0;
			} else 
				strcpy(entry.shortname, "/");
			strncpy(entry.name, source->name, sizeof(entry.name));
			entry.name[sizeof(entry.name)-1]=0;
			snprintf(npath, 64, "%d", source->i); /* dirty oppland */
			entry.dirdbfullpath=dirdbFindAndRef(path, npath);
			ml->append(ml, &entry);
			dirdbUnref(entry.dirdbfullpath);

			source=source->next;
		}
		goto out;
	}
	if (dmparent==dmsources)
	{
		char npath[PATH_MAX+1];
		int id;
		dirdbGetname(path, npath);
		id=atoi(npath);
		struct sources_t *source=sources;

		strcpy(entry.shortname, "remove");
		sprintf(entry.name, "%d/remove", id);
		entry.drive=drive;
		entry.dirdbfullpath=dirdbFindAndRef(path, "remove");
		entry.flags=MODLIST_FLAG_FILE|MODLIST_FLAG_VIRTUAL;
		entry.fileref=0xffffffff;
		entry.adb_ref=0xffffffff;
		entry.Read=0; entry.ReadHeader=0; entry.ReadHandle=mlSourcesRemove;
		ml->append(ml, &entry);
		dirdbUnref(entry.dirdbfullpath);
		
		while (source)
		{
			if (id==source->i)
			{
				int cachelen=strlen(source->name);
				int i;	

				for (i=0;i<files_n;i++)
					if (!strncmp(files[i].name, source->name, cachelen))
					{
						char *cachefilename=rindex(files[i].name, '/')+1;
						fs12name(entry.shortname, cachefilename);
						strncpy(entry.name, cachefilename, NAME_MAX);
						entry.name[NAME_MAX]=0;
					
						entry.drive=dmFILE;
						entry.dirdbfullpath=dirdbResolvePathAndRef(files[i].name);
						entry.flags=MODLIST_FLAG_FILE;
						entry.fileref=files[i].fileref;
						entry.adb_ref=files[i].adb_ref;
						entry.Read=dosfile_Read;
						entry.ReadHeader=dosfile_ReadHeader;
						entry.ReadHandle=dosfile_ReadHandle;
						ml->append(ml, &entry);
						dirdbUnref(entry.dirdbfullpath);
					}
				break;
			}
			source=source->next;
		}
		goto out;
	}
	if (path==dmall)
	{
		int i;	
		for (i=0;i<files_n;i++)
		{
			char *cachefilename=rindex(files[i].name, '/')+1;
			fs12name(entry.shortname, cachefilename);
			strncpy(entry.name, cachefilename, NAME_MAX);
			entry.name[NAME_MAX]=0;
					
			entry.drive=dmFILE;
			entry.dirdbfullpath=dirdbResolvePathAndRef(files[i].name);
			entry.flags=MODLIST_FLAG_FILE;
			entry.fileref=files[i].fileref;
			entry.adb_ref=files[i].adb_ref;
			entry.Read=dosfile_Read;
			entry.ReadHeader=dosfile_ReadHeader;
			entry.ReadHandle=dosfile_ReadHandle;
			ml->append(ml, &entry);
			dirdbUnref(entry.dirdbfullpath);
		}
		goto out;
	}
	if (path==dmsearch)
	{
		int mlTop=mlDrawBox();
		char str[NAME_MAX];
		int curpos;
		int cmdlen;
		int insmode=1;
		int scrolled=0;

		displaystr(mlTop+1, 5, 0x0b, "Give me something to crunch!!", 29);
		displaystr(mlTop+3, 5, 0x0b, "-- Finish with enter --", 23);

		str[0]=0;
		curpos=0;
		cmdlen=0;
		setcurshape(1);

		while (1)
		{
			uint16_t key;
			displaystr(mlTop+2, 5, 0x8f, str+scrolled, plScrWidth-10);
			setcur(mlTop+2, 5+curpos-scrolled);

			while (!ekbhit())
				framelock();
			key=egetch();

			if ((key>=0x20)&&(key<=0xFF))
			{
				if (insmode)
				{
					if (cmdlen<sizeof(str))
					{
						memmove(str+curpos+1, str+curpos, cmdlen-curpos+1);
						str[curpos]=key;
						curpos++;
						cmdlen++;
					}
				} else if (curpos==cmdlen)
				{
					if (cmdlen<(PATH_MAX+5))
					{
						str[curpos++]=key;
						str[curpos]=0;
						cmdlen++;
					}
				} else
				str[curpos++]=key;
			} else switch (key)
			{
				case KEY_LEFT:
					if (curpos)
						curpos--;
					break;
				case KEY_RIGHT:
					if (curpos<cmdlen)
						curpos++;
					break;
				case KEY_HOME:
					curpos=0;
					break;
				case KEY_END:
					curpos=cmdlen;
					break;
				case KEY_INSERT:
					{
						insmode=!insmode;
						setcurshape(insmode?1:2);
					}
					break;
				case KEY_DELETE:
					if (curpos!=cmdlen)
					{
						memmove(str+curpos, str+curpos+1, cmdlen-curpos);
						cmdlen--;
					}
					break;
				case KEY_BACKSPACE:
					if (curpos)
					{
						memmove(str+curpos-1, str+curpos, cmdlen-curpos+1);
						curpos--;
						cmdlen--;
					}
					break;
				case _KEY_ENTER:
					{
						int i, j;
						char buffer[PATH_MAX+1];

						setcurshape(0);

						for (i=0;i<cmdlen;i++)
							str[i]=toupper(str[i]);
						

						for (i=0;i<files_n;i++)
						{
							struct moduleinfostruct info;
						
							for (j=0;j<sizeof(files[i].name);j++)
								buffer[j]=toupper(files[i].name[j]);
							
							if (strstr(buffer, str))
								goto add;
							
							mdbGetModuleInfo(&info, files[i].fileref);
							
							for (j=0;j<sizeof(info.name);j++)
								buffer[j]=toupper(info.name[j]);
							buffer[j]=0;
							if (strstr(buffer, str))
								goto add;
							
							for (j=0;j<sizeof(info.modname);j++)
								buffer[j]=toupper(info.modname[j]);
							buffer[j]=0;
							if (strstr(buffer, str))
								goto add;

							for (j=0;j<sizeof(info.composer);j++)
								buffer[j]=toupper(info.composer[j]);
							buffer[j]=0;
							if (strstr(buffer, str))
								goto add;

							for (j=0;j<sizeof(info.comment);j++)
								buffer[j]=toupper(info.comment[j]);
							buffer[j]=0;
							if (strstr(buffer, str))
								goto add;

							continue;
							{
								char *cachefilename;
							add:
								cachefilename=rindex(files[i].name, '/')+1;
								fs12name(entry.shortname, cachefilename);
								strncpy(entry.name, cachefilename, NAME_MAX);
								entry.name[NAME_MAX]=0;
					
								entry.drive=dmFILE;
								entry.dirdbfullpath=dirdbResolvePathAndRef(files[i].name);
								entry.flags=MODLIST_FLAG_FILE;
								entry.fileref=files[i].fileref;
								entry.adb_ref=files[i].adb_ref;
								entry.Read=dosfile_Read;
								entry.ReadHeader=dosfile_ReadHeader;
								entry.ReadHandle=dosfile_ReadHandle;
								ml->append(ml, &entry);
								dirdbUnref(entry.dirdbfullpath);
							}
						}
						goto out;
					}
			}
			while ((curpos-scrolled)>=(plScrWidth-10))
				scrolled+=8;
			while ((curpos-scrolled)<0)
				scrolled-=8;
		}
	}
out:
	dirdbUnref(dmsearch);
	dirdbUnref(dmall);
	dirdbUnref(dmsources);
	if (dmparent!=DIRDB_NOPARENT)
		dirdbUnref(dmparent);
	return 1;
}


static int mlint(void)
{
	char path[PATH_MAX+1];
	int f;
	char sig[64];
	uint32_t sources_n;

	dmMEDIALIB=RegisterDrive("medialib:");

	files_n=0;
	files_m=50;
	files=malloc(sizeof(struct file_t)*files_m);

	if ((strlen(cfConfigDir)+12)>PATH_MAX)
	{
		fprintf(stderr, "[medialib]: CPMODML.DAT path is too long\n");
		return 1;
	}
	strcpy(path, cfConfigDir);
	strcat(path, "CPMODML.DAT");

	if ((f=open(path, O_RDONLY))<0)
		return 1;

	fprintf(stderr, "Loading %s .. ", path);

	if (read(f, sig, 64)!=64)
	{
		fprintf(stderr, "No header\n");
		close(f);
		return errOk;
	}

	if (memcmp(sig, "Cubic Player MediaLib Information Data Base\x1B\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 56))
	{
		fprintf(stderr, "Invalid header\n");
     		close(f);
		return errOk;
	}
	sources_n=*(uint32_t*)(sig+56);
	while (sources_n)
	{
		struct sources_t *s=malloc(sizeof(struct sources_t));
		read(f, s->name, sizeof(s->name));
		s->name[sizeof(s->name)-1]=0;
		s->next=sources;
		s->i=++sourcecount;
		s->prev=NULL;
		sources=s;
		sources_n--;
	}

	files_n=*(uint32_t*)(sig+60);
	if (!files_n)
	{
		close(f);
		return errOk;
	}
	if (files_n>files_m)
	{
		files_m=files_n+50;
		files=realloc(files, sizeof(struct file_t)*files_m);
	}
	read(f, files, sizeof(struct file_t)*files_n);
	close(f);
	fprintf(stderr, "Done\n");
	return errOk;
}

static void mlclose(void)
{
	free(files);
	files_n=files_m=0;
}

struct initcloseregstruct mlReg={mlint, mlclose};
struct mdbreaddirregstruct mlReadDirReg = {mlReadDir};

char *dllinfo = "initcloseafter mlReg; readdirs mlReadDirReg;";
struct linkinfostruct dllextinfo = {"medialib", "OpenCP medialib (c) 2005 Stian Skjelstad", DLLVERSION, 0};
