/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * CP hypertext help viewer (CPIFACE wrapper)
 *
 * revision history: (please note changes here)
 *  -fg980924  Fabian Giesen <gfabian@jdcs.su.nw.schule.de>
 *    -first release
 */

#include "config.h"
#include <stdio.h>
#include <string.h>
#include "types.h"
#include "stuff/poutput.h"
#include "stuff/framelock.h"
#include "stuff/err.h"
#include "boot/pmain.h"
#include "boot/plinkman.h"
#include "cpiface/cpiface.h"
#include "help/cphelper.h"


struct cpimoderegstruct hlpHelpBrowser;

static char beforehelp[9];

static int plHelpInit(void)
{
	*beforehelp=0;
	return 1;
}

static void hlpDraw(void)
{
	cpiDrawGStrings();
	brDisplayHelp();
	framelock();
}

static void hlpSetMode(void)
{
	cpiSetTextMode(0);
	brSetWinStart(6);
	brSetWinHeight(/*19*/plScrHeight-6);
}

static int hlpOpen(void)
{
	return 1;
}

static int hlpIProcessKey(unsigned short key)
{
	switch (key)
	{

		/*case 0x6800: case 0x3b00: case 'h': case 'H': case '?': case '!': //f1  TODO-keys*/
		case 'h': case 'H': case '?': case '!':
			cpiGetMode(beforehelp);
			cpiSetMode("coolhelp");
			break;
		default:
			return 0;
	}
	return 1;
}

static int plHelpKey(unsigned short key)
{
	switch(key)
	{
		/*case 0x6800: case 0x3b00: case 'h': case 'H': case '?': case '!': case 27: //f1 TODO-keys*/
		case 'h': case 'H': case '?': case '!': case 27: case KEY_F1:
			cpiSetMode(beforehelp);
			break;
		default:
			return brHelpKey(key);
	}
	return 1;
}

static int hlpEvent(int ev)
{
	switch (ev)
	{
		case cpievOpen:
			return hlpOpen();
		case cpievInitAll:
			return plHelpInit();
	}
	return 1;
}

static int hlpGlobalInit(void)
{
	cpiRegisterMode(&hlpHelpBrowser);

	return errOk;
}

static void hlpGlobalClose(void)
{
	hlpEvent(cpievDoneAll);
}

struct initcloseregstruct hlpWrIReg = { hlpGlobalInit, hlpGlobalClose };
struct cpimoderegstruct hlpHelpBrowser = {"coolhelp", hlpSetMode, hlpDraw, hlpIProcessKey, plHelpKey, hlpEvent};

char *dllinfo = "initcloseafter hlpWrIReg; defmodes hlpHelpBrowser";
struct linkinfostruct dllextinfo = {"cphlpif", "OpenCP help browser CPIFACE wrapper (c) 1998-04 Fabian Giesen", DLLVERSION, 0};
