/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Main routine, calls fileselector and interface code
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -kb980717   Tammo Hinrichs
 *    -complete restructuring of fsMain_ etc. to enable non-playable
 *     file types which are handled differently
 *    -therefore, added "handler" line in CP.INI filetype entries
 *    -added routines to read out PLS and M3U play lists
 *    -as always, added dllinfo record ;)
 *  -fd981014   Felix Domke <tmbinc@gmx.net>
 *    -small bugfix (tf was closed, even if it was NULL)
 *  -ss040918   Stian Skjelstad <stian@nixia.no>
 *    -minor tweak.. Do not touch any screen functions after conRestore and
 *     before conSave
 */

#define NO_PFILESEL_IMPORT
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "stuff/err.h"
#include "mdb.h"
#include "pfilesel.h"
#include "boot/plinkman.h"
#include "boot/pmain.h"
#include "stuff/poutput.h"
#include "boot/psetting.h"


static struct preprocregstruct *plPreprocess = 0;


static struct interfacestruct *plintr;
static struct interfacestruct *nextintr;
static FILE *thisf=NULL;
static FILE *nextf=NULL;
static struct moduleinfostruct nextinfo;
static struct moduleinfostruct plModuleInfo;
static char thispath[PATH_MAX+1];
static char nextpath[PATH_MAX+1];

static char callfs;
static char firstfile;

static int  stop;

/* stop: 0 cont
 *       1 next song
 *       2 quit
 *       3 iface : next song or fs
 *       4 iface : call fs
 *       5 iface : dosshell
 */




int callselector (char *path, struct moduleinfostruct *info, FILE **fi,
                  char callfs, char forcecall, char forcenext,
                  struct interfacestruct **iface)
{
	char ret;
	char result;
	char tpath[PATH_MAX+1];
	struct interfacestruct *intr;
	struct filehandlerstruct *hdlr;
	struct moduleinfostruct tmodinfo;
	char secname[20];
	FILE *tf=NULL;

	*iface=0;
	*fi=0;

	do
	{
		ret=result=0;
		if ((callfs && !fsFilesLeft())||forcecall)
		{
			ret=result=fsFileSelect();
		}

		if (!fsFilesLeft())
			return 0;

		while (ret || forcenext)
		{
			conRestore();

			if (!fsFilesLeft())
			{
				conSave();
				break;
			}
			if (!fsGetNextFile(tpath, &tmodinfo, &tf))
			{
				if (tf)
				{
					fclose(tf);
					tf=NULL;
				}
				conSave();
				continue;
			}

			sprintf(secname, "filetype %d", tmodinfo.modtype&0xFF);
			intr=(struct interfacestruct *)_lnkGetSymbol(cfGetProfileString(secname, "interface", ""));
			hdlr=(struct filehandlerstruct *)_lnkGetSymbol(cfGetProfileString(secname, "handler", ""));

			if (hdlr)
			{
				hdlr->Process(tpath, &tmodinfo, &tf);
			}

			conSave();
			{
				int i;
				for (i=0;i<plScrHeight;i++)
					displayvoid(i, 0, plScrWidth);
			}

			if (intr)
			{
				ret=0;
				*iface=intr;
				memcpy(&*info, &tmodinfo, sizeof(*info));
				*fi=tf;
				strcpy(path,tpath);
				return result?-1:1;
			} else {
				if(tf)
				{
					fclose(tf);
					tf=NULL;
				}
			}
		}
		if (ret)
			conSave();
	} while (ret);

  return 0;

}

static int _fsMain(int argc, char *argv[])
{
	conSave();

	callfs=0;
	stop=0;
	firstfile=1;
#if 0
	plintr=0;
	thisf=0;
	nextf=0;
#endif


#ifdef DOS32
  /* TODO.. this can be done on xterm consoles, and proc titles*/
	setwintitle("OpenCP");
#endif 

	fsRescanDir();

	while (1)
	{
		struct preprocregstruct *prep;

/*		while (ekbhit())
		{
			uint16_t key=egetch();
			if ((key==0)||(key==3)||(key==27))
				stop=2;
		}*/
		if (stop==2)
			break;

		stop=0;

		if (!plintr)
		{
			int fsr;
			conSave();
			fsr=callselector(nextpath,&nextinfo,&nextf,(callfs||firstfile),0,1,&nextintr);
			if (!fsr)
				break;
			else if (fsr==-1);
				callfs=1;
			conRestore();
		}

		if (callfs)
			firstfile=0;

		if (nextintr)
		{
			conRestore();

			if (plintr)
			{
				plintr->Close();
				plintr=0;
				/* _heapshrink(); */
			}

			if (thisf)
			{
				fclose(thisf);
				thisf=NULL;
			}

			strcpy(thispath,nextpath);
			thisf=nextf;
			nextf=NULL;
			plModuleInfo=nextinfo;
			plintr=nextintr;
			nextintr=0;

			stop=0;

			for (prep=plPreprocess; prep; prep=prep->next)
				prep->Preprocess(thispath, &plModuleInfo, &thisf);

			if (!plintr->Init(thispath, &plModuleInfo, &thisf))
			{
				plintr=0;
			} else {
				/*
				char wt[256];
				char realname[13];
				memset(wt,0,256);
				fsConv12FileName(realname,plModuleInfo.name);
				strncpy(wt,realname,12);
				strcat(wt," - ");
				strncat(wt,plModuleInfo.modname,32);
			#ifdef DOS32
				setwintitle(wt);
			#endif
				*/
			}
			conSave();
		}

		if (plintr)
		{

/*			while (ekbhit())
				egetch();*/

			while (!stop)
			{
				stop=plintr->Run();
				switch (stop)
				{
					case 1: /* next playlist file (auto) */
						if (firstfile)
							stop=2;
						else
							stop=callselector(nextpath,&nextinfo,&nextf,callfs,0,1,&nextintr)?1:2;
						break;
					case 3: /* next playlist file (man) */
						if (fsFilesLeft())
							stop=callselector(nextpath,&nextinfo,&nextf,1,0,1,&nextintr);
						else
							stop=callselector(nextpath,&nextinfo,&nextf,1,0,0,&nextintr);
						if (stop==-1)
							callfs=1;
						break;
					case 4: /* call fs */
						callfs=1;
						stop=callselector(nextpath,&nextinfo,&nextf,1,1,0,&nextintr);
						break;
					case 5: /* dos shell */
						plSetTextMode(fsScrType);
						if (conRestore())
							break;
						stop=0;
						plDosShell();
						conSave();
/*						while (ekbhit())
							egetch();*/
						break;
				}
			}
			firstfile=0;
		}
	}

	plSetTextMode(fsScrType);
	conRestore();
	if (plintr)
		plintr->Close();
	if (thisf)
	{
		fclose(thisf);
		thisf=NULL;
	}
	return errOk;
}

static void plRegisterPreprocess(struct preprocregstruct *r)
{
	r->next=plPreprocess;
	plPreprocess=r;
}

static int fsint(void)
{
	/*const char *sec=cfGetProfileString(cfConfigSec, "fileselsec", "fileselector");*/

	char regname[50];
	const char *regs=NULL;
	regs=_lnkReadInfoReg("preprocess");

	while (cfGetSpaceListEntry(regname, &regs, 49))
	{
		void *reg=_lnkGetSymbol(regname);
		if (reg)
			plRegisterPreprocess((struct preprocregstruct *)reg);
	}
	
	fprintf(stderr, "initializing fileselector...\n");
	if (!fsInit())
	{
		fprintf(stderr, "fileselector init failed!\n");
		return errGen;
	}

/*	fsAddFiles(cfCommandLine);*/

	return errOk;
}


static void fsclose()
{
	fsClose();
}






#if 0
void addtoplaylist(const char *source,const char *homepath, char *dest)
{
  char finalpath[_MAX_PATH];
  char longpath[_MAX_PATH];

  if (strchr(source,'\\'))
    strcpy(longpath,source);
  else
  {
    strcpy(longpath,homepath);
    strcat(longpath,source);
  }
  strcpy(finalpath,longpath);

#ifdef DOS32
  callrmstruct r;
  char *mem;
  void __far16 *rmptr;
  __segment pmsel;
  mem=(char*)dosmalloc(1024, rmptr, pmsel);
  if (!mem)
    return;
  strcpy(mem, longpath);
  strcpy(mem+512, longpath);
  clearcallrm(r);
  r.w.ax=0x7160;
  r.b.cl=1;
  r.b.ch=0x80;
  r.w.si=(unsigned short)rmptr;
  r.w.di=((unsigned short)rmptr)+512;
  r.s.ds=((unsigned long)rmptr)>>16;
  r.s.es=((unsigned long)rmptr)>>16;
  r.s.flags|=1;
  intrrm(0x21,r);

  if (!(r.s.flags&1))
    strcpy(finalpath, mem+512);
  else if (strchr(finalpath,' '))
    *finalpath=0;

  dosfree(pmsel);
#endif
  if (!memcmp(finalpath,"\\\\",2))
    *finalpath=0;

  if (*finalpath)
  {
    strcat(dest,finalpath);
    strcat(dest," ");
  }
}

static char bdest[32768];

int addpls(const char *path, moduleinfostruct &info, binfile *&fil)
{
  printf("adding %s to playlist ...\n", path);

  char dir[_MAX_DIR];
  char pspec[_MAX_PATH];
  _splitpath(path, pspec, dir, 0, 0);
  strcat(pspec,dir);

  *bdest=0;

  char *buffer = new char[fil->length()+128];
  char *bufend = buffer+fil->length();
  *bufend=0;
  fil->seek(0);
  fil->read(buffer,fil->length());

  char *bufptr=buffer;
  char *lineptr[1000];
  int linenum=0;

  while (bufptr<bufend)
  {
    while(bufptr<bufend && *bufptr<33)
      bufptr++;
    if (bufptr==bufend)
      break;
    lineptr[linenum]=bufptr;
    while (bufptr<bufend && *bufptr>=32)
      bufptr++;
    if (bufptr==bufend)
      break;
    *bufptr++=0;
    linenum++;
  }

  int snum=1, fnd;
  char lbuf[10];
  strcpy(lbuf,"File");
  if (linenum && !strcmp(lineptr[0],"[playlist]"))
  {
    do
    {
      ltoa(snum,lbuf+4,10);
      for (fnd=1; fnd<linenum; fnd++)
        if (!memcmp(lineptr[fnd],lbuf,strlen(lbuf)) && lineptr[fnd][strlen(lbuf)]=='=')
          break;
      if (fnd<linenum)
      {
        addtoplaylist(lineptr[fnd]+strlen(lbuf)+1,pspec,bdest);
        snum++;
      }
    } while (fnd<linenum);
  }
  delete buffer;

  strcpy(info.modname,"PLS play list (");
  ltoa(snum-1,info.modname+21,10);
  strcat(info.modname," entries)");

  fsAddFiles(bdest);

  return 1;
}




int addm3u(const char *path, moduleinfostruct &info, binfile *&fil)
{
  printf("adding %s to playlist ...\n", path);

  char dir[_MAX_DIR];
  char pspec[_MAX_PATH];
  _splitpath(path, pspec, dir, 0, 0);
  strcat(pspec,dir);

  *bdest=0;

  char *buffer = new char[fil->length()+128];
  char *bufend = buffer+fil->length();
  *bufend=0;
  fil->seek(0);
  fil->read(buffer,fil->length());

  char *bufptr=buffer;
  char *lineptr[1000];
  int linenum=0;

  while (bufptr<bufend)
  {
    while(bufptr<bufend && *bufptr<33)
      bufptr++;
    if (bufptr==bufend)
      break;
    lineptr[linenum]=bufptr;
    while (bufptr<bufend && *bufptr>=32)
      bufptr++;
    if (bufptr==bufend)
      break;
    *bufptr++=0;
    if (strchr(lineptr[linenum],';'))
      *strchr(lineptr[linenum],';')=0;
    if (lineptr[linenum][0])
      linenum++;
  }

  int fnd;
  for (fnd=0; fnd<linenum; fnd++)
    addtoplaylist(lineptr[fnd],pspec,bdest);

  delete buffer;

  strcpy(info.modname,"M3U play list (");
  ltoa(linenum,info.modname+21,10);
  strcat(info.modname," entries)");

  fsAddFiles(bdest);

  return 1;
}
#endif

struct initcloseregstruct fsReg={fsint, fsclose};
/*
struct filehandlerstruct fsAddPLS={addpls};
struct filehandlerstruct fsAddM3U={addm3u};
*/
struct mainstruct fsMain = { _fsMain };
char *dllinfo = "initcloseafter fsReg; main fsMain; readdirs adbReadDirReg dosReadDirReg fsReadDirReg plsReadDirReg m3uReadDirReg; getfile adbGetFileReg dosGetFileReg; readinfos fsReadInfoReg";
struct linkinfostruct dllextinfo = {"pfilesel", "OpenCP Fileselector (c) 1994-04 Niklas Beisert, Tammo Hinrichs", DLLVERSION, 0};
