/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * Routines for parsing escaped keycodes mapping and extending ncurses
 *
 * revision history: (please note changes here)
 *  -ss040613   Stian Skjelstad <stian@nixia.no>
 *    -first release
 */

#define _CONSOLE_DRIVER 1
#include "config.h"
#ifdef KEYBOARD_DEBUG
#include <stdio.h>
#endif
#include <curses.h> /* for key codes */
#include "types.h"
#include "poutput.h"

/* #define KEYB_DEBUG */

#define BUFFER_LEN 128
static uint16_t ring_buffer[BUFFER_LEN];
static int ring_head, ring_tail;

static int(*kbhit)(void);
static int(*getnextchar)(void);

void ___setup_key(int(*_kbhit)(void), int(*_getch)(void))
{
	ring_head=0;
	ring_tail=0;
	kbhit=_kbhit;
	getnextchar=_getch;
	_ekbhit=___peek_key;
	_egetch=___pop_key;
}

void ___push_key(uint16_t key)
{
#ifdef KEYBOARD_DEBUG
	fprintf(stderr, "___push_key %d/%c\n", key, (unsigned char)key);
#endif
	if (!key)
		return;
	if (((ring_head+1)%BUFFER_LEN)==ring_tail)
		return; /* buffer full */
	ring_buffer[ring_head]=key;
	ring_head=(ring_head+1)%BUFFER_LEN;
}
int ___peek_key(void)
{
	if (ring_head!=ring_tail)
		return 1;
	return kbhit();
}
/*uint16_t*/int ___pop_key(void)
{
	int retval=0;
	int escapelevel=0; /* number of [ */
	int upcode=0;
	int key_len, i;

	while (((ring_head+1)%BUFFER_LEN)!=ring_tail)
	{
		int temp=getnextchar();
		if (!temp)
			break;
		___push_key(temp);
	}
	if (ring_head==ring_tail)
		return retval;
	
	/* this code now expects escape code not to enter this part of the code
	 * broken up into more than one single buffer read
	 */	
#ifdef KEYBOARD_DEBUG
	fprintf(stderr, "ring_head=%d ring_tail=%d\n", ring_head, ring_tail);
#endif
	key_len=(ring_head-ring_tail+BUFFER_LEN)%BUFFER_LEN;
#ifdef KEYBOARD_DEBUG
	fprintf(stderr, "SEQ: %d", ring_buffer[ring_tail]);
#endif
	for (i=1;i<key_len;i++)
	{
		if (ring_buffer[(ring_tail+i)%BUFFER_LEN]==27)
		{
			key_len=i;
			break;
		}
#ifdef KEYBOARD_DEBUG
		else
			fprintf(stderr, " %d", ring_buffer[(ring_tail+i)%BUFFER_LEN]);
#endif
	}
#ifdef KEYBOARD_DEBUG
	fprintf(stderr, "\n");
#endif
	
	retval=ring_buffer[ring_tail];
	ring_tail=(ring_tail+1)%BUFFER_LEN;
	key_len--;
	if (retval>255)
		return retval; /* pre-parsed upcode from extern filter */

	if ((retval==27)&&key_len) /* okey as long as we read fast */
		escapelevel++;

	if ((retval==27)&&key_len&&(ring_buffer[ring_tail]=='O')) /* aterm on gentoo -> ssh -> redhat -> ncurses gives wierd results */
	{
		escapelevel+=10;
/*		ring_tail=(ring_tail+1)%BUFFER_LEN;
		key_len--;*/
	}
	while ((retval==27)&&key_len&&(ring_buffer[ring_tail]=='['))
	{
		escapelevel++;
		ring_tail=(ring_tail+1)%BUFFER_LEN;
		key_len--;
	}
	if (escapelevel&&key_len)
	{
		if ((((ring_buffer[ring_tail]>='a') && (ring_buffer[ring_tail]<='z')) || (ring_buffer[ring_tail] == 10) || (ring_buffer[ring_tail] == 13)) && (key_len==1) )
		{
			upcode=ring_buffer[ring_tail]+512;
			ring_tail=(ring_tail+1)%BUFFER_LEN;	
			key_len--;
		} else if ((ring_buffer[ring_tail]>='A') && (ring_buffer[ring_tail]<='Z') && (key_len==1) )
		{
			upcode=ring_buffer[ring_tail]+256;
			ring_tail=(ring_tail+1)%BUFFER_LEN;	
			key_len--;
		} else if ( (ring_buffer[ring_tail]>='0') && (ring_buffer[ring_tail]<='9') )
		{
			while ( (ring_buffer[ring_tail]>='0') && (ring_buffer[ring_tail]<='9') && key_len)
			{
				upcode*=10;
				upcode+=ring_buffer[ring_tail]-'0';
				ring_tail=(ring_tail+1)%BUFFER_LEN;			
				key_len--;
			}
			if (key_len&&(ring_buffer[ring_tail]=='~'))
			{
				ring_tail=(ring_tail+1)%BUFFER_LEN;	
				key_len--;
			}
		} else if ( ( ring_buffer[ring_tail] == 'O') && key_len>=3)
		{
			ring_tail=(ring_tail+1)%BUFFER_LEN;
			key_len--;
			if ( (ring_buffer[ring_tail]>='0') && (ring_buffer[ring_tail]<='9') )
				upcode = (ring_buffer[ring_tail] - '0') * 16;
			else
				upcode = (ring_buffer[ring_tail] - 'A' + 10) * 16;
			ring_tail=(ring_tail+1)%BUFFER_LEN;
			key_len--;
			if ( (ring_buffer[ring_tail]>='0') && (ring_buffer[ring_tail]<='9') )
				upcode |= ring_buffer[ring_tail] - '0';
			else
				upcode |= ring_buffer[ring_tail] - 'A' + 10;
			ring_tail=(ring_tail+1)%BUFFER_LEN;
			key_len--;
		} else if ( ( ring_buffer[ring_tail] == 'O') && key_len==1)
		{
			if ((ring_buffer[ring_tail]>='A') && (ring_buffer[ring_tail]<='Z'))
				upcode=ring_buffer[ring_tail]+256;
			ring_tail=(ring_tail+1)%BUFFER_LEN;	
			key_len--;
		}
	}
#ifdef KEYBOARD_DEBUG
	fprintf(stderr, "poutput-keyboard.c: testing upcode=%d escapelevel=%d (key_len=%d n=%d)\n", upcode, escapelevel, key_len, ring_buffer[ring_tail]);
#endif
	if (escapelevel==11)
	{ /* redhat and ncurses is one big pain */
		switch (upcode)
		{
			default:
				retval=KEY_BACKSPACE;
				break;
/*			case 0x5A:
				retval=KEY_CTRL_UP;
				break;
			case 0x5B:
				retval=KEY_CTRL_DOWN;
				break;*/
			case 0x5C:
				retval=KEY_CTRL_RIGHT;
				break;
			case 0x5D:
				retval=KEY_CTRL_LEFT;
				break;
			case 'H'+256:
				retval=KEY_HOME;
				break;
			case 'F'+256:
				retval=KEY_END;
				break;
		}
	} else if (escapelevel==3)
	{
		switch (upcode)
		{
			case 'A'+256:
				retval=KEY_F1;
				break;
			case 'B'+256:
				retval=KEY_F2;
				break;
			case 'C'+256:
				retval=KEY_F3;
				break;
			case 'D'+256:
				retval=KEY_F4;
				break;
			case 'E'+256:
				retval=KEY_F5;
				break;
			default:
				retval=0;
				break;
		}

	} else if (escapelevel==2)
	{
		switch (upcode)
		{
			case 17:
				retval=KEY_F6;
				break;
			case 18:
				retval=KEY_F7;
				break;
			case 19:
				retval=KEY_F8;
				break;
			case 20:
				retval=KEY_F9;
				break;
			case 21:
				retval=KEY_F10;
				break;
			case 23:
				retval=KEY_F11;
				break;
			case 24:
				retval=KEY_F12;
				break;

			case 'A'+256:
				retval=KEY_UP;
				break;
			case 'B'+256:
				retval=KEY_DOWN;
				break;
			case 'C'+256:
				retval=KEY_RIGHT;
				break;
			case 'D'+256:
				retval=KEY_LEFT;
				break;

	/*		case 'P'+256:
				retval=KEY_BREAK;
				break;*/
			case 1:
				retval=KEY_HOME;
				break;
			case 2:
				retval=KEY_INSERT;
				break;
			case 3:
				retval=KEY_DELETE;
				break;
			case 4:
				retval=KEY_END;
				break;
			case 5:
				retval=KEY_PPAGE;
				break;
			case 6:
				retval=KEY_NPAGE;
				break;

/*			case 25:
				retval=KEY_SHIFT_F1;
				break;
			case 26:
				retval=KEY_SHIFT_F2;
				break;
			case 28:
				retval=KEY_SHIFT_F3;
				break;
			case 29:
				retval=KEY_SHIFT_F4;
				break;
			case 31:
				retval=KEY_SHIFT_F5;
				break;
			case 32:
				retval=KEY_SHIFT_F6;
				break;
			case 33:
				retval=KEY_SHIFT_F7;
				break;
			case 34:
				retval=KEY_SHIFT_F8;
				break;*/

			default:
				retval=0;
				break;

		}
	} else if (escapelevel==1)
	{
		switch (upcode)
		{
			case 'a'+512:
				retval=KEY_ALT_A;
				break;
			case 'b'+512:
				retval=KEY_ALT_B;
				break;
			case 'c'+512:
				retval=KEY_ALT_C;
				break;
			case 'd'+512:
				retval=KEY_ALT_D;
				break;
			case 'e'+512:
				retval=KEY_ALT_E;
				break;
			case 'f'+512:
				retval=KEY_ALT_F;
				break;
			case 'g'+512:
				retval=KEY_ALT_G;
				break;
			case 'h'+512:
				retval=KEY_ALT_H;
				break;
			case 'i'+512:
				retval=KEY_ALT_I;
				break;
			case 'j'+512:
				retval=KEY_ALT_J;
				break;
			case 'k'+512:
				retval=KEY_ALT_K;
				break;
			case 'l'+512:
				retval=KEY_ALT_L;
				break;
			case 'm'+512:
				retval=KEY_ALT_M;
				break;
			case 'n'+512:
				retval=KEY_ALT_N;
				break;
			case 'o'+512:
				retval=KEY_ALT_O;
				break;
			case 'p'+512:
				retval=KEY_ALT_P;
				break;
			case 'q'+512:
				retval=KEY_ALT_Q;
				break;
			case 'r'+512:
				retval=KEY_ALT_R;
				break;
			case 's'+512:
				retval=KEY_ALT_S;
				break;
			case 't'+512:
				retval=KEY_ALT_T;
				break;
			case 'u'+512:
				retval=KEY_ALT_U;
				break;
			case 'v'+512:
				retval=KEY_ALT_V;
				break;
			case 'w'+512:
				retval=KEY_ALT_W;
				break;
			case 'x'+512:
				retval=KEY_ALT_X;
				break;
			case 'y'+512:
				retval=KEY_ALT_Y;
				break;
			case 'z'+512:
				retval=KEY_ALT_Z;
				break;
			case 10+512:
			case 13+512:
				retval=KEY_ALT_ENTER;
				break;
			default:
				retval=0;

		}
	} else {
		switch (retval)
		{
			case 240:
				retval=KEY_ALT_P;
				break;
			case 233:
				retval=KEY_ALT_I;
				break;
			case 231:
				retval=KEY_ALT_G;
				break;
			case 229:
				retval=KEY_ALT_E;
				break;
			case 227:
				retval=KEY_ALT_C;
				break;
			case 141:
				retval=KEY_ALT_ENTER;
				break;
			case 127:
			case 8:
				retval=KEY_BS;
				break;
		}
	}
#ifdef KEYBOARD_DEBUG
	fprintf(stderr, "ring_head=%d ring_tail=%d\n", ring_head, ring_tail);
#endif

	if (!retval)
	{
#ifdef KEYBOARD_DEBUG
		fprintf(stderr, "poutput-keyboard.c: upcode %d, escapelevel %d gave no result\n", upcode, escapelevel);
#endif
		return ___pop_key();
	}
#ifdef KEYBOARD_DEBUG
	fprintf(stderr, "gave result %04x\n", retval);
#endif
	return retval;
}

