/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * XMPlay .MXM module loader
 *
 * revision history: (please note changes here)
 *  -kb980717   Tammo Hinrichs <opencp@gmx.net>
 *    -EXPERIMENTAL STAGE - i need MANY .MXMs to test! :)
 *    -loops don't seem to be correct sometimes, don't know why
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "dev/mcp.h"
#include "xmplay.h"
#include "stuff/err.h"

int xmpLoadMXM(struct xmodule *m, FILE *file)
{
	uint8_t deltasamps, modpanning;

	struct __attribute__((packed))
	{
		uint32_t sig;
		uint32_t ordnum;
		uint32_t restart;
		uint32_t channum;
		uint32_t patnum;
		uint32_t insnum;
		uint8_t tempo;
		uint8_t speed;
		uint16_t opt;
		uint32_t sampstart;
		uint32_t samples8;
		uint32_t samples16;
		int32_t lowpitch;
		int32_t highpitch;
		uint8_t panpos[32];
		uint8_t ord[256];
		uint32_t insofs[128];
		uint32_t patofs[256];
	} mxmhead;
	
	struct sampleinfo **smps;
	struct xmpsample **msmps;
	int *instsmpnum;

	int i,j;

	uint32_t guspos[128*16];

	m->envelopes=0;
	m->samples=0;
	m->instruments=0;
	m->sampleinfos=0;
	m->patlens=0;
	m->patterns=0;
	m->orders=0;
	m->ismod=0;

	/* 1st: read headers */

	fread(&mxmhead, sizeof(mxmhead), 1, file);
	if (memcmp(&mxmhead.sig, "MXM\0", 4))
		return errFormStruc;

	memcpy(m->name, "MXMPlay module      ", 20);
	m->name[20]=0;

	modpanning = !!(mxmhead.opt&2);
	deltasamps = !!(mxmhead.opt&4);

	m->linearfreq=!!(mxmhead.opt&1);
	m->nchan=mxmhead.channum;

	m->ninst=mxmhead.insnum;
	m->nenv=2*mxmhead.insnum;

	m->npat=mxmhead.patnum+1;

	m->nord=mxmhead.ordnum;
	m->loopord=mxmhead.restart;

	m->inibpm=mxmhead.speed;
	m->initempo=mxmhead.tempo;

	m->orders=malloc(sizeof(uint16_t)*m->nord);

	m->patterns=(uint8_t (**)[5])malloc(sizeof(void *)*m->npat);
	m->patlens=malloc(sizeof(uint16_t)*m->npat);

	m->instruments=malloc(sizeof(struct xmpinstrument)*m->ninst);
	m->envelopes=malloc(sizeof(struct xmpenvelope)*m->nenv);

      	smps = malloc(sizeof(struct sampleinfo *)*m->ninst);
	msmps = malloc(sizeof(struct xmpsample *)*m->ninst);
	instsmpnum = malloc(sizeof(int)*m->ninst);

	if (!smps||!msmps||!instsmpnum||!m->instruments||!m->envelopes||!m->patterns||!m->orders||!m->patlens)
		return errAllocMem;

	memset(m->patterns, 0, m->npat*sizeof(void *));
	memset(m->instruments, 0, m->ninst*sizeof(struct xmpinstrument));
	memset(m->envelopes, 0, m->nenv*sizeof(struct xmpenvelope));

	for (i=0; i<32; i++)
		m->panpos[i]=0x11*mxmhead.panpos[i];

	for (i=0; i<m->nord; i++)
		m->orders[i]=(mxmhead.ord[i]<mxmhead.patnum)?mxmhead.ord[i]:mxmhead.patnum;

	m->patlens[mxmhead.patnum]=64;
	m->patterns[mxmhead.patnum]= malloc(sizeof(uint8_t)*64*mxmhead.channum*5);
	if (!m->patterns[mxmhead.patnum])
		return errAllocMem;
	memset(m->patterns[mxmhead.patnum], 0, 64*5*mxmhead.channum);

	/* 2nd: read instruments */
	
	memset(guspos,0xff,4*128*16);
	
	m->nsampi=0;
	m->nsamp=0;

	for (i=0; i<m->ninst; i++)
	{
		struct xmpinstrument *ip=&m->instruments[i];
		struct xmpenvelope *env=m->envelopes+2*i;

		struct __attribute__((packed))
		{
			uint32_t sampnum;
			uint8_t snum[96];
			uint16_t volfade;
			uint8_t vibtype, vibsweep, vibdepth, vibrate;
			uint8_t vnum, vsustain, vloops, vloope;
			uint16_t venv[12][2];
			uint8_t pnum, psustain, ploops, ploope;
			uint16_t penv[12][2];
			uint8_t res[46];
		} mxmins;
		uint16_t volfade;
		long el=0;
		int16_t k, p=0, h;
		
		fseek(file, mxmhead.insofs[i], SEEK_SET);

		smps[i]=0;
		msmps[i]=0;

		fread(&mxmins, sizeof(mxmins), 1, file);

		memcpy(ip->name,"                      ",22);
		ip->name[22]=0;

		memset(ip->samples, 0xff, 2*128);
		instsmpnum[i]=mxmins.sampnum;

		smps[i]=malloc(sizeof(struct sampleinfo)*mxmins.sampnum);
		msmps[i]=malloc(sizeof(struct xmpsample)*mxmins.sampnum);

		if (!smps[i]||!msmps[i])
			return errAllocMem;
		memset(msmps[i], 0, sizeof(struct xmpsample)*mxmins.sampnum);
		memset(smps[i], 0, sizeof(struct sampleinfo)*mxmins.sampnum);

		for (j=0; j<96; j++)
			if (mxmins.snum[j]<mxmins.sampnum)
				ip->samples[j]=m->nsamp+mxmins.snum[j];

		volfade = mxmins.volfade;

		env[0].speed=0;
		env[0].type=0;
		for (j=0; j<mxmins.vnum; j++)
			el+=mxmins.venv[j][0];
		env[0].env=malloc(sizeof(uint8_t)*(el+1));
		if (!env[0].env)
			return errAllocMem;
		h=mxmins.venv[0][1]*4;
		for (j=0; j<mxmins.vnum; j++)
		{
			int16_t l=mxmins.venv[j][0];
			int16_t dh=mxmins.venv[j+1][1]*4-h;
			for (k=0; k<l; k++)
			{
				int16_t cv=h+dh*k/l;
				env[0].env[p++]=(cv>255)?255:cv;
			}
			h+=dh;
		}
		env[0].len=p;
		env[0].env[p]=(h>255)?255:h;
		if (mxmins.vsustain<0xff)
		{
			env[0].type|=xmpEnvSLoop;
			env[0].sustain=0;
			for (j=0; j<mxmins.vsustain; j++)
				env[0].sustain+=mxmins.venv[j][0];
		}
		if (mxmins.vloope<0xff)
		{
			env[0].type|=xmpEnvLoop;
			env[0].loops=env[0].loope=0;
			for (j=0; j<mxmins.vloops; j++)
				env[0].loops+=mxmins.venv[j][0];
			for (j=0; j<mxmins.vloope; j++)
				env[0].loope+=mxmins.venv[j][0];
		}

		env[1].speed=0;
		env[1].type=0;
		el=0;
		for (j=0; j<mxmins.pnum; j++)
			el+=mxmins.penv[j][0];
		env[1].env=malloc(sizeof(uint8_t)*(el+1));
		if (!env[1].env)
			return errAllocMem;
		p=0;
		h=mxmins.penv[0][1]*4;
		for (j=0; j<mxmins.pnum; j++)
		{
			int16_t l=mxmins.penv[j][0];
			int16_t dh=mxmins.penv[j+1][1]*4-h;
			for (k=0; k<l; k++)
			{
				int16_t cv=h+dh*k/l;
				env[1].env[p++]=(cv>255)?255:cv;
			}
			h+=dh;
		}
		env[1].len=p;
		env[1].env[p]=(h>255)?255:h;
		if (mxmins.psustain<0xff)
		{
			env[1].type|=xmpEnvSLoop;
			env[1].sustain=0;
			for (j=0; j<mxmins.psustain; j++)
				env[1].sustain+=mxmins.penv[j][0];
		}
		if (mxmins.ploope<0xff)
		{
			env[1].type|=xmpEnvLoop;
			env[1].loops=env[1].loope=0;
			for (j=0; j<mxmins.ploops; j++)
				env[1].loops+=mxmins.penv[j][0];
			for (j=0; j<mxmins.ploope; j++)
				env[1].loope+=mxmins.penv[j][0];
		}


		for (j=0; j<mxmins.sampnum; j++)
		{
			struct __attribute__((packed))
			{
				uint16_t gusstartl;
				uint8_t gusstarth;
				uint16_t gusloopstl;
				uint8_t gusloopsth;
				uint16_t gusloopendl;
				uint8_t gusloopendh;
				uint8_t gusmode;
				uint8_t vol;
				uint8_t pan;
				uint16_t relpitch;
				uint8_t res[2];
			} mxmsamp;
			uint8_t bit16, sloop, sbidi;
			struct xmpsample *sp=&msmps[i][j];
			struct sampleinfo *sip=&smps[i][j];

			int8_t rpf;
			uint32_t sampstart, loopstart, loopend;
			uint32_t l;
	
			fread(&mxmsamp, sizeof (mxmsamp), 1, file);

			bit16=mxmsamp.gusmode&0x04;
			sloop=mxmsamp.gusmode&0x08;
			sbidi=mxmsamp.gusmode&0x18;

			memcpy(sp->name, "                      ", 22);
			sp->name[22]=0;
			sp->handle=0xFFFF;

			sp->normnote=-mxmsamp.relpitch;
			rpf=mxmsamp.relpitch&0xff;
			sp->normtrans=rpf-mxmsamp.relpitch;
			sp->stdvol=(mxmsamp.vol>0x3F)?0xFF:(mxmsamp.vol<<2);
			sp->stdpan=mxmsamp.pan;
			sp->opt=0;
			sp->volfade=volfade;
			sp->vibtype=(mxmins.vibtype==1)?3:(mxmins.vibtype==2)?1:(mxmins.vibtype==3)?2:0;
			sp->vibdepth=mxmins.vibdepth<<2;
			sp->vibspeed=0;
			sp->vibrate=mxmins.vibrate<<8;
			sp->vibsweep=0xFFFF/(mxmins.vibsweep+1);
			sp->volenv=env[0].env?(2*i+0):0xFFFF;
			sp->panenv=env[1].env?(2*i+1):0xFFFF;
			sp->pchenv=0xFFFF;
			
		  	sampstart=mxmsamp.gusstartl+(mxmsamp.gusstarth<<16);
			loopstart=mxmsamp.gusloopstl+(mxmsamp.gusloopsth<<16);
			loopend=mxmsamp.gusloopendl+(mxmsamp.gusloopendh<<16);
			guspos[m->nsampi]=sampstart;
			if (loopstart<sampstart)
				loopstart=sampstart;
			if (loopend<sampstart)
				loopend=sampstart;
			loopstart-=sampstart;
			loopend-=sampstart;

		  	if (bit16)
			{
				loopstart>>=1;
				loopend>>=1;
			}

			sip->length=loopend;
			sip->loopstart=loopstart;
			sip->loopend=loopend+1;
			sip->samprate=8363;
			sip->type=(bit16?mcpSamp16Bit:0)|(sloop?mcpSampLoop:0)|(sbidi?mcpSampBiDi:0);

			l=sip->length<<(!!(sip->type&mcpSamp16Bit));
			if (!l)
				continue;
			sip->ptr=malloc(sizeof(uint8_t)*(l+528));
			if (!sip->ptr)
				return errAllocMem;
			sp->handle=m->nsampi++;	
		}

		m->nsamp+=mxmins.sampnum;
  }

	m->samples=malloc(sizeof(struct xmpsample)*m->nsamp);
	m->sampleinfos=malloc(sizeof(struct sampleinfo)*m->nsampi);

	if (!m->samples||!m->sampleinfos)
		return errAllocMem;

	m->nsampi=0;
	m->nsamp=0;
	for (i=0; i<m->ninst; i++)
	{
		for (j=0; j<instsmpnum[i]; j++)
		{
			m->samples[m->nsamp++]=msmps[i][j];
			if (smps[i][j].ptr)
				m->sampleinfos[m->nsampi++]=smps[i][j];
		}
		free(smps[i]);
		free(msmps[i]);
	}
	free(smps);
	free(msmps);
	free(instsmpnum);

	for (i=0; i<mxmhead.patnum; i++)
	{
		uint32_t patrows;
		uint8_t  pack;
		uint16_t pd;
		uint8_t  *pd1=(unsigned char *)(&pd);
		uint8_t  *pd2=pd1+1;

		fseek(file, mxmhead.patofs[i], SEEK_SET);

		fread(&patrows, 4, 1, file);

		m->patlens[i]=patrows;
		m->patterns[i]=malloc(sizeof(uint8_t)*patrows*mxmhead.channum*5);
		if (!m->patterns[i])
			return errAllocMem;

		memset(m->patterns[i], 0, patrows*mxmhead.channum*5);

		for (j=0; j<patrows; j++)
		{
			uint8_t *currow=(uint8_t *)(m->patterns[i])+j*mxmhead.channum*5;
			fread(&pack, 1, 1, file);
			while (pack)
			{
				uint8_t *cur=currow+5*(pack&0x1f);
				if (pack&0x20)
				{
					fread(&pd, 2, 1, file);
					cur[0]=*pd1;
					cur[1]=*pd2;
				}
				if (pack&0x40)
				{
					fread(&pd, 1, 1, file);
					cur[2]=*pd1;
				}
				if (pack&0x80)
				{
					fread(&pd, 2, 1, file);
					cur[3]=*pd1;
					cur[4]=*pd2;
				}
				fread(&pack, 1, 1, file);
			}
		}
	}

	{
		uint32_t gsize=mxmhead.samples8+2*mxmhead.samples16;
		int8_t *gusmem = malloc(sizeof(int8_t)*gsize);
		int16_t *gus16 = (int16_t *)(gusmem+mxmhead.samples8);
		fseek(file, mxmhead.sampstart, SEEK_SET);
		fread(gusmem, gsize, 1, file);

		if (deltasamps)
		{
			int8_t db=0;
			int16_t dw=0;
			for (i=0; i<mxmhead.samples8; i++)
				gusmem[i]=db+=gusmem[i];
			for (i=0; i<mxmhead.samples16; i++)
				gus16[i]=dw+=gus16[i];
		}

		for (i=0; i<m->nsampi; i++)
		{
			uint32_t poslo, poshi;

			uint32_t actpos=guspos[i];
			uint32_t len=m->sampleinfos[i].length;
			if (m->sampleinfos[i].type&mcpSamp16Bit)
			{
				actpos<<=1;
				len<<=1;
				poslo=actpos&0x03FFFE;
				poshi=actpos&0x180000;
				actpos=poslo|(poshi>>1);
			}
			memcpy(m->sampleinfos[i].ptr, gusmem+actpos, len);
		}

		free(gusmem);
	}
	return errOk;
}
