// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SignCounter_HeaderFile
#define _IFSelect_SignCounter_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IFSelect_SignCounter_HeaderFile
#include <Handle_IFSelect_SignCounter.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColStd_MapOfTransient_HeaderFile
#include <TColStd_MapOfTransient.hxx>
#endif
#ifndef _Handle_IFSelect_Signature_HeaderFile
#include <Handle_IFSelect_Signature.hxx>
#endif
#ifndef _Handle_IFSelect_Selection_HeaderFile
#include <Handle_IFSelect_Selection.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _IFSelect_SignatureList_HeaderFile
#include <IFSelect_SignatureList.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfTransient_HeaderFile
#include <Handle_TColStd_HSequenceOfTransient.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class IFSelect_Signature;
class IFSelect_Selection;
class Standard_Transient;
class Interface_InterfaceModel;
class TColStd_HSequenceOfTransient;
class Interface_Graph;
class TCollection_HAsciiString;


//! SignCounter gives the frame to count signatures associated <br>
//!           with entities, deducted from them. Ex.: their Dynamic Type. <br>
//! <br>
//!	         It can sort a set of Entities according a signature, i.e. : <br>
//!           - list of different values found for this Signature <br>
//!           - for each one, count and list of entities <br>
//!           Results are returned as a SignatureList, which can be queried <br>
//!           on the count (list of strings, count per signature, or list of <br>
//!           entities per signature) <br>
//! <br>
//!           A SignCounter can be filled, either directly from lists, or <br>
//!           from the result of a Selection : hence, its content can be <br>
//!           automatically recomputed as desired <br>
//! <br>
//!           SignCounter works by using a Signature in its method AddSign <br>
//! <br>
//!           Methods can be redefined to, either <br>
//!           - directly compute the value without a Signature <br>
//!           - compute the value in the context of a Graph <br>
class IFSelect_SignCounter : public IFSelect_SignatureList {

public:

  //! Creates a SignCounter, without proper Signature <br>
//!           If <withmap> is True (default), added entities are counted <br>
//!           only if they are not yet recorded in the map <br>
//!           Map control can be set off if the input garantees uniqueness <br>
//!           of data <br>
//!           <withlist> is transmitted to SignatureList (option to list <br>
//!           entities, not only to count them). <br>
  Standard_EXPORT   IFSelect_SignCounter(const Standard_Boolean withmap = Standard_True,const Standard_Boolean withlist = Standard_False);
  //! Creates a SignCounter, with a predefined Signature <br>
//!           Other arguments as for Create without Signature. <br>
  Standard_EXPORT   IFSelect_SignCounter(const Handle(IFSelect_Signature)& matcher,const Standard_Boolean withmap = Standard_True,const Standard_Boolean withlist = Standard_False);
  //! Returns the Signature used to count entities. It can be null. <br>
  Standard_EXPORT     Handle_IFSelect_Signature Signature() const;
  //! Changes the control status. The map is not cleared, simply <br>
//!           its use changes <br>
  Standard_EXPORT     void SetMap(const Standard_Boolean withmap) ;
  //! Adds an entity by considering its signature, which is given by <br>
//!           call to method AddSign <br>
//!           Returns True if added, False if already in the map (and <br>
//!           map control status set) <br>
  Standard_EXPORT   virtual  Standard_Boolean AddEntity(const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) ;
  //! Adds an entity (already filtered by Map) with its signature. <br>
//!           This signature can be computed with the containing model. <br>
//!           Its value is provided by the object Signature given at start, <br>
//!           if no Signature is defined, it does nothing. <br>
//! <br>
//!           Can be redefined (in this case, see also Sign) <br>
  Standard_EXPORT   virtual  void AddSign(const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) ;
  //! Adds a list of entities by adding each of the items <br>
  Standard_EXPORT     void AddList(const Handle(TColStd_HSequenceOfTransient)& list,const Handle(Interface_InterfaceModel)& model) ;
  //! Adds a list of entities in the context given by the graph <br>
//!           Default just call basic AddList <br>
//!           Can be redefined to get a signature computed with the graph <br>
  Standard_EXPORT   virtual  void AddWithGraph(const Handle(TColStd_HSequenceOfTransient)& list,const Interface_Graph& graph) ;
  //! Adds all the entities contained in a Model <br>
  Standard_EXPORT     void AddModel(const Handle(Interface_InterfaceModel)& model) ;
  //! Adds the result determined by a Selection from a Graph <br>
//!           Remark : does not impact at all data from SetSelection & Co <br>
  Standard_EXPORT     void AddFromSelection(const Handle(IFSelect_Selection)& sel,const Interface_Graph& G) ;
  //! Sets a Selection as input : this causes content to be cleared <br>
//!           then the Selection to be ready to compute (but not immediatly) <br>
  Standard_EXPORT     void SetSelection(const Handle(IFSelect_Selection)& sel) ;
  //! Returns the selection, or a null Handle <br>
  Standard_EXPORT     Handle_IFSelect_Selection Selection() const;
  //! Changes the mode of working with the selection : <br>
//!           -1 just clears optimisation data and nothing else <br>
//!           0 clears it   1 inhibits it for computing (but no clearing) <br>
//!           2 sets it active for computing <br>
//!           Default at creation is 0, after SetSelection (not null) is 2 <br>
  Standard_EXPORT     void SetSelMode(const Standard_Integer selmode) ;
  //! Returns the mode of working with the selection <br>
  Standard_EXPORT     Standard_Integer SelMode() const;
  //! Computes from the selection result, if selection is active <br>
//!           (mode 2). If selection is not defined (mode 0) or is inhibited <br>
//!           (mode 1) does nothing. <br>
//!           Returns True if computation is done (or optimised), False else <br>
//!           This method is called by ComputeCounter from WorkSession <br>
//! <br>
//!           If <forced> is True, recomputes systematically <br>
//!           Else (D), if the counter was not cleared and if the former <br>
//!           computed result started from the same total size of Graph and <br>
//!           same count of selected entities : computation is not redone <br>
//!           unless <forced> is given as True <br>
  Standard_EXPORT     Standard_Boolean ComputeSelected(const Interface_Graph& G,const Standard_Boolean forced = Standard_False) ;
  //! Determines and returns the value of the signature for an <br>
//!           entity as an HAsciiString. This method works exactly as <br>
//!           AddSign, which is optimized <br>
//! <br>
//!           Can be redefined, accorded with AddSign <br>
  Standard_EXPORT   virtual  Handle_TCollection_HAsciiString Sign(const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) const;
  //! Applies AddWithGraph on one entity, and returns the Signature <br>
//!           Value which has been recorded <br>
//!           To do this, Add is called with SignOnly Mode True during the <br>
//!           call, the returned value is LastValue <br>
  Standard_EXPORT     Standard_CString ComputedSign(const Handle(Standard_Transient)& ent,const Interface_Graph& G) ;




  DEFINE_STANDARD_RTTI(IFSelect_SignCounter)

protected:




private: 


Standard_Boolean themapstat;
TColStd_MapOfTransient themap;
Handle_IFSelect_Signature thematcher;
Handle_IFSelect_Selection theselect;
Standard_Integer theselmode;
Standard_Integer thenbcomp1;
Standard_Integer thenbcomp2;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
