// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TCollection_ExtendedString_HeaderFile
#define _TCollection_ExtendedString_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_PExtCharacter_HeaderFile
#include <Standard_PExtCharacter.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_ExtString_HeaderFile
#include <Standard_ExtString.hxx>
#endif
#ifndef _Standard_Character_HeaderFile
#include <Standard_Character.hxx>
#endif
#ifndef _Standard_ExtCharacter_HeaderFile
#include <Standard_ExtCharacter.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_PCharacter_HeaderFile
#include <Standard_PCharacter.hxx>
#endif
class Standard_NullObject;
class Standard_OutOfRange;
class Standard_NumericError;
class Standard_NegativeValue;
class TCollection_AsciiString;


//! A variable-length sequence of "extended" <br>
//! (UNICODE) characters (16-bit character type). It <br>
//! provides editing operations with built-in memory <br>
//! management to make ExtendedString objects <br>
//! easier to use than ordinary extended character arrays. <br>
//! ExtendedString objects follow "value <br>
//! semantics", that is, they are the actual strings, <br>
//! not handles to strings, and are copied through <br>
//! assignment. You may use HExtendedString <br>
//! objects to get handles to strings. <br>
class TCollection_ExtendedString  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Initializes a ExtendedString to an empty ExtendedString. <br>
  Standard_EXPORT   TCollection_ExtendedString();
  //! Creation by converting a CString to an extended string. <br>
  Standard_EXPORT   TCollection_ExtendedString(const Standard_CString astring,const Standard_Boolean isMultiByte = Standard_False);
  //! Creation by converting an ExtString to an extended string. <br>
  Standard_EXPORT   TCollection_ExtendedString(const Standard_ExtString astring);
  //! Initializes a AsciiString with a single character. <br>
  Standard_EXPORT   TCollection_ExtendedString(const Standard_Character aChar);
  //! Initializes a ExtendedString with a single character. <br>
  Standard_EXPORT   TCollection_ExtendedString(const Standard_ExtCharacter aChar);
  //! Initializes a ExtendedString with <length> space allocated. <br>
//! and filled with <filler>.This is useful for buffers. <br>
  Standard_EXPORT   TCollection_ExtendedString(const Standard_Integer length,const Standard_ExtCharacter filler);
  //! Initializes an ExtendedString with an integer value <br>
  Standard_EXPORT   TCollection_ExtendedString(const Standard_Integer value);
  //! Initializes an ExtendedString with a real value <br>
  Standard_EXPORT   TCollection_ExtendedString(const Standard_Real value);
  //! Initializes a ExtendedString with another ExtendedString. <br>
  Standard_EXPORT   TCollection_ExtendedString(const TCollection_ExtendedString& astring);
  //! Creation by converting a normal Ascii string to an extended string. <br>
  Standard_EXPORT   TCollection_ExtendedString(const TCollection_AsciiString& astring);
  //!  Appends the other extended string to this extended string. <br>
//! Note that this method is an alias of operator +=. <br>
//! Example: aString += anotherString <br>
  Standard_EXPORT     void AssignCat(const TCollection_ExtendedString& other) ;
    void operator +=(const TCollection_ExtendedString& other) 
{
  AssignCat(other);
}
  //! Appends <other> to me. <br>
  Standard_EXPORT     TCollection_ExtendedString Cat(const TCollection_ExtendedString& other) const;
    TCollection_ExtendedString operator +(const TCollection_ExtendedString& other) const
{
  return Cat(other);
}
  //! Substitutes all the characters equal to aChar by NewChar <br>
//! in the ExtendedString <me>. <br>
//! The substitution can be case sensitive. <br>
//! If you don't use default case sensitive, no matter wether aChar <br>
//! is uppercase or not. <br>
  Standard_EXPORT     void ChangeAll(const Standard_ExtCharacter aChar,const Standard_ExtCharacter NewChar) ;
  //! Removes all characters contained in <me>. <br>
//! This produces an empty ExtendedString. <br>
  Standard_EXPORT     void Clear() ;
  //! Copy <fromwhere> to <me>. <br>
//! Used as operator = <br>
  Standard_EXPORT     void Copy(const TCollection_ExtendedString& fromwhere) ;
    void operator =(const TCollection_ExtendedString& fromwhere) 
{
  Copy(fromwhere);
}
  //! Frees memory allocated by ExtendedString. <br>
  Standard_EXPORT     void Destroy() ;
~TCollection_ExtendedString()
{
  Destroy();
}
  //! Insert a Character at position <where>. <br>
  Standard_EXPORT     void Insert(const Standard_Integer where,const Standard_ExtCharacter what) ;
  //! Insert a ExtendedString at position <where>. <br>
  Standard_EXPORT     void Insert(const Standard_Integer where,const TCollection_ExtendedString& what) ;
  //! Returns true if the characters in this extended <br>
//! string are identical to the characters in the other extended string. <br>
//! Note that this method is an alias of operator == <br>
  Standard_EXPORT     Standard_Boolean IsEqual(const Standard_ExtString other) const;
    Standard_Boolean operator ==(const Standard_ExtString other) const
{
  return IsEqual(other);
}
  //! Returns true if the characters in this extended <br>
//! string are identical to the characters in the other extended string. <br>
//! Note that this method is an alias of operator == <br>
  Standard_EXPORT     Standard_Boolean IsEqual(const TCollection_ExtendedString& other) const;
    Standard_Boolean operator ==(const TCollection_ExtendedString& other) const
{
  return IsEqual(other);
}
  //! Returns true if there are differences between the <br>
//! characters in this extended string and the other extended string. <br>
//! Note that this method is an alias of operator !=. <br>
  Standard_EXPORT     Standard_Boolean IsDifferent(const Standard_ExtString other) const;
    Standard_Boolean operator !=(const Standard_ExtString other) const
{
  return IsDifferent(other);
}
  //! Returns true if there are differences between the <br>
//! characters in this extended string and the other extended string. <br>
//! Note that this method is an alias of operator !=. <br>
  Standard_EXPORT     Standard_Boolean IsDifferent(const TCollection_ExtendedString& other) const;
    Standard_Boolean operator !=(const TCollection_ExtendedString& other) const
{
  return IsDifferent(other);
}
  //! Returns TRUE if <me> is less than <other>. <br>
  Standard_EXPORT     Standard_Boolean IsLess(const Standard_ExtString other) const;
    Standard_Boolean operator <(const Standard_ExtString other) const
{
  return IsLess(other);
}
  //! Returns TRUE if <me> is less than <other>. <br>
  Standard_EXPORT     Standard_Boolean IsLess(const TCollection_ExtendedString& other) const;
    Standard_Boolean operator <(const TCollection_ExtendedString& other) const
{
  return IsLess(other);
}
  //! Returns TRUE if <me> is greater than <other>. <br>
  Standard_EXPORT     Standard_Boolean IsGreater(const Standard_ExtString other) const;
    Standard_Boolean operator >(const Standard_ExtString other) const
{
  return IsGreater(other);
}
  //! Returns TRUE if <me> is greater than <other>. <br>
  Standard_EXPORT     Standard_Boolean IsGreater(const TCollection_ExtendedString& other) const;
    Standard_Boolean operator >(const TCollection_ExtendedString& other) const
{
  return IsGreater(other);
}
  //! Returns True if the ExtendedString contains only <br>
//! "Ascii Range" characters . <br>
  Standard_EXPORT     Standard_Boolean IsAscii() const;
  //! Returns number of characters in <me>. <br>
//! This is the same functionality as 'strlen' in C. <br>
  Standard_EXPORT     Standard_Integer Length() const;
  //! Displays <me> . <br>
  Standard_EXPORT     void Print(Standard_OStream& astream) const;
friend Standard_EXPORT Standard_OStream& operator << (Standard_OStream& astream,const TCollection_ExtendedString& astring);
  //! Removes every <what> characters from <me>. <br>
  Standard_EXPORT     void RemoveAll(const Standard_ExtCharacter what) ;
  //! Erases <ahowmany> characters from position <where>,<where> included. <br>
  Standard_EXPORT     void Remove(const Standard_Integer where,const Standard_Integer ahowmany = 1) ;
  //! Searches a ExtendedString in <me> from the beginning <br>
//! and returns position of first item <what> matching. <br>
//! it returns -1 if not found. <br>
  Standard_EXPORT     Standard_Integer Search(const TCollection_ExtendedString& what) const;
  //! Searches a ExtendedString in another ExtendedString from the <br>
//! end and returns position of first item <what> matching. <br>
//! it returns -1 if not found. <br>
  Standard_EXPORT     Standard_Integer SearchFromEnd(const TCollection_ExtendedString& what) const;
  //! Replaces one character in the ExtendedString at position <where>. <br>
//! If <where> is less than zero or greater than the length of <me> <br>
//! an exception is raised. <br>
  Standard_EXPORT     void SetValue(const Standard_Integer where,const Standard_ExtCharacter what) ;
  //! Replaces a part of <me> by another ExtendedString see above. <br>
  Standard_EXPORT     void SetValue(const Standard_Integer where,const TCollection_ExtendedString& what) ;
  //! Splits this extended string into two sub-strings at position where. <br>
//! -   The second sub-string (from position <br>
//!   where + 1 of this string to the end) is <br>
//!   returned in a new extended string. <br>
//! -   this extended string is modified: its last <br>
//!   characters are removed, it becomes equal to <br>
//!   the first sub-string (from the first character to position where). <br>
//! Example: <br>
//!   aString contains "abcdefg" <br>
//!   aString.Split(3) gives <me> = "abc" and returns "defg" <br>
  Standard_EXPORT     TCollection_ExtendedString Split(const Standard_Integer where) ;
  //! Extracts <whichone> token from <me>. <br>
//! By default, the <separators> is set to space and tabulation. <br>
//! By default, the token extracted is the first one (whichone = 1). <br>
//! <separators> contains all separators you need. <br>
//! If no token indexed by <whichone> is found, it returns an empty AsciiString. <br>
//! Example: <br>
//!    aString contains "This is a     message" <br>
//!    aString.Token()  returns "This" <br>
//!    aString.Token(" ",4) returns "message" <br>
//!    aString.Token(" ",2) returns "is" <br>
//!    aString.Token(" ",9) returns "" <br>
//! Other separators than space character and tabulation are allowed : <br>
//!    aString contains "1234; test:message   , value" <br>
//!    aString.Token("; :,",4) returns "value" <br>
//!    aString.Token("; :,",2) returns "test" <br>
  Standard_EXPORT     TCollection_ExtendedString Token(const Standard_ExtString separators,const Standard_Integer whichone = 1) const;
  //! Returns pointer to ExtString <br>
  Standard_EXPORT    Standard_ExtString ToExtString() const;
  //! Truncates <me> to <ahowmany> characters. <br>
//! Example:  me = "Hello Dolly" -> Trunc(3) -> me = "Hel" <br>
//!   Exceptions <br>
//! Standard_OutOfRange if ahowmany is greater <br>
//! than the length of this string. <br>
  Standard_EXPORT     void Trunc(const Standard_Integer ahowmany) ;
  //! Returns character at position <where> in <me>. <br>
//! If <where> is less than zero or greater than the lenght of <br>
//! <me>, an exception is raised. <br>
//! Example: <br>
//!   aString contains "Hello" <br>
//!   aString.Value(2) returns 'e' <br>
//! Exceptions <br>
//! Standard_OutOfRange if where lies outside <br>
//! the bounds of this extended string. <br>
  Standard_EXPORT     Standard_ExtCharacter Value(const Standard_Integer where) const;
  //! Returns a hashed value for the extended string <br>
//! astring within the range 1..Upper. <br>
//! Note: if astring is ASCII, the computed value is <br>
//! the same as the value computed with the HashCode function on a <br>
//! TCollection_AsciiString string composed with equivalent ASCII characters <br>
  Standard_EXPORT   static  Standard_Integer HashCode(const TCollection_ExtendedString& astring,const Standard_Integer Upper) ;
  //! Returns true if the characters in this extended <br>
//! string are identical to the characters in the other extended string. <br>
//! Note that this method is an alias of operator ==. <br>
  Standard_EXPORT   static  Standard_Boolean IsEqual(const TCollection_ExtendedString& string1,const TCollection_ExtendedString& string2) ;
  //! Converts the internal <mystring> to UTF8 coding and <br>
//!          returns length of the out CString. A memory for the <br>
//!          <theCString> should be allocated before call! <br>
  Standard_EXPORT     Standard_Integer ToUTF8CString(Standard_PCharacter& theCString) const;
  //! Returns expected CString length in UTF8 coding. <br>
//!          It can be used for  memory  calculation  before converting <br>
//!          to CString containing symbols in UTF8 coding. <br>
  Standard_EXPORT     Standard_Integer LengthOfCString() const;





protected:





private:

  //! Returns true if the input CString was successfuly converted <br>
//!          to UTF8 coding <br>
  Standard_EXPORT     Standard_Boolean ConvertToUnicode(const Standard_CString astring) ;


Standard_PExtCharacter mystring;
Standard_Integer mylength;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
