// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Graphic2d_SetOfPolylines_HeaderFile
#define _Graphic2d_SetOfPolylines_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Graphic2d_SetOfPolylines_HeaderFile
#include <Handle_Graphic2d_SetOfPolylines.hxx>
#endif

#ifndef _Graphic2d_SequenceOfPolyline_HeaderFile
#include <Graphic2d_SequenceOfPolyline.hxx>
#endif
#ifndef _Graphic2d_Line_HeaderFile
#include <Graphic2d_Line.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Graphic2d_Drawer_HeaderFile
#include <Handle_Graphic2d_Drawer.hxx>
#endif
#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Aspect_FStream_HeaderFile
#include <Aspect_FStream.hxx>
#endif
class Standard_OutOfRange;
class Graphic2d_GraphicObject;
class Graphic2d_Drawer;


//! The primitive SetOfPolylines <br>
//!  Warning: This primitive must be use as possible for to insure <br>
//!	   that the sets is drawn correctly when the line type or <br>
//!	   line width attrib is not SOLID and 1 pixel for the set. <br>
//!         NOTE: than the method PickedIndex() permits to known <br>
//!              the last picked polyline and segment in the set. <br>
class Graphic2d_SetOfPolylines : public Graphic2d_Line {

public:

  //! Creates an empty set of polylines in the graphic <br>
//!         object <aGraphicObject>. <br>
  Standard_EXPORT   Graphic2d_SetOfPolylines(const Handle(Graphic2d_GraphicObject)& aGraphicObject);
  //! Add a point in the current polyline of the set <br>
//!	    or creates a new one when <NewPolyline> flag is TRUE. <br>
  Standard_EXPORT     void Add(const Quantity_Length X,const Quantity_Length Y,const Standard_Boolean NewPolyline = Standard_False) ;
  //! Add a segment in the set to one of polyline <br>
//!	    which has the last point identical to one of the segment <br>
//!	    or creates a new polyline in the sets with the 2 segment points. <br>
//!	    The first point is <X1>, <Y1>. <br>
//!	    The second point is <X2>, <Y2>. <br>
  Standard_EXPORT     void Add(const Quantity_Length X1,const Quantity_Length Y1,const Quantity_Length X2,const Quantity_Length Y2) ;
  //! Returns the number of polylines in the set. <br>
  Standard_EXPORT     Standard_Integer Length() const;
  //! Returns the number of points of the polylines <br>
//!    of rank <aPrank>. <br>
//!  Trigger: Raises OutOfRange if <aPrank> is <1 or >Length() <br>
  Standard_EXPORT     Standard_Integer Length(const Standard_Integer aPrank) const;
  //! Returns the point of rank <aVrank> <br>
//!	    from the polyline of rank <aPrank>. <br>
//!  Trigger: Raises OutOfRange if <aPrank> is <1 or >Length() <br>
//!	 or if <aVrank> is <1 or >Length(<aPrank>) <br>
  Standard_EXPORT     void Values(const Standard_Integer aPrank,const Standard_Integer aVrank,Quantity_Length& X,Quantity_Length& Y) const;
  
  Standard_EXPORT   virtual  void Save(Aspect_FStream& aFStream) const;




  DEFINE_STANDARD_RTTI(Graphic2d_SetOfPolylines)

protected:

  //! Draws the set of polylines <me>. <br>
  Standard_EXPORT     void Draw(const Handle(Graphic2d_Drawer)& aDrawer) ;
  //! Returns Standard_True if one point of the set <me> <br>
//!	    is picked, Standard_False if not. <br>
//!  Warning: The PickIndex() method returns the rank of the picked <br>
//!	    polyline point if any under the format : <br>
//!	    (<aPrank> << 16) | <aVrank>. <br>
  Standard_EXPORT     Standard_Boolean Pick(const Standard_ShortReal X,const Standard_ShortReal Y,const Standard_ShortReal aPrecision,const Handle(Graphic2d_Drawer)& aDrawer) ;



private: 


Graphic2d_SequenceOfPolyline myPolylines;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
