// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _AIS_ConnectedInteractive_HeaderFile
#define _AIS_ConnectedInteractive_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_AIS_ConnectedInteractive_HeaderFile
#include <Handle_AIS_ConnectedInteractive.hxx>
#endif

#ifndef _Handle_AIS_InteractiveObject_HeaderFile
#include <Handle_AIS_InteractiveObject.hxx>
#endif
#ifndef _AIS_InteractiveObject_HeaderFile
#include <AIS_InteractiveObject.hxx>
#endif
#ifndef _PrsMgr_TypeOfPresentation3d_HeaderFile
#include <PrsMgr_TypeOfPresentation3d.hxx>
#endif
#ifndef _AIS_KindOfInteractive_HeaderFile
#include <AIS_KindOfInteractive.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager3d_HeaderFile
#include <Handle_PrsMgr_PresentationManager3d.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Handle_Prs3d_Projector_HeaderFile
#include <Handle_Prs3d_Projector.hxx>
#endif
#ifndef _Handle_Geom_Transformation_HeaderFile
#include <Handle_Geom_Transformation.hxx>
#endif
#ifndef _Handle_SelectMgr_Selection_HeaderFile
#include <Handle_SelectMgr_Selection.hxx>
#endif
class AIS_InteractiveObject;
class Standard_NotImplemented;
class TopLoc_Location;
class PrsMgr_PresentationManager3d;
class Prs3d_Presentation;
class Prs3d_Projector;
class Geom_Transformation;
class SelectMgr_Selection;


//! Defines an Interactive Object through a connection to <br>
//! another Interactive   Object, which serves as a <br>
//! reference, and which is located elsewhere in the viewer. <br>
//! This allows you to use the Connected Interactive <br>
//! Object without having to recalculate presentation, <br>
//! selection or graphic structure. These are deduced <br>
//! from your reference object. <br>
//! The relation between the connected interactive object <br>
//! and its source is generally one of geometric transformation. <br>
//! AIS_ConnectedInteractive class doesn't support selection <br>
//! modes different from 0. Descendants should redefine ComputeSelection() <br>
//! method in order to handle other selection modes and generate connected <br>
//! sensitive entities properly. Refer to AIS_ConnectedShape class <br>
//! for exisiting implementation of a connected interactive object <br>
//! for AIS_Shape that supports all standard sub-shape selection modes. <br>
//! Warning <br>
//! An Interactive entity which is view (or projector) <br>
//! dependent requires recalculation of views in hidden <br>
//! parts mode depending on the position of the <br>
//! projector in each view. You should derive the entity's <br>
//! inheritance from ConnectedInteractive and redefine <br>
//! its compute method to enable this type of calculation. <br>
class AIS_ConnectedInteractive : public AIS_InteractiveObject {

public:

  
//! Disconnects the previous view and sets highlight <br>
//! mode to 0. This highlights the wireframe presentation <br>
//! aTypeOfPresentation3d. <br>
//! Top_AllView deactivates hidden line removal. <br>
  Standard_EXPORT   AIS_ConnectedInteractive(const PrsMgr_TypeOfPresentation3d aTypeOfPresentation3d = PrsMgr_TOP_AllView);
  //! Returns KOI_Object <br>
  Standard_EXPORT   virtual  AIS_KindOfInteractive Type() const;
  //! Returns 1 <br>
  Standard_EXPORT   virtual  Standard_Integer Signature() const;
  //! Establishes the connection between the Connected <br>
//! Interactive Object, anotherIobj, and its reference <br>
//! entity. If a previous connection with an Interactive <br>
//! Object already exists, it is removed by Disconnect. <br>
//! The second syntax also initiates the location of the <br>
//! Connected Interactive Object. <br>
  Standard_EXPORT   virtual  void Connect(const Handle(AIS_InteractiveObject)& anotherIObj) ;
  
  Standard_EXPORT   virtual  void Connect(const Handle(AIS_InteractiveObject)& anotherIobj,const TopLoc_Location& aLocation) ;
  
//! Returns true if there is a connection established <br>
//! between the presentation and its source reference. <br>
        Standard_Boolean HasConnection() const;
  
//! Returns the connection with the reference Interactive Object. <br>
       const Handle_AIS_InteractiveObject& ConnectedTo() const;
  //! Clears the connection with a source reference. The <br>
//! presentation will no longer be displayed. <br>
//! Warning Must be done before deleting the presentation. <br>
  Standard_EXPORT     void Disconnect() ;
  //! Computes the presentation according to a point of view <br>
//!          given by <aProjector>. <br>
//!          To be Used when the associated degenerated Presentations <br>
//!          have been transformed by <aTrsf> which is not a Pure <br>
//!          Translation. The HLR Prs can't be deducted automatically <br>
//!          WARNING :<aTrsf> must be applied <br>
//!           to the object to display before computation  !!! <br>
  Standard_EXPORT   virtual  void Compute(const Handle(Prs3d_Projector)& aProjector,const Handle(Geom_Transformation)& aTrsf,const Handle(Prs3d_Presentation)& aPresentation) ;
  
  Standard_EXPORT   virtual  void Compute(const Handle(Prs3d_Projector)& aProjector,const Handle(Prs3d_Presentation)& aPresentation) ;
  
      virtual  Standard_Boolean AcceptShapeDecomposition() const;
  
  Standard_EXPORT   virtual  void UpdateLocation() ;
  //! For this class, the  location effect is treated in the <br>
//!           compute   &     computeSelection  methods.  So     the <br>
//!        UpdateLocation Methods are redefined to do nothing else <br>
  Standard_EXPORT   virtual  void UpdateLocation(const Handle(SelectMgr_Selection)& aSel) ;




  DEFINE_STANDARD_RTTI(AIS_ConnectedInteractive)

protected:


Handle_AIS_InteractiveObject myReference;
Handle_AIS_InteractiveObject myOldReference;


private: 

  //! Calculates the view aPresentation and its updates. <br>
//! The latter are managed by aPresentationManager. <br>
//! The display mode aMode is 0 by default. <br>
//!    this method is redefined virtual; <br>
//!          when the instance is connected to another <br>
//!          InteractiveObject,this method doesn't <br>
//!          compute anything, but just uses the <br>
//!          presentation of this last object, with <br>
//!          a transformation if there's one stored. <br>
  Standard_EXPORT   virtual  void Compute(const Handle(PrsMgr_PresentationManager3d)& aPresentationManager,const Handle(Prs3d_Presentation)& aPresentation,const Standard_Integer aMode = 0) ;
  //! Generates sensitive entities by copying <br>
//! them from myReference selection, creates and sets an entity <br>
//! owner for this entities and adds them to aSelection <br>
  Standard_EXPORT   virtual  void ComputeSelection(const Handle(SelectMgr_Selection)& aSelection,const Standard_Integer aMode) ;



};


#include <AIS_ConnectedInteractive.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
