// Created on: 1994-08-02
// Created by: Jean Yves LEBEY
// Copyright (c) 1994-1999 Matra Datavision
// Copyright (c) 1999-2012 OPEN CASCADE SAS
//
// The content of this file is subject to the Open CASCADE Technology Public
// License Version 6.5 (the "License"). You may not use the content of this file
// except in compliance with the License. Please obtain a copy of the License
// at http://www.opencascade.org and read it completely before using this file.
//
// The Initial Developer of the Original Code is Open CASCADE S.A.S., having its
// main offices at: 1, place des Freres Montgolfier, 78280 Guyancourt, France.
//
// The Original Code and all software distributed under the License is
// distributed on an "AS IS" basis, without warranty of any kind, and the
// Initial Developer hereby disclaims all such warranties, including without
// limitation, any warranties of merchantability, fitness for a particular
// purpose or non-infringement. Please see the License for the specific terms
// and conditions governing the rights and limitations under the License.

// Modifed:     Portage NT 7-5-97 DPF (strcasecmp)

#include <TopOpeBRep.ixx>

//#ifdef WNT
//#define strcasecmp strcmp Already defined
//#endif

//=======================================================================
//function : Print
//purpose  : 
//=======================================================================

Standard_OStream& TopOpeBRep::Print
  (const TopOpeBRep_TypeLineCurve t, Standard_OStream& OS)
{
  switch (t) {
  case TopOpeBRep_ANALYTIC    : OS << "ANALYTIC"; break;
  case TopOpeBRep_RESTRICTION : OS << "RESTRICTION"; break;
  case TopOpeBRep_WALKING     : OS << "WALKING"; break;
  case TopOpeBRep_LINE        : OS << "LINE"; break;
  case TopOpeBRep_CIRCLE      : OS << "CIRCLE"; break;
  case TopOpeBRep_ELLIPSE     : OS << "ELLIPSE"; break;
  case TopOpeBRep_PARABOLA    : OS << "PARABOLA"; break;
  case TopOpeBRep_HYPERBOLA   : OS << "HYPERBOLA"; break;
  case TopOpeBRep_OTHERTYPE   : OS << "OTHERTYPE"; break;
  default                     : OS << "UNKNOWN"; break;  
  }
  return OS;
}
