// Created on: 2009-04-06
// Created by: Sergey ZARITCHNY
// Copyright (c) 2009-2012 OPEN CASCADE SAS
//
// The content of this file is subject to the Open CASCADE Technology Public
// License Version 6.5 (the "License"). You may not use the content of this file
// except in compliance with the License. Please obtain a copy of the License
// at http://www.opencascade.org and read it completely before using this file.
//
// The Initial Developer of the Original Code is Open CASCADE S.A.S., having its
// main offices at: 1, place des Freres Montgolfier, 78280 Guyancourt, France.
//
// The Original Code and all software distributed under the License is
// distributed on an "AS IS" basis, without warranty of any kind, and the
// Initial Developer hereby disclaims all such warranties, including without
// limitation, any warranties of merchantability, fitness for a particular
// purpose or non-infringement. Please see the License for the specific terms
// and conditions governing the rights and limitations under the License.


#include <TDataXtd_Plane.ixx>
#include <TDataStd.hxx>
#include <TDataXtd.hxx>
#include <TNaming_NamedShape.hxx>
#include <TNaming_Tool.hxx>
#include <TNaming_Builder.hxx>
#include <TDF_Label.hxx>
#include <gp_Pln.hxx>
#include <TopoDS.hxx>
#include <TopoDS_Face.hxx>
#include <TopAbs.hxx>
#include <BRep_Tool.hxx>
#include <BRepBuilderAPI_MakeFace.hxx>
#include <Geom_RectangularTrimmedSurface.hxx>
#include <Geom_Plane.hxx>
#include <GeomLib_IsPlanarSurface.hxx>

#define OCC2932

//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataXtd_Plane::GetID () 
{
  static Standard_GUID TDataXtd_PlaneID("2a96b60c-ec8b-11d0-bee7-080009dc3333");
  return TDataXtd_PlaneID;
}

 
//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataXtd_Plane) TDataXtd_Plane::Set (const TDF_Label& L)
{
  Handle(TDataXtd_Plane) A;
  if (!L.FindAttribute(TDataXtd_Plane::GetID(),A)) {
    A = new TDataXtd_Plane (); 
    L.AddAttribute(A);
  }  
  return A;
}



//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataXtd_Plane) TDataXtd_Plane::Set (const TDF_Label& L, const gp_Pln& P)
{ 
  Handle(TDataXtd_Plane) A = Set (L);

#ifdef OCC2932
  Handle(TNaming_NamedShape) aNS;
  if(L.FindAttribute(TNaming_NamedShape::GetID(), aNS)) {
    if(!aNS->Get().IsNull())
       if(aNS->Get().ShapeType() == TopAbs_FACE) {
	 TopoDS_Face aFace = TopoDS::Face(aNS->Get());
	 Handle(Geom_Surface) aSurface = BRep_Tool::Surface(aFace);
	 GeomLib_IsPlanarSurface aChecker(aSurface);
	 if(aChecker.IsPlanar()) {
	   gp_Pln aPlane = aChecker.Plan();
	   if(aPlane.Location().X() == P.Location().X() &&
	      aPlane.Location().Y() == P.Location().Y() &&
	      aPlane.Location().Z() == P.Location().Z() &&
	      aPlane.Axis().Location().X() == P.Axis().Location().X() &&
	      aPlane.Axis().Location().Y() == P.Axis().Location().Y() &&
	      aPlane.Axis().Location().Z() == P.Axis().Location().Z() &&
	      aPlane.Axis().Direction().X() == P.Axis().Direction().X() &&
	      aPlane.Axis().Direction().Y() == P.Axis().Direction().Y() &&
	      aPlane.Axis().Direction().Z() == P.Axis().Direction().Z()
	      )
	     return A;
	 }
       }
  }
#endif

  TNaming_Builder B(L);
  B.Generated(BRepBuilderAPI_MakeFace(P));
  return A;
}

//=======================================================================
//function : TDataXtd_Plane
//purpose  : 
//=======================================================================

TDataXtd_Plane::TDataXtd_Plane () { }


//=======================================================================
//function : ID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataXtd_Plane::ID() const { return GetID(); }

//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) TDataXtd_Plane::NewEmpty () const
{  
  return new TDataXtd_Plane(); 
}

//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================

void TDataXtd_Plane::Restore(const Handle(TDF_Attribute)& With)  {}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void TDataXtd_Plane::Paste (const Handle(TDF_Attribute)& Into, const Handle(TDF_RelocationTable)& RT) const { }


//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TDataXtd_Plane::Dump (Standard_OStream& anOS) const
{  
  anOS << "Plane";
  return anOS;
}
