// Created on: 2011-10-25
// Created by: Sergey ZERCHANINOV
// Copyright (c) 2011-2012 OPEN CASCADE SAS
//
// The content of this file is subject to the Open CASCADE Technology Public
// License Version 6.5 (the "License"). You may not use the content of this file
// except in compliance with the License. Please obtain a copy of the License
// at http://www.opencascade.org and read it completely before using this file.
//
// The Initial Developer of the Original Code is Open CASCADE S.A.S., having its
// main offices at: 1, place des Freres Montgolfier, 78280 Guyancourt, France.
//
// The Original Code and all software distributed under the License is
// distributed on an "AS IS" basis, without warranty of any kind, and the
// Initial Developer hereby disclaims all such warranties, including without
// limitation, any warranties of merchantability, fitness for a particular
// purpose or non-infringement. Please see the License for the specific terms
// and conditions governing the rights and limitations under the License.


#include <OpenGl_GlCore11.hxx>

#include <OpenGl_Display.hxx>

#ifdef HAVE_CONFIG_H
# include <oce-config.h>
#endif

#ifdef HAVE_GL2PS
  #include <gl2ps.h>
#endif

#define  DOT_LS            0xCCCC
#define  DASH_DOT_LS       0xFF18
#define  DASH_LS           0xFFC0
#define  DASH_DDOT_LS      0xFF24

static const unsigned int myInteriors[TEL_HS_USER_DEF_START][32] =
{
  //TEL_HS_SOLID
  {
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF,
    0xFFFFFFFF
  },
  //TEL_HS_CROSS
  {
    0xFFFFFFFF,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB,
    0xEEEEEEEE,
    0xBBBBBBBB
  },
  //TEL_HS_CROSS_SPARSE
  {
    0x81818181,
    0x24242424,
    0x18181818,
    0x42424242,
    0x81818181,
    0x24242424,
    0x18181818,
    0x42424242,
    0x81818181,
    0x24242424,
    0x18181818,
    0x42424242,
    0x81818181,
    0x24242424,
    0x18181818,
    0x42424242,
    0x81818181,
    0x24242424,
    0x18181818,
    0x42424242,
    0x81818181,
    0x24242424,
    0x18181818,
    0x42424242,
    0x81818181,
    0x24242424,
    0x18181818,
    0x42424242,
    0x81818181,
    0x24242424,
    0x18181818,
    0x42424242
  },
  //TEL_HS_GRID
  {
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888,
    0xFFFFFFFF,
    0x88888888
  },
  //TEL_HS_GRID_SPARSE
  {
    0xFFFFFFFF,
    0x80808080,
    0x80808080,
    0x80808080,
    0xFFFFFFFF,
    0x80808080,
    0x80808080,
    0x80808080,
    0xFFFFFFFF,
    0x80808080,
    0x80808080,
    0x80808080,
    0xFFFFFFFF,
    0x80808080,
    0x80808080,
    0x80808080,
    0xFFFFFFFF,
    0x80808080,
    0x80808080,
    0x80808080,
    0xFFFFFFFF,
    0x80808080,
    0x80808080,
    0x80808080,
    0xFFFFFFFF,
    0x80808080,
    0x80808080,
    0x80808080,
    0xFFFFFFFF,
    0x80808080,
    0x80808080,
    0x80808080
  },
  //TEL_HS_DIAG_45
  {
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222,
    0x88888888,
    0x22222222
  },
  //TEL_HS_DIAG_135
  {
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444,
    0x11111111,
    0x44444444
  },
  //TEL_HS_HORIZONTAL
  {
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0xFFFFFFFF,
    0x00000000
  },
  //TEL_HS_VERTICAL
  {
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111
  },
  //TEL_HS_DIAG_45_SPARSE
  {
    0x80808080,
    0x20202020,
    0x08080808,
    0x02020202,
    0x80808080,
    0x20202020,
    0x08080808,
    0x02020202,
    0x80808080,
    0x20202020,
    0x08080808,
    0x02020202,
    0x80808080,
    0x20202020,
    0x08080808,
    0x02020202,
    0x80808080,
    0x20202020,
    0x08080808,
    0x02020202,
    0x80808080,
    0x20202020,
    0x08080808,
    0x02020202,
    0x80808080,
    0x20202020,
    0x08080808,
    0x02020202,
    0x80808080,
    0x20202020,
    0x08080808,
    0x02020202
  },
  //TEL_HS_DIAG_135_SPARSE
  {
    0x01010101,
    0x04040404,
    0x10101010,
    0x40404040,
    0x01010101,
    0x04040404,
    0x10101010,
    0x40404040,
    0x01010101,
    0x04040404,
    0x10101010,
    0x40404040,
    0x01010101,
    0x04040404,
    0x10101010,
    0x40404040,
    0x01010101,
    0x04040404,
    0x10101010,
    0x40404040,
    0x01010101,
    0x04040404,
    0x10101010,
    0x40404040,
    0x01010101,
    0x04040404,
    0x10101010,
    0x40404040,
    0x01010101,
    0x04040404,
    0x10101010,
    0x40404040
  },
  //TEL_HS_HORIZONTAL_SPARSE
  {
    0xFFFFFFFF,
    0x00000000,
    0x00000000,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0x00000000,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0x00000000,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0x00000000,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0x00000000,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0x00000000,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0x00000000,
    0x00000000,
    0xFFFFFFFF,
    0x00000000,
    0x00000000,
    0x00000000
  },
  //TEL_HS_VERTICAL_SPARSE
  {
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010,
    0x10101010
  }
};

/* Following Section relates to POLYMARKER */

#define TEL_NO_OF_SIZES   13
#define TEL_NB_OF_LISTS   5

struct PM_FONT_INFO
{
  const char *str;
  Tfloat width, height;
  Tint offset;
};
typedef PM_FONT_INFO* pm_font_info;

#define PM_PLUS_10_NUM  9*2
#define PM_PLUS_15_NUM  11*2
#define PM_PLUS_20_NUM  13*2
#define PM_PLUS_25_NUM  15*2
#define PM_PLUS_30_NUM  17*3
#define PM_PLUS_35_NUM  19*3
#define PM_PLUS_40_NUM  21*3
#define PM_PLUS_45_NUM  23*3
#define PM_PLUS_50_NUM  25*4
#define PM_PLUS_55_NUM  27*4
#define PM_PLUS_60_NUM  29*4
#define PM_PLUS_65_NUM  31*4
#define PM_PLUS_70_NUM  32*4

#define PM_STAR_10_NUM  9
#define PM_STAR_15_NUM  11*2
#define PM_STAR_20_NUM  13*2
#define PM_STAR_25_NUM  15*2
#define PM_STAR_30_NUM  17*2
#define PM_STAR_35_NUM  19*2
#define PM_STAR_40_NUM  21*3
#define PM_STAR_45_NUM  23*3
#define PM_STAR_50_NUM  25*3
#define PM_STAR_55_NUM  27*3
#define PM_STAR_60_NUM  29*4
#define PM_STAR_65_NUM  32*4
#define PM_STAR_70_NUM  32*4

#define PM_CIRC_10_NUM  7
#define PM_CIRC_15_NUM  9*2
#define PM_CIRC_20_NUM  9*2
#define PM_CIRC_25_NUM  11*2
#define PM_CIRC_30_NUM  13*2
#define PM_CIRC_35_NUM  15*2
#define PM_CIRC_40_NUM  17*3
#define PM_CIRC_45_NUM  19*3
#define PM_CIRC_50_NUM  21*3
#define PM_CIRC_55_NUM  23*3
#define PM_CIRC_60_NUM  25*4
#define PM_CIRC_65_NUM  27*4
#define PM_CIRC_70_NUM  29*4

#define PM_CROSS_10_NUM 7
#define PM_CROSS_15_NUM 9*2
#define PM_CROSS_20_NUM 11*2
#define PM_CROSS_25_NUM 13*2
#define PM_CROSS_30_NUM 15*2
#define PM_CROSS_35_NUM 17*3
#define PM_CROSS_40_NUM 19*3
#define PM_CROSS_45_NUM 21*3
#define PM_CROSS_50_NUM 23*3
#define PM_CROSS_55_NUM 25*4
#define PM_CROSS_60_NUM 27*4
#define PM_CROSS_65_NUM 32*4
#define PM_CROSS_70_NUM 32*4

#define PM_PLUS_10_OFT  0
#define PM_PLUS_15_OFT  PM_PLUS_10_OFT + PM_PLUS_10_NUM
#define PM_PLUS_20_OFT  PM_PLUS_15_OFT + PM_PLUS_15_NUM
#define PM_PLUS_25_OFT  PM_PLUS_20_OFT + PM_PLUS_20_NUM
#define PM_PLUS_30_OFT  PM_PLUS_25_OFT + PM_PLUS_25_NUM
#define PM_PLUS_35_OFT  PM_PLUS_30_OFT + PM_PLUS_30_NUM
#define PM_PLUS_40_OFT  PM_PLUS_35_OFT + PM_PLUS_35_NUM
#define PM_PLUS_45_OFT  PM_PLUS_40_OFT + PM_PLUS_40_NUM
#define PM_PLUS_50_OFT  PM_PLUS_45_OFT + PM_PLUS_45_NUM
#define PM_PLUS_55_OFT  PM_PLUS_50_OFT + PM_PLUS_50_NUM
#define PM_PLUS_60_OFT  PM_PLUS_55_OFT + PM_PLUS_55_NUM
#define PM_PLUS_65_OFT  PM_PLUS_60_OFT + PM_PLUS_60_NUM
#define PM_PLUS_70_OFT  PM_PLUS_65_OFT + PM_PLUS_65_NUM

#define PM_STAR_10_OFT  PM_PLUS_70_OFT + PM_PLUS_70_NUM
#define PM_STAR_15_OFT  PM_STAR_10_OFT + PM_STAR_10_NUM
#define PM_STAR_20_OFT  PM_STAR_15_OFT + PM_STAR_15_NUM
#define PM_STAR_25_OFT  PM_STAR_20_OFT + PM_STAR_20_NUM
#define PM_STAR_30_OFT  PM_STAR_25_OFT + PM_STAR_25_NUM
#define PM_STAR_35_OFT  PM_STAR_30_OFT + PM_STAR_30_NUM
#define PM_STAR_40_OFT  PM_STAR_35_OFT + PM_STAR_35_NUM
#define PM_STAR_45_OFT  PM_STAR_40_OFT + PM_STAR_40_NUM
#define PM_STAR_50_OFT  PM_STAR_45_OFT + PM_STAR_45_NUM
#define PM_STAR_55_OFT  PM_STAR_50_OFT + PM_STAR_50_NUM
#define PM_STAR_60_OFT  PM_STAR_55_OFT + PM_STAR_55_NUM
#define PM_STAR_65_OFT  PM_STAR_60_OFT + PM_STAR_60_NUM
#define PM_STAR_70_OFT  PM_STAR_65_OFT + PM_STAR_65_NUM

#define PM_CIRC_10_OFT  PM_STAR_70_OFT + PM_STAR_70_NUM
#define PM_CIRC_15_OFT  PM_CIRC_10_OFT + PM_CIRC_10_NUM
#define PM_CIRC_20_OFT  PM_CIRC_15_OFT + PM_CIRC_15_NUM
#define PM_CIRC_25_OFT  PM_CIRC_20_OFT + PM_CIRC_20_NUM
#define PM_CIRC_30_OFT  PM_CIRC_25_OFT + PM_CIRC_25_NUM
#define PM_CIRC_35_OFT  PM_CIRC_30_OFT + PM_CIRC_30_NUM
#define PM_CIRC_40_OFT  PM_CIRC_35_OFT + PM_CIRC_35_NUM
#define PM_CIRC_45_OFT  PM_CIRC_40_OFT + PM_CIRC_40_NUM
#define PM_CIRC_50_OFT  PM_CIRC_45_OFT + PM_CIRC_45_NUM
#define PM_CIRC_55_OFT  PM_CIRC_50_OFT + PM_CIRC_50_NUM
#define PM_CIRC_60_OFT  PM_CIRC_55_OFT + PM_CIRC_55_NUM
#define PM_CIRC_65_OFT  PM_CIRC_60_OFT + PM_CIRC_60_NUM
#define PM_CIRC_70_OFT  PM_CIRC_65_OFT + PM_CIRC_65_NUM

#define PM_CROSS_10_OFT  PM_CIRC_70_OFT + PM_CIRC_70_NUM
#define PM_CROSS_15_OFT  PM_CROSS_10_OFT + PM_CROSS_10_NUM
#define PM_CROSS_20_OFT  PM_CROSS_15_OFT + PM_CROSS_15_NUM
#define PM_CROSS_25_OFT  PM_CROSS_20_OFT + PM_CROSS_20_NUM
#define PM_CROSS_30_OFT  PM_CROSS_25_OFT + PM_CROSS_25_NUM
#define PM_CROSS_35_OFT  PM_CROSS_30_OFT + PM_CROSS_30_NUM
#define PM_CROSS_40_OFT  PM_CROSS_35_OFT + PM_CROSS_35_NUM
#define PM_CROSS_45_OFT  PM_CROSS_40_OFT + PM_CROSS_40_NUM
#define PM_CROSS_50_OFT  PM_CROSS_45_OFT + PM_CROSS_45_NUM
#define PM_CROSS_55_OFT  PM_CROSS_50_OFT + PM_CROSS_50_NUM
#define PM_CROSS_60_OFT  PM_CROSS_55_OFT + PM_CROSS_55_NUM
#define PM_CROSS_65_OFT  PM_CROSS_60_OFT + PM_CROSS_60_NUM
#define PM_CROSS_70_OFT  PM_CROSS_65_OFT + PM_CROSS_65_NUM

static const PM_FONT_INFO arrPMFontInfo[][TEL_NO_OF_SIZES] =
{
 /* TOM_POINT - not used */
 {{"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"}},

 /* TOM_PLUS */
 {{"\001",  9.f,  9.f, PM_PLUS_10_OFT},
  {"\002", 11.f, 11.f, PM_PLUS_15_OFT},
  {"\003", 13.f, 13.f, PM_PLUS_20_OFT},
  {"\004", 15.f, 15.f, PM_PLUS_25_OFT},
  {"\005", 17.f, 17.f, PM_PLUS_30_OFT},
  {"\006", 19.f, 19.f, PM_PLUS_35_OFT},
  {"\007", 21.f, 21.f, PM_PLUS_40_OFT},
  {"\010", 23.f, 23.f, PM_PLUS_45_OFT},
  {"\011", 25.f, 25.f, PM_PLUS_50_OFT},
  {"\012", 27.f, 27.f, PM_PLUS_55_OFT},
  {"\013", 29.f, 29.f, PM_PLUS_60_OFT},
  {"\014", 31.f, 31.f, PM_PLUS_65_OFT},
  {"\015", 32.f, 32.f, PM_PLUS_70_OFT}},

 /* TOM_STAR */
 {{"\016",  7.f,  9.f, PM_STAR_10_OFT},
  {"\017",  9.f, 11.f, PM_STAR_15_OFT},
  {"\020", 11.f, 13.f, PM_STAR_20_OFT},
  {"\021", 13.f, 15.f, PM_STAR_25_OFT},
  {"\022", 13.f, 17.f, PM_STAR_30_OFT},
  {"\023", 15.f, 19.f, PM_STAR_35_OFT},
  {"\024", 17.f, 21.f, PM_STAR_40_OFT},
  {"\025", 19.f, 23.f, PM_STAR_45_OFT},
  {"\026", 21.f, 25.f, PM_STAR_50_OFT},
  {"\027", 23.f, 27.f, PM_STAR_55_OFT},
  {"\030", 25.f, 29.f, PM_STAR_60_OFT},
  {"\031", 32.f, 32.f, PM_STAR_65_OFT},
  {"\032", 32.f, 32.f, PM_STAR_70_OFT}},

 /* TOM_O */
 {{"\033",  7.f,  7.f, PM_CIRC_10_OFT},
  {"\034",  9.f,  9.f, PM_CIRC_15_OFT},
  {"\035",  9.f,  9.f, PM_CIRC_20_OFT},
  {"\036", 11.f, 11.f, PM_CIRC_25_OFT},
  {"\037", 13.f, 13.f, PM_CIRC_30_OFT},
  {"\040", 15.f, 15.f, PM_CIRC_35_OFT},
  {"\041", 17.f, 17.f, PM_CIRC_40_OFT},
  {"\042", 19.f, 19.f, PM_CIRC_45_OFT},
  {"\043", 21.f, 21.f, PM_CIRC_50_OFT},
  {"\044", 23.f, 23.f, PM_CIRC_55_OFT},
  {"\045", 25.f, 25.f, PM_CIRC_60_OFT},
  {"\046", 27.f, 27.f, PM_CIRC_65_OFT},
  {"\047", 29.f, 29.f, PM_CIRC_70_OFT}},

 /* TOM_X */
 {{"\050",  7.f,  7.f, PM_CROSS_10_OFT},
  {"\051",  9.f,  9.f, PM_CROSS_15_OFT},
  {"\052", 11.f, 11.f, PM_CROSS_20_OFT},
  {"\053", 13.f, 13.f, PM_CROSS_25_OFT},
  {"\054", 15.f, 15.f, PM_CROSS_30_OFT},
  {"\055", 17.f, 17.f, PM_CROSS_35_OFT},
  {"\056", 19.f, 19.f, PM_CROSS_40_OFT},
  {"\057", 21.f, 21.f, PM_CROSS_45_OFT},
  {"\060", 23.f, 23.f, PM_CROSS_50_OFT},
  {"\061", 25.f, 25.f, PM_CROSS_55_OFT},
  {"\062", 27.f, 27.f, PM_CROSS_60_OFT},
  {"\063", 32.f, 32.f, PM_CROSS_65_OFT},
  {"\064", 32.f, 32.f, PM_CROSS_70_OFT}},

 /* TOM_O_POINT - not used */
 {{"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"},
  {"\0"}},

 /* TOM_O_PLUS */
 {{"\001\033"},
  {"\002\034"},
  {"\003\035"},
  {"\004\036"},
  {"\005\037"},
  {"\006\040"},
  {"\007\041"},
  {"\010\042"},
  {"\011\043"},
  {"\012\044"},
  {"\013\045"},
  {"\014\046"},
  {"\015\047"}},

 /* TOM_O_STAR */
 {{"\016\033"},
  {"\017\034"},
  {"\020\035"},
  {"\021\036"},
  {"\022\037"},
  {"\023\040"},
  {"\024\041"},
  {"\025\042"},
  {"\026\043"},
  {"\027\044"},
  {"\030\045"},
  {"\031\046"},
  {"\032\047"}},

 /* TOM_O_X */
 {{"\050\033"},
  {"\051\034"},
  {"\052\035"},
  {"\053\036"},
  {"\054\037"},
  {"\055\040"},
  {"\056\041"},
  {"\057\042"},
  {"\060\043"},
  {"\061\044"},
  {"\062\045"},
  {"\063\046"},
  {"\064\047"}}
};

static const unsigned char myMarkerRaster[] =
{
    /* TYPE = PLUS */

    0x08,0x00,
    0x08,0x00,
    0x08,0x00,
    0x08,0x00,
    0xff,0x80,
    0x08,0x00,
    0x08,0x00,
    0x08,0x00,
    0x08,0x00,  /* PLUS 9x9 = 1.0 */

    0x04,0x00,
    0x04,0x00,
    0x04,0x00,
    0x04,0x00,
    0x04,0x00,
    0xff,0xe0,
    0x04,0x00,
    0x04,0x00,
    0x04,0x00,
    0x04,0x00,
    0x04,0x00,  /* PLUS 11x11 = 1.5 */

    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0xff,0xf8,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,/* PLUS 13x13 = 2.0 */

    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0xff,0xfe,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,/* PLUS 15x15 = 2.5 */

    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0xff,0xff, 0x80,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,/* PLUS 17x17 = 3.0 */

    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0xff,0xff, 0xe0,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,/* PLUS 19x19 = 3.5 */

    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0xff,0xff, 0xf8,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,/* PLUS 21x21 = 4.0 */

    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0xff,0xff, 0xfe,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,/* PLUS 23x23 = 4.5 */

    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0xff,0xff, 0xff,0x80,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,/* PLUS 25x25 = 5.0 */

    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0xff,0xff, 0xff,0xe0,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x04, 0x00,0x00,/* PLUS 27x27 = 5.5 */

    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0xff,0xff, 0xff,0xf8,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,
    0x00,0x02, 0x00,0x00,/* PLUS 29x29 = 6.0 */

    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0xff,0xff, 0xff,0xfd,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,
    0x00,0x01, 0x00,0x00,/* PLUS 31x31 = 6.5 */

    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0xff,0xff, 0xff,0xff,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,/* PLUS 32x32 = 7.0 */

    /* TYPE = STAR */

    0x10,
    0x10,
    0xd6,
    0x38,
    0x10,
    0x38,
    0xd6,
    0x10,
    0x10,/* STAR 7x9 = 1.0 */

    0x08,0x00,
    0x08,0x00,
    0x08,0x00,
    0xc9,0x80,
    0x3e,0x00,
    0x08,0x00,
    0x3e,0x00,
    0xc9,0x80,
    0x08,0x00,
    0x08,0x00,
    0x08,0x00,/* STAR 9x11 = 1.5 */

    0x04,0x00,
    0x04,0x00,
    0x04,0x00,
    0x84,0x20,
    0x64,0xc0,
    0x1f,0x00,
    0x04,0x00,
    0x1f,0x00,
    0x64,0xc0,
    0x84,0x20,
    0x04,0x00,
    0x04,0x00,
    0x04,0x00,/* STAR 11x13 = 2.0 */

    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x82,0x18,
    0x62,0x60,
    0x1b,0x80,
    0x06,0x00,
    0x1b,0x80,
    0x62,0x60,
    0x82,0x18,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,/* STAR 13x15 = 2.5 */

    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x82,0x08,
    0x62,0x30,
    0x12,0x40,
    0x0f,0x80,
    0x02,0x00,
    0x0f,0x80,
    0x12,0x40,
    0x62,0x30,
    0x82,0x08,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,
    0x02,0x00,/* STAR 13x17 = 3.0 */

    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0xc1,0x06,
    0x21,0x18,
    0x19,0x20,
    0x07,0xc0,
    0x01,0x00,
    0x07,0xc0,
    0x19,0x20,
    0x21,0x18,
    0xc1,0x06,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,
    0x01,0x00,/* STAR 15x19 = 3.5 */

    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x80,0x80, 0x80,
    0x60,0x83, 0x00,
    0x10,0x8c, 0x00,
    0x0c,0x90, 0x00,
    0x03,0xe0, 0x00,
    0x00,0x80, 0x00,
    0x03,0xe0, 0x00,
    0x0c,0x90, 0x00,
    0x10,0x8c, 0x00,
    0x60,0x83, 0x00,
    0x80,0x80, 0x80,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,
    0x00,0x80, 0x00,/* STAR 17x21 = 4.0 */

    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0xc0,0x40, 0x60,
    0x30,0x41, 0x80,
    0x08,0x42, 0x00,
    0x06,0x4c, 0x00,
    0x01,0xf0, 0x00,
    0x00,0x40, 0x00,
    0x01,0xf0, 0x00,
    0x06,0x4c, 0x00,
    0x08,0x42, 0x00,
    0x30,0x41, 0x80,
    0xc0,0x40, 0x60,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,
    0x00,0x40, 0x00,/* STAR 19x23 = 4.5 */

    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x80,0x20, 0x08,
    0x60,0x20, 0x30,
    0x18,0x20, 0xc0,
    0x04,0x21, 0x00,
    0x03,0x26, 0x00,
    0x00,0xf8, 0x00,
    0x00,0x20, 0x00,
    0x00,0xf8, 0x00,
    0x03,0x26, 0x00,
    0x04,0x21, 0x00,
    0x18,0x20, 0xc0,
    0x60,0x20, 0x30,
    0x80,0x20, 0x08,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,
    0x00,0x20, 0x00,/* STAR 21x25 = 5.0 */

    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0xc0,0x10, 0x06,
    0x30,0x10, 0x18,
    0x08,0x10, 0x60,
    0x06,0x10, 0x80,
    0x01,0x93, 0x00,
    0x00,0x7c, 0x00,
    0x00,0x10, 0x00,
    0x00,0x7c, 0x00,
    0x01,0x93, 0x00,
    0x06,0x10, 0x80,
    0x08,0x10, 0x60,
    0x30,0x10, 0x18,
    0xc0,0x10, 0x06,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,
    0x00,0x10, 0x00,/* STAR 23x27 = 5.5 */

    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x80,0x08, 0x00,0x80,
    0x60,0x08, 0x03,0x00,
    0x18,0x08, 0x0c,0x00,
    0x04,0x08, 0x30,0x00,
    0x03,0x08, 0x40,0x00,
    0x00,0xc9, 0x80,0x00,
    0x00,0x3e, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x3e, 0x00,0x00,
    0x00,0xc9, 0x80,0x00,
    0x03,0x08, 0x40,0x00,
    0x04,0x08, 0x30,0x00,
    0x18,0x08, 0x0c,0x00,
    0x60,0x08, 0x03,0x00,
    0x80,0x08, 0x00,0x80,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x08, 0x00,0x00,/* STAR 25x29 = 6.0 */

    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00, 
    0x00,0x00, 0x80,0x00,
    0x30,0x00, 0x80,0x06,
    0x0c,0x00, 0x80,0x18,
    0x03,0x00, 0x80,0x60,
    0x00,0xc0, 0x81,0x80,
    0x00,0x30, 0x86,0x00,
    0x00,0x0c, 0x98,0x00,
    0x00,0x03, 0xe0,0x00,
    0x00,0x03, 0xe0,0x00,
    0x00,0x0c, 0x98,0x00,
    0x00,0x30, 0x86,0x00,
    0x00,0xc0, 0x81,0x80,
    0x03,0x00, 0x80,0x60,
    0x0c,0x00, 0x80,0x18,
    0x30,0x00, 0x80,0x06,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x80,0x00,
    0x00,0x00, 0x00,0x00,
    0x00,0x00, 0x00,0x00,/* STAR 32x32 = 6.5 */

    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00, 
    0x00, 0x00, 0x80, 0x00,
    0x10, 0x00, 0x80, 0x04,
    0x0c, 0x00, 0x80, 0x18,
    0x02, 0x00, 0x80, 0x20,
    0x01, 0x80, 0x80, 0xc0,
    0x00, 0x40, 0x81, 0x00,
    0x00, 0x30, 0x86, 0x00,
    0x00, 0x08, 0x88, 0x00,
    0x00, 0x06, 0xb0, 0x00,
    0x00, 0x01, 0xc0, 0x00,
    0x00, 0x06, 0xb0, 0x00,
    0x00, 0x08, 0x88, 0x00,
    0x00, 0x30, 0x86, 0x00,
    0x00, 0x40, 0x81, 0x00,
    0x01, 0x80, 0x80, 0xc0,
    0x02, 0x00, 0x80, 0x20,
    0x0c, 0x00, 0x80, 0x18,
    0x10, 0x00, 0x80, 0x04,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,
    0x00, 0x00, 0x80, 0x00,/* STAR 32x32 = 7.0 */

      /* TYPE = CIRC */

    0x38,
    0x44,
    0x82,
    0x82,
    0x82,
    0x44,
    0x38,/* CIRC 7x7 = 1.0 */

    0x3c,0x00,
    0x42,0x00,
    0x81,0x00,
    0x81,0x00,
    0x81,0x00,
    0x81,0x00,
    0x42,0x00,
    0x3c,0x00,
    0x00,0x00,/*CIRC 9x9 = 1.5 */

    0x3e, 0x00,
    0x41, 0x00,
    0x81, 0x80,
    0x80,0x80,
    0x80,0x80,
    0x80,0x80,
    0x81, 0x80,
    0x41, 0x00,
    0x3e,0x00,/* CIRC 9x9 = 2.0 */

    0x1f,0x00,
    0x20,0x80,
    0x40,0x40,
    0x80,0x20,
    0x80,0x20,
    0x80,0x20,
    0x80,0x20,
    0x80,0x20,
    0x40,0x40,
    0x20,0x80,
    0x1f,0x00,/* CIRC 11x11 = 2.5 */

    0x0f,0x80,
    0x10,0x40,
    0x20,0x20,
    0x40,0x10,
    0x80,0x08,
    0x80,0x08,
    0x80,0x08,
    0x80,0x08,
    0x80,0x08,
    0x40,0x10,
    0x20,0x20,
    0x10,0x40,
    0x0f,0x80,/* CIRC 13x13 = 3.0 */

    0x07,0xc0,
    0x18,0x30,
    0x20,0x08,
    0x40,0x04,
    0x40,0x04,
    0x80,0x02,
    0x80,0x02,
    0x80,0x02,
    0x80,0x02,
    0x80,0x02,
    0x40,0x04,
    0x40,0x04,
    0x20,0x08,
    0x18,0x30,
    0x07,0xc0,/* CIRC 15x15 = 3.5 */

    0x03,0xe0, 0x00,
    0x0c,0x18, 0x00,
    0x10,0x04, 0x00,
    0x20,0x02, 0x00,
    0x40,0x01, 0x00,
    0x40,0x01, 0x00,
    0x80,0x00, 0x80,
    0x80,0x00, 0x80,
    0x80,0x00, 0x80,
    0x80,0x00, 0x80,
    0x80,0x00, 0x80,
    0x40,0x01, 0x00,
    0x40,0x01, 0x00,
    0x20,0x02, 0x00,
    0x10,0x04, 0x00,
    0x0c,0x18, 0x00,
    0x03,0xe0, 0x00,/* CIRC 17x17 = 4.0 */

    0x03,0xf8, 0x00,
    0x0e,0x0e, 0x00,
    0x18,0x03, 0x00,
    0x20,0x00, 0x80,
    0x60,0x00, 0xc0,
    0x40,0x00, 0x40,
    0xc0,0x00, 0x60,
    0x80,0x00, 0x20,
    0x80,0x00, 0x20,
    0x80,0x00, 0x20,
    0x80,0x00, 0x20,
    0x80,0x00, 0x20,
    0xc0,0x00, 0x60,
    0x40,0x00, 0x40,
    0x60,0x00, 0xc0,
    0x20,0x00, 0x80,
    0x18,0x03, 0x00,
    0x0e,0x0e, 0x00,
    0x03,0xf8, 0x00,/* CIRC 19x19 = 4.5 */

    0x01,0xfc, 0x00,
    0x06,0x03, 0x00,
    0x08,0x00, 0x80,
    0x10,0x00, 0x40,
    0x20,0x00, 0x20,
    0x40,0x00, 0x10,
    0x40,0x00, 0x10,
    0x80,0x00, 0x08,
    0x80,0x00, 0x08,
    0x80,0x00, 0x08,
    0x80,0x00, 0x08,
    0x80,0x00, 0x08,
    0x80,0x00, 0x08,
    0x80,0x00, 0x08,
    0x40,0x00, 0x10,
    0x40,0x00, 0x10,
    0x20,0x00, 0x20,
    0x10,0x00, 0x40,
    0x08,0x00, 0x80,
    0x06,0x03, 0x00,
    0x01,0xfc, 0x00,/* CIRC 21x21 = 5.0 */

    0x00,0xfe, 0x00,
    0x03,0x01, 0x80,
    0x0c,0x00, 0x60,
    0x18,0x00, 0x30,
    0x30,0x00, 0x18,
    0x20,0x00, 0x08,
    0x40,0x00, 0x04,
    0x40,0x00, 0x04,
    0x80,0x00, 0x02,
    0x80,0x00, 0x02,
    0x80,0x00, 0x02,
    0x80,0x00, 0x02,
    0x80,0x00, 0x02,
    0x80,0x00, 0x02,
    0x80,0x00, 0x02,
    0x40,0x00, 0x04,
    0x40,0x00, 0x04,
    0x20,0x00, 0x08,
    0x30,0x00, 0x18,
    0x18,0x00, 0x30,
    0x0c,0x00, 0x60,
    0x03,0x01, 0x80,
    0x00,0xfe, 0x00,/* CIRC 23x23 = 5.5 */

    0x00,0x7f, 0x00,0x00,
    0x01,0x80, 0xc0,0x00,
    0x06,0x00, 0x30,0x00,
    0x08,0x00, 0x08,0x00,
    0x10,0x00, 0x04,0x00,
    0x20,0x00, 0x02,0x00,
    0x20,0x00, 0x02,0x00,
    0x40,0x00, 0x01,0x00,
    0x40,0x00, 0x01,0x00,
    0x80,0x00, 0x00,0x80,
    0x80,0x00, 0x00,0x80,
    0x80,0x00, 0x00,0x80,
    0x80,0x00, 0x00,0x80,
    0x80,0x00, 0x00,0x80,
    0x80,0x00, 0x00,0x80,
    0x80,0x00, 0x00,0x80,
    0x40,0x00, 0x01,0x00,
    0x40,0x00, 0x01,0x00,
    0x20,0x00, 0x02,0x00,
    0x20,0x00, 0x02,0x00,
    0x10,0x00, 0x04,0x00,
    0x08,0x00, 0x08,0x00,
    0x06,0x00, 0x30,0x00,
    0x01,0x80, 0xc0,0x00,
    0x00,0x7f, 0x00,0x00,/* CIRC 25x25 = 6.0 */

    0x00,0x3f, 0x80,0x00,
    0x01,0xc0, 0x70,0x00,
    0x03,0x00, 0x18,0x00,
    0x0c,0x00, 0x06,0x00,
    0x18,0x00, 0x03,0x00,
    0x10,0x00, 0x01,0x00,
    0x20,0x00, 0x00,0x80,
    0x60,0x00, 0x00,0xc0,
    0x40,0x00, 0x00,0x40,
    0x40,0x00, 0x00,0x40,
    0x80,0x00, 0x00,0x20,
    0x80,0x00, 0x00,0x20,
    0x80,0x00, 0x00,0x20,
    0x80,0x00, 0x00,0x20,
    0x80,0x00, 0x00,0x20,
    0x80,0x00, 0x00,0x20,
    0x80,0x00, 0x00,0x20,
    0x40,0x00, 0x00,0x40,
    0x40,0x00, 0x00,0x40,
    0x60,0x00, 0x00,0xc0,
    0x20,0x00, 0x00,0x80,
    0x10,0x00, 0x01,0x00,
    0x18,0x00, 0x03,0x00,
    0x0c,0x00, 0x06,0x00,
    0x03,0x00, 0x18,0x00,
    0x01,0xc0, 0x70,0x00,
    0x00,0x3f, 0x80,0x00,/* CIRC 27x27 = 6.5 */

    0x00,0x1f, 0xc0,0x00,
    0x00,0xe0, 0x38,0x00,
    0x01,0x00, 0x04,0x00,
    0x06,0x00, 0x03,0x00,
    0x08,0x00, 0x00,0x80,
    0x10,0x00, 0x00,0x40,
    0x10,0x00, 0x00,0x40,
    0x20,0x00, 0x00,0x20,
    0x40,0x00, 0x00,0x10,
    0x40,0x00, 0x00,0x10,
    0x40,0x00, 0x00,0x10,
    0x80,0x00, 0x00,0x08,
    0x80,0x00, 0x00,0x08,
    0x80,0x00, 0x00,0x08,
    0x80,0x00, 0x00,0x08,
    0x80,0x00, 0x00,0x08,
    0x80,0x00, 0x00,0x08,
    0x80,0x00, 0x00,0x08,
    0x40,0x00, 0x00,0x10,
    0x40,0x00, 0x00,0x10,
    0x40,0x00, 0x00,0x10,
    0x20,0x00, 0x00,0x20,
    0x10,0x00, 0x00,0x40,
    0x10,0x00, 0x00,0x40,
    0x08,0x00, 0x00,0x80,
    0x06,0x00, 0x03,0x00,
    0x01,0x00, 0x04,0x00,
    0x00,0xe0, 0x38,0x00,
    0x00,0x1f, 0xc0,0x00, /* CIRC 29x29 = 7.0 */

      /* TYPE = CROSS */

    0x82,
    0x44,
    0x28,
    0x10,
    0x28,
    0x44,
    0x82,/* CROSS 7x7 = 1.0 */

    0x80,0x80,
    0x41,0x00,
    0x22,0x00,
    0x14,0x00,
    0x08,0x00,
    0x14,0x00,
    0x22,0x00,
    0x41,0x00,
    0x80,0x80,/* CROSS 9x9 = 1.5 */

    0x80,0x20,
    0x40,0x40,
    0x20,0x80,
    0x11,0x00,
    0x0a,0x00,
    0x04,0x00,
    0x0a,0x00,
    0x11,0x00,
    0x20,0x80,
    0x40,0x40,
    0x80,0x20,/* CROSS 11x11 = 2.0 */

    0x80,0x08,
    0x40,0x10,
    0x20,0x20,
    0x10,0x40,
    0x08,0x80,
    0x05,0x00,
    0x02,0x00,
    0x05,0x00,
    0x08,0x80,
    0x10,0x40,
    0x20,0x20,
    0x40,0x10,
    0x80,0x08,/* CROSS 13x13 = 2.5 */

    0x80,0x02,
    0x40,0x04,
    0x20,0x08,
    0x10,0x10,
    0x08,0x20,
    0x04,0x40,
    0x02,0x80,
    0x01,0x00,
    0x02,0x80,
    0x04,0x40,
    0x08,0x20,
    0x10,0x10,
    0x20,0x08,
    0x40,0x04,
    0x80,0x02,/* CROSS 15x15 = 3.0 */

    0x80,0x00, 0x80,
    0x40,0x01, 0x00,
    0x20,0x02, 0x00,
    0x10,0x04, 0x00,
    0x08,0x08, 0x00,
    0x04,0x10, 0x00,
    0x02,0x20, 0x00,
    0x01,0x40, 0x00,
    0x00,0x80, 0x00,
    0x01,0x40, 0x00,
    0x02,0x20, 0x00,
    0x04,0x10, 0x00,
    0x08,0x08, 0x00,
    0x10,0x04, 0x00,
    0x20,0x02, 0x00,
    0x40,0x01, 0x00,
    0x80,0x00, 0x80,/* CROSS 17x17 = 3.5 */

    0x80,0x00, 0x20,
    0x40,0x00, 0x40,
    0x20,0x00, 0x80,
    0x10,0x01, 0x00,
    0x08,0x02, 0x00,
    0x04,0x04, 0x00,
    0x02,0x08, 0x00,
    0x01,0x10, 0x00,
    0x00,0xa0, 0x00,
    0x00,0x40, 0x00,
    0x00,0xa0, 0x00,
    0x01,0x10, 0x00,
    0x02,0x08, 0x00,
    0x04,0x04, 0x00,
    0x08,0x02, 0x00,
    0x10,0x01, 0x00,
    0x20,0x00, 0x80,
    0x40,0x00, 0x40,
    0x80,0x00, 0x20,/* CROSS 19x19 = 4.0 */

    0x80,0x00, 0x08,
    0x40,0x00, 0x10,
    0x20,0x00, 0x20,
    0x10,0x00, 0x40,
    0x08,0x00, 0x80,
    0x04,0x01, 0x00,
    0x02,0x02, 0x00,
    0x01,0x04, 0x00,
    0x00,0x88, 0x00,
    0x00,0x50, 0x00,
    0x00,0x20, 0x00,
    0x00,0x50, 0x00,
    0x00,0x88, 0x00,
    0x01,0x04, 0x00,
    0x02,0x02, 0x00,
    0x04,0x01, 0x00,
    0x08,0x00, 0x80,
    0x10,0x00, 0x40,
    0x20,0x00, 0x20,
    0x40,0x00, 0x10,
    0x80,0x00, 0x08,/* CROSS 21x21 = 4.5 */

    0x80,0x00, 0x02,
    0x40,0x00, 0x04,
    0x20,0x00, 0x08,
    0x10,0x00, 0x10,
    0x08,0x00, 0x20,
    0x04,0x00, 0x40,
    0x02,0x00, 0x80,
    0x01,0x01, 0x00,
    0x00,0x82, 0x00,
    0x00,0x44, 0x00,
    0x00,0x28, 0x00,
    0x00,0x10, 0x00,
    0x00,0x28, 0x00,
    0x00,0x44, 0x00,
    0x00,0x82, 0x00,
    0x01,0x01, 0x00,
    0x02,0x00, 0x80,
    0x04,0x00, 0x40,
    0x08,0x00, 0x20,
    0x10,0x00, 0x10,
    0x20,0x00, 0x08,
    0x40,0x00, 0x04,
    0x80,0x00, 0x02,/* CROSS 23x23 = 5.0 */

    0x80,0x00, 0x00,0x80,
    0x40,0x00, 0x01,0x00,
    0x20,0x00, 0x02,0x00,
    0x10,0x00, 0x04,0x00,
    0x08,0x00, 0x08,0x00,
    0x04,0x00, 0x10,0x00,
    0x02,0x00, 0x20,0x00,
    0x01,0x00, 0x40,0x00,
    0x00,0x80, 0x80,0x00,
    0x00,0x41, 0x00,0x00,
    0x00,0x22, 0x00,0x00,
    0x00,0x14, 0x00,0x00,
    0x00,0x08, 0x00,0x00,
    0x00,0x14, 0x00,0x00,
    0x00,0x22, 0x00,0x00,
    0x00,0x41, 0x00,0x00,
    0x00,0x80, 0x80,0x00,
    0x01,0x00, 0x40,0x00,
    0x02,0x00, 0x20,0x00,
    0x04,0x00, 0x10,0x00,
    0x08,0x00, 0x08,0x00,
    0x10,0x00, 0x04,0x00,
    0x20,0x00, 0x02,0x00,
    0x40,0x00, 0x01,0x00,
    0x80,0x00, 0x00,0x80,/* CROSS 25x25 = 5.5 */

    0x80,0x00, 0x00,0x20,
    0x40,0x00, 0x00,0x40,
    0x20,0x00, 0x00,0x80,
    0x10,0x00, 0x01,0x00,
    0x08,0x00, 0x02,0x00,
    0x04,0x00, 0x04,0x00,
    0x02,0x00, 0x08,0x00,
    0x01,0x00, 0x10,0x00,
    0x00,0x80, 0x20,0x00,
    0x00,0x40, 0x40,0x00,
    0x00,0x20, 0x80,0x00,
    0x00,0x11, 0x00,0x00,
    0x00,0x0a, 0x00,0x00,
    0x00,0x04, 0x00,0x00,
    0x00,0x0a, 0x00,0x00,
    0x00,0x11, 0x00,0x00,
    0x00,0x20, 0x80,0x00,
    0x00,0x40, 0x40,0x00,
    0x00,0x80, 0x20,0x00,
    0x01,0x00, 0x10,0x00,
    0x02,0x00, 0x08,0x00,
    0x04,0x00, 0x04,0x00,
    0x08,0x00, 0x02,0x00,
    0x10,0x00, 0x01,0x00,
    0x20,0x00, 0x00,0x80,
    0x40,0x00, 0x00,0x40,
    0x80,0x00, 0x00,0x20,/* CROSS 27x27 = 6.0 */

    0x00,0x00, 0x00,0x00,
    0x00,0x00, 0x00,0x00,
    0x20,0x00, 0x00,0x04,
    0x10,0x00, 0x00,0x08,
    0x08,0x00, 0x00,0x10,
    0x04,0x00, 0x00,0x20,
    0x02,0x00, 0x00,0x40,
    0x01,0x00, 0x00,0x80,
    0x00,0x80, 0x01,0x00,
    0x00,0x40, 0x02,0x00,
    0x00,0x20, 0x04,0x00,
    0x00,0x10, 0x08,0x00,
    0x00,0x08, 0x10,0x00,
    0x00,0x04, 0x20,0x00,
    0x00,0x02, 0x40,0x00,
    0x00,0x01, 0x80,0x00,
    0x00,0x01, 0x80,0x00,
    0x00,0x02, 0x40,0x00,
    0x00,0x04, 0x20,0x00,
    0x00,0x08, 0x10,0x00,
    0x00,0x10, 0x08,0x00,
    0x00,0x20, 0x04,0x00,
    0x00,0x40, 0x02,0x00,
    0x00,0x80, 0x01,0x00,
    0x01,0x00, 0x00,0x80,
    0x02,0x00, 0x00,0x40, 
    0x04,0x00, 0x00,0x20,
    0x08,0x00, 0x00,0x10,
    0x10,0x00, 0x00,0x08,
    0x20,0x00, 0x00,0x04,
    0x00,0x00, 0x00,0x00,
    0x00,0x00, 0x00,0x00,/* CROSS 32x32 = 6.5 */

    0x00,0x00, 0x00,0x00,
    0x40,0x00, 0x00,0x02,
    0x20,0x00, 0x00,0x04,
    0x10,0x00, 0x00,0x08,
    0x08,0x00, 0x00,0x10,
    0x04,0x00, 0x00,0x20,
    0x02,0x00, 0x00,0x40,
    0x01,0x00, 0x00,0x80,
    0x00,0x80, 0x01,0x00,
    0x00,0x40, 0x02,0x00,
    0x00,0x20, 0x04,0x00,
    0x00,0x10, 0x08,0x00,
    0x00,0x08, 0x10,0x00,
    0x00,0x04, 0x20,0x00,
    0x00,0x02, 0x40,0x00,
    0x00,0x01, 0x80,0x00,
    0x00,0x01, 0x80,0x00,
    0x00,0x02, 0x40,0x00,
    0x00,0x04, 0x20,0x00,
    0x00,0x08, 0x10,0x00,
    0x00,0x10, 0x08,0x00,
    0x00,0x20, 0x04,0x00,
    0x00,0x40, 0x02,0x00, 
    0x00,0x80, 0x01,0x00,
    0x01,0x00, 0x00,0x80,
    0x02,0x00, 0x00,0x40,
    0x04,0x00, 0x00,0x20,
    0x08,0x00, 0x00,0x10,
    0x10,0x00, 0x00,0x08,
    0x20,0x00, 0x00,0x04,
    0x40,0x00, 0x00,0x02,
    0x00,0x00, 0x00,0x00/* CROSS 32x32 = 7.0 */
};

/*----------------------------------------------------------------------*/

//TsmInitAttributes
void OpenGl_Display::InitAttributes ()
{
  // Return if already initialized
  if (myLinestyleBase) return;

  myLinestyleBase = glGenLists(5);

  /* Line */

  glNewList( (GLuint)myLinestyleBase+(GLuint)Aspect_TOL_DASH, GL_COMPILE );
  glLineStipple(1,  DASH_LS );
  glEndList();

  glNewList( (GLuint)myLinestyleBase+(GLuint)Aspect_TOL_DOT, GL_COMPILE );
  glLineStipple(1,  DOT_LS );
  glEndList();

  glNewList( (GLuint)myLinestyleBase+(GLuint)Aspect_TOL_DOTDASH, GL_COMPILE );
  glLineStipple(1,  DASH_DOT_LS );
  glEndList();

  glNewList( (GLuint)myLinestyleBase+(GLuint)Aspect_TOL_USERDEFINED, GL_COMPILE );
  glLineStipple(1,  DASH_DDOT_LS );
  glEndList();

  /* FSXXX
  * GL_POLYGON_STIPPLE
  * need 32x32 stipple patterns
  */
  const int nbi = sizeof(myInteriors)/(32*sizeof(unsigned int));
  myPatternBase = glGenLists(TEL_HS_USER_DEF_START);
  int i;
  for( i = 1; i < TEL_HS_USER_DEF_START; i++ )
  {
    glNewList( (GLuint)myPatternBase + i, GL_COMPILE );
	glPolygonStipple((const GLubyte *) (myInteriors[i<nbi? i : 0]));
    glEndList();
  }

  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

  myMarkerBase = glGenLists (60);
  int j;
  for( i = 1; i < TEL_NB_OF_LISTS; i++ )
    for( j = 0; j < TEL_NO_OF_SIZES; j++ )
    {           
      const Tfloat w = arrPMFontInfo[i][j].width;
      const Tfloat h = arrPMFontInfo[i][j].height;
      const Tint offset = arrPMFontInfo[i][j].offset;

      glNewList( (const GLuint)(arrPMFontInfo[i][j].str[0] + myMarkerBase), GL_COMPILE );
      glBitmap( (GLsizei)w, (GLsizei)h, (GLfloat)(0.5f * w), (GLfloat)(0.5f * h), 0.f, 0.f, (const GLubyte *) &myMarkerRaster[offset] );
      glEndList();
    }
}

/*----------------------------------------------------------------------*/

#define TEL_PM_START_SIZE 1.F
#define TEL_PM_END_SIZE   7.F

//TelGetStringForPM
const char * OpenGl_Display::GetStringForMarker (const Aspect_TypeOfMarker AType, const Tfloat AVal) const
{
  const int atype = (int)(( AType > Aspect_TOM_O_X )? Aspect_TOM_X : AType);

  const float index = ( float )(TEL_NO_OF_SIZES-1) * (AVal - ( float )TEL_PM_START_SIZE ) / ( float )(TEL_PM_END_SIZE - TEL_PM_START_SIZE);
  int id = (int)(index + 0.5F);
  if (id < 0) id = 0;
  else if (id >= TEL_NO_OF_SIZES) id = TEL_NO_OF_SIZES-1;

  return arrPMFontInfo[atype][id].str;
}

/*----------------------------------------------------------------------*/

void OpenGl_Display::SetBaseForMarker () const
{
  glListBase( (const GLuint) myMarkerBase );
}

/*----------------------------------------------------------------------*/

void OpenGl_Display::SetTypeOfLine (const Aspect_TypeOfLine AType) const
{
  if (AType != Aspect_TOL_SOLID)
  {
    glCallList((GLuint)myLinestyleBase+(GLuint)AType);
    glEnable( GL_LINE_STIPPLE );
#ifdef HAVE_GL2PS
    gl2psEnable( GL2PS_LINE_STIPPLE );
#endif
  }
  else
  {
    glDisable( GL_LINE_STIPPLE );
#ifdef HAVE_GL2PS
    gl2psDisable( GL2PS_LINE_STIPPLE );
#endif
  }
}

/*----------------------------------------------------------------------*/

void OpenGl_Display::SetTypeOfHatch (const int AType) const
{
  if (AType)
  {
    glCallList((GLuint)myPatternBase+(GLuint)AType);
    glEnable( GL_POLYGON_STIPPLE );
  }
  else
    glDisable( GL_POLYGON_STIPPLE );
}

/*----------------------------------------------------------------------*/
