// Created on: 1991-04-16
// Created by: Arnaud BOUZY
// Copyright (c) 1991-1999 Matra Datavision
// Copyright (c) 1999-2012 OPEN CASCADE SAS
//
// The content of this file is subject to the Open CASCADE Technology Public
// License Version 6.5 (the "License"). You may not use the content of this file
// except in compliance with the License. Please obtain a copy of the License
// at http://www.opencascade.org and read it completely before using this file.
//
// The Initial Developer of the Original Code is Open CASCADE S.A.S., having its
// main offices at: 1, place des Freres Montgolfier, 78280 Guyancourt, France.
//
// The Original Code and all software distributed under the License is
// distributed on an "AS IS" basis, without warranty of any kind, and the
// Initial Developer hereby disclaims all such warranties, including without
// limitation, any warranties of merchantability, fitness for a particular
// purpose or non-infringement. Please see the License for the specific terms
// and conditions governing the rights and limitations under the License.


#include <Expr_UnaryMinus.ixx>
#include <Expr_NumericValue.hxx>
#include <Expr_Operators.hxx>
#include <Expr.hxx>
#include <Standard_OutOfRange.hxx>

Expr_UnaryMinus::Expr_UnaryMinus(const Handle(Expr_GeneralExpression)& exp)
{
  CreateOperand(exp);
}

Handle(Expr_GeneralExpression) Expr_UnaryMinus::ShallowSimplified () const
{
  Handle(Expr_GeneralExpression) myexp = Operand();
  if (myexp->IsKind(STANDARD_TYPE(Expr_NumericValue))) {
    Handle(Expr_NumericValue) myNVexp = Handle(Expr_NumericValue)::DownCast(myexp);
    return new Expr_NumericValue(-myNVexp->GetValue());
  }
  if (myexp->IsKind(STANDARD_TYPE(Expr_UnaryMinus))) {
    return myexp->SubExpression(1);
  }
  Handle(Expr_UnaryMinus) me = this;
  return me;
}

Handle(Expr_GeneralExpression) Expr_UnaryMinus::Copy () const
{
  return -(Expr::CopyShare(Operand()));
}

Standard_Boolean Expr_UnaryMinus::IsIdentical (const Handle(Expr_GeneralExpression)& Other) const
{
  if (Other->IsKind(STANDARD_TYPE(Expr_UnaryMinus))) {
    Handle(Expr_GeneralExpression) myexp = Operand();
    return myexp->IsIdentical(Other->SubExpression(1));
  }
  return Standard_False;
}

Standard_Boolean Expr_UnaryMinus::IsLinear () const
{
  Handle(Expr_GeneralExpression) myexp = Operand();
  return myexp->IsLinear();
}

Handle(Expr_GeneralExpression) Expr_UnaryMinus::Derivative (const Handle(Expr_NamedUnknown)& X) const
{
  Handle(Expr_GeneralExpression) myder = Operand();
  myder = myder->Derivative(X);
  Handle(Expr_UnaryMinus) resu = - myder;
  return resu->ShallowSimplified();
}

Handle(Expr_GeneralExpression) Expr_UnaryMinus::NDerivative (const Handle(Expr_NamedUnknown)& X, const Standard_Integer N) const
{
  if (N <= 0) {
    Standard_OutOfRange::Raise();
  }
  Handle(Expr_GeneralExpression) myder = Operand();
  myder = myder->NDerivative(X,N);
  Handle(Expr_UnaryMinus) resu = - myder;
  return resu->ShallowSimplified();
}

Standard_Real Expr_UnaryMinus::Evaluate(const Expr_Array1OfNamedUnknown& vars, const TColStd_Array1OfReal& vals) const
{
  return - Operand()->Evaluate(vars,vals);
}

TCollection_AsciiString Expr_UnaryMinus::String() const
{
  TCollection_AsciiString str;
  Handle(Expr_GeneralExpression) op = Operand();
  if (op->NbSubExpressions() > 1) {
    str = "-(";
    str += op->String();
    str += ")";
  }
  else {
    str = "-";
    str += op->String();
  }
  return str;
}
