// Created on: 1993-08-10
// Created by: Remi LEQUETTE
// Copyright (c) 1993-1999 Matra Datavision
// Copyright (c) 1999-2012 OPEN CASCADE SAS
//
// The content of this file is subject to the Open CASCADE Technology Public
// License Version 6.5 (the "License"). You may not use the content of this file
// except in compliance with the License. Please obtain a copy of the License
// at http://www.opencascade.org and read it completely before using this file.
//
// The Initial Developer of the Original Code is Open CASCADE S.A.S., having its
// main offices at: 1, place des Freres Montgolfier, 78280 Guyancourt, France.
//
// The Original Code and all software distributed under the License is
// distributed on an "AS IS" basis, without warranty of any kind, and the
// Initial Developer hereby disclaims all such warranties, including without
// limitation, any warranties of merchantability, fitness for a particular
// purpose or non-infringement. Please see the License for the specific terms
// and conditions governing the rights and limitations under the License.



#include <BRep_PointOnCurveOnSurface.ixx>


//=======================================================================
//function : BRep_PointOnCurveOnSurface
//purpose  : 
//=======================================================================

BRep_PointOnCurveOnSurface::BRep_PointOnCurveOnSurface
  (const Standard_Real P, 
   const Handle(Geom2d_Curve)& C,
   const Handle(Geom_Surface)& S,
   const TopLoc_Location& L) :
  BRep_PointsOnSurface(P,S,L),
  myPCurve(C)
{
}


//=======================================================================
//function : IsPointOnCurveOnSurface
//purpose  : 
//=======================================================================

Standard_Boolean  BRep_PointOnCurveOnSurface::IsPointOnCurveOnSurface()const 
{
  return Standard_True;
}


//=======================================================================
//function : IsPointOnCurveOnSurface
//purpose  : 
//=======================================================================

Standard_Boolean  BRep_PointOnCurveOnSurface::IsPointOnCurveOnSurface
  (const Handle(Geom2d_Curve)& PC,
   const Handle(Geom_Surface)& S, 
   const TopLoc_Location& L)const 
{
  return (myPCurve == PC) && (Surface() == S) && (Location() == L);
}


//=======================================================================
//function : PCurve
//purpose  : 
//=======================================================================

const Handle(Geom2d_Curve)&  BRep_PointOnCurveOnSurface::PCurve()const 
{
  return myPCurve;
}


//=======================================================================
//function : PCurve
//purpose  : 
//=======================================================================

void  BRep_PointOnCurveOnSurface::PCurve(const Handle(Geom2d_Curve)& C)
{
  myPCurve = C;
}


