// Created on: 1995-03-14
// Created by: Modelistation
// Copyright (c) 1995-1999 Matra Datavision
// Copyright (c) 1999-2012 OPEN CASCADE SAS
//
// The content of this file is subject to the Open CASCADE Technology Public
// License Version 6.5 (the "License"). You may not use the content of this file
// except in compliance with the License. Please obtain a copy of the License
// at http://www.opencascade.org and read it completely before using this file.
//
// The Initial Developer of the Original Code is Open CASCADE S.A.S., having its
// main offices at: 1, place des Freres Montgolfier, 78280 Guyancourt, France.
//
// The Original Code and all software distributed under the License is
// distributed on an "AS IS" basis, without warranty of any kind, and the
// Initial Developer hereby disclaims all such warranties, including without
// limitation, any warranties of merchantability, fitness for a particular
// purpose or non-infringement. Please see the License for the specific terms
// and conditions governing the rights and limitations under the License.



#ifndef DEB
#define No_Standard_OutOfRange
#define No_Standard_RangeError
#endif


#include <AppCont_ContMatrices.hxx>
#include <math_Matrix.hxx>
#include <Standard_DimensionError.hxx>

static const Standard_Real IMatrix[] = {
4.0, -2.0,
-2.0, 4.0,


 9.0, -9.0,  3.0,
-9.0, 21.0, -9.0,
 3.0, -9.0,  9.0,


16.0, -24.0, 16.0, -4.0, 
-24.0, 69.33333333333333333333333, -57.333333333333333333333, 16.0,
16.0, -57.33333333333333333333333, 69.333333333333333333333, -24.0,
-4.0, 16.0, -24.0, 16.0,


25.0,  -50.0,   50.0,  -25.0,   5.0, 
-50.0, 175.0, -212.5,  117.5, -25.0,
50.0, -212.5,  330.0, -212.5,  50.0,
-25.0, 117.5, -212.5,  175.0, -50.0,
5.0,   -25.0,   50.0,  -50.0,  25.0,  


 36.0,  -90.0,   120.0,   -90.0,   36.0,  -6.0,
-90.0,  372.0,  -594.0,   489.6, -207.6,  36.0,
120.0, -594.0,  1144.8, -1064.4,  489.6, -90.0,
-90.0,  489.6, -1064.4,  1144.8, -594.0, 120.0,
36.0,  -207.6,   489.6,  -594.0,  372.0, -90.0,
-6.0,    36.0,   -90.0,   120.0,  -90.0,  36.0,


49.0, -147.0, 245.0, -245.0, 147.0, -49.0, 7.0,
-147.0, 702.3333333333333333333333, -1388.333333333333333333333, 1519.0,
-963.6666666666666666666666, 333.6666666666666666666666666, -49.0,
245.0, -1388.33333333333333333333333, 3211.133333333333333333333333333, -3890.6,
2646.4666666666666666666666666, -963.6666666666666666666666, 147.0, -245.0, 1519.0,
-3890.6, 5240.2, -3890.6, 1519.0, -245.0, 147.0, -963.66666666666666666666666,
2646.46666666666666666666666, -3890.6, 3211.1333333333333333333333, 
-1388.333333333333333333333, 245.0, -49.0, 333.666666666666666666666666666, -963.6666666666666666666666, 1519.0, -1388.3333333333333333333333333, 
702.33333333333333333333333, -147.0, 7.0, -49.0, 147.0, -245.0, 245.0, -147.0, 49.0,


64.0, -224.0, 448.0, -560.0, 448.0, -224.0, 64.0, -8.0, 
-224.0, 1216.0, -2864.0, 3904.0, -3296.0, 1709.7142857142857142857, -501.7142857142857142857, 64.0, 
448.0, -2864.0, 7744.0, -11552.0, 10377.142857142857142857, -5630.857142857142857142857, 1709.71428571428571428, -224.0, 
-560.0, 3904.0, -11552.0, 18770.2857142857142857, -18083.42857142857142857, 10377.142857142857142857, -3296.0, 448.0, 
448.0, -3296.0, 10377.1428571428571428, -18083.42857142857142857, 18770.2857142857142857, -11552.0, 3904.0, -560.0, 
-224.0, 1709.7142857142857142857, -5630.8571428571428571428, 10377.142857142857142857, -11552.0, 7744.0, -2864.0, 448.0, 
64.0, -501.7142857142857142857, 1709.7142857142857142857, -3296.0, 3904.0, -2864.0, 1216.0, -224.0, 
-8.0, 64.0, -224.0, 448.0, -560.0, 448.0, -224.0, 64.0,


81.0, -324.0, 756.0, -1134.0, 1134.0, -756.0, 324.0, -81.0, 9.0, 
-324.0, 1971.0, -5386.5, 8788.5, -9261.0, 6399.0, -2814.75, 717.75, -81.0, 
756.0, -5386.5, 16686.0, -29551.5, 32955.42857142857142857142, -23730.1071428571428571428, 10770.42857142857142857, -2814.75, 324.0, 
-1134.0, 8788.5, -29551.5, 56318.142857142857142857, -66645.642857142857142857, 50320.6071428571428571428, -23730.10714285714285714, 6399.0, -756.0, 
1134.0, -9261.0, 32955.42857142857142857, -66645.642857142857142857, 83643.42857142857142857142857, -66645.642857142857142857, 32955.4285714285714285714, -9261.0, 1134.0, 
-756.0, 6399.0, -23730.1071428571428571428, 50320.6071428571428571428, -66645.642857142857142857, 56318.142857142857142857, -29551.5, 8788.5, -1134.0, 
324.0, -2814.75, 10770.42857142857142857, -23730.1071428571428571428, 32955.42857142857142857, -29551.5, 16686.0, -5386.5, 756.0, 
-81.0, 717.75, -2814.75, 6399.0, -9261.0, 8788.5, -5386.5, 1971.0, -324.0, 
9.0, -81.0, 324.0, -756.0, 1134.0, -1134.0, 756.0, -324.0, 81.0, 



100.0, -450.0, 1200.0, -2100.0, 2520.0, -2100.0, 1200.0, -450.0, 100.0, -10.0, 
-450.0, 3033.333333333333333333333, -9433.3333333333333333333, 17920.0, -22633.33333333333333333333, 19533.3333333333333333333, -11450.0, 4377.777777777777777777777, -987.777777777777777777, 100.0, 
1200.0, -9433.33333333333333333, 32953.33333333333333333333, -67550.0, 89933.33333333333333333333, -80658.33333333333333333333, 48683.333333333333333333333, -19046.111111111111111111111, 4377.7777777777777777777, -450.0, 
-2100.0, 17920.0, -67550.0, 147814.28571428571428, -207367.8571428571428571428, 193909.523809523809523809, -121049.2857142857142857, 48683.33333333333333333333, -11450.0, 1200.0, 
2520.0, -22633.3333333333333333333, 89933.33333333333333333333, -207367.8571428571428571428, 305673.01587301587301587301587, -298799.6825396825396825, 193909.523809523809523809, -80658.333333333333333333, 19533.333333333333333333, -2100.0, 
-2100.0, 19533.333333333333333333, -80658.3333333333333333333, 193909.523809523809523809, -298799.6825396825396825, 305673.01587301587301587301587, -207367.8571428571428571428, 89933.333333333333333333, -22633.33333333333333333, 2520.0, 
1200.0, -11450.0, 48683.333333333333333333, -121049.2857142857142857, 193909.523809523809523809, -207367.8571428571428571428, 147814.28571428571428, -67550.0, 17920.0, -2100.0, 
-450.0, 4377.77777777777777777, -19046.111111111111111111111, 48683.33333333333333333333, -80658.3333333333333333333, 89933.333333333333333333333, -67550.0, 32953.3333333333333333333, -9433.333333333333333333, 1200.0, 
100.0, -987.777777777777777777, 4377.7777777777777777, -11450.0, 19533.33333333333333333, -22633.33333333333333333, 17920.0, -9433.3333333333333333333, 3033.3333333333333333, -450.0, 
-10.0, 100.0, -450.0, 1200.0, -2100.0, 2520.0, -2100.0, 1200.0, -450.0, 100.0,



121.0, -605.0, 1815.0, -3630.0, 5082.0, -5082.0, 3630.0, -1815.0, 605.0, -121.0,11.0, 
-605.0, 4477.0, -15609.0, 33831.6, -49803.6, 51546.0, -37752.0, 19239.0, -6509.8, 1317.8, -121.0, 
1815.0, -15609.0, 60717.8, -141376.4, 218719.6, -234740.0, 176740.6666666666666666667, -92048.7333333333333333333, 31696.86666666666666666667, -6509.8, 605.0, 
-3630.0, 33831.6, -141376.4, 349423.8, -566824.5, 631720.833333333333333333, -490328.3, 261818.7, -92048.7333333333333333333, 19239.0, -1815.0, 
5082.0, -49803.6, 218719.6, -566824.5, 960256.0, -1111949.666666666666666667 , 892240.8, -490328.3, 176740.6666666666666666667, -37752.0, 3630.0, 
-5082.0, 51546.0, -234740.0, 631720.833333333333333333, -1111949.666666666666666667, 1337020.666666666666666667, -1111949.666666666666666667, 631720.833333333333333333, -234740.0, 51546.0, -5082.0, 
3630.0, -37752.0, 176740.6666666666666666667, -490328.3, 892240.8, -1111949.666666666666666667, 960256.0, -566824.5, 218719.6, -49803.6, 5082.0, 
-1815.0, 19239.0, -92048.7333333333333333333, 261818.7, -490328.3, 631720.833333333333333333, -566824.5, 349423.8, -141376.4, 33831.6, -3630.0, 
605.0, -6509.8, 31696.86666666666666666667, -92048.7333333333333333333, 176740.6666666666666666667, -234740.0, 218719.6, -141376.4, 60717.8, -15609.0, 1815.0, 
-121.0, 1317.8, -6509.8, 19239.0, -37752.0, 51546.0, -49803.6, 33831.6, -15609.0, 4477.0, -605.0, 
11.0, -121.0, 605.0, -1815.0, 3630.0, -5082.0, 
5082.0, -3630.0, 1815.0, -605.0, 121.0,





144.0, -792.0, 2640.0, -5940.0, 9504.0, -11088.0, 9504.0, -5940.0, 2640.0, -792.0, 144.0, -12.0, 
-792.0, 6384.0, -24660.0, 60048.0, -100944.0, 121824.0, -107028.0, 68160.0, -30744.0, 9333.81818181818181818182, -1713.818181818181818181818, 144.0, 
2640.0, -24660.0, 105724.8, -275601.6, 485740.8, -606852.0, 547392.0, -355910.4, 163246.2545454545454545455, -50249.67272727272727272727, 9333.81818181818181818182, -792.0,-5940.0, 60048.0, -275601.6, 759427.2, -1.3983336e06 , 1.808704e06, -1.677792e06, 1.116207709090909090909091e06, -521849.9636363636363636364, 163246.2545454545454545455, -30744.0, 2640.0, 
9504.0, -100944.0, 485740.8, -1.3983336e06, 2.6774368e06, -3.583176e06, 3.422954181818181818181818e06, -2.335687490909090909090909e06, 1.116207709090909090909091e06, 
-355910.4, 68160.0, -5940.0, 
-11088.0, 121824.0, -606852.0, 1.808704e06, -3.583176e06, 4.954023272727272727272727e06, -4.878453454545454545454545e06, 3.422954181818181818181818e06, -1.677792e06, 547392.0, -107028.0, 9504.0, 
9504.0, -107028.0, 547392.0, -1.677792e06, 3.422954181818181818181818e06, -4.878453454545454545454545e06, 4.954023272727272727272727e06, -3.583176e06, 1.808704e06, -606852.0, 121824.0, -11088.0, 
-5940.0, 68160.0, -355910.4, 1.116207709090909090909091e06, -2.335687490909090909090909e06, 3.422954181818181818181818e06, -3.583176e06, 2.6774368e06, -1.3983336e06, 485740.8, -100944.0, 9504.0, 
2640.0, -30744.0, 163246.2545454545454545455, -521849.9636363636363636364, 1.116207709090909090909091e06, -1.677792e06, 1.808704e06, -1.3983336e06, 759427.2, -275601.6, 60048.0, -5940.0, 
-792.0, 9333.81818181818181818182, -50249.67272727272727272727, 163246.2545454545454545455, -355910.4, 547392.0, -606852.0, 485740.8, -275601.6, 105724.8, -24660.0, 2640.0,144.0, -1713.818181818181818181818, 9333.81818181818181818182, -30744.0, 68160.0, -107028.0, 121824.0, -100944.0, 60048.0, -24660.0, 6384.0, -792.0, 
-12.0, 144.0, -792.0, 2640.0, -5940.0, 9504.0, -11088.0, 9504.0, -5940.0, 2640.0, -792.0, 144.0,




169.0,-1014.0,3718.0,-9295.0,16731.0,-22308.0,22308.0,-16731.0,9295.0,-3718.0,1014.0,-169.0,13.0,
-1014.0,8844.33333333333333333333,-37489.83333333333333333333,101315.5,-191477.0,263978.0,-270484.5,206658.8333333333333333333,-116497.3333333333333333333,47151.0,-12984.83333333333333333333,2181.833333333333333333333,-169.00,
3718.0,-37489.83333333333333333333,175647.3333333333333333333,-506746.5,1.00217e6,-1.4283035e6,1.501058e6,-1.169958833333333333333333e6,670233.515151515151515152,-274893.8636363636363636364,76549.5151515151515151515,-12984.83333333333333333333,1014.0,
-9295.0,101315.5,-506746.5,1.540435e6,-3.17382e6,4.6724275e6,-5.0403405e6,4.013534909090909090909091e6,-2.340573181818181818181818e6,974536.136363636363636364,-274893.8636363636363636364,47151.0,-3718.0,
16731.0,-191477.0,1.00217e6,-3.17382e6,6.778496111111111111111111e6,-1.029324544444444444444444e7,1.140291139393939393939394e7, -9.28986171717171717171717e6,5.525650656565656565656566e6,-2.340573181818181818181818e6,670233.515151515151515152,-116497.3333333333333333333,9295.0,
-22308.0,263978.0,-1.4283035e6,4.6724275e6,-1.029324544444444444444444e7,1.609035514141414141414141e7,-1.830653834848484848484848e7,1.52800054595959595959596e7,-9.28986171717171717171717e6,4.013534909090909090909091e6,-1.169958833333333333333333e6,206658.8333333333333333333,-16731.0,
22308.0,-270484.5,1.501058e6,-5.0403405e6,1.140291139393939393939394e7,-1.830653834848484848484848e7,2.138218490909090909090909e7,-1.830653834848484848484848e7, 1.140291139393939393939394e7,-5.0403405e6,1.501058e6,-270484.5,22308.0,
-16731.0,206658.8333333333333333333,-1.169958833333333333333333e6,4.013534909090909090909091e6,-9.28986171717171717171717e6,1.52800054595959595959596e7,-1.830653834848484848484848e7,1.609035514141414141414141e7,-1.029324544444444444444444e7,4.6724275e6,-1.4283035e6,263978.0,-22308.0,
9295.0,-116497.3333333333333333333,670233.515151515151515152,-2.340573181818181818181818e6,5.525650656565656565656566e6,-9.28986171717171717171717e6,1.140291139393939393939394e7,-1.029324544444444444444444e7,6.778496111111111111111111e6,-3.17382e6,1.00217e6,-191477.0,16731.0,
-3718.0,47151.0,-274893.8636363636363636364,974536.136363636363636364,-2.340573181818181818181818e6,4.013534909090909090909091e6,-5.0403405e6,4.6724275e6,-3.17382e6,1.540435e6,-506746.5,101315.5,-9295.0,
1014.0,-12984.83333333333333333333,76549.5151515151515151515,-274893.8636363636363636364,670233.515151515151515152,-1.169958833333333333333333e6,1.501058e6,-1.4283035e6,1.00217e6,-506746.5,175647.3333333333333333333,-37489.83333333333333333333,3718.0,
-169.0,2181.833333333333333333333,-12984.83333333333333333333,47151.0,-116497.3333333333333333333,206658.8333333333333333333,-270484.5,263978.0,-191477.0,101315.5,-37489.83333333333333333333,8844.33333333333333333333,-1014.0,
13.0,-169.0,1014.0,-3718.0,9295.0,-16731.0,22308.0,-22308.0,16731.0,-9295.0,3718.0,-1014.0,169.0,




196.,-1274.,5096.,-14014.,28028.,-42042.,48048.,
     -42042.,28028.,-14014.,5096.,-1274.,196.,-14.,
-1274.,11956.,-55174.,163856.,-343882.,533148.,-624162.,556248.,
     -376222.,190316.,-69874.,17609.84615384615384615385,
     -2727.846153846153846153846,196.,
5096.,-55174.,280476.,-887194.,1.945328e6,-3.114342e6,3.736348e6,
     -3.394622e6,2.332008e6,-1.194914e6,443457.5384615384615384615,
     -112789.3846153846153846154,17609.84615384615384615385,-1274.,
-14014.,163856.,-887194.,2.949436e6,-6.722702e6,1.1097128e7,
     -1.3645422e7,1.265007163636363636363636e7,-8.83745290909090909090909e6,
     4.592989986013986013986014e6,-1.725362251748251748251748e6,
     443457.5384615384615384615,-69874.,5096.,
28028.,-343882.,1.945328e6,-6.722702e6,1.584562e7,-2.6916778e7,
     3.391765745454545454545455e7,-3.211006527272727272727273e7,
     2.284201955244755244755245e7,-1.205958972027972027972028e7,
     4.592989986013986013986014e6,-1.194914e6,190316.,-14014.,
-42042.,533148.,-3.114342e6,1.1097128e7,-2.6916778e7,
     4.694554581818181818181818e7,-6.059096781818181818181818e7,
     5.861555714685314685314685e7,-4.251561579020979020979021e7,
     2.284201955244755244755245e7,-8.83745290909090909090909e6,2.332008e6,
     -376222.,28028.,48048.,-624162.,3.736348e6,-1.3645422e7,
     3.391765745454545454545455e7,-6.059096781818181818181818e7,
     8.00337038601398601398601e7,-7.9150339006993006993007e7,
     5.861555714685314685314685e7,-3.211006527272727272727273e7,
     1.265007163636363636363636e7,-3.394622e6,556248.,-42042.,
-42042.,556248.,-3.394622e6,1.265007163636363636363636e7,
     -3.211006527272727272727273e7,5.861555714685314685314685e7,
     -7.9150339006993006993007e7,8.00337038601398601398601e7,
     -6.059096781818181818181818e7,3.391765745454545454545455e7,-1.3645422e7,
     3.736348e6,-624162.,48048.,
28028.,-376222.,2.332008e6,-8.83745290909090909090909e6,
     2.284201955244755244755245e7,-4.251561579020979020979021e7,
     5.861555714685314685314685e7,-6.059096781818181818181818e7,
     4.694554581818181818181818e7,-2.6916778e7,1.1097128e7,-3.114342e6,
     533148.,-42042.,-14014.,190316.,-1.194914e6,
     4.592989986013986013986014e6,-1.205958972027972027972028e7,
     2.284201955244755244755245e7,-3.211006527272727272727273e7,
     3.391765745454545454545455e7,-2.6916778e7,1.584562e7,-6.722702e6,
     1.945328e6,-343882.,28028.,
5096.,-69874.,443457.5384615384615384615,
     -1.725362251748251748251748e6,4.592989986013986013986014e6,
     -8.83745290909090909090909e6,1.265007163636363636363636e7,-1.3645422e7,
     1.1097128e7,-6.722702e6,2.949436e6,-887194.,163856.,-14014.,
-1274.,17609.84615384615384615385,-112789.3846153846153846154,
     443457.5384615384615384615,-1.194914e6,2.332008e6,-3.394622e6,3.736348e6,
     -3.114342e6,1.945328e6,-887194.,280476.,-55174.,5096.,
196.,-2727.846153846153846153846,17609.84615384615384615385,-69874.,
     190316.,-376222.,556248.,-624162.,533148.,-343882.,163856.,-55174.,
     11956.,-1274.,-14.,196.,-1274.,5096.,-14014.,28028.,-42042.,48048.,
     -42042.,28028.,-14014.,5096.,-1274.,196.0,




225.,-1575.,6825.,-20475.,45045.,-75075.,96525.,
     -96525.,75075.,-45045.,20475.,-6825.,1575.,-225.,15.,
-1575.,15825.,-78975.,255645.,-589875.,1.015810714285714285714286e6,
     -1.337560714285714285714286e6,1.362075e6,-1.074645e6,652275.,-299325.,
     100575.,-23367.85714285714285714286,3357.857142857142857142857,-225.,
6825.,-78975.,432945.,-1.489875e6,3.586982142857142857142857e6,
     -6.372417857142857142857143e6,8.59261071428571428571429e6,-8.915445e6,
     7.141275e6,-4.388925e6,2.035228846153846153846154e6,
     -689961.263736263736263736,161540.2747252747252747253,
     -23367.85714285714285714286,1575.,
-20475.,255645.,-1.489875e6,5.377339285714285714285714e6,
     -1.343394642857142857142857e7,2.457168214285714285714286e7,-3.3917895e7,
     3.5873775e7,-2.9197425e7,1.818794423076923076923077e7,
     -8.5319282967032967032967e6,2.92138532967032967032967e6,
     -689961.263736263736263736,100575.,-6825.,
45045.,-589875.,3.586982142857142857142857e6,
     -1.343394642857142857142857e7,3.463933928571428571428571e7,-6.5081295e7,
     9.19092068181818181818182e7,-9.91241522727272727272727e7,
     8.20435736013986013986014e7,-5.185833469030969030969031e7,
     2.463902099400599400599401e7,-8.5319282967032967032967e6,
     2.035228846153846153846154e6,-299325.,20475.,
-75075.,1.015810714285714285714286e6,-6.372417857142857142857143e6,
     2.457168214285714285714286e7,-6.5081295e7,1.252944613636363636363636e8,
     -1.808700477272727272727273e8,1.989428868881118881118881e8,
     -1.675862615634365634365634e8,1.076123564985014985014985e8,
     -5.185833469030969030969031e7,1.818794423076923076923077e7,-4.388925e6,
     652275.,-45045.,96525.,-1.337560714285714285714286e6,
     8.59261071428571428571429e6,-3.3917895e7,9.19092068181818181818182e7,
     -1.808700477272727272727273e8,2.666011578671328671328671e8,
     -2.990534963286713286713287e8,2.565779223326673326673327e8,
     -1.675862615634365634365634e8,8.20435736013986013986014e7,-2.9197425e7,
     7.141275e6,-1.074645e6,75075.,
-96525.,1.362075e6,-8.915445e6,3.5873775e7,
     -9.91241522727272727272727e7,1.989428868881118881118881e8,
     -2.990534963286713286713287e8,3.420217784265734265734266e8,
     -2.990534963286713286713287e8,1.989428868881118881118881e8,
     -9.91241522727272727272727e7,3.5873775e7,-8.915445e6,1.362075e6,-96525.,
75075.,-1.074645e6,7.141275e6,-2.9197425e7,
     8.20435736013986013986014e7,-1.675862615634365634365634e8,
     2.565779223326673326673327e8,-2.990534963286713286713287e8,
     2.666011578671328671328671e8,-1.808700477272727272727273e8,
     9.19092068181818181818182e7,-3.3917895e7,8.59261071428571428571429e6,
     -1.337560714285714285714286e6,96525.,
-45045.,652275.,-4.388925e6,1.818794423076923076923077e7,
     -5.185833469030969030969031e7,1.076123564985014985014985e8,
     -1.675862615634365634365634e8,1.989428868881118881118881e8,
     -1.808700477272727272727273e8,1.252944613636363636363636e8,-6.5081295e7,
     2.457168214285714285714286e7,-6.372417857142857142857143e6,
     1.015810714285714285714286e6,-75075.,
20475.,-299325.,2.035228846153846153846154e6,
     -8.5319282967032967032967e6,2.463902099400599400599401e7,
     -5.185833469030969030969031e7,8.20435736013986013986014e7,
     -9.91241522727272727272727e7,9.19092068181818181818182e7,-6.5081295e7,
     3.463933928571428571428571e7,-1.343394642857142857142857e7,
     3.586982142857142857142857e6,-589875.,45045.,
-6825.,100575.,-689961.263736263736263736,
     2.92138532967032967032967e6,-8.5319282967032967032967e6,
     1.818794423076923076923077e7,-2.9197425e7,3.5873775e7,-3.3917895e7,
     2.457168214285714285714286e7,-1.343394642857142857142857e7,
     5.377339285714285714285714e6,-1.489875e6,255645.,-20475.,
1575.,-23367.85714285714285714286,161540.2747252747252747253,
     -689961.263736263736263736,2.035228846153846153846154e6,-4.388925e6,
     7.141275e6,-8.915445e6,8.59261071428571428571429e6,
     -6.372417857142857142857143e6,3.586982142857142857142857e6,-1.489875e6,
     432945.,-78975.,6825.,-225.,3357.857142857142857142857,
     -23367.85714285714285714286,100575.,-299325.,652275.,-1.074645e6,
     1.362075e6,-1.337560714285714285714286e6,1.015810714285714285714286e6,
     -589875.,255645.,-78975.,15825.,-1575.,
15.,-225.,1575.,-6825.,20475.,-45045.,75075.,-96525.,96525.,-75075.,
     45045.,-20475.,6825.,-1575.,225.0,



256.,-1920.,8960.,-29120.,69888.,-128128.,183040.,
     -205920.,183040.,-128128.,69888.,-29120.,8960.,-1920.,256.,-16.,
-1920.,20565.33333333333333333333,-110357.3333333333333333333,
     386713.6,-972996.266666666666666667,1.842602666666666666666667e6,
     -2.695264e6,3.087274666666666666666667e6,-2.783428266666666666666667e6,
     1.9708416e6,-1.085205333333333333333333e6,455765.3333333333333333333,
     -141184.,30429.86666666666666666667,-4077.866666666666666666667,256.,
8960.,-110357.3333333333333333333,648994.133333333333333333,
     -2.4137984e6,6.329887695238095238095238e6,-1.235628952380952380952381e7,
     1.849749942857142857142857e7,-2.157797546666666666666667e7,
     1.974324906666666666666667e7,-1.41504896e7,7.871573333333333333333333e6,
     -3.334723047619047619047619e6,1.040757028571428571428571e6,
     -225781.1809523809523809524,30429.86666666666666666667,-1920.,
-29120.,386713.6,-2.4137984e6,9.39982994285714285714286e6,
     -2.554077714285714285714286e7,5.126930285714285714285714e7,
     -7.84918564571428571428571e7,9.32601344e7,-8.66443648e7,
     6.290674215384615384615385e7,-3.538176703296703296703297e7,
     1.513285823296703296703297e7,-4.762414382417582417582418e6,
     1.040757028571428571428571e6,-141184.,8960.,
69888.,-972996.266666666666666667,6.329887695238095238095238e6,
     -2.554077714285714285714286e7,7.15164647619047619047619e7,
     -1.472479024761904761904762e8,2.303302290285714285714286e8,
     -2.787310549333333333333333e8,2.630741924102564102564103e8,
     -1.936307214065934065934066e8,1.102168718534798534798535e8,
     -4.763884604249084249084249e7,1.513285823296703296703297e7,
     -3.334723047619047619047619e6,455765.3333333333333333333,-29120.,
-128128.,1.842602666666666666666667e6,-1.235628952380952380952381e7,
     5.126930285714285714285714e7,-1.472479024761904761904762e8,
     3.101685017489177489177489e8,-4.951622923636363636363636e8,
     6.10192938368298368298368e8,-5.85315892214452214452214e8,
     4.370868588691308691308691e8,-2.520410447525807525807526e8,
     1.102168718534798534798535e8,-3.538176703296703296703297e7,
     7.871573333333333333333333e6,-1.085205333333333333333333e6,69888.,
183040.,-2.695264e6,1.849749942857142857142857e7,
     -7.84918564571428571428571e7,2.303302290285714285714286e8,
     -4.951622923636363636363636e8,8.05756682741258741258741e8,
     -1.010792479328671328671329e9,9.85725504805594405594406e8,
     -7.47406151470929070929071e8,4.370868588691308691308691e8,
     -1.936307214065934065934066e8,6.290674215384615384615385e7,-1.41504896e7,
     1.9708416e6,-128128.,-205920.,3.087274666666666666666667e6,
     -2.157797546666666666666667e7,9.32601344e7,-2.787310549333333333333333e8,
     6.10192938368298368298368e8,-1.010792479328671328671329e9,
     1.290169792626573426573427e9,-1.279384995334265734265734e9,
     9.85725504805594405594406e8,-5.85315892214452214452214e8,
     2.630741924102564102564103e8,-8.66443648e7,1.974324906666666666666667e7,
     -2.783428266666666666666667e6,183040.,
183040.,-2.783428266666666666666667e6,1.974324906666666666666667e7,
     -8.66443648e7,2.630741924102564102564103e8,-5.85315892214452214452214e8,
     9.85725504805594405594406e8,-1.279384995334265734265734e9,
     1.290169792626573426573427e9,-1.010792479328671328671329e9,
     6.10192938368298368298368e8,-2.787310549333333333333333e8,9.32601344e7,
     -2.157797546666666666666667e7,3.087274666666666666666667e6,-205920.,
-128128.,1.9708416e6,-1.41504896e7,6.290674215384615384615385e7,
     -1.936307214065934065934066e8,4.370868588691308691308691e8,
     -7.47406151470929070929071e8,9.85725504805594405594406e8,
     -1.010792479328671328671329e9,8.05756682741258741258741e8,
     -4.951622923636363636363636e8,2.303302290285714285714286e8,
     -7.84918564571428571428571e7,1.849749942857142857142857e7,-2.695264e6,
     183040.,69888.,-1.085205333333333333333333e6,
     7.871573333333333333333333e6,-3.538176703296703296703297e7,
     1.102168718534798534798535e8,-2.520410447525807525807526e8,
     4.370868588691308691308691e8,-5.85315892214452214452214e8,
     6.10192938368298368298368e8,-4.951622923636363636363636e8,
     3.101685017489177489177489e8,-1.472479024761904761904762e8,
     5.126930285714285714285714e7,-1.235628952380952380952381e7,
     1.842602666666666666666667e6,-128128.,
-29120.,455765.3333333333333333333,-3.334723047619047619047619e6,
     1.513285823296703296703297e7,-4.763884604249084249084249e7,
     1.102168718534798534798535e8,-1.936307214065934065934066e8,
     2.630741924102564102564103e8,-2.787310549333333333333333e8,
     2.303302290285714285714286e8,-1.472479024761904761904762e8,
     7.15164647619047619047619e7,-2.554077714285714285714286e7,
     6.329887695238095238095238e6,-972996.266666666666666667,69888.,
8960.,-141184.,1.040757028571428571428571e6,
     -4.762414382417582417582418e6,1.513285823296703296703297e7,
     -3.538176703296703296703297e7,6.290674215384615384615385e7,-8.66443648e7,
     9.32601344e7,-7.84918564571428571428571e7,5.126930285714285714285714e7,
     -2.554077714285714285714286e7,9.39982994285714285714286e6,-2.4137984e6,
     386713.6,-29120.,-1920.,30429.86666666666666666667,
     -225781.1809523809523809524,1.040757028571428571428571e6,
     -3.334723047619047619047619e6,7.871573333333333333333333e6,-1.41504896e7,
     1.974324906666666666666667e7,-2.157797546666666666666667e7,
     1.849749942857142857142857e7,-1.235628952380952380952381e7,
     6.329887695238095238095238e6,-2.4137984e6,648994.133333333333333333,
     -110357.3333333333333333333,8960.,
256.,-4077.866666666666666666667,30429.86666666666666666667,-141184.,
     455765.3333333333333333333,-1.085205333333333333333333e6,1.9708416e6,
     -2.783428266666666666666667e6,3.087274666666666666666667e6,-2.695264e6,
     1.842602666666666666666667e6,-972996.266666666666666667,386713.6,
     -110357.3333333333333333333,20565.33333333333333333333,-1920.,
-16.,256.,-1920.,8960.,-29120.,69888.,-128128.,183040.,-205920.,
     183040.,-128128.,69888.,-29120.,8960.,-1920.,256.0,




289.,-2312.,11560.,-40460.,105196.,-210392.,330616.,
     -413270.,413270.,-330616.,210392.,-105196.,40460.,-11560.,2312.,-289.,
     17.,-2312.,26299.,-151002.5,569474.5,-1.551641e6,3.204721e6,
     -5.15554325e6,6.56066125e6,-6.653647e6,5.383781e6,-3.4583185e6,
     1.7428145e6,-674815.,193919.,-38978.875,4893.875,-289.,
11560.,-151002.5,948266.8,-3.7904951e6,1.07540368e7,-2.287919075e7,
     3.7648897e7,-4.877205905e7,5.01814976e7,-4.10899333e7,2.6659094e7,
     -1.35493315e7,5.2847696e6,-1.528354825e6,308929.1,-38978.875,2312.,
-40460.,569474.5,-3.7904951e6,1.584151848571428571428571e7,
     -4.651117695714285714285714e7,1.016524781071428571428571e8,
     -1.709269960357142857142857e8,2.253741646e8,-2.353219492e8,1.950949121e8,
     -1.279281826428571428571429e8,6.561823442857142857142857e7,
     -2.579953987857142857142857e7,7.514030417857142857142857e6,
     -1.528354825e6,193919.,-11560.,
105196.,-1.551641e6,1.07540368e7,-4.651117695714285714285714e7,
     1.405469093714285714285714e8,-3.146885700714285714285714e8,
     5.40056446857142857142857e8,-7.245692978e8,7.67927847753846153846154e8,
     -6.44940994415384615384615e8,4.277067123516483516483516e8,
     -2.215758466510989010989011e8,8.78895200395604395604396e7,
     -2.579953987857142857142857e7,5.2847696e6,-674815.,40460.,
-210392.,3.204721e6,-2.287919075e7,1.016524781071428571428571e8,
     -3.146885700714285714285714e8,7.19937519571428571428571e8,
     -1.259374123357142857142857e9,1.718539644884615384615385e9,
     -1.849028180153846153846154e9,1.573892821769230769230769e9,
     -1.056376184784340659340659e9,5.53198798006868131868132e8,
     -2.215758466510989010989011e8,6.561823442857142857142857e7,-1.35493315e7,
     1.7428145e6,-105196.,330616.,-5.15554325e6,3.7648897e7,
     -1.709269960357142857142857e8,5.40056446857142857142857e8,
     -1.259374123357142857142857e9,2.242484937208791208791209e9,
     -3.110737788730769230769231e9,3.397908696615384615384615e9,
     -2.932760414990384615384615e9,1.993711777258241758241758e9,
     -1.056376184784340659340659e9,4.277067123516483516483516e8,
     -1.279281826428571428571429e8,2.6659094e7,-3.4583185e6,210392.,
-413270.,6.56066125e6,-4.877205905e7,2.253741646e8,-7.245692978e8,
     1.718539644884615384615385e9,-3.110737788730769230769231e9,
     4.383774027584615384615385e9,-4.861132576438461538461538e9,
     4.256126954536538461538462e9,-2.932760414990384615384615e9,
     1.573892821769230769230769e9,-6.44940994415384615384615e8,1.950949121e8,
     -4.10899333e7,5.383781e6,-330616.,
413270.,-6.653647e6,5.01814976e7,-2.353219492e8,
     7.67927847753846153846154e8,-1.849028180153846153846154e9,
     3.397908696615384615384615e9,-4.861132576438461538461538e9,
     5.471410098646153846153846e9,-4.861132576438461538461538e9,
     3.397908696615384615384615e9,-1.849028180153846153846154e9,
     7.67927847753846153846154e8,-2.353219492e8,5.01814976e7,-6.653647e6,
     413270.,-330616.,5.383781e6,-4.10899333e7,1.950949121e8,
     -6.44940994415384615384615e8,1.573892821769230769230769e9,
     -2.932760414990384615384615e9,4.256126954536538461538462e9,
     -4.861132576438461538461538e9,4.383774027584615384615385e9,
     -3.110737788730769230769231e9,1.718539644884615384615385e9,
     -7.245692978e8,2.253741646e8,-4.877205905e7,6.56066125e6,-413270.,
210392.,-3.4583185e6,2.6659094e7,-1.279281826428571428571429e8,
     4.277067123516483516483516e8,-1.056376184784340659340659e9,
     1.993711777258241758241758e9,-2.932760414990384615384615e9,
     3.397908696615384615384615e9,-3.110737788730769230769231e9,
     2.242484937208791208791209e9,-1.259374123357142857142857e9,
     5.40056446857142857142857e8,-1.709269960357142857142857e8,3.7648897e7,
     -5.15554325e6,330616.,-105196.,1.7428145e6,-1.35493315e7,
     6.561823442857142857142857e7,-2.215758466510989010989011e8,
     5.53198798006868131868132e8,-1.056376184784340659340659e9,
     1.573892821769230769230769e9,-1.849028180153846153846154e9,
     1.718539644884615384615385e9,-1.259374123357142857142857e9,
     7.19937519571428571428571e8,-3.146885700714285714285714e8,
     1.016524781071428571428571e8,-2.287919075e7,3.204721e6,-210392.,
40460.,-674815.,5.2847696e6,-2.579953987857142857142857e7,
     8.78895200395604395604396e7,-2.215758466510989010989011e8,
     4.277067123516483516483516e8,-6.44940994415384615384615e8,
     7.67927847753846153846154e8,-7.245692978e8,5.40056446857142857142857e8,
     -3.146885700714285714285714e8,1.405469093714285714285714e8,
     -4.651117695714285714285714e7,1.07540368e7,-1.551641e6,105196.,
-11560.,193919.,-1.528354825e6,7.514030417857142857142857e6,
     -2.579953987857142857142857e7,6.561823442857142857142857e7,
     -1.279281826428571428571429e8,1.950949121e8,-2.353219492e8,2.253741646e8,
     -1.709269960357142857142857e8,1.016524781071428571428571e8,
     -4.651117695714285714285714e7,1.584151848571428571428571e7,-3.7904951e6,
     569474.5,-40460.,2312.,-38978.875,308929.1,-1.528354825e6,
     5.2847696e6,-1.35493315e7,2.6659094e7,-4.10899333e7,5.01814976e7,
     -4.877205905e7,3.7648897e7,-2.287919075e7,1.07540368e7,-3.7904951e6,
     948266.8,-151002.5,11560.,
-289.,4893.875,-38978.875,193919.,-674815.,1.7428145e6,-3.4583185e6,
     5.383781e6,-6.653647e6,6.56066125e6,-5.15554325e6,3.204721e6,-1.551641e6,
     569474.5,-151002.5,26299.,-2312.,
17.,-289.,2312.,-11560.,40460.,-105196.,210392.,-330616.,413270.,
     -413270.,330616.,-210392.,105196.,-40460.,11560.,-2312.,289.0,



324.,-2754.,14688.,-55080.,154224.,-334152.,572832.,-787644.,
     875160.,-787644.,572832.,-334152.,154224.,-55080.,14688.,-2754.,324.,
     -18.,-2754.,33156.,-202824.,819072.,-2.402568e6,5.374512e6,
     -9.430668e6,1.3199472e7,-1.4872572e7,1.3537368e7,-9.937512e6,5.842368e6,
     -2.714472e6,975024.,-261306.,49209.88235294117647058824,
     -5811.882352941176470588235,324.,
14688.,-202824.,1.354644e6,-5.791446e6,1.76742e7,-4.0701609e7,
     7.3020402e7,-1.04003757e8,1.18854216e8,-1.0945233e8,8.1136404e7,
     -4.8099582e7,2.2508712e7,-8.1355995e6,2.192312647058823529411765e6,
     -414869.0294117647058823529,49209.88235294117647058824,-2754.,
-55080.,819072.,-5.791446e6,2.5855524e7,-8.1571293e7,1.9280898e8,
     -3.53210949e8,5.11751682e8,-5.93194914e8,5.52864528e8,-4.1406147e8,
     2.476521e8,-1.167920775e8,4.250225329411764705882353e7,
     -1.152258644117647058823529e7,2.192312647058823529411765e6,-261306.,
     14688.,154224.,-2.402568e6,1.76742e7,-8.1571293e7,2.64581784e8,
     -6.40051308e8,1.195630956e9,-1.761263595e9,2.070811008e9,-1.953932544e9,
     1.47919068e9,-8.931175425e8,4.247360788235294117647059e8,
     -1.557266601176470588235294e8,4.250225329411764705882353e7,-8.1355995e6,
     975024.,-55080.,-334152.,5.374512e6,-4.0701609e7,1.9280898e8,
     -6.40051308e8,1.580411736e9,-3.006136071e9,4.499628607384615384615385e9,
     -5.365894596923076923076923e9,5.127197449846153846153846e9,
     -3.925355022346153846153846e9,2.394114671158371040723982e9,
     -1.148955644443438914027149e9,4.247360788235294117647059e8,
     -1.167920775e8,2.2508712e7,-2.714472e6,154224.,
572832.,-9.430668e6,7.3020402e7,-3.53210949e8,1.195630956e9,
     -3.006136071e9,5.814148173230769230769231e9,-8.83686782907692307692308e9,
     1.068683384492307692307692e10,-1.034323593853846153846154e10,
     8.012254609914027149321267e9,-4.939637207110859728506787e9,
     2.394114671158371040723982e9,-8.931175425e8,2.476521e8,-4.8099582e7,
     5.842368e6,-334152.,-787644.,1.3199472e7,-1.04003757e8,
     5.11751682e8,-1.761263595e9,4.499628607384615384615385e9,
     -8.83686782907692307692308e9,1.362802337446153846153846e10,
     -1.670972899361538461538462e10,1.63840847416289592760181e10,
     -1.284783656235067873303167e10,8.012254609914027149321267e9,
     -3.925355022346153846153846e9,1.47919068e9,-4.1406147e8,8.1136404e7,
     -9.937512e6,572832.,875160.,-1.4872572e7,1.18854216e8,
     -5.93194914e8,2.070811008e9,-5.365894596923076923076923e9,
     1.068683384492307692307692e10,-1.670972899361538461538462e10,
     2.076631804930316742081448e10,-2.063027681462443438914027e10,
     1.63840847416289592760181e10,-1.034323593853846153846154e10,
     5.127197449846153846153846e9,-1.953932544e9,5.52864528e8,-1.0945233e8,
     1.3537368e7,-787644.,-787644.,1.3537368e7,-1.0945233e8,
     5.52864528e8,-1.953932544e9,5.127197449846153846153846e9,
     -1.034323593853846153846154e10,1.63840847416289592760181e10,
     -2.063027681462443438914027e10,2.076631804930316742081448e10,
     -1.670972899361538461538462e10,1.068683384492307692307692e10,
     -5.365894596923076923076923e9,2.070811008e9,-5.93194914e8,1.18854216e8,
     -1.4872572e7,875160.,572832.,-9.937512e6,8.1136404e7,-4.1406147e8,
     1.47919068e9,-3.925355022346153846153846e9,8.012254609914027149321267e9,
     -1.284783656235067873303167e10,1.63840847416289592760181e10,
     -1.670972899361538461538462e10,1.362802337446153846153846e10,
     -8.83686782907692307692308e9,4.499628607384615384615385e9,-1.761263595e9,
     5.11751682e8,-1.04003757e8,1.3199472e7,-787644.,
-334152.,5.842368e6,-4.8099582e7,2.476521e8,-8.931175425e8,
     2.394114671158371040723982e9,-4.939637207110859728506787e9,
     8.012254609914027149321267e9,-1.034323593853846153846154e10,
     1.068683384492307692307692e10,-8.83686782907692307692308e9,
     5.814148173230769230769231e9,-3.006136071e9,1.195630956e9,-3.53210949e8,
     7.3020402e7,-9.430668e6,572832.,
154224.,-2.714472e6,2.2508712e7,-1.167920775e8,
     4.247360788235294117647059e8,-1.148955644443438914027149e9,
     2.394114671158371040723982e9,-3.925355022346153846153846e9,
     5.127197449846153846153846e9,-5.365894596923076923076923e9,
     4.499628607384615384615385e9,-3.006136071e9,1.580411736e9,-6.40051308e8,
     1.9280898e8,-4.0701609e7,5.374512e6,-334152.,
-55080.,975024.,-8.1355995e6,4.250225329411764705882353e7,
     -1.557266601176470588235294e8,4.247360788235294117647059e8,
     -8.931175425e8,1.47919068e9,-1.953932544e9,2.070811008e9,-1.761263595e9,
     1.195630956e9,-6.40051308e8,2.64581784e8,-8.1571293e7,1.76742e7,
     -2.402568e6,154224.,14688.,-261306.,2.192312647058823529411765e6,
     -1.152258644117647058823529e7,4.250225329411764705882353e7,
     -1.167920775e8,2.476521e8,-4.1406147e8,5.52864528e8,-5.93194914e8,
     5.11751682e8,-3.53210949e8,1.9280898e8,-8.1571293e7,2.5855524e7,
     -5.791446e6,819072.,-55080.,
-2754.,49209.88235294117647058824,-414869.0294117647058823529,
     2.192312647058823529411765e6,-8.1355995e6,2.2508712e7,-4.8099582e7,
     8.1136404e7,-1.0945233e8,1.18854216e8,-1.04003757e8,7.3020402e7,
     -4.0701609e7,1.76742e7,-5.791446e6,1.354644e6,-202824.,14688.,
324.,-5811.882352941176470588235,49209.88235294117647058824,-261306.,
     975024.,-2.714472e6,5.842368e6,-9.937512e6,1.3537368e7,-1.4872572e7,
     1.3199472e7,-9.430668e6,5.374512e6,-2.402568e6,819072.,-202824.,33156.,
     -2754.,-18.,324.,-2754.,14688.,-55080.,154224.,-334152.,572832.,
     -787644.,875160.,-787644.,572832.,-334152.,154224.,-55080.,14688.,-2754.,
     324.0,


361.,-3249.,18411.,-73644.,220932.,-515508.,957372.,-1.436058e6,
     1.755182e6,-1.755182e6,1.436058e6,-957372.,515508.,-220932.,73644.,
     -18411.,3249.,-361.,19.,-3249.,41274.33333333333333333333,
     -267982.3333333333333333333,1.153756e6,-3.624921333333333333333333e6,
     8.73090533333333333333333e6,-1.6594448e7,2.533489977777777777777778e7,
     -3.139825577777777777777778e7,3.1752838e7,-2.622135533333333333333333e7,
     1.761728133333333333333333e7,-9.549172e6,4.115881333333333333333333e6,
     -1.378779333333333333333333e6,346199.,-61329.88888888888888888889,
     6837.888888888888888888889,-361.,
18411.,-267982.3333333333333333333,1.896814333333333333333333e6,
     -8.636564e6,2.821046533333333333333333e7,-6.99117413333333333333333e7,
     1.358029053333333333333333e8,-2.109211491111111111111111e8,
     2.650533397777777777777778e8,-2.71133382e8,2.260622913333333333333333e8,
     -1.531309053333333333333333e8,8.3588828e7,-3.624993533333333333333333e7,
     1.220890674509803921568627e7,-3.080186490196078431372549e6,
     547983.967320261437908497,-61329.88888888888888888889,3249.,
-73644.,1.153756e6,-8.636564e6,4.1020791e7,-1.383931405e8,
     3.517642361666666666666667e8,-6.973023655e8,1.101117807833333333333333e9,
     -1.402930113e9,1.451914203e9,-1.222666207e9,8.35369523e8,-4.5943594575e8,
     2.005647463088235294117647e8,-6.79469935245098039215686e7,
     1.723232745588235294117647e7,-3.080186490196078431372549e6,346199.,
     -18411.,220932.,-3.624921333333333333333333e6,
     2.821046533333333333333333e7,-1.383931405e8,4.795881791111111111111111e8,
     -1.246531836777777777777778e9,2.517788242666666666666667e9,
     -4.0396428865e9,5.217553216e9,-5.463784818e9,
     4.648674013333333333333333e9,-3.205010194583333333333333e9,
     1.776872791176470588235294e9,-7.81248104526143790849673e8,
     2.663713037124183006535948e8,-6.79469935245098039215686e7,
     1.220890674509803921568627e7,-1.378779333333333333333333e6,73644.,
-515508.,8.73090533333333333333333e6,-6.99117413333333333333333e7,
     3.517642361666666666666667e8,-1.246531836777777777777778e9,
     3.304148205111111111111111e9,-6.789865251e9,1.10605261165e10,
     -1.4478513646e10,1.5343354848e10,-1.319368444233333333333333e10,
     9.18326977749509803921569e9,-5.135028301009803921568627e9,
     2.275295001065359477124183e9,-7.81248104526143790849673e8,
     2.005647463088235294117647e8,-3.624993533333333333333333e7,
     4.115881333333333333333333e6,-220932.,
957372.,-1.6594448e7,1.358029053333333333333333e8,-6.973023655e8,
     2.517788242666666666666667e9,-6.789865251e9,
     1.417462423476923076923077e10,-2.342481418811538461538462e10,
     3.106865280553846153846154e10,-3.332077238238461538461538e10,
     2.896709011636199095022624e10,-2.03645431955026395173454e10,
     1.149201246441628959276018e10,-5.135028301009803921568627e9,
     1.776872791176470588235294e9,-4.5943594575e8,8.3588828e7,-9.549172e6,
     515508.,-1.436058e6,2.533489977777777777777778e7,
     -2.109211491111111111111111e8,1.101117807833333333333333e9,
     -4.0396428865e9,1.10605261165e10,-2.342481418811538461538462e10,
     3.924091651669230769230769e10,-5.271461361273076923076923e10,
     5.721677485369004524886878e10,-5.030137346403142282554047e10,
     3.573551626858609854198089e10,-2.03645431955026395173454e10,
     9.18326977749509803921569e9,-3.205010194583333333333333e9,8.35369523e8,
     -1.531309053333333333333333e8,1.761728133333333333333333e7,-957372.,
1.755182e6,-3.139825577777777777777778e7,
     2.650533397777777777777778e8,-1.402930113e9,5.217553216e9,
     -1.4478513646e10,3.106865280553846153846154e10,
     -5.271461361273076923076923e10,7.16958095035475113122172e10,
     -7.87525926774751131221719e10,7.00319072667893413775767e10,
     -5.030137346403142282554047e10,2.896709011636199095022624e10,
     -1.319368444233333333333333e10,4.648674013333333333333333e9,
     -1.222666207e9,2.260622913333333333333333e8,
     -2.622135533333333333333333e7,1.436058e6,
-1.755182e6,3.1752838e7,-2.71133382e8,1.451914203e9,-5.463784818e9,
     1.5343354848e10,-3.332077238238461538461538e10,
     5.721677485369004524886878e10,-7.87525926774751131221719e10,
     8.75324834173393665158371e10,-7.87525926774751131221719e10,
     5.721677485369004524886878e10,-3.332077238238461538461538e10,
     1.5343354848e10,-5.463784818e9,1.451914203e9,-2.71133382e8,3.1752838e7,
     -1.755182e6,1.436058e6,-2.622135533333333333333333e7,
     2.260622913333333333333333e8,-1.222666207e9,4.648674013333333333333333e9,
     -1.319368444233333333333333e10,2.896709011636199095022624e10,
     -5.030137346403142282554047e10,7.00319072667893413775767e10,
     -7.87525926774751131221719e10,7.16958095035475113122172e10,
     -5.271461361273076923076923e10,3.106865280553846153846154e10,
     -1.4478513646e10,5.217553216e9,-1.402930113e9,
     2.650533397777777777777778e8,-3.139825577777777777777778e7,1.755182e6,
-957372.,1.761728133333333333333333e7,-1.531309053333333333333333e8,
     8.35369523e8,-3.205010194583333333333333e9,9.18326977749509803921569e9,
     -2.03645431955026395173454e10,3.573551626858609854198089e10,
     -5.030137346403142282554047e10,5.721677485369004524886878e10,
     -5.271461361273076923076923e10,3.924091651669230769230769e10,
     -2.342481418811538461538462e10,1.10605261165e10,-4.0396428865e9,
     1.101117807833333333333333e9,-2.109211491111111111111111e8,
     2.533489977777777777777778e7,-1.436058e6,
515508.,-9.549172e6,8.3588828e7,-4.5943594575e8,
     1.776872791176470588235294e9,-5.135028301009803921568627e9,
     1.149201246441628959276018e10,-2.03645431955026395173454e10,
     2.896709011636199095022624e10,-3.332077238238461538461538e10,
     3.106865280553846153846154e10,-2.342481418811538461538462e10,
     1.417462423476923076923077e10,-6.789865251e9,
     2.517788242666666666666667e9,-6.973023655e8,1.358029053333333333333333e8,
     -1.6594448e7,957372.,-220932.,4.115881333333333333333333e6,
     -3.624993533333333333333333e7,2.005647463088235294117647e8,
     -7.81248104526143790849673e8,2.275295001065359477124183e9,
     -5.135028301009803921568627e9,9.18326977749509803921569e9,
     -1.319368444233333333333333e10,1.5343354848e10,-1.4478513646e10,
     1.10605261165e10,-6.789865251e9,3.304148205111111111111111e9,
     -1.246531836777777777777778e9,3.517642361666666666666667e8,
     -6.99117413333333333333333e7,8.73090533333333333333333e6,-515508.,
73644.,-1.378779333333333333333333e6,1.220890674509803921568627e7,
     -6.79469935245098039215686e7,2.663713037124183006535948e8,
     -7.81248104526143790849673e8,1.776872791176470588235294e9,
     -3.205010194583333333333333e9,4.648674013333333333333333e9,
     -5.463784818e9,5.217553216e9,-4.0396428865e9,
     2.517788242666666666666667e9,-1.246531836777777777777778e9,
     4.795881791111111111111111e8,-1.383931405e8,2.821046533333333333333333e7,
     -3.624921333333333333333333e6,220932.,
-18411.,346199.,-3.080186490196078431372549e6,
     1.723232745588235294117647e7,-6.79469935245098039215686e7,
     2.005647463088235294117647e8,-4.5943594575e8,8.35369523e8,-1.222666207e9,
     1.451914203e9,-1.402930113e9,1.101117807833333333333333e9,-6.973023655e8,
     3.517642361666666666666667e8,-1.383931405e8,4.1020791e7,-8.636564e6,
     1.153756e6,-73644.,3249.,-61329.88888888888888888889,
     547983.967320261437908497,-3.080186490196078431372549e6,
     1.220890674509803921568627e7,-3.624993533333333333333333e7,8.3588828e7,
     -1.531309053333333333333333e8,2.260622913333333333333333e8,-2.71133382e8,
     2.650533397777777777777778e8,-2.109211491111111111111111e8,
     1.358029053333333333333333e8,-6.99117413333333333333333e7,
     2.821046533333333333333333e7,-8.636564e6,1.896814333333333333333333e6,
     -267982.3333333333333333333,18411.,
-361.,6837.888888888888888888889,-61329.88888888888888888889,346199.,
     -1.378779333333333333333333e6,4.115881333333333333333333e6,-9.549172e6,
     1.761728133333333333333333e7,-2.622135533333333333333333e7,3.1752838e7,
     -3.139825577777777777777778e7,2.533489977777777777777778e7,-1.6594448e7,
     8.73090533333333333333333e6,-3.624921333333333333333333e6,1.153756e6,
     -267982.3333333333333333333,41274.33333333333333333333,-3249.,
19.,-361.,3249.,-18411.,73644.,-220932.,515508.,-957372.,1.436058e6,
     -1.755182e6,1.755182e6,-1.436058e6,957372.,-515508.,220932.,-73644.,
     18411.,-3249.,361.0,


400.,-3800.,22800.,-96900.,310080.,-775200.,1.5504e6,-2.5194e6,
     3.3592e6,-3.69512e6,3.3592e6,-2.5194e6,1.5504e6,-775200.,310080.,-96900.,
     22800.,-3800.,400.,-20.,-3800.,50800.,-348900.,1.59528e6,-5.3448e6,
     1.37904e7,-2.82234e7,4.66752e7,-6.309992e7,7.01896e7,-6.43994e7,
     4.86744e7,-3.01512e7,1.516128e7,-6.0945e6,1.9128e6,-451800.,
     75557.8947368421052631579,-7977.894736842105263157895,400.,
22800.,-348900.,2.60888e6,-1.26038e7,4.38736e7,-1.164194e8,
     2.434218666666666666666667e8,-4.094216533333333333333333e8,
     5.61104266666666666666667e8,-6.312202e8,5.846504e8,-4.454612e8,
     2.7785888e8,-1.405645e8,5.6804e7,-1.791213333333333333333333e7,
     4.24854035087719298245614e6,-713184.912280701754385965,
     75557.8947368421052631579,-3800.,
-96900.,1.59528e6,-1.26038e7,6.34596e7,-2.279826e8,
     6.20072533333333333333333e8,-1.32238592e9,2.2603776e9,
     -3.139665533333333333333333e9,3.5722392e9,-3.3408852e9,2.56690928e9,
     -1.6128645e9,8.21187529411764705882353e8,-3.337512549019607843137255e8,
     1.057799356037151702786378e8,-2.520477046439628482972136e7,
     4.24854035087719298245614e6,-451800.,22800.,
310080.,-5.3448e6,4.38736e7,-2.279826e8,8.406388e8,
     -2.336326786666666666666667e9,5.0735796e9,-8.8064327e9,
     1.239382586666666666666667e10,-1.42623636e10,1.347133008e10,
     -1.044088825e10,6.611043705882352941176471e9,
     -3.389191205882352941176471e9,1.385957794633642930856553e9,
     -4.417132669040247678018576e8,1.057799356037151702786378e8,
     -1.791213333333333333333333e7,1.9128e6,-96900.,
-775200.,1.37904e7,-1.164194e8,6.20072533333333333333333e8,
     -2.336326786666666666666667e9,6.616939866666666666666667e9,
     -1.460870656666666666666667e10,2.572730173333333333333333e10,
     -3.66734292e10,4.268320368e10,-4.072463265e10,
     3.184972562352941176470588e10,-2.033131255490196078431373e10,
     1.049973751351909184726522e10,-4.322395091878224974200206e9,
     1.385957794633642930856553e9,-3.337512549019607843137255e8,5.6804e7,
     -6.0945e6,310080.,1.5504e6,-2.82234e7,2.434218666666666666666667e8,
     -1.32238592e9,5.0735796e9,-1.460870656666666666666667e10,3.27408124e10,
     -5.84514702e10,8.435910288e10,-9.929504325e10,
     9.57152232705882352941176e10,-7.55603350156862745098039e10,
     4.864878865696594427244582e10,-2.532187011891640866873065e10,
     1.049973751351909184726522e10,-3.389191205882352941176471e9,
     8.21187529411764705882353e8,-1.405645e8,1.516128e7,-775200.,
-2.5194e6,4.66752e7,-4.094216533333333333333333e8,2.2603776e9,
     -8.8064327e9,2.572730173333333333333333e10,-5.84514702e10,
     1.0569463848e11,-1.5437543325e11,1.837446751764705882352941e11,
     -1.789700407411764705882353e11,1.426584677230134158926729e11,
     -9.26817313362538699690402e10,4.864878865696594427244582e10,
     -2.033131255490196078431373e10,6.611043705882352941176471e9,-1.6128645e9,
     2.7785888e8,-3.01512e7,1.5504e6,
3.3592e6,-6.309992e7,5.61104266666666666666667e8,
     -3.139665533333333333333333e9,1.239382586666666666666667e10,
     -3.66734292e10,8.435910288e10,-1.5437543325e11,
     2.280805545882352941176471e11,-2.744714492941176470588235e11,
     2.701584478489164086687307e11,-2.17507890593890608875129e11,
     1.426584677230134158926729e11,-7.55603350156862745098039e10,
     3.184972562352941176470588e10,-1.044088825e10,2.56690928e9,-4.454612e8,
     4.86744e7,-2.5194e6,-3.69512e6,7.01896e7,-6.312202e8,3.5722392e9,
     -1.42623636e10,4.268320368e10,-9.929504325e10,
     1.837446751764705882352941e11,-2.744714492941176470588235e11,
     3.338809764582043343653251e11,-3.321205654388854489164087e11,
     2.701584478489164086687307e11,-1.789700407411764705882353e11,
     9.57152232705882352941176e10,-4.072463265e10,1.347133008e10,-3.3408852e9,
     5.846504e8,-6.43994e7,3.3592e6,
3.3592e6,-6.43994e7,5.846504e8,-3.3408852e9,1.347133008e10,
     -4.072463265e10,9.57152232705882352941176e10,
     -1.789700407411764705882353e11,2.701584478489164086687307e11,
     -3.321205654388854489164087e11,3.338809764582043343653251e11,
     -2.744714492941176470588235e11,1.837446751764705882352941e11,
     -9.929504325e10,4.268320368e10,-1.42623636e10,3.5722392e9,-6.312202e8,
     7.01896e7,-3.69512e6,-2.5194e6,4.86744e7,-4.454612e8,2.56690928e9,
     -1.044088825e10,3.184972562352941176470588e10,
     -7.55603350156862745098039e10,1.426584677230134158926729e11,
     -2.17507890593890608875129e11,2.701584478489164086687307e11,
     -2.744714492941176470588235e11,2.280805545882352941176471e11,
     -1.5437543325e11,8.435910288e10,-3.66734292e10,
     1.239382586666666666666667e10,-3.139665533333333333333333e9,
     5.61104266666666666666667e8,-6.309992e7,3.3592e6,
1.5504e6,-3.01512e7,2.7785888e8,-1.6128645e9,
     6.611043705882352941176471e9,-2.033131255490196078431373e10,
     4.864878865696594427244582e10,-9.26817313362538699690402e10,
     1.426584677230134158926729e11,-1.789700407411764705882353e11,
     1.837446751764705882352941e11,-1.5437543325e11,1.0569463848e11,
     -5.84514702e10,2.572730173333333333333333e10,-8.8064327e9,2.2603776e9,
     -4.094216533333333333333333e8,4.66752e7,-2.5194e6,
-775200.,1.516128e7,-1.405645e8,8.21187529411764705882353e8,
     -3.389191205882352941176471e9,1.049973751351909184726522e10,
     -2.532187011891640866873065e10,4.864878865696594427244582e10,
     -7.55603350156862745098039e10,9.57152232705882352941176e10,
     -9.929504325e10,8.435910288e10,-5.84514702e10,3.27408124e10,
     -1.460870656666666666666667e10,5.0735796e9,-1.32238592e9,
     2.434218666666666666666667e8,-2.82234e7,1.5504e6,
310080.,-6.0945e6,5.6804e7,-3.337512549019607843137255e8,
     1.385957794633642930856553e9,-4.322395091878224974200206e9,
     1.049973751351909184726522e10,-2.033131255490196078431373e10,
     3.184972562352941176470588e10,-4.072463265e10,4.268320368e10,
     -3.66734292e10,2.572730173333333333333333e10,
     -1.460870656666666666666667e10,6.616939866666666666666667e9,
     -2.336326786666666666666667e9,6.20072533333333333333333e8,-1.164194e8,
     1.37904e7,-775200.,-96900.,1.9128e6,-1.791213333333333333333333e7,
     1.057799356037151702786378e8,-4.417132669040247678018576e8,
     1.385957794633642930856553e9,-3.389191205882352941176471e9,
     6.611043705882352941176471e9,-1.044088825e10,1.347133008e10,
     -1.42623636e10,1.239382586666666666666667e10,-8.8064327e9,5.0735796e9,
     -2.336326786666666666666667e9,8.406388e8,-2.279826e8,4.38736e7,-5.3448e6,
     310080.,22800.,-451800.,4.24854035087719298245614e6,
     -2.520477046439628482972136e7,1.057799356037151702786378e8,
     -3.337512549019607843137255e8,8.21187529411764705882353e8,-1.6128645e9,
     2.56690928e9,-3.3408852e9,3.5722392e9,-3.139665533333333333333333e9,
     2.2603776e9,-1.32238592e9,6.20072533333333333333333e8,-2.279826e8,
     6.34596e7,-1.26038e7,1.59528e6,-96900.,
-3800.,75557.8947368421052631579,-713184.912280701754385965,
     4.24854035087719298245614e6,-1.791213333333333333333333e7,5.6804e7,
     -1.405645e8,2.7785888e8,-4.454612e8,5.846504e8,-6.312202e8,
     5.61104266666666666666667e8,-4.094216533333333333333333e8,
     2.434218666666666666666667e8,-1.164194e8,4.38736e7,-1.26038e7,2.60888e6,
     -348900.,22800.,400.,-7977.894736842105263157895,
     75557.8947368421052631579,-451800.,1.9128e6,-6.0945e6,1.516128e7,
     -3.01512e7,4.86744e7,-6.43994e7,7.01896e7,-6.309992e7,4.66752e7,
     -2.82234e7,1.37904e7,-5.3448e6,1.59528e6,-348900.,50800.,-3800.,
-20.,400.,-3800.,22800.,-96900.,310080.,-775200.,1.5504e6,-2.5194e6,
     3.3592e6,-3.69512e6,3.3592e6,-2.5194e6,1.5504e6,-775200.,310080.,-96900.,
     22800.,-3800.,400.0,


441.,-4410.,27930.,-125685.,427329.,-1.139544e6,2.44188e6,
     -4.27329e6,6.17253e6,-7.407036e6,7.407036e6,-6.17253e6,4.27329e6,
     -2.44188e6,1.139544e6,-427329.,125685.,-27930.,4410.,-441.,21.,
-4410.,61887.,-448276.5,2.1693231e6,-7.7204106e6,2.1244356e7,
     -4.6578861e7,8.2949307e7,-1.214753904e8,1.474000164e8,-1.48757973e8,
     1.24922511e8,-8.7053022e7,5.00259816e7,-2.34603621e7,8.8356555e6,
     -2.608662e6,581679.,-92124.9,9237.9,-441.,
27930.,-448276.5,3.5309988e6,-1.80399429e7,6.66671796e7,
     -1.88587035e8,4.22301012e8,-7.646685102e8,1.1349918216e9,-1.3925942394e9,
     1.41858234e9,-1.200769857e9,8.425008648e8,-4.870403559e8,2.296002996e8,
     -8.68729575e7,2.575453926315789473684211e7,-5.764016226315789473684211e6,
     915940.863157894736842105,-92124.9,4410.,
-125685.,2.1693231e6,-1.80399429e7,9.59778918e7,-3.65808618e8,
     1.060054975e9,-2.4200231034e9,4.4515946496e9,-6.6946047532e9,
     8.305349031e9,-8.540662725e9,7.2885943956e9,-5.1505079724e9,
     2.9961920583e9,-1.4203454825e9,5.40087516315789473684211e8,
     -1.608317545578947368421053e8,3.614048446842105263157895e7,
     -5.764016226315789473684211e6,581679.,-27930.,
427329.,-7.7204106e6,6.66671796e7,-3.65808618e8,1.430027809e9,
     -4.231848642e9,9.8320366704e9,-1.83564210424e10,2.7958358946e10,
     -3.5067700458e10,3.6407577612e10,-3.13322242716e10,
     2.230621822948235294117647e10,-1.306238046852941176470588e10,
     6.229104174241486068111455e9,-2.381333748055727554179567e9,
     7.12579922756037151702786e8,-1.608317545578947368421053e8,
     2.575453926315789473684211e7,-2.608662e6,125685.,
-1.139544e6,2.1244356e7,-1.88587035e8,1.060054975e9,-4.231848642e9,
     1.2753780711e10,-3.01064441965e10,5.69968403025e10,-8.788101609e10,
     1.11428895018e11,-1.1680715303775e11,1.013942048276911764705882e11,
     -7.27466401827941176470588e10,4.289907987847523219814241e10,
     -2.058767496750696594427245e10,7.916114510624613003095975e9,
     -2.381333748055727554179567e9,5.40087516315789473684211e8,-8.68729575e7,
     8.8356555e6,-427329.,2.44188e6,-4.6578861e7,4.22301012e8,
     -2.4200231034e9,9.8320366704e9,-3.01064441965e10,7.2098707506e10,
     -1.382826934545e11,2.157369557056e11,-2.7647897217885e11,
     2.926476936217058823529412e11,-2.562863095988382352941176e11,
     1.853659984230092879256966e11,-1.101224760495013931888545e11,
     5.320899943913993808049536e10,-2.058767496750696594427245e10,
     6.229104174241486068111455e9,-1.4203454825e9,2.296002996e8,-2.34603621e7,
     1.139544e6,-4.27329e6,8.2949307e7,-7.646685102e8,4.4515946496e9,
     -1.83564210424e10,5.69968403025e10,-1.382826934545e11,2.684546817358e11,
     -4.235665775859e11,5.485367972279382352941176e11,
     -5.86288402224926470588235e11,5.181008671586284829721362e11,
     -3.778902580767696594427245e11,2.262586046597849845201238e11,
     -1.101224760495013931888545e11,4.289907987847523219814241e10,
     -1.306238046852941176470588e10,2.9961920583e9,-4.870403559e8,
     5.00259816e7,-2.44188e6,6.17253e6,-1.214753904e8,1.1349918216e9,
     -6.6946047532e9,2.7958358946e10,-8.788101609e10,2.157369557056e11,
     -4.235665775859e11,6.75526010748564705882353e11,
     -8.83832347174411764705882e11,9.53883272573498452012384e11,
     -8.50744496643124458204334e11,6.2595022377944520123839e11,
     -3.778902580767696594427245e11,1.853659984230092879256966e11,
     -7.27466401827941176470588e10,2.230621822948235294117647e10,
     -5.1505079724e9,8.425008648e8,-8.7053022e7,4.27329e6,
-7.407036e6,1.474000164e8,-1.3925942394e9,8.305349031e9,
     -3.5067700458e10,1.11428895018e11,-2.7647897217885e11,
     5.485367972279382352941176e11,-8.83832347174411764705882e11,
     1.167954965882136222910217e12,-1.272782640454857585139319e12,
     1.145849638394687925696594e12,-8.50744496643124458204334e11,
     5.181008671586284829721362e11,-2.562863095988382352941176e11,
     1.013942048276911764705882e11,-3.13322242716e10,7.2885943956e9,
     -1.200769857e9,1.24922511e8,-6.17253e6,
7.407036e6,-1.48757973e8,1.41858234e9,-8.540662725e9,3.6407577612e10,
     -1.1680715303775e11,2.926476936217058823529412e11,
     -5.86288402224926470588235e11,9.53883272573498452012384e11,
     -1.272782640454857585139319e12,1.400406166485659442724458e12,
     -1.272782640454857585139319e12,9.53883272573498452012384e11,
     -5.86288402224926470588235e11,2.926476936217058823529412e11,
     -1.1680715303775e11,3.6407577612e10,-8.540662725e9,1.41858234e9,
     -1.48757973e8,7.407036e6,-6.17253e6,1.24922511e8,-1.200769857e9,
     7.2885943956e9,-3.13322242716e10,1.013942048276911764705882e11,
     -2.562863095988382352941176e11,5.181008671586284829721362e11,
     -8.50744496643124458204334e11,1.145849638394687925696594e12,
     -1.272782640454857585139319e12,1.167954965882136222910217e12,
     -8.83832347174411764705882e11,5.485367972279382352941176e11,
     -2.7647897217885e11,1.11428895018e11,-3.5067700458e10,8.305349031e9,
     -1.3925942394e9,1.474000164e8,-7.407036e6,
4.27329e6,-8.7053022e7,8.425008648e8,-5.1505079724e9,
     2.230621822948235294117647e10,-7.27466401827941176470588e10,
     1.853659984230092879256966e11,-3.778902580767696594427245e11,
     6.2595022377944520123839e11,-8.50744496643124458204334e11,
     9.53883272573498452012384e11,-8.83832347174411764705882e11,
     6.75526010748564705882353e11,-4.235665775859e11,2.157369557056e11,
     -8.788101609e10,2.7958358946e10,-6.6946047532e9,1.1349918216e9,
     -1.214753904e8,6.17253e6,-2.44188e6,5.00259816e7,-4.870403559e8,
     2.9961920583e9,-1.306238046852941176470588e10,
     4.289907987847523219814241e10,-1.101224760495013931888545e11,
     2.262586046597849845201238e11,-3.778902580767696594427245e11,
     5.181008671586284829721362e11,-5.86288402224926470588235e11,
     5.485367972279382352941176e11,-4.235665775859e11,2.684546817358e11,
     -1.382826934545e11,5.69968403025e10,-1.83564210424e10,4.4515946496e9,
     -7.646685102e8,8.2949307e7,-4.27329e6,
1.139544e6,-2.34603621e7,2.296002996e8,-1.4203454825e9,
     6.229104174241486068111455e9,-2.058767496750696594427245e10,
     5.320899943913993808049536e10,-1.101224760495013931888545e11,
     1.853659984230092879256966e11,-2.562863095988382352941176e11,
     2.926476936217058823529412e11,-2.7647897217885e11,2.157369557056e11,
     -1.382826934545e11,7.2098707506e10,-3.01064441965e10,9.8320366704e9,
     -2.4200231034e9,4.22301012e8,-4.6578861e7,2.44188e6,
-427329.,8.8356555e6,-8.68729575e7,5.40087516315789473684211e8,
     -2.381333748055727554179567e9,7.916114510624613003095975e9,
     -2.058767496750696594427245e10,4.289907987847523219814241e10,
     -7.27466401827941176470588e10,1.013942048276911764705882e11,
     -1.1680715303775e11,1.11428895018e11,-8.788101609e10,5.69968403025e10,
     -3.01064441965e10,1.2753780711e10,-4.231848642e9,1.060054975e9,
     -1.88587035e8,2.1244356e7,-1.139544e6,
125685.,-2.608662e6,2.575453926315789473684211e7,
     -1.608317545578947368421053e8,7.12579922756037151702786e8,
     -2.381333748055727554179567e9,6.229104174241486068111455e9,
     -1.306238046852941176470588e10,2.230621822948235294117647e10,
     -3.13322242716e10,3.6407577612e10,-3.5067700458e10,2.7958358946e10,
     -1.83564210424e10,9.8320366704e9,-4.231848642e9,1.430027809e9,
     -3.65808618e8,6.66671796e7,-7.7204106e6,427329.,
-27930.,581679.,-5.764016226315789473684211e6,
     3.614048446842105263157895e7,-1.608317545578947368421053e8,
     5.40087516315789473684211e8,-1.4203454825e9,2.9961920583e9,
     -5.1505079724e9,7.2885943956e9,-8.540662725e9,8.305349031e9,
     -6.6946047532e9,4.4515946496e9,-2.4200231034e9,1.060054975e9,
     -3.65808618e8,9.59778918e7,-1.80399429e7,2.1693231e6,-125685.,
4410.,-92124.9,915940.863157894736842105,
     -5.764016226315789473684211e6,2.575453926315789473684211e7,-8.68729575e7,
     2.296002996e8,-4.870403559e8,8.425008648e8,-1.200769857e9,1.41858234e9,
     -1.3925942394e9,1.1349918216e9,-7.646685102e8,4.22301012e8,-1.88587035e8,
     6.66671796e7,-1.80399429e7,3.5309988e6,-448276.5,27930.,
-441.,9237.9,-92124.9,581679.,-2.608662e6,8.8356555e6,-2.34603621e7,
     5.00259816e7,-8.7053022e7,1.24922511e8,-1.48757973e8,1.474000164e8,
     -1.214753904e8,8.2949307e7,-4.6578861e7,2.1244356e7,-7.7204106e6,
     2.1693231e6,-448276.5,61887.,-4410.,
21.,-441.,4410.,-27930.,125685.,-427329.,1.139544e6,-2.44188e6,
     4.27329e6,-6.17253e6,7.407036e6,-7.407036e6,6.17253e6,-4.27329e6,
     2.44188e6,-1.139544e6,427329.,-125685.,27930.,-4410.,441.0,




484.,-5082.,33880.,-160930.,579348.,-1.641486e6,3.751968e6,
     -7.03494e6,1.094324e7,-1.4226212e7,1.5519504e7,-1.4226212e7,1.094324e7,
     -7.03494e6,3.751968e6,-1.641486e6,579348.,-160930.,33880.,-5082.,484.,
     -22.,-5082.,74697.3333333333333333333,-569103.333333333333333333,
     2.905936e6,-1.0947838e7,3.200339371428571428571429e7,
     -7.48383617142857142857143e7,1.427832266666666666666667e8,
     -2.251701906666666666666667e8,2.95979112e8,-3.258479986666666666666667e8,
     3.009912106666666666666667e8,-2.330463457142857142857143e8,
     1.506593817142857142857143e8,-8.0745478e7,3.5478168e7,
     -1.256939933333333333333333e7,3.503353333333333333333333e6,-739794.,
     111273.9047619047619047619,-10623.9047619047619047619,484.,
33880.,-569103.333333333333333333,4.710062133333333333333333e6,
     -2.53726836e7,9.92085499428571428571429e7,-2.980246248571428571428571e8,
     7.11578597714285714285714e8,-1.380088473866666666666667e9,
     2.205501537066666666666667e9,-2.9310061352e9,
     3.256604002666666666666667e9,-3.03182091980952380952381e9,
     2.363311043657142857142857e9,-1.536823959314285714285714e9,8.279140408e8,
     -3.65435246e8,1.299962693333333333333333e8,-3.636516253333333333333333e7,
     7.704464114285714285714286e6,-1.162308819047619047619048e6,
     111273.9047619047619047619,-5082.,
-160930.,2.905936e6,-2.53726836e7,1.422311854857142857142857e8,
     -5.73219751028571428571429e8,1.763126401142857142857143e9,-4.290005148e9,
     8.4496703984e9,-1.36774916168e10,1.83743483264e10,
     -2.060505480628571428571429e10,1.933664865942857142857143e10,
     -1.517839659474285714285714e10,9.9310202112e9,-5.3792078956e9,
     2.385907982526315789473684e9,-8.52451457578947368421053e8,
     2.394066654075187969924812e8,-5.090341046917293233082707e7,
     7.704464114285714285714286e6,-739794.,33880.,
579348.,-1.0947838e7,9.92085499428571428571429e7,
     -5.73219751028571428571429e8,2.36807854353015873015873e9,
     -7.434157531777777777777778e9,1.839994329066666666666667e10,
     -3.676716046764444444444444e10,6.025274184551111111111111e10,
     -8.18088245203428571428571e10,9.25943888487619047619048e10,
     -8.76043066716190476190476e10,6.92622959248e10,
     -4.560898251848888888888889e10,2.484685828203976608187135e10,
     -1.107788520396491228070175e10,3.976589185059314954051796e9,
     -1.121583219652798663324979e9,2.394066654075187969924812e8,
     -3.636516253333333333333333e7,3.503353333333333333333333e6,-160930.,
-1.641486e6,3.200339371428571428571429e7,
     -2.980246248571428571428571e8,1.763126401142857142857143e9,
     -7.434157531777777777777778e9,2.375477543511111111111111e10,
     -5.970527183866666666666667e10,1.209171116657777777777778e11,
     -2.005055583261587301587302e11,2.750900039988571428571429e11,
     -3.142534678464761904761905e11,2.997872896307450980392157e11,
     -2.387871396990588235294118e11,1.582982357284100447196422e11,
     -8.67634413756030271757826e10,3.88978147719109538552263e10,
     -1.403380222055128016118728e10,3.976589185059314954051796e9,
     -8.52451457578947368421053e8,1.299962693333333333333333e8,
     -1.256939933333333333333333e7,579348.,
3.751968e6,-7.48383617142857142857143e7,7.11578597714285714285714e8,
     -4.290005148e9,1.839994329066666666666667e10,
     -5.970527183866666666666667e10,1.52154848164e11,
     -3.120154526646666666666667e11,5.232399033043809523809524e11,
     -7.25217256306714285714286e11,8.36143203581529411764706e11,
     -8.04374975875705882352941e11,6.45626593806798761609907e11,
     -4.310120060390577915376677e11,2.377622280018844169246646e11,
     -1.07226483444921273772667e11,3.88978147719109538552263e10,
     -1.107788520396491228070175e10,2.385907982526315789473684e9,
     -3.65435246e8,3.5478168e7,-1.641486e6,
-7.03494e6,1.427832266666666666666667e8,
     -1.380088473866666666666667e9,8.4496703984e9,
     -3.676716046764444444444444e10,1.209171116657777777777778e11,
     -3.120154526646666666666667e11,6.47269835714577777777778e11,
     -1.097126984567044444444444e12,1.535766037709976470588235e12,
     -1.786979410169196078431373e12,1.733751791625310629514964e12,
     -1.402594226453234055727554e12,9.43232252864502511179911e11,
     -5.238764829910806329549364e11,2.377622280018844169246646e11,
     -8.67634413756030271757826e10,2.484685828203976608187135e10,
     -5.3792078956e9,8.279140408e8,-8.0745478e7,3.751968e6,
1.094324e7,-2.251701906666666666666667e8,
     2.205501537066666666666667e9,-1.36774916168e10,
     6.025274184551111111111111e10,-2.005055583261587301587302e11,
     5.232399033043809523809524e11,-1.097126984567044444444444e12,
     1.878608767678075816993464e12,-2.655079421934305882352941e12,
     3.117574649820177502579979e12,-3.050772199436778121775026e12,
     2.488120363924418575851393e12,-1.686073365984842655658755e12,
     9.43232252864502511179911e11,-4.310120060390577915376677e11,
     1.582982357284100447196422e11,-4.560898251848888888888889e10,
     9.9310202112e9,-1.536823959314285714285714e9,
     1.506593817142857142857143e8,-7.03494e6,
-1.4226212e7,2.95979112e8,-2.9310061352e9,1.83743483264e10,
     -8.18088245203428571428571e10,2.750900039988571428571429e11,
     -7.25217256306714285714286e11,1.535766037709976470588235e12,
     -2.655079421934305882352941e12,3.787530110672762848297214e12,
     -4.487368962588538699690402e12,4.429316598550241486068111e12,
     -3.642544079498060681114551e12,2.488120363924418575851393e12,
     -1.402594226453234055727554e12,6.45626593806798761609907e11,
     -2.387871396990588235294118e11,6.92622959248e10,
     -1.517839659474285714285714e10,2.363311043657142857142857e9,
     -2.330463457142857142857143e8,1.094324e7,
1.5519504e7,-3.258479986666666666666667e8,
     3.256604002666666666666667e9,-2.060505480628571428571429e10,
     9.25943888487619047619048e10,-3.142534678464761904761905e11,
     8.36143203581529411764706e11,-1.786979410169196078431373e12,
     3.117574649820177502579979e12,-4.487368962588538699690402e12,
     5.363701362722534571723426e12,-5.340448775608986584107327e12,
     4.429316598550241486068111e12,-3.050772199436778121775026e12,
     1.733751791625310629514964e12,-8.04374975875705882352941e11,
     2.997872896307450980392157e11,-8.76043066716190476190476e10,
     1.933664865942857142857143e10,-3.03182091980952380952381e9,
     3.009912106666666666666667e8,-1.4226212e7,
-1.4226212e7,3.009912106666666666666667e8,
     -3.03182091980952380952381e9,1.933664865942857142857143e10,
     -8.76043066716190476190476e10,2.997872896307450980392157e11,
     -8.04374975875705882352941e11,1.733751791625310629514964e12,
     -3.050772199436778121775026e12,4.429316598550241486068111e12,
     -5.340448775608986584107327e12,5.363701362722534571723426e12,
     -4.487368962588538699690402e12,3.117574649820177502579979e12,
     -1.786979410169196078431373e12,8.36143203581529411764706e11,
     -3.142534678464761904761905e11,9.25943888487619047619048e10,
     -2.060505480628571428571429e10,3.256604002666666666666667e9,
     -3.258479986666666666666667e8,1.5519504e7,
1.094324e7,-2.330463457142857142857143e8,
     2.363311043657142857142857e9,-1.517839659474285714285714e10,
     6.92622959248e10,-2.387871396990588235294118e11,
     6.45626593806798761609907e11,-1.402594226453234055727554e12,
     2.488120363924418575851393e12,-3.642544079498060681114551e12,
     4.429316598550241486068111e12,-4.487368962588538699690402e12,
     3.787530110672762848297214e12,-2.655079421934305882352941e12,
     1.535766037709976470588235e12,-7.25217256306714285714286e11,
     2.750900039988571428571429e11,-8.18088245203428571428571e10,
     1.83743483264e10,-2.9310061352e9,2.95979112e8,-1.4226212e7,
-7.03494e6,1.506593817142857142857143e8,
     -1.536823959314285714285714e9,9.9310202112e9,
     -4.560898251848888888888889e10,1.582982357284100447196422e11,
     -4.310120060390577915376677e11,9.43232252864502511179911e11,
     -1.686073365984842655658755e12,2.488120363924418575851393e12,
     -3.050772199436778121775026e12,3.117574649820177502579979e12,
     -2.655079421934305882352941e12,1.878608767678075816993464e12,
     -1.097126984567044444444444e12,5.232399033043809523809524e11,
     -2.005055583261587301587302e11,6.025274184551111111111111e10,
     -1.36774916168e10,2.205501537066666666666667e9,
     -2.251701906666666666666667e8,1.094324e7,
3.751968e6,-8.0745478e7,8.279140408e8,-5.3792078956e9,
     2.484685828203976608187135e10,-8.67634413756030271757826e10,
     2.377622280018844169246646e11,-5.238764829910806329549364e11,
     9.43232252864502511179911e11,-1.402594226453234055727554e12,
     1.733751791625310629514964e12,-1.786979410169196078431373e12,
     1.535766037709976470588235e12,-1.097126984567044444444444e12,
     6.47269835714577777777778e11,-3.120154526646666666666667e11,
     1.209171116657777777777778e11,-3.676716046764444444444444e10,
     8.4496703984e9,-1.380088473866666666666667e9,
     1.427832266666666666666667e8,-7.03494e6,
-1.641486e6,3.5478168e7,-3.65435246e8,2.385907982526315789473684e9,
     -1.107788520396491228070175e10,3.88978147719109538552263e10,
     -1.07226483444921273772667e11,2.377622280018844169246646e11,
     -4.310120060390577915376677e11,6.45626593806798761609907e11,
     -8.04374975875705882352941e11,8.36143203581529411764706e11,
     -7.25217256306714285714286e11,5.232399033043809523809524e11,
     -3.120154526646666666666667e11,1.52154848164e11,
     -5.970527183866666666666667e10,1.839994329066666666666667e10,
     -4.290005148e9,7.11578597714285714285714e8,-7.48383617142857142857143e7,
     3.751968e6,579348.,-1.256939933333333333333333e7,
     1.299962693333333333333333e8,-8.52451457578947368421053e8,
     3.976589185059314954051796e9,-1.403380222055128016118728e10,
     3.88978147719109538552263e10,-8.67634413756030271757826e10,
     1.582982357284100447196422e11,-2.387871396990588235294118e11,
     2.997872896307450980392157e11,-3.142534678464761904761905e11,
     2.750900039988571428571429e11,-2.005055583261587301587302e11,
     1.209171116657777777777778e11,-5.970527183866666666666667e10,
     2.375477543511111111111111e10,-7.434157531777777777777778e9,
     1.763126401142857142857143e9,-2.980246248571428571428571e8,
     3.200339371428571428571429e7,-1.641486e6,
-160930.,3.503353333333333333333333e6,-3.636516253333333333333333e7,
     2.394066654075187969924812e8,-1.121583219652798663324979e9,
     3.976589185059314954051796e9,-1.107788520396491228070175e10,
     2.484685828203976608187135e10,-4.560898251848888888888889e10,
     6.92622959248e10,-8.76043066716190476190476e10,
     9.25943888487619047619048e10,-8.18088245203428571428571e10,
     6.025274184551111111111111e10,-3.676716046764444444444444e10,
     1.839994329066666666666667e10,-7.434157531777777777777778e9,
     2.36807854353015873015873e9,-5.73219751028571428571429e8,
     9.92085499428571428571429e7,-1.0947838e7,579348.,
33880.,-739794.,7.704464114285714285714286e6,
     -5.090341046917293233082707e7,2.394066654075187969924812e8,
     -8.52451457578947368421053e8,2.385907982526315789473684e9,
     -5.3792078956e9,9.9310202112e9,-1.517839659474285714285714e10,
     1.933664865942857142857143e10,-2.060505480628571428571429e10,
     1.83743483264e10,-1.36774916168e10,8.4496703984e9,-4.290005148e9,
     1.763126401142857142857143e9,-5.73219751028571428571429e8,
     1.422311854857142857142857e8,-2.53726836e7,2.905936e6,-160930.,
-5082.,111273.9047619047619047619,-1.162308819047619047619048e6,
     7.704464114285714285714286e6,-3.636516253333333333333333e7,
     1.299962693333333333333333e8,-3.65435246e8,8.279140408e8,
     -1.536823959314285714285714e9,2.363311043657142857142857e9,
     -3.03182091980952380952381e9,3.256604002666666666666667e9,
     -2.9310061352e9,2.205501537066666666666667e9,
     -1.380088473866666666666667e9,7.11578597714285714285714e8,
     -2.980246248571428571428571e8,9.92085499428571428571429e7,-2.53726836e7,
     4.710062133333333333333333e6,-569103.333333333333333333,33880.,
484.,-10623.9047619047619047619,111273.9047619047619047619,-739794.,
     3.503353333333333333333333e6,-1.256939933333333333333333e7,3.5478168e7,
     -8.0745478e7,1.506593817142857142857143e8,-2.330463457142857142857143e8,
     3.009912106666666666666667e8,-3.258479986666666666666667e8,2.95979112e8,
     -2.251701906666666666666667e8,1.427832266666666666666667e8,
     -7.48383617142857142857143e7,3.200339371428571428571429e7,-1.0947838e7,
     2.905936e6,-569103.333333333333333333,74697.3333333333333333333,-5082.,
-22.,484.,-5082.,33880.,-160930.,579348.,-1.641486e6,3.751968e6,
     -7.03494e6,1.094324e7,-1.4226212e7,1.5519504e7,-1.4226212e7,1.094324e7,
     -7.03494e6,3.751968e6,-1.641486e6,579348.,-160930.,33880.,-5082.,484.0,




529.,-5819.,40733.,-203665.,773927.,-2.321781e6,5.638611e6,
     -1.1277222e7,1.879537e7,-2.6313518e7,3.1097794e7,-3.1097794e7,
     2.6313518e7,-1.879537e7,1.1277222e7,-5.638611e6,2.321781e6,-773927.,
     203665.,-40733.,5819.,-529.,23.,
-5819.,89401.,-714679.,3.840011e6,-1.5267469e7,4.7249751e7,
     -1.17385629e8,2.38872066e8,-4.03587854e8,5.71286047818181818181818e8,
     -6.81324395818181818181818e8,6.86543606e8,-5.84706874e8,4.19991086e8,
     -2.53224894e8,1.27155201e8,-5.2556679e7,1.7578141e7,-4.639859e6,930511.,
     -133259.9090909090909090909,12141.90909090909090909091,-529.,
40733.,-714679.,6.200409e6,-3.5124013e7,1.448708064285714285714286e8,
     -4.605784598571428571428571e8,1.168022402428571428571429e9,
     -2.415717646e9,4.135385267454545454545455e9,
     -5.917434877272727272727273e9,7.121643359818181818181818e9,
     -7.231921365428571428571429e9,6.200372876857142857142857e9,
     -4.479595729428571428571429e9,2.71467459e9,-1.369318087e9,5.68256561e8,
     -1.90746291e8,5.051277414285714285714286e7,-1.016013201298701298701299e7,
     1.458963779220779220779221e6,-133259.9090909090909090909,5819.,
-203665.,3.840011e6,-3.5124013e7,2.069190301428571428571429e8,
     -8.79199738142857142857143e8,2.860737157857142857142857e9,
     -7.390461531857142857142857e9,1.551792347290909090909091e10,
     -2.690046167836363636363636e10,3.890271895945454545454545e10,
     -4.724545778714285714285714e10,4.835404288314285714285714e10,
     -4.174105061085714285714286e10,3.033859315085714285714286e10,
     -1.8483748796e10,9.367941975e9,-3.904285029e9,
     1.315620052714285714285714e9,-3.496213281688311688311688e8,
     7.05478614675324675324675e7,-1.016013201298701298701299e7,930511.,
     -40733.,773927.,-1.5267469e7,1.448708064285714285714286e8,
     -8.79199738142857142857143e8,3.827314924428571428571429e9,
     -1.270423192014285714285714e10,3.337075361061038961038961e10,
     -7.10600616790909090909091e10,1.246686983449090909090909e11,
     -1.821664192934285714285714e11,2.232331079591428571428571e11,
     -2.302844909954285714285714e11,2.001855365071428571428571e11,
     -1.464097942374285714285714e11,8.96993113969473684210526e10,
     -4.569069898878947368421053e10,1.912949454182706766917293e10,
     -6.472801815594668489405332e9,1.72664888963568010936432e9,
     -3.496213281688311688311688e8,5.051277414285714285714286e7,-4.639859e6,
     203665.,-2.321781e6,4.7249751e7,-4.605784598571428571428571e8,
     2.860737157857142857142857e9,-1.270423192014285714285714e10,
     4.290188019341558441558442e10,-1.143853295644545454545455e11,
     2.467596676961818181818182e11,-4.3788041125e11,
     6.46299234684857142857143e11,-7.99099009908857142857143e11,
     8.30935932533142857142857e11,-7.27514641339142857142857e11,
     5.355264598205263157894737e11,-3.300188661758947368421053e11,
     1.690004811053157894736842e11,-7.11008238637641831852358e10,
     2.41656951836971975393028e10,-6.472801815594668489405332e9,
     1.315620052714285714285714e9,-1.90746291e8,1.7578141e7,-773927.,
5.638611e6,-1.17385629e8,1.168022402428571428571429e9,
     -7.390461531857142857142857e9,3.337075361061038961038961e10,
     -1.143853295644545454545455e11,3.090802351682727272727273e11,
     -6.74821445274e11,1.210492382846e12,-1.804156631265428571428571e12,
     2.250474456673563025210084e12,-2.358968479583663865546218e12,
     2.080503034109219814241486e12,-1.541726396660749226006192e12,
     9.55926200174482972136223e11,-4.922883583242209400506614e11,
     2.081913569487339069599132e11,-7.11008238637641831852358e10,
     1.912949454182706766917293e10,-3.904285029e9,5.68256561e8,-5.2556679e7,
     2.321781e6,-1.1277222e7,2.38872066e8,-2.415717646e9,
     1.551792347290909090909091e10,-7.10600616790909090909091e10,
     2.467596676961818181818182e11,-6.74821445274e11,1.489762251699e12,
     -2.6997702078205e12,4.061926573048676470588235e12,
     -5.111061395349794117647059e12,5.400732032536874613003096e12,
     -4.798802884746348297213622e12,3.580722369770010835913313e12,
     -2.234462884230384886011821e12,1.157604619431160005629046e12,
     -4.922883583242209400506614e11,1.690004811053157894736842e11,
     -4.569069898878947368421053e10,9.367941975e9,-1.369318087e9,1.27155201e8,
     -5.638611e6,1.879537e7,-4.03587854e8,4.135385267454545454545455e9,
     -2.690046167836363636363636e10,1.246686983449090909090909e11,
     -4.3788041125e11,1.210492382846e12,-2.6997702078205e12,
     4.939965453656235294117647e12,-7.500247688602470588235294e12,
     9.51854821253541795665635e12,-1.013934200250417027863777e13,
     9.07781902572605572755418e12,-6.822088990654417675204053e12,
     4.285852657353698846045595e12,-2.234462884230384886011821e12,
     9.55926200174482972136223e11,-3.300188661758947368421053e11,
     8.96993113969473684210526e10,-1.8483748796e10,2.71467459e9,-2.53224894e8,
     1.1277222e7,-2.6313518e7,5.71286047818181818181818e8,
     -5.917434877272727272727273e9,3.890271895945454545454545e10,
     -1.821664192934285714285714e11,6.46299234684857142857143e11,
     -1.804156631265428571428571e12,4.061926573048676470588235e12,
     -7.500247688602470588235294e12,1.148744605484502786377709e13,
     -1.47015456175195479876161e13,1.578683164754892569659443e13,
     -1.424328151871174500422178e13,1.078308026750076329862088e13,
     -6.822088990654417675204053e12,3.580722369770010835913313e12,
     -1.541726396660749226006192e12,5.355264598205263157894737e11,
     -1.464097942374285714285714e11,3.033859315085714285714286e10,
     -4.479595729428571428571429e9,4.19991086e8,-1.879537e7,
3.1097794e7,-6.81324395818181818181818e8,
     7.121643359818181818181818e9,-4.724545778714285714285714e10,
     2.232331079591428571428571e11,-7.99099009908857142857143e11,
     2.250474456673563025210084e12,-5.111061395349794117647059e12,
     9.51854821253541795665635e12,-1.47015456175195479876161e13,
     1.897001510409204953560372e13,-2.053426725267228173374613e13,
     1.867166695478726822403603e13,-1.424328151871174500422178e13,
     9.07781902572605572755418e12,-4.798802884746348297213622e12,
     2.080503034109219814241486e12,-7.27514641339142857142857e11,
     2.001855365071428571428571e11,-4.174105061085714285714286e10,
     6.200372876857142857142857e9,-5.84706874e8,2.6313518e7,
-3.1097794e7,6.86543606e8,-7.231921365428571428571429e9,
     4.835404288314285714285714e10,-2.302844909954285714285714e11,
     8.30935932533142857142857e11,-2.358968479583663865546218e12,
     5.400732032536874613003096e12,-1.013934200250417027863777e13,
     1.578683164754892569659443e13,-2.053426725267228173374613e13,
     2.240517009163677399380805e13,-2.053426725267228173374613e13,
     1.578683164754892569659443e13,-1.013934200250417027863777e13,
     5.400732032536874613003096e12,-2.358968479583663865546218e12,
     8.30935932533142857142857e11,-2.302844909954285714285714e11,
     4.835404288314285714285714e10,-7.231921365428571428571429e9,6.86543606e8,
     -3.1097794e7,2.6313518e7,-5.84706874e8,
     6.200372876857142857142857e9,-4.174105061085714285714286e10,
     2.001855365071428571428571e11,-7.27514641339142857142857e11,
     2.080503034109219814241486e12,-4.798802884746348297213622e12,
     9.07781902572605572755418e12,-1.424328151871174500422178e13,
     1.867166695478726822403603e13,-2.053426725267228173374613e13,
     1.897001510409204953560372e13,-1.47015456175195479876161e13,
     9.51854821253541795665635e12,-5.111061395349794117647059e12,
     2.250474456673563025210084e12,-7.99099009908857142857143e11,
     2.232331079591428571428571e11,-4.724545778714285714285714e10,
     7.121643359818181818181818e9,-6.81324395818181818181818e8,3.1097794e7,
-1.879537e7,4.19991086e8,-4.479595729428571428571429e9,
     3.033859315085714285714286e10,-1.464097942374285714285714e11,
     5.355264598205263157894737e11,-1.541726396660749226006192e12,
     3.580722369770010835913313e12,-6.822088990654417675204053e12,
     1.078308026750076329862088e13,-1.424328151871174500422178e13,
     1.578683164754892569659443e13,-1.47015456175195479876161e13,
     1.148744605484502786377709e13,-7.500247688602470588235294e12,
     4.061926573048676470588235e12,-1.804156631265428571428571e12,
     6.46299234684857142857143e11,-1.821664192934285714285714e11,
     3.890271895945454545454545e10,-5.917434877272727272727273e9,
     5.71286047818181818181818e8,-2.6313518e7,
1.1277222e7,-2.53224894e8,2.71467459e9,-1.8483748796e10,
     8.96993113969473684210526e10,-3.300188661758947368421053e11,
     9.55926200174482972136223e11,-2.234462884230384886011821e12,
     4.285852657353698846045595e12,-6.822088990654417675204053e12,
     9.07781902572605572755418e12,-1.013934200250417027863777e13,
     9.51854821253541795665635e12,-7.500247688602470588235294e12,
     4.939965453656235294117647e12,-2.6997702078205e12,1.210492382846e12,
     -4.3788041125e11,1.246686983449090909090909e11,
     -2.690046167836363636363636e10,4.135385267454545454545455e9,
     -4.03587854e8,1.879537e7,-5.638611e6,1.27155201e8,-1.369318087e9,
     9.367941975e9,-4.569069898878947368421053e10,
     1.690004811053157894736842e11,-4.922883583242209400506614e11,
     1.157604619431160005629046e12,-2.234462884230384886011821e12,
     3.580722369770010835913313e12,-4.798802884746348297213622e12,
     5.400732032536874613003096e12,-5.111061395349794117647059e12,
     4.061926573048676470588235e12,-2.6997702078205e12,1.489762251699e12,
     -6.74821445274e11,2.467596676961818181818182e11,
     -7.10600616790909090909091e10,1.551792347290909090909091e10,
     -2.415717646e9,2.38872066e8,-1.1277222e7,
2.321781e6,-5.2556679e7,5.68256561e8,-3.904285029e9,
     1.912949454182706766917293e10,-7.11008238637641831852358e10,
     2.081913569487339069599132e11,-4.922883583242209400506614e11,
     9.55926200174482972136223e11,-1.541726396660749226006192e12,
     2.080503034109219814241486e12,-2.358968479583663865546218e12,
     2.250474456673563025210084e12,-1.804156631265428571428571e12,
     1.210492382846e12,-6.74821445274e11,3.090802351682727272727273e11,
     -1.143853295644545454545455e11,3.337075361061038961038961e10,
     -7.390461531857142857142857e9,1.168022402428571428571429e9,-1.17385629e8,
     5.638611e6,-773927.,1.7578141e7,-1.90746291e8,
     1.315620052714285714285714e9,-6.472801815594668489405332e9,
     2.41656951836971975393028e10,-7.11008238637641831852358e10,
     1.690004811053157894736842e11,-3.300188661758947368421053e11,
     5.355264598205263157894737e11,-7.27514641339142857142857e11,
     8.30935932533142857142857e11,-7.99099009908857142857143e11,
     6.46299234684857142857143e11,-4.3788041125e11,
     2.467596676961818181818182e11,-1.143853295644545454545455e11,
     4.290188019341558441558442e10,-1.270423192014285714285714e10,
     2.860737157857142857142857e9,-4.605784598571428571428571e8,4.7249751e7,
     -2.321781e6,203665.,-4.639859e6,5.051277414285714285714286e7,
     -3.496213281688311688311688e8,1.72664888963568010936432e9,
     -6.472801815594668489405332e9,1.912949454182706766917293e10,
     -4.569069898878947368421053e10,8.96993113969473684210526e10,
     -1.464097942374285714285714e11,2.001855365071428571428571e11,
     -2.302844909954285714285714e11,2.232331079591428571428571e11,
     -1.821664192934285714285714e11,1.246686983449090909090909e11,
     -7.10600616790909090909091e10,3.337075361061038961038961e10,
     -1.270423192014285714285714e10,3.827314924428571428571429e9,
     -8.79199738142857142857143e8,1.448708064285714285714286e8,-1.5267469e7,
     773927.,-40733.,930511.,-1.016013201298701298701299e7,
     7.05478614675324675324675e7,-3.496213281688311688311688e8,
     1.315620052714285714285714e9,-3.904285029e9,9.367941975e9,
     -1.8483748796e10,3.033859315085714285714286e10,
     -4.174105061085714285714286e10,4.835404288314285714285714e10,
     -4.724545778714285714285714e10,3.890271895945454545454545e10,
     -2.690046167836363636363636e10,1.551792347290909090909091e10,
     -7.390461531857142857142857e9,2.860737157857142857142857e9,
     -8.79199738142857142857143e8,2.069190301428571428571429e8,-3.5124013e7,
     3.840011e6,-203665.,5819.,-133259.9090909090909090909,
     1.458963779220779220779221e6,-1.016013201298701298701299e7,
     5.051277414285714285714286e7,-1.90746291e8,5.68256561e8,-1.369318087e9,
     2.71467459e9,-4.479595729428571428571429e9,6.200372876857142857142857e9,
     -7.231921365428571428571429e9,7.121643359818181818181818e9,
     -5.917434877272727272727273e9,4.135385267454545454545455e9,
     -2.415717646e9,1.168022402428571428571429e9,
     -4.605784598571428571428571e8,1.448708064285714285714286e8,-3.5124013e7,
     6.200409e6,-714679.,40733.,
-529.,12141.90909090909090909091,-133259.9090909090909090909,930511.,
     -4.639859e6,1.7578141e7,-5.2556679e7,1.27155201e8,-2.53224894e8,
     4.19991086e8,-5.84706874e8,6.86543606e8,-6.81324395818181818181818e8,
     5.71286047818181818181818e8,-4.03587854e8,2.38872066e8,-1.17385629e8,
     4.7249751e7,-1.5267469e7,3.840011e6,-714679.,89401.,-5819.,
23.,-529.,5819.,-40733.,203665.,-773927.,2.321781e6,-5.638611e6,
     1.1277222e7,-1.879537e7,2.6313518e7,-3.1097794e7,3.1097794e7,
     -2.6313518e7,1.879537e7,-1.1277222e7,5.638611e6,-2.321781e6,773927.,
     -203665.,40733.,-5819.,529.0,



576.,-6624.,48576.,-255024.,1.020096e6,-3.230304e6,8.306496e6,
     -1.7651304e7,3.1380096e7,-4.7070144e7,5.9907456e7,-6.4899744e7,
     5.9907456e7,-4.7070144e7,3.1380096e7,-1.7651304e7,8.306496e6,-3.230304e6,
     1.020096e6,-255024.,48576.,-6624.,576.,-24.,
-6624.,106176.,-888624.,5.011776e6,-2.0971104e7,6.8498496e7,
     -1.80169704e8,3.89522496e8,-7.01959104e8,1.064566656e9,-1.367235744e9,
     1.492477056e9,-1.386615744e9,1.095574656e9,-7.33936104e8,4.14602496e8,
     -1.95844704e8,7.6418496e7,-2.4205104e7,6.067776e6,-1.158624e6,
     158349.9130434782608695652,-13797.91304347826086956522,576.,
48576.,-888624.,8.064576e6,-4.7925024e7,2.07948096e8,-6.97547304e8,
     1.872434496e9,-4.113614304e9,7.509945914181818181818182e9,
     -1.151192578036363636363636e10,1.491837727418181818181818e10,
     -1.6409991744e10,1.5346851456e10,-1.2195423144e10,8.211108096e9,
     -4.659218304e9,2.209634496e9,-8.65280304e8,2.74956096e8,
     -6.91279330909090909090909e7,1.323491592094861660079051e7,
     -1.81322874308300395256917e6,158349.9130434782608695652,-6624.,
-255024.,5.011776e6,-4.7925024e7,2.960110902857142857142857e8,
     -1.322519646857142857142857e9,4.538549238857142857142857e9,
     -1.240666481828571428571429e10,2.766444118690909090909091e10,
     -5.113203132218181818181818e10,7.91996526196363636363636e10,
     -1.035519754946493506493506e11,1.147841917988571428571429e11,
     -1.080699442868571428571429e11,8.63864139702857142857143e10,
     -5.8468677504e10,3.3332196096e10,-1.5874285104e10,
     6.239888667428571428571429e9,-1.98965376374025974025974e9,
     5.01799042854884246188594e8,-9.63483424641445511010728e7,
     1.323491592094861660079051e7,-1.158624e6,48576.,
1.020096e6,-2.0971104e7,2.07948096e8,-1.322519646857142857142857e9,
     6.050787044571428571428571e9,-2.117408301257142857142857e10,
     5.883035363158441558441558e10,-1.329904663112727272727273e11,
     2.486964842705454545454545e11,-3.891150452421818181818182e11,
     5.13243869937038961038961e11,-5.73313732652571428571429e11,
     5.434675144045714285714286e11,-4.370675397668571428571429e11,
     2.97431375616e11,-1.70393909184e11,8.1509831616e10,
     -3.216950653464935064935065e10,1.029544846162394127611519e10,
     -2.605343556738565782044043e9,5.01799042854884246188594e8,
     -6.91279330909090909090909e7,6.067776e6,-255024.,
-3.230304e6,6.8498496e7,-6.97547304e8,4.538549238857142857142857e9,
     -2.117408301257142857142857e10,7.53504562809350649350649e10,
     -2.12413806945038961038961e11,4.862749510341818181818182e11,
     -9.19453041111272727272727e11,1.452670520866909090909091e12,
     -1.932696315966857142857143e12,2.175595770404571428571429e12,
     -2.076637913252571428571429e12,1.680511877087278195488722e12,
     -1.150087122826105263157895e12,6.62258762900210526315789e11,
     -3.182879654863923444976077e11,1.261600172901775387084312e11,
     -4.053594315219519153615263e10,1.029544846162394127611519e10,
     -1.98965376374025974025974e9,2.74956096e8,-2.4205104e7,1.020096e6,
8.306496e6,-1.80169704e8,1.872434496e9,
     -1.240666481828571428571429e10,5.883035363158441558441558e10,
     -2.12413806945038961038961e11,6.06607557621194805194805e11,
     -1.404900331802181818181818e12,2.684210467688727272727273e12,
     -4.280833268424e12,5.743903756690285714285714e12,
     -6.515709933366857142857143e12,6.263029261171488721804511e12,
     -5.100842154443548872180451e12,3.511360073552842105263158e12,
     -2.032877088567732057416268e12,9.81883335061475348450177e11,
     -3.909804356249105768373503e11,1.261600172901775387084312e11,
     -3.216950653464935064935065e10,6.239888667428571428571429e9,
     -8.65280304e8,7.6418496e7,-3.230304e6,
-1.7651304e7,3.89522496e8,-4.113614304e9,
     2.766444118690909090909091e10,-1.329904663112727272727273e11,
     4.862749510341818181818182e11,-1.404900331802181818181818e12,
     3.288618076852363636363636e12,-6.345129261384e12,
     1.021097915718776470588235e13,-1.381504694370635294117647e13,
     1.579187145893884829721362e13,-1.528729008007786996904025e13,
     1.253239892914565944272446e13,-8.679766242387039684773431e12,
     5.053565593384186101151507e12,-2.45376055130027895593436e12,
     9.81883335061475348450177e11,-3.182879654863923444976077e11,
     8.1509831616e10,-1.5874285104e10,2.209634496e9,-1.95844704e8,8.306496e6,
3.1380096e7,-7.01959104e8,7.509945914181818181818182e9,
     -5.113203132218181818181818e10,2.486964842705454545454545e11,
     -9.19453041111272727272727e11,2.684210467688727272727273e12,
     -6.345129261384e12,1.235567439519247058823529e13,
     -2.005615062394164705882353e13,2.735618627782677399380805e13,
     -3.150958484975093498452012e13,3.07215129537400866873065e13,
     -2.535481172231079988741908e13,1.767147508766645583034545e13,
     -1.034995679096306973898359e13,5.053565593384186101151507e12,
     -2.032877088567732057416268e12,6.62258762900210526315789e11,
     -1.70393909184e11,3.3332196096e10,-4.659218304e9,4.14602496e8,
     -1.7651304e7,-4.7070144e7,1.064566656e9,
     -1.151192578036363636363636e10,7.91996526196363636363636e10,
     -3.891150452421818181818182e11,1.452670520866909090909091e12,
     -4.280833268424e12,1.021097915718776470588235e13,
     -2.005615062394164705882353e13,3.282630072306665015479876e13,
     -4.5129847686135826625387e13,5.23755777238344520123839e13,
     -5.14345294466249907120743e13,4.274171878647190964157662e13,
     -2.998492911059246510603409e13,1.767147508766645583034545e13,
     -8.679766242387039684773431e12,3.511360073552842105263158e12,
     -1.150087122826105263157895e12,2.97431375616e11,-5.8468677504e10,
     8.211108096e9,-7.33936104e8,3.1380096e7,
5.9907456e7,-1.367235744e9,1.491837727418181818181818e10,
     -1.035519754946493506493506e11,5.13243869937038961038961e11,
     -1.932696315966857142857143e12,5.743903756690285714285714e12,
     -1.381504694370635294117647e13,2.735618627782677399380805e13,
     -4.5129847686135826625387e13,6.252388106942949845201238e13,
     -7.31060959814361362229102e13,7.23139934521588025306232e13,
     -6.051472824378668627858882e13,4.274171878647190964157662e13,
     -2.535481172231079988741908e13,1.253239892914565944272446e13,
     -5.100842154443548872180451e12,1.680511877087278195488722e12,
     -4.370675397668571428571429e11,8.63864139702857142857143e10,
     -1.2195423144e10,1.095574656e9,-4.7070144e7,
-6.4899744e7,1.492477056e9,-1.6409991744e10,
     1.147841917988571428571429e11,-5.73313732652571428571429e11,
     2.175595770404571428571429e12,-6.515709933366857142857143e12,
     1.579187145893884829721362e13,-3.150958484975093498452012e13,
     5.23755777238344520123839e13,-7.31060959814361362229102e13,
     8.6111703165232217525912e13,-8.57993413389471067438417e13,
     7.23139934521588025306232e13,-5.14345294466249907120743e13,
     3.07215129537400866873065e13,-1.528729008007786996904025e13,
     6.263029261171488721804511e12,-2.076637913252571428571429e12,
     5.434675144045714285714286e11,-1.080699442868571428571429e11,
     1.5346851456e10,-1.386615744e9,5.9907456e7,
5.9907456e7,-1.386615744e9,1.5346851456e10,
     -1.080699442868571428571429e11,5.434675144045714285714286e11,
     -2.076637913252571428571429e12,6.263029261171488721804511e12,
     -1.528729008007786996904025e13,3.07215129537400866873065e13,
     -5.14345294466249907120743e13,7.23139934521588025306232e13,
     -8.57993413389471067438417e13,8.6111703165232217525912e13,
     -7.31060959814361362229102e13,5.23755777238344520123839e13,
     -3.150958484975093498452012e13,1.579187145893884829721362e13,
     -6.515709933366857142857143e12,2.175595770404571428571429e12,
     -5.73313732652571428571429e11,1.147841917988571428571429e11,
     -1.6409991744e10,1.492477056e9,-6.4899744e7,
-4.7070144e7,1.095574656e9,-1.2195423144e10,
     8.63864139702857142857143e10,-4.370675397668571428571429e11,
     1.680511877087278195488722e12,-5.100842154443548872180451e12,
     1.253239892914565944272446e13,-2.535481172231079988741908e13,
     4.274171878647190964157662e13,-6.051472824378668627858882e13,
     7.23139934521588025306232e13,-7.31060959814361362229102e13,
     6.252388106942949845201238e13,-4.5129847686135826625387e13,
     2.735618627782677399380805e13,-1.381504694370635294117647e13,
     5.743903756690285714285714e12,-1.932696315966857142857143e12,
     5.13243869937038961038961e11,-1.035519754946493506493506e11,
     1.491837727418181818181818e10,-1.367235744e9,5.9907456e7,
3.1380096e7,-7.33936104e8,8.211108096e9,-5.8468677504e10,
     2.97431375616e11,-1.150087122826105263157895e12,
     3.511360073552842105263158e12,-8.679766242387039684773431e12,
     1.767147508766645583034545e13,-2.998492911059246510603409e13,
     4.274171878647190964157662e13,-5.14345294466249907120743e13,
     5.23755777238344520123839e13,-4.5129847686135826625387e13,
     3.282630072306665015479876e13,-2.005615062394164705882353e13,
     1.021097915718776470588235e13,-4.280833268424e12,
     1.452670520866909090909091e12,-3.891150452421818181818182e11,
     7.91996526196363636363636e10,-1.151192578036363636363636e10,
     1.064566656e9,-4.7070144e7,
-1.7651304e7,4.14602496e8,-4.659218304e9,3.3332196096e10,
     -1.70393909184e11,6.62258762900210526315789e11,
     -2.032877088567732057416268e12,5.053565593384186101151507e12,
     -1.034995679096306973898359e13,1.767147508766645583034545e13,
     -2.535481172231079988741908e13,3.07215129537400866873065e13,
     -3.150958484975093498452012e13,2.735618627782677399380805e13,
     -2.005615062394164705882353e13,1.235567439519247058823529e13,
     -6.345129261384e12,2.684210467688727272727273e12,
     -9.19453041111272727272727e11,2.486964842705454545454545e11,
     -5.113203132218181818181818e10,7.509945914181818181818182e9,
     -7.01959104e8,3.1380096e7,
8.306496e6,-1.95844704e8,2.209634496e9,-1.5874285104e10,
     8.1509831616e10,-3.182879654863923444976077e11,
     9.81883335061475348450177e11,-2.45376055130027895593436e12,
     5.053565593384186101151507e12,-8.679766242387039684773431e12,
     1.253239892914565944272446e13,-1.528729008007786996904025e13,
     1.579187145893884829721362e13,-1.381504694370635294117647e13,
     1.021097915718776470588235e13,-6.345129261384e12,
     3.288618076852363636363636e12,-1.404900331802181818181818e12,
     4.862749510341818181818182e11,-1.329904663112727272727273e11,
     2.766444118690909090909091e10,-4.113614304e9,3.89522496e8,-1.7651304e7,
-3.230304e6,7.6418496e7,-8.65280304e8,6.239888667428571428571429e9,
     -3.216950653464935064935065e10,1.261600172901775387084312e11,
     -3.909804356249105768373503e11,9.81883335061475348450177e11,
     -2.032877088567732057416268e12,3.511360073552842105263158e12,
     -5.100842154443548872180451e12,6.263029261171488721804511e12,
     -6.515709933366857142857143e12,5.743903756690285714285714e12,
     -4.280833268424e12,2.684210467688727272727273e12,
     -1.404900331802181818181818e12,6.06607557621194805194805e11,
     -2.12413806945038961038961e11,5.883035363158441558441558e10,
     -1.240666481828571428571429e10,1.872434496e9,-1.80169704e8,8.306496e6,
1.020096e6,-2.4205104e7,2.74956096e8,-1.98965376374025974025974e9,
     1.029544846162394127611519e10,-4.053594315219519153615263e10,
     1.261600172901775387084312e11,-3.182879654863923444976077e11,
     6.62258762900210526315789e11,-1.150087122826105263157895e12,
     1.680511877087278195488722e12,-2.076637913252571428571429e12,
     2.175595770404571428571429e12,-1.932696315966857142857143e12,
     1.452670520866909090909091e12,-9.19453041111272727272727e11,
     4.862749510341818181818182e11,-2.12413806945038961038961e11,
     7.53504562809350649350649e10,-2.117408301257142857142857e10,
     4.538549238857142857142857e9,-6.97547304e8,6.8498496e7,-3.230304e6,
-255024.,6.067776e6,-6.91279330909090909090909e7,
     5.01799042854884246188594e8,-2.605343556738565782044043e9,
     1.029544846162394127611519e10,-3.216950653464935064935065e10,
     8.1509831616e10,-1.70393909184e11,2.97431375616e11,
     -4.370675397668571428571429e11,5.434675144045714285714286e11,
     -5.73313732652571428571429e11,5.13243869937038961038961e11,
     -3.891150452421818181818182e11,2.486964842705454545454545e11,
     -1.329904663112727272727273e11,5.883035363158441558441558e10,
     -2.117408301257142857142857e10,6.050787044571428571428571e9,
     -1.322519646857142857142857e9,2.07948096e8,-2.0971104e7,1.020096e6,
48576.,-1.158624e6,1.323491592094861660079051e7,
     -9.63483424641445511010728e7,5.01799042854884246188594e8,
     -1.98965376374025974025974e9,6.239888667428571428571429e9,
     -1.5874285104e10,3.3332196096e10,-5.8468677504e10,
     8.63864139702857142857143e10,-1.080699442868571428571429e11,
     1.147841917988571428571429e11,-1.035519754946493506493506e11,
     7.91996526196363636363636e10,-5.113203132218181818181818e10,
     2.766444118690909090909091e10,-1.240666481828571428571429e10,
     4.538549238857142857142857e9,-1.322519646857142857142857e9,
     2.960110902857142857142857e8,-4.7925024e7,5.011776e6,-255024.,
-6624.,158349.9130434782608695652,-1.81322874308300395256917e6,
     1.323491592094861660079051e7,-6.91279330909090909090909e7,2.74956096e8,
     -8.65280304e8,2.209634496e9,-4.659218304e9,8.211108096e9,
     -1.2195423144e10,1.5346851456e10,-1.6409991744e10,
     1.491837727418181818181818e10,-1.151192578036363636363636e10,
     7.509945914181818181818182e9,-4.113614304e9,1.872434496e9,-6.97547304e8,
     2.07948096e8,-4.7925024e7,8.064576e6,-888624.,48576.,
576.,-13797.91304347826086956522,158349.9130434782608695652,
     -1.158624e6,6.067776e6,-2.4205104e7,7.6418496e7,-1.95844704e8,
     4.14602496e8,-7.33936104e8,1.095574656e9,-1.386615744e9,1.492477056e9,
     -1.367235744e9,1.064566656e9,-7.01959104e8,3.89522496e8,-1.80169704e8,
     6.8498496e7,-2.0971104e7,5.011776e6,-888624.,106176.,-6624.,
-24.,576.,-6624.,48576.,-255024.,1.020096e6,-3.230304e6,8.306496e6,
     -1.7651304e7,3.1380096e7,-4.7070144e7,5.9907456e7,-6.4899744e7,
     5.9907456e7,-4.7070144e7,3.1380096e7,-1.7651304e7,8.306496e6,-3.230304e6,
     1.020096e6,-255024.,48576.,-6624.,576.0,



625.,-7500.,57500.,-316250.,1.32825e6,-4.4275e6,1.20175e7,
     -2.7039375e7,5.1074375e7,-8.1719e7,1.11435e8,-1.300075e8,1.300075e8,
     -1.11435e8,8.1719e7,-5.1074375e7,2.7039375e7,-1.20175e7,4.4275e6,
     -1.32825e6,316250.,-57500.,7500.,-625.,25.,
-7500.,125208.3333333333333333333,-1.094895833333333333333333e6,
     6.4673125e6,-2.840979166666666666666667e7,9.76685416666666666666667e7,
     -2.7114484375e8,6.20653802083333333333333e8,
     -1.188330458333333333333333e9,1.92225375e9,-2.645033541666666666666667e9,
     3.109346041666666666666667e9,-3.12946625e9,2.697346083333333333333333e9,
     -1.987644427083333333333333e9,1.24756671875e9,
     -6.62965416666666666666667e8,2.956410416666666666666667e8,-1.092485625e8,
     3.286364583333333333333333e7,-7.843958333333333333333333e6,1.429375e6,
     -186822.9166666666666666667,15597.91666666666666666667,-625.,
57500.,-1.094895833333333333333333e6,1.037408333333333333333333e7,
     -6.45321875e7,2.938466666666666666666667e8,-1.037163072916666666666667e9,
     2.937886875e9,-6.832473427083333333333333e9,
     1.325080583333333333333333e10,-2.1663004375e10,
     3.007479916666666666666667e10,-3.562292979166666666666667e10,
     3.6088144e10,-3.128223036458333333333333e10,
     2.316682270833333333333333e10,-1.460527921875e10,
     7.791969166666666666666667e9,-3.487027729166666666666667e9,1.29267875e9,
     -3.899830208333333333333333e8,9.33272463768115942028986e7,
     -1.704766983695652173913043e7,2.233104710144927536231884e6,
     -186822.9166666666666666667,7500.,
-316250.,6.4673125e6,-6.45321875e7,4.17008125e8,-1.9543503125e9,
     7.05457046875e9,-2.034401665625e10,4.800915573863636363636364e10,
     -9.42448665909090909090909e10,1.556602884659090909090909e11,
     -2.180010869886363636363636e11,2.6017545025e11,-2.653163384375e11,
     2.3132189171875e11,-1.7219475265625e11,1.090581775e11,-5.842349075e10,
     2.62430303125e10,-9.76153036931818181818182e9,
     2.954009735671936758893281e9,-7.08924939476284584980237e8,
     1.298323304594861660079051e8,-1.704766983695652173913043e7,1.429375e6,
     -57500.,1.32825e6,-2.840979166666666666666667e7,
     2.938466666666666666666667e8,-1.9543503125e9,9.37547333333333333333333e9,
     -3.449634139583333333333333e10,1.010766145454545454545455e11,
     -2.417467875189393939393939e11,4.800191213257575757575758e11,
     -8.00675560568181818181818e11,1.130991586424242424242424e12,
     -1.359981843645833333333333e12,1.3961073175e12,
     -1.224454954479166666666667e12,9.16324756666666666666667e11,
     -5.831264845e11,3.137406370833333333333333e11,
     -1.414836087310606060606061e11,5.281666505928853754940711e10,
     -1.603600833045125164690382e10,3.860127845322793148880105e9,
     -7.08924939476284584980237e8,9.33272463768115942028986e7,
     -7.843958333333333333333333e6,316250.,
-4.4275e6,9.76685416666666666666667e7,-1.037163072916666666666667e9,
     7.05457046875e9,-3.449634139583333333333333e10,
     1.290258771401515151515152e11,-3.834407116193181818181818e11,
     9.28417342774621212121212e11,-1.86340110678030303030303e12,
     3.137703388659090909090909e12,-4.469454370705492424242424e12,
     5.414684203177083333333333e12,-5.5958730471875e12,
     4.937570394166666666666667e12,-3.715296472416666666666667e12,
     2.37610391625e12,-1.284235124924242424242424e12,
     5.81549333755764163372859e11,-2.179280434208250988142292e11,
     6.640056033408267457180501e10,-1.603600833045125164690382e10,
     2.954009735671936758893281e9,-3.899830208333333333333333e8,
     3.286364583333333333333333e7,-1.32825e6,
1.20175e7,-2.7114484375e8,2.937886875e9,-2.034401665625e10,
     1.010766145454545454545455e11,-3.834407116193181818181818e11,
     1.153959054659090909090909e12,-2.825661700767045454545455e12,
     5.728742171045454545454545e12,-9.73418096507102272727273e12,
     1.397954921323863636363636e13,-1.706196199640625e13,
     1.775207494789473684210526e13,-1.576029047811842105263158e13,
     1.192583890342105263157895e13,-7.666666611417464114832536e12,
     4.163466033925005200748908e12,-1.893692259718346941959642e12,
     7.12538092581792178073643e11,-2.179280434208250988142292e11,
     5.281666505928853754940711e10,-9.76153036931818181818182e9,1.29267875e9,
     -1.092485625e8,4.4275e6,-2.7039375e7,6.20653802083333333333333e8,
     -6.832473427083333333333333e9,4.800915573863636363636364e10,
     -2.417467875189393939393939e11,9.28417342774621212121212e11,
     -2.825661700767045454545455e12,6.990736162617424242424242e12,
     -1.430741278526515151515152e13,2.452237174938920454545455e13,
     -3.549875113963541666666667e13,4.364474294679824561403509e13,
     -4.571818456265789473684211e13,4.084317612326754385964912e13,
     -3.108567156592304625199362e13,2.009158011874921988766382e13,
     -1.096569822604322689133902e13,5.010918936069468570140767e12,
     -1.893692259718346941959642e12,5.81549333755764163372859e11,
     -1.414836087310606060606061e11,2.62430303125e10,
     -3.487027729166666666666667e9,2.956410416666666666666667e8,-1.20175e7,
5.1074375e7,-1.188330458333333333333333e9,
     1.325080583333333333333333e10,-9.42448665909090909090909e10,
     4.800191213257575757575758e11,-1.86340110678030303030303e12,
     5.728742171045454545454545e12,-1.430741278526515151515152e13,
     2.954171740155191622103387e13,-5.105359710591911764705882e13,
     7.44791950236171310629515e13,-9.22351832145412796697626e13,
     9.7273993820797213622291e13,-8.74551916661816305469556e13,
     6.695976944656838270985532e13,-4.352089595735335417711915e13,
     2.387837029558502072141526e13,-1.096569822604322689133902e13,
     4.163466033925005200748908e12,-1.284235124924242424242424e12,
     3.137406370833333333333333e11,-5.842349075e10,
     7.791969166666666666666667e9,-6.62965416666666666666667e8,2.7039375e7,
-8.1719e7,1.92225375e9,-2.1663004375e10,
     1.556602884659090909090909e11,-8.00675560568181818181818e11,
     3.137703388659090909090909e12,-9.73418096507102272727273e12,
     2.452237174938920454545455e13,-5.105359710591911764705882e13,
     8.89277386175832043343653e13,-1.307078354618306888544892e14,
     1.630271494816186145510836e14,-1.731027304384500773993808e14,
     1.566356342224788834298021e14,-1.206640072496325078164197e14,
     7.88839471305732878063853e13,-4.352089595735335417711915e13,
     2.009158011874921988766382e13,-7.666666611417464114832536e12,
     2.37610391625e12,-5.831264845e11,1.090581775e11,-1.460527921875e10,
     1.24756671875e9,-5.1074375e7,
1.11435e8,-2.645033541666666666666667e9,
     3.007479916666666666666667e10,-2.180010869886363636363636e11,
     1.130991586424242424242424e12,-4.469454370705492424242424e12,
     1.397954921323863636363636e13,-3.549875113963541666666667e13,
     7.44791950236171310629515e13,-1.307078354618306888544892e14,
     1.93516107226827915376677e14,-2.430640041222139447884417e14,
     2.598385886369100821106475e14,-2.366593707498075040943151e14,
     1.834594200802547945806157e14,-1.206640072496325078164197e14,
     6.695976944656838270985532e13,-3.108567156592304625199362e13,
     1.192583890342105263157895e13,-3.715296472416666666666667e12,
     9.16324756666666666666667e11,-1.7219475265625e11,
     2.316682270833333333333333e10,-1.987644427083333333333333e9,8.1719e7,
-1.300075e8,3.109346041666666666666667e9,
     -3.562292979166666666666667e10,2.6017545025e11,
     -1.359981843645833333333333e12,5.414684203177083333333333e12,
     -1.706196199640625e13,4.364474294679824561403509e13,
     -9.22351832145412796697626e13,1.630271494816186145510836e14,
     -2.430640041222139447884417e14,3.074065710570127484632297e14,
     -3.308451014504098381343384e14,3.033258546158715823686454e14,
     -2.366593707498075040943151e14,1.566356342224788834298021e14,
     -8.74551916661816305469556e13,4.084317612326754385964912e13,
     -1.576029047811842105263158e13,4.937570394166666666666667e12,
     -1.224454954479166666666667e12,2.3132189171875e11,
     -3.128223036458333333333333e10,2.697346083333333333333333e9,-1.11435e8,
1.300075e8,-3.12946625e9,3.6088144e10,-2.653163384375e11,
     1.3961073175e12,-5.5958730471875e12,1.775207494789473684210526e13,
     -4.571818456265789473684211e13,9.7273993820797213622291e13,
     -1.731027304384500773993808e14,2.598385886369100821106475e14,
     -3.308451014504098381343384e14,3.584667048576065553910351e14,
     -3.308451014504098381343384e14,2.598385886369100821106475e14,
     -1.731027304384500773993808e14,9.7273993820797213622291e13,
     -4.571818456265789473684211e13,1.775207494789473684210526e13,
     -5.5958730471875e12,1.3961073175e12,-2.653163384375e11,3.6088144e10,
     -3.12946625e9,1.300075e8,-1.11435e8,2.697346083333333333333333e9,
     -3.128223036458333333333333e10,2.3132189171875e11,
     -1.224454954479166666666667e12,4.937570394166666666666667e12,
     -1.576029047811842105263158e13,4.084317612326754385964912e13,
     -8.74551916661816305469556e13,1.566356342224788834298021e14,
     -2.366593707498075040943151e14,3.033258546158715823686454e14,
     -3.308451014504098381343384e14,3.074065710570127484632297e14,
     -2.430640041222139447884417e14,1.630271494816186145510836e14,
     -9.22351832145412796697626e13,4.364474294679824561403509e13,
     -1.706196199640625e13,5.414684203177083333333333e12,
     -1.359981843645833333333333e12,2.6017545025e11,
     -3.562292979166666666666667e10,3.109346041666666666666667e9,-1.300075e8,
8.1719e7,-1.987644427083333333333333e9,2.316682270833333333333333e10,
     -1.7219475265625e11,9.16324756666666666666667e11,
     -3.715296472416666666666667e12,1.192583890342105263157895e13,
     -3.108567156592304625199362e13,6.695976944656838270985532e13,
     -1.206640072496325078164197e14,1.834594200802547945806157e14,
     -2.366593707498075040943151e14,2.598385886369100821106475e14,
     -2.430640041222139447884417e14,1.93516107226827915376677e14,
     -1.307078354618306888544892e14,7.44791950236171310629515e13,
     -3.549875113963541666666667e13,1.397954921323863636363636e13,
     -4.469454370705492424242424e12,1.130991586424242424242424e12,
     -2.180010869886363636363636e11,3.007479916666666666666667e10,
     -2.645033541666666666666667e9,1.11435e8,
-5.1074375e7,1.24756671875e9,-1.460527921875e10,1.090581775e11,
     -5.831264845e11,2.37610391625e12,-7.666666611417464114832536e12,
     2.009158011874921988766382e13,-4.352089595735335417711915e13,
     7.88839471305732878063853e13,-1.206640072496325078164197e14,
     1.566356342224788834298021e14,-1.731027304384500773993808e14,
     1.630271494816186145510836e14,-1.307078354618306888544892e14,
     8.89277386175832043343653e13,-5.105359710591911764705882e13,
     2.452237174938920454545455e13,-9.73418096507102272727273e12,
     3.137703388659090909090909e12,-8.00675560568181818181818e11,
     1.556602884659090909090909e11,-2.1663004375e10,1.92225375e9,-8.1719e7,
2.7039375e7,-6.62965416666666666666667e8,
     7.791969166666666666666667e9,-5.842349075e10,
     3.137406370833333333333333e11,-1.284235124924242424242424e12,
     4.163466033925005200748908e12,-1.096569822604322689133902e13,
     2.387837029558502072141526e13,-4.352089595735335417711915e13,
     6.695976944656838270985532e13,-8.74551916661816305469556e13,
     9.7273993820797213622291e13,-9.22351832145412796697626e13,
     7.44791950236171310629515e13,-5.105359710591911764705882e13,
     2.954171740155191622103387e13,-1.430741278526515151515152e13,
     5.728742171045454545454545e12,-1.86340110678030303030303e12,
     4.800191213257575757575758e11,-9.42448665909090909090909e10,
     1.325080583333333333333333e10,-1.188330458333333333333333e9,5.1074375e7,
-1.20175e7,2.956410416666666666666667e8,
     -3.487027729166666666666667e9,2.62430303125e10,
     -1.414836087310606060606061e11,5.81549333755764163372859e11,
     -1.893692259718346941959642e12,5.010918936069468570140767e12,
     -1.096569822604322689133902e13,2.009158011874921988766382e13,
     -3.108567156592304625199362e13,4.084317612326754385964912e13,
     -4.571818456265789473684211e13,4.364474294679824561403509e13,
     -3.549875113963541666666667e13,2.452237174938920454545455e13,
     -1.430741278526515151515152e13,6.990736162617424242424242e12,
     -2.825661700767045454545455e12,9.28417342774621212121212e11,
     -2.417467875189393939393939e11,4.800915573863636363636364e10,
     -6.832473427083333333333333e9,6.20653802083333333333333e8,-2.7039375e7,
4.4275e6,-1.092485625e8,1.29267875e9,-9.76153036931818181818182e9,
     5.281666505928853754940711e10,-2.179280434208250988142292e11,
     7.12538092581792178073643e11,-1.893692259718346941959642e12,
     4.163466033925005200748908e12,-7.666666611417464114832536e12,
     1.192583890342105263157895e13,-1.576029047811842105263158e13,
     1.775207494789473684210526e13,-1.706196199640625e13,
     1.397954921323863636363636e13,-9.73418096507102272727273e12,
     5.728742171045454545454545e12,-2.825661700767045454545455e12,
     1.153959054659090909090909e12,-3.834407116193181818181818e11,
     1.010766145454545454545455e11,-2.034401665625e10,2.937886875e9,
     -2.7114484375e8,1.20175e7,
-1.32825e6,3.286364583333333333333333e7,
     -3.899830208333333333333333e8,2.954009735671936758893281e9,
     -1.603600833045125164690382e10,6.640056033408267457180501e10,
     -2.179280434208250988142292e11,5.81549333755764163372859e11,
     -1.284235124924242424242424e12,2.37610391625e12,
     -3.715296472416666666666667e12,4.937570394166666666666667e12,
     -5.5958730471875e12,5.414684203177083333333333e12,
     -4.469454370705492424242424e12,3.137703388659090909090909e12,
     -1.86340110678030303030303e12,9.28417342774621212121212e11,
     -3.834407116193181818181818e11,1.290258771401515151515152e11,
     -3.449634139583333333333333e10,7.05457046875e9,
     -1.037163072916666666666667e9,9.76685416666666666666667e7,-4.4275e6,
316250.,-7.843958333333333333333333e6,9.33272463768115942028986e7,
     -7.08924939476284584980237e8,3.860127845322793148880105e9,
     -1.603600833045125164690382e10,5.281666505928853754940711e10,
     -1.414836087310606060606061e11,3.137406370833333333333333e11,
     -5.831264845e11,9.16324756666666666666667e11,
     -1.224454954479166666666667e12,1.3961073175e12,
     -1.359981843645833333333333e12,1.130991586424242424242424e12,
     -8.00675560568181818181818e11,4.800191213257575757575758e11,
     -2.417467875189393939393939e11,1.010766145454545454545455e11,
     -3.449634139583333333333333e10,9.37547333333333333333333e9,
     -1.9543503125e9,2.938466666666666666666667e8,
     -2.840979166666666666666667e7,1.32825e6,
-57500.,1.429375e6,-1.704766983695652173913043e7,
     1.298323304594861660079051e8,-7.08924939476284584980237e8,
     2.954009735671936758893281e9,-9.76153036931818181818182e9,
     2.62430303125e10,-5.842349075e10,1.090581775e11,-1.7219475265625e11,
     2.3132189171875e11,-2.653163384375e11,2.6017545025e11,
     -2.180010869886363636363636e11,1.556602884659090909090909e11,
     -9.42448665909090909090909e10,4.800915573863636363636364e10,
     -2.034401665625e10,7.05457046875e9,-1.9543503125e9,4.17008125e8,
     -6.45321875e7,6.4673125e6,-316250.,
7500.,-186822.9166666666666666667,2.233104710144927536231884e6,
     -1.704766983695652173913043e7,9.33272463768115942028986e7,
     -3.899830208333333333333333e8,1.29267875e9,-3.487027729166666666666667e9,
     7.791969166666666666666667e9,-1.460527921875e10,
     2.316682270833333333333333e10,-3.128223036458333333333333e10,
     3.6088144e10,-3.562292979166666666666667e10,
     3.007479916666666666666667e10,-2.1663004375e10,
     1.325080583333333333333333e10,-6.832473427083333333333333e9,
     2.937886875e9,-1.037163072916666666666667e9,2.938466666666666666666667e8,
     -6.45321875e7,1.037408333333333333333333e7,-1.094895833333333333333333e6,
     57500.,-625.,15597.91666666666666666667,
     -186822.9166666666666666667,1.429375e6,-7.843958333333333333333333e6,
     3.286364583333333333333333e7,-1.092485625e8,2.956410416666666666666667e8,
     -6.62965416666666666666667e8,1.24756671875e9,
     -1.987644427083333333333333e9,2.697346083333333333333333e9,-3.12946625e9,
     3.109346041666666666666667e9,-2.645033541666666666666667e9,1.92225375e9,
     -1.188330458333333333333333e9,6.20653802083333333333333e8,
     -2.7114484375e8,9.76685416666666666666667e7,
     -2.840979166666666666666667e7,6.4673125e6,-1.094895833333333333333333e6,
     125208.3333333333333333333,-7500.,
25.,-625.,7500.,-57500.,316250.,-1.32825e6,4.4275e6,-1.20175e7,
     2.7039375e7,-5.1074375e7,8.1719e7,-1.11435e8,1.300075e8,-1.300075e8,
     1.11435e8,-8.1719e7,5.1074375e7,-2.7039375e7,1.20175e7,-4.4275e6,
     1.32825e6,-316250.,57500.,-7500.,625.0,


676.,-8450.,67600.,-388700.,1.71028e6,-5.98598e6,1.71028e7,
     -4.061915e7,8.12383e7,-1.3810511e8,2.0088016e8,-2.511002e8,2.704156e8,
     -2.511002e8,2.0088016e8,-1.3810511e8,8.12383e7,-4.061915e7,1.71028e7,
     -5.98598e6,1.71028e6,-388700.,67600.,-8450.,676.,-26.,
-8450.,146692.,-1.337804e6,8.2590976e6,-3.80024216e7,1.37164456e8,
     -4.00804118e8,9.68360536e8,-1.9630422812e9,3.3737822872e9,-4.951695944e9,
     6.236556352e9,-6.759617384e9,6.3116546272e9,-5.0737306412e9,
     3.502995496e9,-2.068327118e9,1.037626876e9,-4.382079416e8,1.537883776e8,
     -4.4047484e7,1.0033192e7,-1.748474e6,218969.92,-17547.92,676.,
67600.,-1.337804e6,1.32102568e7,-8.58451724e7,4.093042096e8,
     -1.516377005e9,4.520184526e9,-1.10940647246e10,2.27775650128e10,
     -3.95598321092e10,5.857588204e10,-7.4330681204e10,8.10872853856e10,
     -7.61408625458e10,6.15104207692e10,-4.2654169415e10,2.5283411296e10,
     -1.27285194608e10,5.3924786344e9,-1.8979085996e9,5.4501148e8,
     -1.24439939e8,2.173357576e7,-2.72730068e6,218969.92,-8450.,
-388700.,8.2590976e6,-8.58451724e7,5.792412808e8,-2.841405281e9,
     1.076208562e10,-3.26519180702e10,8.13003326668e10,-1.689265986356e11,
     2.96360784304e11,-4.4261213906e11,5.658515495152e11,-6.213058168538e11,
     5.867468443096e11,-4.76410357631e11,3.3186215491e11,-1.975130361776e11,
     9.98000907904e10,-4.24216122668e10,1.497586613617391304347826e10,
     -4.312495451521739130434783e9,9.87168148041739130434783e8,
     -1.728161544539130434782609e8,2.173357576e7,-1.748474e6,67600.,
1.71028e6,-3.80024216e7,4.093042096e8,-2.841405281e9,1.4261827528e10,
     -5.5042835588e10,1.696259763810181818181818e11,
     -4.279395995554727272727273e11,8.99187724154909090909091e11,
     -1.592799611099272727272727e12,2.398867439317818181818182e12,
     -3.0894481350902e12,3.4143556971472e12,-3.243162904436e12,
     2.646985560388e12,-1.852494308327e12,1.1072140561456e12,
     -5.61613086016509090909091e11,2.395626785928537549407115e11,
     -8.48443334246284584980237e10,2.450455102805375494071146e10,
     -5.624676608411699604743083e9,9.87168148041739130434783e8,-1.24439939e8,
     1.0033192e7,-388700.,-5.98598e6,1.37164456e8,-1.516377005e9,
     1.076208562e10,-5.5042835588e10,2.158753929563636363636364e11,
     -6.74526636229727272727273e11,1.722245564047272727272727e12,
     -3.656872623489090909090909e12,6.537625870473454545454545e12,
     -9.92673822684227272727273e12,1.2877644639652e13,-1.432489643858e13,
     1.368668021812e13,-1.1230159960019e13,7.89744995728e12,
     -4.741051724254181818181818e12,2.414534564417233201581028e12,
     -1.033778512896897233201581e12,3.673825348734324110671937e11,
     -1.064434008381185770750988e11,2.450455102805375494071146e10,
     -4.312495451521739130434783e9,5.4501148e8,-4.4047484e7,1.71028e6,
1.71028e7,-4.00804118e8,4.520184526e9,-3.26519180702e10,
     1.696259763810181818181818e11,-6.74526636229727272727273e11,
     2.133664378895636363636364e12,-5.507706764817636363636364e12,
     1.180950197716829090909091e13,-2.129872287604029090909091e13,
     3.259686871978490909090909e13,-4.2590733133403e13,4.7686452577036e13,
     -4.58329204238906e13,3.78113775953056e13,-2.672314802197890909090909e13,
     1.611642381133097233201581e13,-8.242684452286252964426877e12,
     3.542977131938642529644269e12,-1.263698385689430671936759e12,
     3.673825348734324110671937e11,-8.48443334246284584980237e10,
     1.497586613617391304347826e10,-1.8979085996e9,1.537883776e8,-5.98598e6,
-4.061915e7,9.68360536e8,-1.10940647246e10,8.13003326668e10,
     -4.279395995554727272727273e11,1.722245564047272727272727e12,
     -5.507706764817636363636364e12,1.435985820883687272727273e13,
     -3.107223869432043636363636e13,5.650948169757847272727273e13,
     -8.71506209607622727272727e13,1.146748019971470526315789e14,
     -1.292306854277491684210526e14,1.249540271500965052631579e14,
     -1.036582035132504421052632e14,7.363817876501700020803e13,
     -4.462326034951713293114208e13,2.292432720528819877678386e13,
     -9.89471034620161247347618e12,3.542977131938642529644269e12,
     -1.033778512896897233201581e12,2.395626785928537549407115e11,
     -4.24216122668e10,5.3924786344e9,-4.382079416e8,1.71028e7,
8.12383e7,-1.9630422812e9,2.27775650128e10,-1.689265986356e11,
     8.99187724154909090909091e11,-3.656872623489090909090909e12,
     1.180950197716829090909091e13,-3.107223869432043636363636e13,
     6.780938397725723636363636e13,-1.243039102260587272727273e14,
     1.931299004689376076555024e14,-2.558877014964254947368421e14,
     2.902370851167095578947368e14,-2.823335225010001684210526e14,
     2.355452932917388741418764e14,-1.682206883986575369253172e14,
     1.024478032672736938298315e14,-5.287782385611698517994591e13,
     2.292432720528819877678386e13,-8.242684452286252964426877e12,
     2.414534564417233201581028e12,-5.61613086016509090909091e11,
     9.98000907904e10,-1.27285194608e10,1.037626876e9,-4.061915e7,
-1.3810511e8,3.3737822872e9,-3.95598321092e10,2.96360784304e11,
     -1.592799611099272727272727e12,6.537625870473454545454545e12,
     -2.129872287604029090909091e13,5.650948169757847272727273e13,
     -1.243039102260587272727273e14,2.295890001484706794258373e14,
     -3.592682626003927368421053e14,4.792486904788500210526316e14,
     -5.470834239028824421052632e14,5.354355401840663798627002e14,
     -4.492895073107258672768879e14,3.226333558751677663407531e14,
     -1.975100167040327882338257e14,1.024478032672736938298315e14,
     -4.462326034951713293114208e13,1.611642381133097233201581e13,
     -4.741051724254181818181818e12,1.1072140561456e12,-1.975130361776e11,
     2.5283411296e10,-2.068327118e9,8.12383e7,
2.0088016e8,-4.951695944e9,5.857588204e10,-4.4261213906e11,
     2.398867439317818181818182e12,-9.92673822684227272727273e12,
     3.259686871978490909090909e13,-8.71506209607622727272727e13,
     1.931299004689376076555024e14,-3.592682626003927368421053e14,
     5.66078864576392631578947e14,-7.60146462658580947368421e14,
     8.73288215264791487414188e14,-8.5994474930971028604119e14,
     7.25843967143151892906178e14,-5.241762895276401516538382e14,
     3.226333558751677663407531e14,-1.682206883986575369253172e14,
     7.363817876501700020803e13,-2.672314802197890909090909e13,
     7.89744995728e12,-1.852494308327e12,3.3186215491e11,-4.2654169415e10,
     3.502995496e9,-1.3810511e8,
-2.511002e8,6.236556352e9,-7.4330681204e10,5.658515495152e11,
     -3.0894481350902e12,1.2877644639652e13,-4.2590733133403e13,
     1.146748019971470526315789e14,-2.558877014964254947368421e14,
     4.792486904788500210526316e14,-7.60146462658580947368421e14,
     1.027374630571166050343249e15,-1.187765934052720876430206e15,
     1.176831184376152618398169e15,-9.99274158930430481556064e14,
     7.25843967143151892906178e14,-4.492895073107258672768879e14,
     2.355452932917388741418764e14,-1.036582035132504421052632e14,
     3.78113775953056e13,-1.1230159960019e13,2.646985560388e12,
     -4.76410357631e11,6.15104207692e10,-5.0737306412e9,2.0088016e8,
2.704156e8,-6.759617384e9,8.10872853856e10,-6.213058168538e11,
     3.4143556971472e12,-1.432489643858e13,4.7686452577036e13,
     -1.292306854277491684210526e14,2.902370851167095578947368e14,
     -5.470834239028824421052632e14,8.73288215264791487414188e14,
     -1.187765934052720876430206e15,1.381797120910987958627002e15,
     -1.37754132533705096604119e15,1.176831184376152618398169e15,
     -8.5994474930971028604119e14,5.354355401840663798627002e14,
     -2.823335225010001684210526e14,1.249540271500965052631579e14,
     -4.58329204238906e13,1.368668021812e13,-3.243162904436e12,
     5.867468443096e11,-7.61408625458e10,6.3116546272e9,-2.511002e8,
-2.511002e8,6.3116546272e9,-7.61408625458e10,5.867468443096e11,
     -3.243162904436e12,1.368668021812e13,-4.58329204238906e13,
     1.249540271500965052631579e14,-2.823335225010001684210526e14,
     5.354355401840663798627002e14,-8.5994474930971028604119e14,
     1.176831184376152618398169e15,-1.37754132533705096604119e15,
     1.381797120910987958627002e15,-1.187765934052720876430206e15,
     8.73288215264791487414188e14,-5.470834239028824421052632e14,
     2.902370851167095578947368e14,-1.292306854277491684210526e14,
     4.7686452577036e13,-1.432489643858e13,3.4143556971472e12,
     -6.213058168538e11,8.10872853856e10,-6.759617384e9,2.704156e8,
2.0088016e8,-5.0737306412e9,6.15104207692e10,-4.76410357631e11,
     2.646985560388e12,-1.1230159960019e13,3.78113775953056e13,
     -1.036582035132504421052632e14,2.355452932917388741418764e14,
     -4.492895073107258672768879e14,7.25843967143151892906178e14,
     -9.99274158930430481556064e14,1.176831184376152618398169e15,
     -1.187765934052720876430206e15,1.027374630571166050343249e15,
     -7.60146462658580947368421e14,4.792486904788500210526316e14,
     -2.558877014964254947368421e14,1.146748019971470526315789e14,
     -4.2590733133403e13,1.2877644639652e13,-3.0894481350902e12,
     5.658515495152e11,-7.4330681204e10,6.236556352e9,-2.511002e8,
-1.3810511e8,3.502995496e9,-4.2654169415e10,3.3186215491e11,
     -1.852494308327e12,7.89744995728e12,-2.672314802197890909090909e13,
     7.363817876501700020803e13,-1.682206883986575369253172e14,
     3.226333558751677663407531e14,-5.241762895276401516538382e14,
     7.25843967143151892906178e14,-8.5994474930971028604119e14,
     8.73288215264791487414188e14,-7.60146462658580947368421e14,
     5.66078864576392631578947e14,-3.592682626003927368421053e14,
     1.931299004689376076555024e14,-8.71506209607622727272727e13,
     3.259686871978490909090909e13,-9.92673822684227272727273e12,
     2.398867439317818181818182e12,-4.4261213906e11,5.857588204e10,
     -4.951695944e9,2.0088016e8,
8.12383e7,-2.068327118e9,2.5283411296e10,-1.975130361776e11,
     1.1072140561456e12,-4.741051724254181818181818e12,
     1.611642381133097233201581e13,-4.462326034951713293114208e13,
     1.024478032672736938298315e14,-1.975100167040327882338257e14,
     3.226333558751677663407531e14,-4.492895073107258672768879e14,
     5.354355401840663798627002e14,-5.470834239028824421052632e14,
     4.792486904788500210526316e14,-3.592682626003927368421053e14,
     2.295890001484706794258373e14,-1.243039102260587272727273e14,
     5.650948169757847272727273e13,-2.129872287604029090909091e13,
     6.537625870473454545454545e12,-1.592799611099272727272727e12,
     2.96360784304e11,-3.95598321092e10,3.3737822872e9,-1.3810511e8,
-4.061915e7,1.037626876e9,-1.27285194608e10,9.98000907904e10,
     -5.61613086016509090909091e11,2.414534564417233201581028e12,
     -8.242684452286252964426877e12,2.292432720528819877678386e13,
     -5.287782385611698517994591e13,1.024478032672736938298315e14,
     -1.682206883986575369253172e14,2.355452932917388741418764e14,
     -2.823335225010001684210526e14,2.902370851167095578947368e14,
     -2.558877014964254947368421e14,1.931299004689376076555024e14,
     -1.243039102260587272727273e14,6.780938397725723636363636e13,
     -3.107223869432043636363636e13,1.180950197716829090909091e13,
     -3.656872623489090909090909e12,8.99187724154909090909091e11,
     -1.689265986356e11,2.27775650128e10,-1.9630422812e9,8.12383e7,
1.71028e7,-4.382079416e8,5.3924786344e9,-4.24216122668e10,
     2.395626785928537549407115e11,-1.033778512896897233201581e12,
     3.542977131938642529644269e12,-9.89471034620161247347618e12,
     2.292432720528819877678386e13,-4.462326034951713293114208e13,
     7.363817876501700020803e13,-1.036582035132504421052632e14,
     1.249540271500965052631579e14,-1.292306854277491684210526e14,
     1.146748019971470526315789e14,-8.71506209607622727272727e13,
     5.650948169757847272727273e13,-3.107223869432043636363636e13,
     1.435985820883687272727273e13,-5.507706764817636363636364e12,
     1.722245564047272727272727e12,-4.279395995554727272727273e11,
     8.13003326668e10,-1.10940647246e10,9.68360536e8,-4.061915e7,
-5.98598e6,1.537883776e8,-1.8979085996e9,
     1.497586613617391304347826e10,-8.48443334246284584980237e10,
     3.673825348734324110671937e11,-1.263698385689430671936759e12,
     3.542977131938642529644269e12,-8.242684452286252964426877e12,
     1.611642381133097233201581e13,-2.672314802197890909090909e13,
     3.78113775953056e13,-4.58329204238906e13,4.7686452577036e13,
     -4.2590733133403e13,3.259686871978490909090909e13,
     -2.129872287604029090909091e13,1.180950197716829090909091e13,
     -5.507706764817636363636364e12,2.133664378895636363636364e12,
     -6.74526636229727272727273e11,1.696259763810181818181818e11,
     -3.26519180702e10,4.520184526e9,-4.00804118e8,1.71028e7,
1.71028e6,-4.4047484e7,5.4501148e8,-4.312495451521739130434783e9,
     2.450455102805375494071146e10,-1.064434008381185770750988e11,
     3.673825348734324110671937e11,-1.033778512896897233201581e12,
     2.414534564417233201581028e12,-4.741051724254181818181818e12,
     7.89744995728e12,-1.1230159960019e13,1.368668021812e13,
     -1.432489643858e13,1.2877644639652e13,-9.92673822684227272727273e12,
     6.537625870473454545454545e12,-3.656872623489090909090909e12,
     1.722245564047272727272727e12,-6.74526636229727272727273e11,
     2.158753929563636363636364e11,-5.5042835588e10,1.076208562e10,
     -1.516377005e9,1.37164456e8,-5.98598e6,
-388700.,1.0033192e7,-1.24439939e8,9.87168148041739130434783e8,
     -5.624676608411699604743083e9,2.450455102805375494071146e10,
     -8.48443334246284584980237e10,2.395626785928537549407115e11,
     -5.61613086016509090909091e11,1.1072140561456e12,-1.852494308327e12,
     2.646985560388e12,-3.243162904436e12,3.4143556971472e12,
     -3.0894481350902e12,2.398867439317818181818182e12,
     -1.592799611099272727272727e12,8.99187724154909090909091e11,
     -4.279395995554727272727273e11,1.696259763810181818181818e11,
     -5.5042835588e10,1.4261827528e10,-2.841405281e9,4.093042096e8,
     -3.80024216e7,1.71028e6,67600.,-1.748474e6,2.173357576e7,
     -1.728161544539130434782609e8,9.87168148041739130434783e8,
     -4.312495451521739130434783e9,1.497586613617391304347826e10,
     -4.24216122668e10,9.98000907904e10,-1.975130361776e11,3.3186215491e11,
     -4.76410357631e11,5.867468443096e11,-6.213058168538e11,5.658515495152e11,
     -4.4261213906e11,2.96360784304e11,-1.689265986356e11,8.13003326668e10,
     -3.26519180702e10,1.076208562e10,-2.841405281e9,5.792412808e8,
     -8.58451724e7,8.2590976e6,-388700.,
-8450.,218969.92,-2.72730068e6,2.173357576e7,-1.24439939e8,
     5.4501148e8,-1.8979085996e9,5.3924786344e9,-1.27285194608e10,
     2.5283411296e10,-4.2654169415e10,6.15104207692e10,-7.61408625458e10,
     8.10872853856e10,-7.4330681204e10,5.857588204e10,-3.95598321092e10,
     2.27775650128e10,-1.10940647246e10,4.520184526e9,-1.516377005e9,
     4.093042096e8,-8.58451724e7,1.32102568e7,-1.337804e6,67600.,
676.,-17547.92,218969.92,-1.748474e6,1.0033192e7,-4.4047484e7,
     1.537883776e8,-4.382079416e8,1.037626876e9,-2.068327118e9,3.502995496e9,
     -5.0737306412e9,6.3116546272e9,-6.759617384e9,6.236556352e9,
     -4.951695944e9,3.3737822872e9,-1.9630422812e9,9.68360536e8,-4.00804118e8,
     1.37164456e8,-3.80024216e7,8.2590976e6,-1.337804e6,146692.,-8450.,
-26.,676.,-8450.,67600.,-388700.,1.71028e6,-5.98598e6,1.71028e7,
     -4.061915e7,8.12383e7,-1.3810511e8,2.0088016e8,-2.511002e8,2.704156e8,
     -2.511002e8,2.0088016e8,-1.3810511e8,8.12383e7,-4.061915e7,1.71028e7,
     -5.98598e6,1.71028e6,-388700.,67600.,-8450.,676.0



};





void InvMMatrix(const Standard_Integer classe,
		math_Matrix&           InvM)
{
  if (classe > 24) Standard_DimensionError::Raise("InvMMatrix: classe > 24");
  Standard_Integer i, j, k = 0, Som = 0;
  for (i = 2; i < classe; i++) {
    Som += (i)*(i);
  }
  for (i = 1; i <= classe; i++) {
    for (j = 1; j <= classe; j++) {
      InvM(i+InvM.LowerRow()-1, j+InvM.LowerCol()-1) = IMatrix[Som+k];
      k++;
    }
  }
}


