// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_Vector_HeaderFile
#define _math_Vector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _math_SingleTabOfReal_HeaderFile
#include <math_SingleTabOfReal.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Standard_DimensionError;
class Standard_DivideByZero;
class Standard_RangeError;
class Standard_NullValue;
class math_Matrix;



//! This class implements the real vector abstract data type. <br>
//! Vectors can have an arbitrary range which must be defined at <br>
//! the declaration and cannot be changed after this declaration. <br>
//!    math_Vector V1(-3, 5); // a vector with range [-3..5] <br>
class math_Vector  {
public:

  DEFINE_STANDARD_ALLOC

  //! Contructs a non-initialized vector in the range [Lower..Upper] <br>
//! Lower and Upper are the indexes of the lower and upper <br>
//! bounds of the constructed vector. <br>
  Standard_EXPORT   math_Vector(const Standard_Integer Lower,const Standard_Integer Upper);
  //! Contructs a vector in the range [Lower..Upper] <br>
//!         whose values are all initialized with the value   InitialValue.. <br>
  Standard_EXPORT   math_Vector(const Standard_Integer Lower,const Standard_Integer Upper,const Standard_Real InitialValue);
  //! Constructs a vector in the range [Lower..Upper] <br>
//!          with the "c array" Tab. <br>
  Standard_EXPORT   math_Vector(const Standard_Address Tab,const Standard_Integer Lower,const Standard_Integer Upper);
  //! Initialize all the elements of a vector with InitialValue. <br>
  Standard_EXPORT     void Init(const Standard_Real InitialValue) ;
  //! Constructs a copy for initialization. <br>
//!          An exception is raised if the lengths of the vectors are <br>
//!          different. <br>
  Standard_EXPORT   math_Vector(const math_Vector& Other);
  //! Returns the length of a vector <br>
        Standard_Integer Length() const;
  //! Returns the value of the Lower index of a vector. <br>
        Standard_Integer Lower() const;
  //! Returns the value of the Upper index of a vector. <br>
        Standard_Integer Upper() const;
  //! Returns the value or the square  of the norm of this vector. <br>
  Standard_EXPORT     Standard_Real Norm() const;
  //! Returns the value of the square of the norm of a vector. <br>
  Standard_EXPORT     Standard_Real Norm2() const;
  //! Returns the value of the Index of the maximum element of a vector. <br>
  Standard_EXPORT     Standard_Integer Max() const;
  //! Returns the value of the Index of the minimum element  of a vector. <br>
  Standard_EXPORT     Standard_Integer Min() const;
  //! Normalizes this vector (the norm of the result <br>
//! is equal to 1.0) and assigns the result to this vector <br>
//!   Exceptions <br>
//! Standard_NullValue if this vector is null (i.e. if its norm is <br>
//! less than or equal to Standard_Real::RealEpsilon(). <br>
  Standard_EXPORT     void Normalize() ;
  //! Normalizes this vector (the norm of the result <br>
//! is equal to 1.0) and creates a new vector <br>
//!   Exceptions <br>
//! Standard_NullValue if this vector is null (i.e. if its norm is <br>
//! less than or equal to Standard_Real::RealEpsilon(). <br>
  Standard_EXPORT     math_Vector Normalized() const;
  //! Inverts this vector and assigns the result to this vector. <br>
  Standard_EXPORT     void Invert() ;
  //! Inverts this vector and creates a new vector. <br>
  Standard_EXPORT     math_Vector Inverse() const;
  //! sets a vector from <I1> to <I2> to the vector <V>; <br>
//! An exception is raised if I1<LowerIndex or I2>UpperIndex or I1>I2. <br>
//! An exception is raised if I2-I1+1 is different from the Length of V. <br>
  Standard_EXPORT     void Set(const Standard_Integer I1,const Standard_Integer I2,const math_Vector& V) ;
  //!Creates a new vector by inverting the values of this vector <br>
//!  between indexes I1 and I2. <br>
//! If the values of this vector were (1., 2., 3., 4., <br>
//! 5., 6.), by slicing it between indexes 2 and 5 the <br>
//! values of the resulting vector are (1., 5., 4., 3., 2., 6.) <br>
  Standard_EXPORT     math_Vector Slice(const Standard_Integer I1,const Standard_Integer I2) const;
  //! returns the product of a vector and a real value. <br>
  Standard_EXPORT     void Multiply(const Standard_Real Right) ;
    void operator *=(const Standard_Real Right) 
{
  Multiply(Right);
}
  //! returns the product of a vector and a real value. <br>
  Standard_EXPORT     math_Vector Multiplied(const Standard_Real Right) const;
    math_Vector operator*(const Standard_Real Right) const
{
  return Multiplied(Right);
}
  //! returns the product of a vector and a real value. <br>
  Standard_EXPORT     math_Vector TMultiplied(const Standard_Real Right) const;
friend math_Vector operator *(const Standard_Real Left,const math_Vector& Right);
  //! divides a vector by the value <Right>. <br>
//! An exception is raised if <Right> = 0. <br>
  Standard_EXPORT     void Divide(const Standard_Real Right) ;
    void operator /=(const Standard_Real Right) 
{
  Divide(Right);
}
  //! divides a vector by the value <Right>. <br>
//! An exception is raised if <Right> = 0. <br>
  Standard_EXPORT     math_Vector Divided(const Standard_Real Right) const;
    math_Vector operator/(const Standard_Real Right) const
{
  return Divided(Right);
}
  //! adds the vector <Right> to a vector. <br>
//! An exception is raised if the vectors have not the same length. <br>
//! Warning <br>
//! In order to avoid time-consuming copying of vectors, it <br>
//! is preferable to use operator += or the function Add whenever possible. <br>
  Standard_EXPORT     void Add(const math_Vector& Right) ;
    void operator +=(const math_Vector& Right) 
{
  Add(Right);
}
  //! adds the vector <Right> to a vector. <br>
//! An exception is raised if the vectors have not the same length. <br>
//! An exception is raised if the lengths are not equal. <br>
  Standard_EXPORT     math_Vector Added(const math_Vector& Right) const;
    math_Vector operator+(const math_Vector& Right) const
{
  return Added(Right);
}
  //! sets a vector to the product of the vector <Left> <br>
//!          with the matrix <Right>. <br>
  Standard_EXPORT     void Multiply(const math_Vector& Left,const math_Matrix& Right) ;
  //!sets a vector to the product of the matrix <Left> <br>
//!         with the vector <Right>. <br>
  Standard_EXPORT     void Multiply(const math_Matrix& Left,const math_Vector& Right) ;
  //! sets a vector to the product of the transpose <br>
//!           of the matrix <TLeft> by the vector <Right>. <br>
  Standard_EXPORT     void TMultiply(const math_Matrix& TLeft,const math_Vector& Right) ;
  //! sets a vector to the product of the vector <br>
//!          <Left> by the transpose of the matrix <TRight>. <br>
  Standard_EXPORT     void TMultiply(const math_Vector& Left,const math_Matrix& TRight) ;
  //! sets a vector to the sum of the vector <Left> <br>
//!          and the vector <Right>. <br>
//! An exception is raised if the lengths are different. <br>
  Standard_EXPORT     void Add(const math_Vector& Left,const math_Vector& Right) ;
  //! sets a vector to the Subtraction of the <br>
//!           vector <Right> from the vector <Left>. <br>
//! An exception is raised if the vectors have not the same length. <br>
//!  Warning <br>
//! In order to avoid time-consuming copying of vectors, it <br>
//! is preferable to use operator -= or the function <br>
//! Subtract whenever possible. <br>
  Standard_EXPORT     void Subtract(const math_Vector& Left,const math_Vector& Right) ;
  //! accesses (in read or write mode) the value of index Num of <br>
//!          a vector. <br>
        Standard_Real& Value(const Standard_Integer Num) const;
      Standard_Real& operator()(const Standard_Integer Num) const
{
  return Value(Num);
}
  //! Initialises a vector by copying <Other>. <br>
//!          An exception is raised if the Lengths are differents. <br>
  Standard_EXPORT     math_Vector& Initialized(const math_Vector& Other) ;
    math_Vector& operator=(const math_Vector& Other) 
{
  return Initialized(Other);
}
  //! returns the inner product of 2 vectors. <br>
//! An exception is raised if the lengths are not equal. <br>
  Standard_EXPORT     Standard_Real Multiplied(const math_Vector& Right) const;
    Standard_Real operator*(const math_Vector& Right) const
{
  return Multiplied(Right);
}
  //! returns the product of a vector by a matrix. <br>
  Standard_EXPORT     math_Vector Multiplied(const math_Matrix& Right) const;
    math_Vector operator*(const math_Matrix& Right) const
{
  return Multiplied(Right);
}
  //! returns the opposite of a vector. <br>
  Standard_EXPORT     math_Vector Opposite() ;
    math_Vector operator-() 
{
  return Opposite();
}
  //! returns the subtraction of <Right> from <me>. <br>
//! An exception is raised if the vectors have not the same length. <br>
  Standard_EXPORT     void Subtract(const math_Vector& Right) ;
    void operator-=(const math_Vector& Right) 
{
  Subtract(Right);
}
  //! returns the subtraction of <Right> from <me>. <br>
//! An exception is raised if the vectors have not the same length. <br>
  Standard_EXPORT     math_Vector Subtracted(const math_Vector& Right) const;
    math_Vector operator-(const math_Vector& Right) const
{
  return Subtracted(Right);
}
  //! returns the multiplication of a real by a vector. <br>
//!          <me> = <Left> * <Right> <br>
  Standard_EXPORT     void Multiply(const Standard_Real Left,const math_Vector& Right) ;
  //! Prints information on the current state of the object. <br>
//!          Is used to redefine the operator <<. <br>
  Standard_EXPORT     void Dump(Standard_OStream& o) const;


friend class math_Matrix;



protected:

  //! Is used internally to set the Lower value of the vector. <br>
  Standard_EXPORT     void SetLower(const Standard_Integer Lower) ;




private:



Standard_Integer LowerIndex;
Standard_Integer UpperIndex;
math_SingleTabOfReal Array;


};


#include <math_Vector.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
