// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_Semaphore_HeaderFile
#define _OSD_Semaphore_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _OSD_Error_HeaderFile
#include <OSD_Error.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class OSD_OSDError;
class Standard_ProgramError;
class TCollection_AsciiString;


//! IPC Tools -Semaphores <br>
//!          The semaphores are used to facilitate shared resources. <br>
//!          This implementation provides a way to ensure mutual <br>
//!          exclusion using 'Lock' and 'Free' primitives. <br>
//!          The Lock is used to prevent access if it's not yet allowed. <br>
//!          The Free validates the semaphores and if possible, frees process <br>
//!          waiting for a common resource. <br>
class OSD_Semaphore  {
public:

  DEFINE_STANDARD_ALLOC

  //! Allocate room for semaphore name. <br>
//!          This is to be used with 'Open'. <br>
//!          so the process is a client. <br>
  Standard_EXPORT   OSD_Semaphore();
  //! Instantiates Semaphore object with a name. <br>
//!          The name is the only way provided to work with a common <br>
//!          semaphore for different processes. <br>
//!          Each process working with the same semaphore must use <br>
//!          a common known access : the semaphore's NAME. <br>
//!          Raises ConstructionError when the name contains characters <br>
//!          not in range of ' '...'~'. <br>
//!          This is for a server process. <br>
  Standard_EXPORT   OSD_Semaphore(const TCollection_AsciiString& Name);
  //! Sets semaphore (physically) into memory <br>
  Standard_EXPORT     void Build() ;
  //! Opens (physically) a semaphore <br>
//!          Raises ConstructionError when the name contains characters <br>
//!          not in range of ' '...'~'. <br>
  Standard_EXPORT     void Open(const TCollection_AsciiString& Name) ;
  //! Returns current value of the semaphore's counter. <br>
//!          Raises ProgramError when the semaphore is not open. <br>
  Standard_EXPORT     Standard_Integer GetCounter() ;
  //! Sets the semaphore's counter to a specific value. <br>
//!          Raises ProgramError when the semaphore is not open. <br>
  Standard_EXPORT     void SetCounter(const Standard_Integer Value) ;
  //! Removes the semaphore. <br>
//!          This is used only by server process ! <br>
//!          Raise ProgramError if the semaphore is already deleted. <br>
  Standard_EXPORT     void Delete() ;
  //! Makes current process waiting for access <br>
//!          Raises ProgramError when the semaphore does't exist. <br>
  Standard_EXPORT     void Lock() ;
  //! Frees one access to a semaphore. <br>
//!          Raises ProgramError when the semaphore does't exist. <br>
  Standard_EXPORT     void Free() ;
  //! Resets semaphore counter to zero. <br>
//!          Raises ProgramError when the semaphore does't exist. <br>
  Standard_EXPORT     void Restore() ;
  //! Returns TRUE if an error occurs <br>
  Standard_EXPORT     Standard_Boolean Failed() const;
  //! Resets error counter to zero <br>
  Standard_EXPORT     void Reset() ;
  //! Raises OSD_Error <br>
  Standard_EXPORT     void Perror() ;
  //! Returns error number if 'Failed' is TRUE. <br>
  Standard_EXPORT     Standard_Integer Error() const;





protected:





private:



TCollection_AsciiString myName;
Standard_Integer myKey;
Standard_Integer mySemId;
OSD_Error myError;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
