// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Image_Convertor_HeaderFile
#define _Image_Convertor_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Image_DitheringMethod_HeaderFile
#include <Image_DitheringMethod.hxx>
#endif
#ifndef _Handle_Image_PseudoColorImage_HeaderFile
#include <Handle_Image_PseudoColorImage.hxx>
#endif
#ifndef _Handle_Image_ColorImage_HeaderFile
#include <Handle_Image_ColorImage.hxx>
#endif
#ifndef _Handle_Aspect_ColorMap_HeaderFile
#include <Handle_Aspect_ColorMap.hxx>
#endif
class Image_PseudoColorImage;
class Image_ColorImage;
class Aspect_ColorMap;


//! This class is used to convert : <br>
//!		a PseudoColorImage to a ColorImage <br>
//!		a ColorImage to a PseudoColorImage <br>
//!		a PseudoColorImage to a PseudoColorImage with a <br>
//!			different ColorMap. <br>
class Image_Convertor  {
public:

  DEFINE_STANDARD_ALLOC

  //! Create a Convertor object with the default DitheringMethod <br>
//!	( DM_NearestColor ). <br>
  Standard_EXPORT   Image_Convertor();
  //! Set DitheringMethod. <br>
  Standard_EXPORT     void SetDitheringMethod(const Image_DitheringMethod aMethod) ;
  //! Dither a ColorImage into a PseudoColorImage using the <br>
//!		 ColorMap parameter. <br>
  Standard_EXPORT     Handle_Image_PseudoColorImage Convert(const Handle(Image_ColorImage)& aColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;
  //! Dither a PseudoColorImage into a PseudoColorImage using the <br>
//!		 ColorMap parameter. <br>
  Standard_EXPORT     Handle_Image_PseudoColorImage Convert(const Handle(Image_PseudoColorImage)& aPseudoColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;
  //! Lookup a PseudoColorImage into a ColorImage using the <br>
//!		PseudoColorImage ColorMap. <br>
  Standard_EXPORT     Handle_Image_ColorImage Convert(const Handle(Image_PseudoColorImage)& aPseudoColorImage) const;





protected:





private:

  
  Standard_EXPORT     Handle_Image_PseudoColorImage NearestDithering(const Handle(Image_ColorImage)& aColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;
  
  Standard_EXPORT     Handle_Image_PseudoColorImage NearestDithering(const Handle(Image_PseudoColorImage)& aPseudoColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;
  
  Standard_EXPORT     Handle_Image_PseudoColorImage ErrorDiffusionDithering(const Handle(Image_ColorImage)& aColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;
  
  Standard_EXPORT     Handle_Image_PseudoColorImage ErrorDiffusionDithering(const Handle(Image_PseudoColorImage)& aPseudoColorImage,const Handle(Aspect_ColorMap)& aColorMap) const;


Image_DitheringMethod myDitheringMethod;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
